/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook;

import ancestris.modules.webbook.Log;
import ancestris.modules.webbook.WebBook;
import genj.gedcom.Gedcom;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class WebBookStarter {
    private Gedcom gedcom;
    private Log log;
    private static RequestProcessor RP = null;
    private RequestProcessor.Task theTask = null;

    public WebBookStarter(Gedcom gedcom) {
        this.gedcom = gedcom;
        String logname = gedcom.getRegistry().get("webbook.logFile", "");
        this.log = new Log(logname, NbBundle.getMessage(WebBookStarter.class, (String)"OpenIDE-Module-Name") + " " + gedcom.getName());
    }

    public synchronized void start() {
        final ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(WebBookStarter.class, (String)"TASK_WebBookExecution"), (Cancellable)new Cancellable(){

            public boolean cancel() {
                return WebBookStarter.this.handleCancel();
            }
        });
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                ph.start();
                this.execute();
            }

            private void execute() {
                WebBookStarter.this.log.write(NbBundle.getMessage(WebBookStarter.class, (String)"TASK_WebBookExecutionStart"));
                try {
                    new WebBook(WebBookStarter.this.gedcom, WebBookStarter.this.log);
                    if (((WebBookStarter)WebBookStarter.this).log.endSuccessful) {
                        WebBookStarter.this.log.write(((WebBookStarter)WebBookStarter.this).log.NORMAL, NbBundle.getMessage(WebBookStarter.class, (String)"TASK_WebBookExecutionSuccess"));
                    } else {
                        WebBookStarter.this.log.write(((WebBookStarter)WebBookStarter.this).log.ERROR, NbBundle.getMessage(WebBookStarter.class, (String)"TASK_WebBookExecutionFailed"));
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception ex) {
                    WebBookStarter.this.log.printStackTrace(ex);
                    Thread.currentThread().interrupt();
                }
            }
        };
        if (RP == null) {
            RP = new RequestProcessor("WebBookStarter", 1, true);
        }
        this.theTask = RP.create(runnable);
        this.theTask.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                ph.finish();
                WebBookStarter.this.log.close();
            }
        });
        this.theTask.schedule(0);
    }

    private boolean handleCancel() {
        if (null == this.theTask) {
            return false;
        }
        this.log.write(this.log.ERROR, NbBundle.getMessage(WebBookStarter.class, (String)"TASK_WebBookExecutionStopped"));
        return this.theTask.cancel();
    }
}

