/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook.creator;

import ancestris.modules.webbook.WebBook;
import ancestris.modules.webbook.WebBookParams;
import ancestris.modules.webbook.creator.WebHelper;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyNote;
import genj.gedcom.PropertySource;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSection {
    public boolean toBeGenerated = true;
    public WebBook wb = null;
    public WebBookParams wp = null;
    public WebHelper wh = null;
    public int sizeIndiSection = 50;
    public String sectionName;
    public String sectionDir;
    public String sectionPrefix;
    public String formatNbrs;
    public String sectionSuffix;
    public int nbPerPage;
    public String sectionLink;
    public final Charset UTF8 = Charset.forName("UTF-8");
    public final String SPACE = "&nbsp;";
    public final String SEP = "/";
    public final String DEFCHAR = "-";
    private String htmlTitle = "";
    private String owner = "";
    private String author = "";
    private String replyto = "";
    private String keywords = "";
    private String siteDesc = "";
    private String language = "";
    public boolean hidePrivateData = true;
    public String includesDir = "includes";
    public String includeInit = "awb_init.php";
    public String includeHeaderStart = "awb_header_start.php";
    public String includeHeaderEnd = "awb_header_end.php";
    public String includeFooter = "awb_footer.php";
    public String themeDir = "theme";
    public String indexFile = "index";
    public String styleFile = "style.css";
    public String POPUP = "popup.htm";
    public final String DEFPOPUPWIDTH = "400";
    public final String DEFPOPUPLENGTH = "500";
    private final int WIDTH_PICTURES = 200;
    public String prefixPersonDetailsDir = "";
    public static final int NB_WORDS = 7;
    private static final int IMG_BUFFER_SIZE = 1024;
    public byte[] imgBuffer = new byte[1024];
    public Map<String, String> linkForLetter = new TreeMap<String, String>();
    public Map<String, String> namePage = new TreeMap<String, String>();
    public Map<String, String> personPage = new TreeMap<String, String>();
    public Map<String, String> sourcePage = new TreeMap<String, String>();
    public Map<Integer, String> mediaPage = new TreeMap<Integer, String>();
    public Map<String, String> cityPage = new TreeMap<String, String>();
    public Map<String, String> dayPage = new TreeMap<String, String>();
    public String[] Months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private String[] events = null;
    private String[] eventsMarr = null;
    private boolean showDate = true;
    private boolean showPlace = true;
    private boolean showAllPlaceJurisdictions = true;
    public Comparator<String> sortLastnames = new Comparator<String>(){

        @Override
        public int compare(String orig1, String orig2) {
            String name1 = WebSection.this.htmlAnchorText(orig1);
            String name2 = WebSection.this.htmlAnchorText(orig2);
            if (name1.startsWith("-")) {
                if (name2.startsWith("-")) {
                    return orig1.compareTo(orig2);
                }
                return 1;
            }
            if (name2.startsWith("-")) {
                return -1;
            }
            if (name2.compareTo(name1) == 0) {
                return orig1.compareTo(orig2);
            }
            return name1.compareTo(name2);
        }
    };
    public Comparator<Indi> sortIndividuals = new Comparator<Indi>(){

        @Override
        public int compare(Indi indi1, Indi indi2) {
            int sort = WebSection.this.sortLastnames.compare(WebSection.this.wh.getLastName(indi1, "-"), WebSection.this.wh.getLastName(indi2, "-"));
            if (sort == 0) {
                return WebSection.this.sortLastnames.compare(indi1.getFirstName(), indi2.getFirstName());
            }
            return sort;
        }
    };
    public final boolean DT_NOBREAK = false;
    public final boolean DT_BREAK = true;
    public final int DT_LASTFIRST = 0;
    public final int DT_FIRSTLAST = 1;
    public final int DT_LAST = 2;
    public final boolean DT_NOICON = false;
    public final boolean DT_ICON = true;
    public final boolean DT_NOLINK = false;
    public final boolean DT_LINK = true;
    public final boolean DT_NOSOSA = false;
    public final boolean DT_SOSA = true;
    public final boolean DT_NOID = false;
    public final boolean DT_ID = true;

    public WebSection(boolean generate, WebBook wb, WebBookParams wp, WebHelper wh) {
        this.toBeGenerated = generate;
        this.wb = wb;
        this.wp = wp;
        this.wh = wh;
    }

    public void init(String sectionName, String sectionDir, String sectionPrefix, String formatNbrs, int firstPage, int nbPerPage) {
        this.sectionName = sectionName;
        this.sectionDir = sectionDir;
        this.sectionPrefix = sectionPrefix;
        this.formatNbrs = formatNbrs;
        this.sectionSuffix = this.wp.param_PHP_Support.equals("1") ? ".php" : ".html";
        this.nbPerPage = nbPerPage;
        this.sectionLink = sectionDir + "/" + sectionPrefix + (formatNbrs.length() == 0 ? "" : String.format(formatNbrs, firstPage)) + this.sectionSuffix;
        this.htmlTitle = this.htmlText(this.wp.param_title);
        this.siteDesc = "";
        this.owner = this.htmlText(this.wp.param_author);
        this.author = this.htmlText(this.wp.param_author);
        this.hidePrivateData = this.wp.param_hidePrivateData.equals("1");
        this.replyto = this.wp.param_email;
        this.keywords = this.getKeywords();
        this.language = Locale.getDefault().getLanguage();
        this.indexFile = "index" + this.sectionSuffix;
        this.wh.log.write(sectionName);
    }

    public void initEvents() {
        this.events = new String[]{"BIRT", "CHR", "DEAT", "BURI", "CREM", "ADOP", "BAPM", "BARM", "BASM", "BLES", "CHRA", "CONF", "FCOM", "ORDN", "NATU", "EMIG", "IMMI", "CENS", "PROB", "WILL", "GRAD", "RETI", "EVEN", "CAST", "DSCR", "EDUC", "IDNO", "NATI", "NCHI", "NMR", "OCCU", "PROP", "RELI", "RESI", "SSN", "TITL"};
        this.eventsMarr = new String[]{"ANUL", "CENS", "DIV", "DIVF", "ENGA", "MARR", "MARB", "MARC", "MARL", "MARS", "EVEN"};
    }

    public void create() {
    }

    public String formatFromSize(int nbIndis) {
        int l = 1;
        if (nbIndis > this.sizeIndiSection) {
            l = (int)Math.log10(nbIndis / this.sizeIndiSection) + 1;
        }
        return "%0" + l + "d";
    }

    public String trs(String string) {
        return this.wb.log.trs(string);
    }

    public String trs(String string, Object param1) {
        return this.wb.log.trs(string, param1);
    }

    public String trs(String string, Object param1, Object param2) {
        return this.wb.log.trs(string, param1, param2);
    }

    public String trs(String string, Object param1, Object param2, Object param3) {
        return this.wb.log.trs(string, param1, param2, param3);
    }

    public String trs(String string, Object param1, Object param2, Object param3, Object param4) {
        return this.wb.log.trs(string, param1, param2, param3, param4);
    }

    public String trs(String string, Object[] arr) {
        return this.wb.log.trs(string, arr);
    }

    private String getParentDir(WebSection section) {
        String path = section == null || section.sectionDir == null ? "" : (section.sectionDir.length() == 0 ? "" : "..");
        return path == null || path.length() == 0 ? "" : path + "/";
    }

    public void printOpenHTML(PrintWriter out) {
        this.printOpenHTML(out, null, null);
    }

    public void printOpenHTML(PrintWriter out, String title) {
        this.printOpenHTML(out, title, null);
    }

    public void printOpenHTML(PrintWriter out, String title, WebSection section) {
        this.printOpenHTMLHead(out, title, section);
        this.printOpenHTMLBody(out, title, section);
    }

    public void printOpenHTMLHead(PrintWriter out, String title, WebSection section) {
        String parent = this.getParentDir(section);
        if (this.wp.param_PHP_Support.equals("1") && this.wp.param_PHP_Integrate.equals("1")) {
            if (!parent.isEmpty()) {
                out.println("<?php chdir('..'); ?>");
            }
            out.println("<?php include(\"" + this.includesDir + "/" + this.includeInit + "\"); ?>");
            out.println("<?php include(\"" + this.includesDir + "/" + this.includeHeaderStart + "\"); ?>");
            out.println("<link rel=\"stylesheet\" href=\"" + parent + this.wp.param_PHP_HeadCSS + "\" type=\"text/css\"/>");
            out.println("<link rel=\"stylesheet\" href=\"" + parent + this.themeDir + "/" + this.styleFile + "\" type=\"text/css\"/>");
            out.println("<?php include(\"" + this.includesDir + "/" + this.includeHeaderEnd + "\"); ?>");
            out.println("");
            out.println("<!-- START OF VARIABLE CONTENT -->");
            out.println("");
        } else if (this.wp.param_PHP_Support.equals("1") && !this.wp.param_PHP_Integrate.equals("1")) {
            if (!parent.isEmpty()) {
                out.println("<?php chdir('..'); ?>");
            }
            out.println("<?php include(\"" + this.includesDir + "/" + this.includeInit + "\"); ?>");
            out.println(this.getHeader(title));
            out.println("<link rel=\"stylesheet\" href=\"" + parent + this.themeDir + "/" + this.styleFile + "\" type=\"text/css\"/>");
            out.println("</head>");
            out.println("<body>");
            out.println("");
            out.println("<!-- START OF VARIABLE CONTENT -->");
            out.println("");
        } else {
            out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            out.println(this.getHeader(title));
            out.println("<link rel=\"StyleSheet\" href=\"" + parent + this.themeDir + "/" + this.styleFile + "\" type=\"text/css\"/>");
            out.println("</head>");
            out.println("<body>");
        }
    }

    public String getHeader(String title) {
        String str = "";
        if (title != null && title.length() != 0) {
            this.htmlTitle = this.htmlText(this.wp.param_title) + "&nbsp;" + "-" + "&nbsp;" + this.htmlText(this.trs(title));
        }
        str = str + "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">";
        str = str + "<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"" + this.language + "\" lang=\"" + this.language + "\" >";
        str = str + "<head>";
        str = str + "<title>" + this.htmlTitle + "</title>";
        str = str + "<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\" />";
        str = str + "<meta http-equiv=\"Content-Style-Type\" content=\"text/css\" />";
        str = str + "<meta name=\"description\" content=\"" + this.htmlTitle + " " + this.siteDesc + "\" />";
        str = str + "<meta name=\"keywords\" content=\"" + this.keywords + "\" />";
        str = str + "<meta http-equiv=\"Content-language\" content=\"" + this.language + "\" />";
        str = str + "<meta name=\"author\" content=\"" + this.author + "\" />";
        str = str + "<meta name=\"generator\" content=\"Ancestris\" />";
        str = str + "<meta name=\"robots\" content=\"all\" />";
        str = str + "<meta name=\"reply-to\" content=\"" + this.replyto + "\" />";
        str = str + "<meta name=\"owner\" content=\"" + this.owner + "\" />";
        return str;
    }

    public void printOpenHTMLBody(PrintWriter out, String title, WebSection section) {
        if (title != null) {
            String titlePage = "";
            titlePage = title.length() == 0 ? this.wp.param_title : this.trs(title);
            out.println("<div class=\"title\"><a name=\"top\">&nbsp;</a>" + this.htmlText(titlePage) + "</div>");
        }
    }

    public void printCloseHTML(PrintWriter out) {
        out.println("<p><a name=\"bot\"></a>&nbsp;</p>");
        if (this.wp.param_PHP_Support.equals("1")) {
            out.println("");
            out.println("<!-- END OF VARIABLE CONTENT -->");
            out.println("");
            out.println("<?php include(\"" + this.includesDir + "/" + this.includeFooter + "\"); ?>");
            return;
        }
        out.println("</body>");
        out.println("</html>");
    }

    public void exportLinks(PrintWriter out, String pagename, int start, int previous, int next, int last) {
        this.printLinks(out, pagename, this.sectionPrefix + String.format(this.formatNbrs, start) + this.sectionSuffix, this.sectionPrefix + String.format(this.formatNbrs, previous) + this.sectionSuffix, this.sectionPrefix + String.format(this.formatNbrs, next) + this.sectionSuffix, this.sectionPrefix + String.format(this.formatNbrs, last) + this.sectionSuffix, this);
    }

    public void printLinks(PrintWriter out, String here, WebSection wsFrom) {
        this.printLinks(out, here, "", "", "", "", wsFrom);
    }

    public void printLinks(PrintWriter out, String here, String s, String p, String n, String e, WebSection wsFrom) {
        String theme;
        String string = theme = wsFrom == null ? this.themeDir + "/" : this.buildLinkTheme(wsFrom, this.themeDir);
        String home = wsFrom == null ? this.indexFile : (wsFrom.sectionDir.length() == 0 ? "" : "../") + this.indexFile;
        out.println("<p class=\"footer\">");
        out.println("<br /><br />");
        out.println("<a href=\"" + here + "#top\"><img src=\"" + theme + "t.gif\" alt=\"" + this.trs("alt_top") + "\" title=\"" + this.trs("alt_top") + "\" /></a><br />");
        if (s != null && s.length() > 0) {
            out.println("<a href=\"" + s + "\"><img src=\"" + theme + "s.gif\" alt=\"" + this.trs("alt_start") + "\" title=\"" + this.trs("alt_start") + "\" /></a>");
        }
        if (p != null && p.length() > 0) {
            out.println("<a href=\"" + p + "\"><img src=\"" + theme + "p.gif\" alt=\"" + this.trs("alt_previous") + "\" title=\"" + this.trs("alt_previous") + "\" /></a>");
        }
        out.println("<a href=\"" + home + "#top\"><img src=\"" + theme + "h.gif\" alt=\"" + this.trs("alt_home") + "\" title=\"" + this.trs("alt_home") + "\" /></a>");
        if (n != null && n.length() > 0) {
            out.println("<a href=\"" + n + "\"><img src=\"" + theme + "n.gif\" alt=\"" + this.trs("alt_next") + "\" title=\"" + this.trs("alt_next") + "\" /></a>");
        }
        if (e != null && e.length() > 0) {
            out.println("<a href=\"" + e + "\"><img src=\"" + theme + "e.gif\" alt=\"" + this.trs("alt_end") + "\" title=\"" + this.trs("alt_end") + "\"  /></a>");
        }
        out.println("<br /><a href=\"" + here + "#bot\"><img src=\"" + theme + "b.gif\" alt=\"" + this.trs("alt_bottom") + "\" title=\"" + this.trs("alt_bottom") + "\" /></a>");
        out.println("</p>");
    }

    public void printHomeLink(PrintWriter out, WebSection wsFrom) {
        String theme;
        String string = theme = wsFrom == null ? this.themeDir + "/" : this.buildLinkTheme(wsFrom, this.themeDir);
        String home = wsFrom == null ? this.indexFile : (wsFrom.sectionDir.length() == 0 ? "" : "../") + this.indexFile;
        out.println("<p class=\"footer\">");
        out.println("<br /><br />");
        out.println("<a href=\"" + home + "#top\" ><img src=\"" + theme + "h.gif\" alt=\"" + this.trs("alt_home") + "\" title=\"" + this.trs("alt_home") + "\"/></a>");
        out.println("</p>");
    }

    public String getHomeLink(WebSection wsFrom) {
        String home = wsFrom == null ? this.indexFile : (wsFrom.sectionDir.length() == 0 ? "" : "../") + this.indexFile;
        return home + "#top";
    }

    public String buildLink(WebSection wsFrom, WebSection wsTo, int nbItem) {
        String relPath = "";
        if (wsFrom.sectionDir.length() == 0 && wsTo.sectionDir.length() == 0) {
            relPath = "";
        }
        if (wsFrom.sectionDir.length() == 0 && wsTo.sectionDir.length() != 0) {
            relPath = wsTo.sectionDir + "/";
        }
        if (wsFrom.sectionDir.length() != 0 && wsTo.sectionDir.length() == 0) {
            relPath = "../";
        }
        if (wsFrom.sectionDir.length() != 0 && wsTo.sectionDir.length() != 0) {
            relPath = "../" + wsTo.sectionDir + "/";
        }
        return relPath + wsTo.sectionPrefix + String.format(wsTo.formatNbrs, nbItem / wsTo.nbPerPage + 1) + wsTo.sectionSuffix;
    }

    public String buildLinkTheme(WebSection wsFrom, String themeDir) {
        String relPath = "";
        if (wsFrom.sectionDir.length() == 0 && themeDir.length() == 0) {
            relPath = "";
        }
        if (wsFrom.sectionDir.length() == 0 && themeDir.length() != 0) {
            relPath = themeDir + "/";
        }
        if (wsFrom.sectionDir.length() != 0 && themeDir.length() == 0) {
            relPath = "../";
        }
        if (wsFrom.sectionDir.length() != 0 && themeDir.length() != 0) {
            relPath = "../" + themeDir + "/";
        }
        return relPath;
    }

    public String buildLinkShort(WebSection wsFrom, WebSection wsTo) {
        String relPath = "";
        if (wsFrom.sectionDir.length() == 0 && wsTo.sectionDir.length() == 0) {
            relPath = "";
        }
        if (wsFrom.sectionDir.length() == 0 && wsTo.sectionDir.length() != 0) {
            relPath = wsTo.sectionDir + "/";
        }
        if (wsFrom.sectionDir.length() != 0 && wsTo.sectionDir.length() == 0) {
            relPath = "../";
        }
        if (wsFrom.sectionDir.length() != 0 && wsTo.sectionDir.length() != 0) {
            relPath = "../" + wsTo.sectionDir + "/";
        }
        return relPath;
    }

    public void createPopupEmail(File file) {
        PrintWriter out = this.wh.getWriter(file, this.UTF8);
        out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />");
        out.println("<html><head><title>" + this.trs("TXT_popupemail_title") + "</title>");
        out.println("<link rel=\"StyleSheet\" href=\"../" + this.themeDir + "/" + this.styleFile + "\" type=\"text/css\"/>");
        out.println("<script language='javascript'>");
        out.println("var arrTemp=self.location.href.split(\"?\");");
        out.println("var person = (arrTemp.length>0) ? \": \"+arrTemp[1] : \"\";");
        out.println("</script>");
        out.println("</head>");
        out.println("<body bgcolor=\"#ffffff\" topmargin=\"10\" marginheight=\"10\" leftmargin=\"10\" marginwidth=\"10\">");
        out.println("<div class=\"contreport\">");
        out.println("<p class=\"decal\"><br /><span class=\"gras\">" + this.htmlText(this.trs("TXT_emailform_description")) + "</span></p>");
        out.println("<p class=\"description\">" + this.htmlText(this.trs("TXT_emailform_info")) + "</p>");
        out.println("</div>");
        out.println("<div class=\"contreport\">");
        out.println("<p class=\"decal\"><br /><span class=\"gras\">" + this.htmlText(this.trs("TXT_emailform_form")) + "</span></p>");
        out.println("<p class=\"description\">");
        out.println("  <script language='javascript'>");
        out.println("  document.write( \"<form class='description' action='mailto:" + this.wp.param_email + "?subject=" + this.trs("TXT_idx_email_subject") + "\" + person + \"' method='post' enctype='text/plain' >\" );");
        out.println("  </script>");
        out.println("  " + this.htmlText(this.trs("TXT_emailform_name")) + "&nbsp;<input type=\"text\" size=\"60\" name=\"" + this.htmlText(this.trs("TXT_emailform_mynameis")) + "\"><br /><br />");
        out.println("  " + this.htmlText(this.trs("TXT_emailform_reason")) + "&nbsp;<input type=\"text\" size=\"60\" name=\"" + this.htmlText(this.trs("TXT_emailform_reason")) + "\"><br /><br />");
        out.println("  " + this.htmlText(this.trs("TXT_emailform_message")) + "&nbsp;<br />");
        out.println("  <textarea name=\"" + this.htmlText(this.trs("TXT_emailform_message")) + "\" cols=77 rows=8 wrap=virtual></textarea><br /><br />");
        out.println("  <center><input onclick='self.close();' type=\"submit\" value=\"" + this.htmlText(this.trs("TXT_emailform_send")) + "\">&nbsp;&nbsp;&nbsp;<input onclick='self.close();' type=\"reset\" value=\"" + this.htmlText(this.trs("TXT_emailform_cancel")) + "\"></center>");
        out.println("  </form>");
        out.println("</p>");
        out.println("<div class=\"spacer\">&nbsp;</div>");
        out.println("</div>");
        out.println("</body></html>");
        out.close();
    }

    public void includePopupScript(PrintWriter out) {
        out.println("<script type=\"text/javascript\">");
        out.println("<!--");
        out.println("function popup(sPicURL, w, h)");
        out.println("{");
        out.println("l=screen.width/2-w/2;");
        out.println("t=screen.height/2-h/2;");
        out.println("window.open( sPicURL, '', 'width='+w+', height='+h+', left='+l+', top='+t+', position=0,scrollbars=yes,toolbar=0,status=0,resizable=0,menubar=0');");
        out.println("}");
        out.println("//-->");
        out.println("</script>");
    }

    public String getKeywords() {
        if (!this.keywords.isEmpty()) {
            return this.keywords;
        }
        String kw = "G\u00e9n\u00e9alogie, Genealogy, ancestors, anc\u00eatres, descendance, famille, family tree";
        List<String> listnames = this.wh.getLastNames("-", this.sortLastnames);
        TreeMap<Integer, String> volumePerName = new TreeMap<Integer, String>(new Comparator<Integer>(){

            @Override
            public int compare(Integer i1, Integer i2) {
                return i2.compareTo(i1);
            }
        });
        Iterator<String> it = listnames.iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            if (key.length() <= 0) continue;
            volumePerName.put(this.wh.getLastNameCount(key, "-"), key.trim().toLowerCase());
        }
        int cpt = 0;
        Iterator it1 = volumePerName.keySet().iterator();
        while (it.hasNext()) {
            Integer k = (Integer)it1.next();
            kw = kw + ", " + (String)volumePerName.get(k);
            if (++cpt <= 50) continue;
            break;
        }
        this.keywords = kw = kw + ", fredwebbook";
        return this.keywords;
    }

    public String htmlAnchorText(String anchor) {
        String strInput = "";
        if (anchor == null) {
            return "-";
        }
        strInput = anchor.trim().toLowerCase();
        if (strInput.length() == 0) {
            return "-";
        }
        char[] charInput = strInput.toCharArray();
        StringBuffer strOutput = new StringBuffer(1000);
        for (int i = 0; i < charInput.length; ++i) {
            strOutput.append(this.wh.convertChar(charInput[i], true, "-"));
        }
        return strOutput.toString().toUpperCase();
    }

    public String wrapEntity(Entity ent) {
        return this.wrapEntity(ent, false, 0, true, true, true, true);
    }

    public String wrapEntity(Entity ent, boolean linebreak, int nameType, boolean icon, boolean link, boolean sosa, boolean dispId) {
        String str = "";
        if (ent instanceof Indi) {
            Indi indi = (Indi)ent;
            if (icon) {
                str = str + this.wrapSex(indi) + "&nbsp;";
            }
            str = str + this.wrapName(indi, nameType, link, sosa, dispId);
            if (linebreak) {
                str = str + "<br />";
            }
            str = str + this.wrapDate(indi, true);
        }
        if (ent instanceof Fam) {
            Fam fam = (Fam)ent;
            Indi husband = fam.getHusband();
            Indi wife = fam.getWife();
            if (icon) {
                str = str + this.wrapSex(fam) + "&nbsp;";
            }
            str = str + this.wrapName(husband, nameType, link, sosa, dispId);
            str = str + this.wrapDate(husband, true);
            str = str + "&nbsp;+&nbsp;";
            if (linebreak) {
                str = str + "<br />";
            }
            str = str + this.wrapName(wife, nameType, link, sosa, dispId);
            str = str + this.wrapDate(wife, true);
        }
        return str;
    }

    public String wrapName(Indi indi) {
        return this.wrapName(indi, 0, true, true, true);
    }

    public String wrapName(Indi indi, int nameType, boolean link, boolean sosa, boolean dispId) {
        if (indi == null) {
            return this.wp.param_unknown;
        }
        String str = "";
        String id = indi.getId();
        String personFile = this.personPage.get(id);
        if (link) {
            str = str + "<a href='" + this.prefixPersonDetailsDir + personFile + '#' + id + "'>";
        }
        String privDisplay = this.wh.getPrivDisplay();
        String strClear = "";
        String strHidden = "";
        strClear = this.htmlText(this.getNameDisplay(indi, nameType, privDisplay, false));
        strHidden = this.htmlText(this.getNameDisplay(indi, nameType, privDisplay, true));
        String sosaNb = "";
        if (sosa && (sosaNb = this.wh.getSosa(indi)) != null && sosaNb.length() != 0) {
            strClear = strClear + "&nbsp;(" + sosaNb + ")";
            strHidden = strHidden + "&nbsp;(" + privDisplay + ")";
        }
        if (this.wp.param_dispId.equals("1") && id != null && !id.isEmpty() && dispId) {
            strClear = strClear + "&nbsp;(" + id + ")";
            strHidden = strHidden + "&nbsp;(" + privDisplay + ")";
        }
        str = str + this.phpText((Property)indi, strClear, this.hidePrivateData ? strHidden : strClear);
        if (link) {
            str = str + "</a>";
        }
        return str;
    }

    private String getNameDisplay(Indi indi, int nameType, String privDisplay, boolean hidden) {
        String name = "";
        String lastname = "";
        String firstname = "";
        if (hidden) {
            lastname = privDisplay;
            firstname = privDisplay;
        } else {
            lastname = this.wh.getLastName(indi, "-");
            firstname = indi.getFirstName().trim();
        }
        switch (nameType) {
            case 0: {
                name = lastname + ", " + firstname;
                break;
            }
            case 1: {
                name = firstname + " " + lastname;
                break;
            }
            case 2: {
                name = lastname;
                break;
            }
            default: {
                name = lastname + ", " + firstname;
            }
        }
        return name;
    }

    public String wrapDate(Indi indi, boolean parenthesis) {
        if (indi == null) {
            return "";
        }
        String str = "";
        String privDisplay = this.wh.getPrivDisplay();
        String strClear = "";
        String strHidden = "";
        String date = "";
        PropertyDate bdate = indi.getBirthDate();
        PropertyDate ddate = indi.getDeathDate();
        String birthdate = bdate == null ? "." : bdate.getDisplayValue();
        String deathdate = ddate == null ? "" : " - " + ddate.getDisplayValue();
        date = (birthdate + deathdate).trim();
        if (!date.equals(".")) {
            strClear = "&nbsp;" + (parenthesis ? "(" : "") + this.htmlText(date) + (parenthesis ? ")" : "");
            strHidden = "&nbsp;" + (parenthesis ? "(" : "") + this.htmlText(privDisplay) + (parenthesis ? ")" : "");
        }
        if (date.isEmpty()) {
            return "";
        }
        str = str + this.phpText((Property)indi, strClear, this.hidePrivateData ? strHidden : strClear);
        return str;
    }

    public String wrapSex(Indi indi) {
        int iSex;
        if (indi == null) {
            return "";
        }
        String str = "";
        String themeDirLink = this.buildLinkTheme(this, this.themeDir);
        String strClear = "";
        String strHidden = "<img src='" + themeDirLink + "u.gif' alt='" + this.trs("alt_unknown") + "' />";
        int n = iSex = indi == null ? 0 : indi.getSex();
        strClear = iSex == 1 ? "<img src='" + themeDirLink + "m.gif' alt='" + this.trs("alt_male") + "' />" : (iSex == 2 ? "<img src='" + themeDirLink + "f.gif' alt='" + this.trs("alt_female") + "' />" : "<img src='" + themeDirLink + "u.gif' alt='" + this.trs("alt_unknown") + "' />");
        str = str + this.phpText((Property)indi, strClear, this.hidePrivateData ? strHidden : strClear);
        return str;
    }

    public String wrapSex(Fam fam) {
        String themeDirLink = this.buildLinkTheme(this, this.themeDir);
        return "<img src='" + themeDirLink + "u.gif' alt='" + this.trs("alt_unknown") + "' />";
    }

    public String getSexStyle(Indi indi) {
        if (indi == null) {
            return "";
        }
        String str = "";
        String strClear = "";
        String strHidden = "unk";
        strClear = indi.getSex() == 1 ? strClear + "hom" : (indi.getSex() == 2 ? strClear + "fem" : strClear + "unk");
        str = str + this.phpText((Property)indi, strClear, this.hidePrivateData ? strHidden : strClear);
        return str;
    }

    public String wrapEmailButton(Indi indi, String picture, String title) {
        if (indi == null) {
            return this.wp.param_unknown;
        }
        String str = "";
        String themeDirLink = this.buildLinkTheme(this, this.themeDir);
        String strHidden = "<img src='" + themeDirLink + picture + "' />";
        title = this.htmlText(title);
        if (this.wh.isPrivate((Entity)indi)) {
            String strClear = "<a href='javascript:popup(\\\"" + this.htmlText(indi.toString()) + "\\\")'><img src='" + themeDirLink + picture + "' alt='" + title + "' title='" + title + "'/></a>";
            str = str + this.phpText((Property)indi, strClear, this.hidePrivateData ? strHidden : strClear);
        } else {
            String strClear = "<a href='javascript:popup(\"" + this.htmlText(indi.toString()) + "\")'><img src='" + themeDirLink + picture + "' alt='" + title + "' title='" + title + "'/></a>";
            str = str + strClear;
        }
        return str;
    }

    public String wrapEvents(Entity entity, boolean includeFamilies, String from2sourceDir, String from2mediaDir) {
        if (entity == null) {
            return this.wp.param_unknown;
        }
        String str = "";
        String strClear = "";
        String themeDirLink = this.buildLinkTheme(this, this.themeDir);
        List<String> listEvents = this.getEventDetails(entity, from2sourceDir, from2mediaDir);
        if (entity instanceof Indi && includeFamilies) {
            Indi indi = (Indi)entity;
            Fam[] families = indi.getFamiliesWhereSpouse();
            for (int i = 0; families != null && i < families.length; ++i) {
                Fam family = families[i];
                listEvents.addAll(this.getEventDetails((Entity)family, from2sourceDir, from2mediaDir));
            }
        }
        Collections.sort(listEvents);
        for (String event : listEvents) {
            String[] eventBits = event.split("\\|", -1);
            strClear = strClear + "<img src='" + themeDirLink + "ev_" + eventBits[3] + ".png" + "' alt='' />";
            strClear = strClear + eventBits[1].trim();
            if (this.wp.param_media_GeneSources.equals("1") && eventBits[2].length() != 0) {
                strClear = strClear + eventBits[2].trim();
            }
            if (this.wp.param_media_GeneMedia.equals("1") && eventBits[4].length() != 0) {
                strClear = strClear + eventBits[4];
            }
            if (eventBits[5].length() != 0) {
                strClear = strClear + eventBits[5];
            }
            strClear = strClear + "<br />";
        }
        str = this.wh.isPrivate(entity) ? str + this.phpText((Property)entity, strClear, this.wh.getPrivDisplay() + "<br />") : str + strClear;
        return str;
    }

    public List<String> getEventDetails(Entity entity, String from2sourceDir, String from2mediaDir) {
        String privDisplay = this.wh.getPrivDisplay();
        String[] ev = null;
        if (entity == null) {
            return null;
        }
        if (entity instanceof Indi) {
            ev = this.events;
        } else if (entity instanceof Fam) {
            ev = this.eventsMarr;
        } else {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        String description = "";
        String date = "";
        for (int i = 0; i < ev.length; ++i) {
            Property[] props = entity.getProperties(ev[i]);
            for (int j = 0; j < props.length; ++j) {
                String format;
                String juridic;
                PropertyDate pDate;
                Property p = props[j].getProperty("DATE");
                PropertyDate propertyDate = pDate = p instanceof PropertyDate ? (PropertyDate)p : null;
                date = ev[i].equals("BIRT") ? "0-" : (ev[i].equals("DEAT") ? "8-" : (ev[i].equals("BURI") || ev[i].equals("CREM") ? "9-" : "5-"));
                if (pDate == null) {
                    date = date + "-";
                } else {
                    PointInTime pit = null;
                    try {
                        pit = pDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN);
                        date = date + "";
                        date = date + pit.getYear();
                        date = date + pit.getMonth();
                        date = date + pit.getJulianDay();
                    }
                    catch (GedcomException e) {
                        date = date + pDate.getStart();
                    }
                }
                String format1 = "<span class='gras'> { $T}: </span>";
                String format2 = this.showDate ? "{ $D}" : "";
                String format3 = "{ $V}";
                if (this.showPlace && (juridic = props[j].format(format = this.showAllPlaceJurisdictions ? "{ $P}" : "{ $p}").trim()) != null) {
                    format3 = format3 + " " + juridic.replaceAll(",", " ");
                }
                if ("RESI".compareTo(ev[i]) == 0) {
                    Property city = props[j].getProperty(new TagPath(".:ADDR:CITY"));
                    Property ctry = props[j].getProperty(new TagPath(".:ADDR:CTRY"));
                    format3 = " " + (city == null ? "" : city.getDisplayValue() + ", ") + (ctry == null ? "" : ctry.getDisplayValue());
                }
                format = format1 + format2 + " : " + format3;
                description = props[j].format(format).trim();
                String source = "";
                Property[] pSources = props[j].getProperties("SOUR");
                if (pSources != null && pSources.length > 0) {
                    for (int k = 0; k < pSources.length; ++k) {
                        if (!(pSources[k] instanceof PropertySource)) continue;
                        PropertySource pSource = (PropertySource)pSources[k];
                        source = source + this.wrapSource(this.buildLinkTheme(this, this.themeDir) + "src.gif", pSource, from2sourceDir);
                    }
                }
                String event_tag = props[j].getTag().toLowerCase();
                String media = "";
                Property[] pMedias = props[j].getProperties("OBJE");
                if (pMedias != null && pMedias.length > 0) {
                    for (Property pMedia : pMedias) {
                        PropertyFile pFile = (PropertyFile)pMedia.getProperty("FILE");
                        media = media + this.wrapMedia(null, pFile, from2mediaDir, false, false, true, false, this.buildLinkTheme(this, this.themeDir) + "media.png", "", false, "OBJE:NOTE", "tooltip");
                    }
                }
                String note = "";
                Property[] pNotes = props[j].getProperties("NOTE");
                if (pNotes != null && pNotes.length > 0) {
                    for (Property pNote : pNotes) {
                        note = note + this.wrapNote(this.buildLinkTheme(this, this.themeDir) + "note.png", pNote);
                    }
                }
                if (this.wh.isPrivate(entity)) {
                    list.add(date + "|" + description + "|" + source + "|" + event_tag + "|" + media + "|" + note);
                    continue;
                }
                String str = date + "|";
                str = str + this.phpText(props[j], description, privDisplay) + "|";
                str = str + this.phpText(props[j], source, privDisplay) + "|";
                str = str + event_tag + "|";
                str = str + this.phpText(props[j], media, privDisplay) + "|";
                str = str + this.phpText(props[j], note, privDisplay);
                list.add(str);
            }
        }
        Collections.sort(list);
        return list;
    }

    private String wrapSource(String origFile, PropertySource source, String from2sourceDir) {
        String sourceFile;
        String id = "";
        if (source != null && source.getTargetEntity() != null) {
            id = source.getTargetEntity().getId();
        }
        String link = "";
        String string = id == null ? "" : (sourceFile = this.sourcePage == null ? "" : this.sourcePage.get(id));
        if (id != null) {
            link = from2sourceDir + sourceFile + '#' + id;
        }
        String ret = "<a class=tooltip href='" + link + "'>";
        ret = ret + "<img src='" + origFile + "' alt='" + id + "' />";
        ret = ret + "<span>" + this.htmlText(this.trs("TXT_src_comment")) + "&nbsp;" + id + "</span></a>";
        return ret;
    }

    public String wrapMedia(File dir, PropertyFile file, String from2mediaDir, boolean toBeCopied, boolean useLink, boolean displayMin, boolean popup, String forcedIcon, String defaultTitle, boolean displayTitle, String textPath, String style) {
        String quote;
        if (file == null) {
            return "";
        }
        String str = "";
        boolean isFileValid = file != null && file.getFile() != null;
        boolean isImage = isFileValid ? this.wh.isImage(file.getFile().getAbsolutePath()) : false;
        String miniPrefix = "mini_";
        String strClear = "";
        String strHidden = "";
        String privDisplay = this.wh.getPrivDisplay();
        String privMedia = this.isUnderSource((Property)file) ? "medprivSour.png" : "medprivPic.png";
        String filename = this.wh.getCleanFileName(file.getValue(), "-");
        if (isFileValid && toBeCopied) {
            try {
                this.wh.copy(file.getFile().getAbsolutePath(), dir.getAbsolutePath() + File.separator + filename, useLink, false);
            }
            catch (IOException e) {
                this.wb.log.write(this.wb.log.ERROR, "wrapMedia - " + e.getMessage());
            }
            if (displayMin && isImage) {
                this.wh.scaleImage(file.getFile().getAbsolutePath(), dir.getAbsolutePath() + File.separator + miniPrefix + filename, 200, 0, 100, false);
            }
        }
        String hrefHidden = "";
        String href = "";
        String string = quote = this.wh.isPrivate((Property)file) && this.wp.param_PHP_Support.equals("1") ? "\\\"" : "\"";
        if (isFileValid) {
            if (popup) {
                if (isImage) {
                    href = "'javascript:popup(" + quote + filename + quote + "," + quote + this.wh.getImageSize(file.getFile().getAbsolutePath(), quote) + quote + ")'";
                    hrefHidden = hrefHidden + "'javascript:popup(" + quote + this.buildLinkTheme(this, this.themeDir) + privMedia + quote + "," + quote + "120" + quote + "," + quote + "120" + quote + ")'";
                } else {
                    href = "'javascript:popup(" + quote + filename + quote + "," + quote + "400" + quote + "," + quote + "500" + quote + ")'";
                    hrefHidden = hrefHidden + "'javascript:popup(" + quote + this.buildLinkTheme(this, this.themeDir) + privMedia + quote + "," + quote + "120" + quote + "," + quote + "120" + quote + ")'";
                }
            } else {
                href = "'" + from2mediaDir + this.wb.sectionMedia.getPageForMedia(file) + "'";
            }
        } else {
            href = "''";
        }
        String titleHidden = privDisplay;
        String title = "";
        title = defaultTitle != null && !defaultTitle.trim().isEmpty() ? defaultTitle : this.wh.getTitle(file, "-");
        String srcHidden = this.buildLinkTheme(this, this.themeDir) + privMedia;
        String src = "";
        if (forcedIcon.isEmpty()) {
            if (displayMin) {
                src = isFileValid ? (isImage ? from2mediaDir + miniPrefix + filename : this.buildLinkTheme(this, this.themeDir) + "mednopic.png") : this.buildLinkTheme(this, this.themeDir) + "medno.png";
            }
        } else {
            src = this.buildLinkTheme(this, this.themeDir) + forcedIcon;
        }
        String textHidden = privDisplay;
        String text = "";
        for (Property prop = file.getParent(); prop != null; prop = prop.getParent()) {
            Property pText = prop.getProperty(new TagPath(textPath));
            if (pText == null) {
                continue;
            }
            text = pText.getDisplayValue();
            break;
        }
        strClear = !href.isEmpty() ? strClear + "<a class=" + style + " href=" + href + " >" : strClear + "<a class=" + style + " >";
        strHidden = !hrefHidden.isEmpty() ? strHidden + "<a class=" + style + " href=" + hrefHidden + " >" : strHidden + "<a class=" + style + " >";
        if (displayMin) {
            strClear = strClear + "<img alt='" + this.htmlText(title) + "' title='" + this.htmlText(title) + "' src='" + src + "' />";
            strHidden = strHidden + "<img alt='" + this.htmlText(titleHidden) + "' title='" + this.htmlText(titleHidden) + "' src='" + srcHidden + "' />";
        } else {
            strClear = strClear + this.htmlText(title);
            strHidden = strHidden + this.htmlText(titleHidden);
        }
        strClear = strClear + "<span>";
        strHidden = strHidden + "<span>";
        if (!title.isEmpty()) {
            strClear = strClear + "<b>" + this.htmlText(title) + "</b><br>";
            strHidden = strHidden + "<b>" + this.htmlText(titleHidden) + "</b><br>";
        }
        strClear = strClear + "<i>" + this.htmlText(text) + "</i></span></a>";
        strHidden = strHidden + "<i>" + this.htmlText(textHidden) + "</i></span></a>";
        if (displayTitle) {
            strClear = strClear + "<br />" + this.htmlText(title) + "<br />";
            strHidden = strHidden + "<br />" + this.htmlText(titleHidden) + "<br />";
        }
        str = str + this.phpText((Property)file, strClear, this.hidePrivateData ? strHidden : strClear);
        return str;
    }

    private String wrapNote(String pictureFile, Property note) {
        if (note instanceof PropertyNote) {
            note = ((PropertyNote)note).getTargetEntity();
        }
        String noteText = "<i>" + (note == null || note.getValue().trim().isEmpty() ? "" : this.htmlText(note.getValue())) + "</i>";
        String ret = "<a class=tooltip '>";
        ret = ret + "<img src='" + pictureFile + "' />";
        ret = ret + "<span>" + noteText + "</span></a>";
        return ret;
    }

    public String wrapPropertyName(Property prop) {
        if (prop == null) {
            return "";
        }
        return this.phpText(prop, this.htmlText(prop.getPropertyName()), this.htmlText(this.wh.getPrivDisplay()));
    }

    public String wrapPropertyValue(Property prop) {
        if (prop == null) {
            return "";
        }
        String str = prop.getValue();
        if (prop instanceof PropertyXRef) {
            str = ((PropertyXRef)prop).getTarget().toString();
        }
        return this.phpText(prop, this.htmlText(str), this.htmlText(this.wh.getPrivDisplay()));
    }

    public String wrapEventDate(PropertyDate date) {
        String str = this.trs("place_nodate");
        if (date != null) {
            str = date.getDisplayValue();
        }
        return this.phpText((Property)date, this.htmlText(str), this.htmlText(this.wh.getPrivDisplay()));
    }

    public String wrapString(Property prop, String str) {
        if (str == null) {
            return "";
        }
        return this.phpText(prop, this.htmlText(str), this.htmlText(this.wh.getPrivDisplay()));
    }

    public boolean isUnderSource(Property prop) {
        Property parent = prop.getParent();
        if (parent == null) {
            return false;
        }
        return parent.getTag().compareTo("SOUR") == 0 ? true : this.isUnderSource(parent);
    }

    private String phpText(Property prop, String strClear, String strHidden) {
        if (this.wh.isPrivate(prop)) {
            if (this.wp.param_PHP_Support.equals("1")) {
                return "<?php echo " + this.wp.param_PHP_Test + " ? \"" + strClear + "\" : \"" + strHidden + "\" ?>";
            }
            return this.hidePrivateData ? strHidden : strClear;
        }
        return strClear;
    }

    public String htmlText(int i) {
        return this.htmlText(Integer.toString(i));
    }

    public String htmlText(double d) {
        return this.htmlText(Double.toString(d));
    }

    public String htmlText(Object o) {
        return this.htmlText(o.toString());
    }

    public String htmlText(String text) {
        return this.htmlText(text, true);
    }

    public String htmlText(String text, boolean convertTags) {
        char[] charInput = text.toCharArray();
        StringBuffer strOutput = new StringBuffer(1000);
        block143: for (int i = 0; i < charInput.length; ++i) {
            switch (charInput[i]) {
                case '\n': {
                    strOutput.append("<br />");
                    continue block143;
                }
                case '<': {
                    strOutput.append(convertTags ? "&lt;" : String.valueOf(charInput[i]));
                    continue block143;
                }
                case '>': {
                    strOutput.append(convertTags ? "&gt;" : String.valueOf(charInput[i]));
                    continue block143;
                }
                case '&': {
                    strOutput.append(convertTags ? "&amp;" : String.valueOf(charInput[i]));
                    continue block143;
                }
                case '\"': {
                    strOutput.append(convertTags ? "&quot;" : String.valueOf(charInput[i]));
                    continue block143;
                }
                case '\u00a1': {
                    strOutput.append("&iexcl;");
                    continue block143;
                }
                case '\u00a2': {
                    strOutput.append("&cent;");
                    continue block143;
                }
                case '\u00a3': {
                    strOutput.append("&pound;");
                    continue block143;
                }
                case '\u00a4': {
                    strOutput.append("&curren;");
                    continue block143;
                }
                case '\u00a5': {
                    strOutput.append("&yen;");
                    continue block143;
                }
                case '\u00a6': {
                    strOutput.append("&brvbar;");
                    continue block143;
                }
                case '\u00a7': {
                    strOutput.append("&sect;");
                    continue block143;
                }
                case '\u00a8': {
                    strOutput.append("&uml;");
                    continue block143;
                }
                case '\u00a9': {
                    strOutput.append("&copy;");
                    continue block143;
                }
                case '\u00aa': {
                    strOutput.append("&ordf;");
                    continue block143;
                }
                case '\u00ab': {
                    strOutput.append("&laquo;");
                    continue block143;
                }
                case '\u00ac': {
                    strOutput.append("&not;");
                    continue block143;
                }
                case '\u00ad': {
                    strOutput.append("&shy;");
                    continue block143;
                }
                case '\u00ae': {
                    strOutput.append("&reg;");
                    continue block143;
                }
                case '\u00af': {
                    strOutput.append("&hibar;");
                    continue block143;
                }
                case '\u00b0': {
                    strOutput.append("&deg;");
                    continue block143;
                }
                case '\u00b1': {
                    strOutput.append("&plusmn;");
                    continue block143;
                }
                case '\u00b2': {
                    strOutput.append("&sup2;");
                    continue block143;
                }
                case '\u00b3': {
                    strOutput.append("&sup3;");
                    continue block143;
                }
                case '\u00b4': {
                    strOutput.append("&acute;");
                    continue block143;
                }
                case '\u00b5': {
                    strOutput.append("&micro;");
                    continue block143;
                }
                case '\u00b6': {
                    strOutput.append("&para;");
                    continue block143;
                }
                case '\u00b7': {
                    strOutput.append("&middot;");
                    continue block143;
                }
                case '\u00b8': {
                    strOutput.append("&cedil;");
                    continue block143;
                }
                case '\u00b9': {
                    strOutput.append("&sup1;");
                    continue block143;
                }
                case '\u00ba': {
                    strOutput.append("&ordm;");
                    continue block143;
                }
                case '\u00bb': {
                    strOutput.append("&raquo;");
                    continue block143;
                }
                case '\u00bc': {
                    strOutput.append("&frac14;");
                    continue block143;
                }
                case '\u00bd': {
                    strOutput.append("&frac12;");
                    continue block143;
                }
                case '\u00be': {
                    strOutput.append("&frac34;");
                    continue block143;
                }
                case '\u00bf': {
                    strOutput.append("&iquest;");
                    continue block143;
                }
                case '\u00c0': {
                    strOutput.append("&Agrave;");
                    continue block143;
                }
                case '\u00c1': {
                    strOutput.append("&Aacute;");
                    continue block143;
                }
                case '\u00c2': {
                    strOutput.append("&Acirc;");
                    continue block143;
                }
                case '\u00c3': {
                    strOutput.append("&Atilde;");
                    continue block143;
                }
                case '\u00c4': {
                    strOutput.append("&Auml;");
                    continue block143;
                }
                case '\u00c5': {
                    strOutput.append("&Aring;");
                    continue block143;
                }
                case '\u00c6': {
                    strOutput.append("&AElig;");
                    continue block143;
                }
                case '\u00c7': {
                    strOutput.append("&Ccedil;");
                    continue block143;
                }
                case '\u00c8': {
                    strOutput.append("&Egrave;");
                    continue block143;
                }
                case '\u00c9': {
                    strOutput.append("&Eacute;");
                    continue block143;
                }
                case '\u00ca': {
                    strOutput.append("&Ecirc;");
                    continue block143;
                }
                case '\u00cb': {
                    strOutput.append("&Euml;");
                    continue block143;
                }
                case '\u00cc': {
                    strOutput.append("&Igrave;");
                    continue block143;
                }
                case '\u00cd': {
                    strOutput.append("&Iacute;");
                    continue block143;
                }
                case '\u00ce': {
                    strOutput.append("&Icirc;");
                    continue block143;
                }
                case '\u00cf': {
                    strOutput.append("&Iuml;");
                    continue block143;
                }
                case '\u00d0': {
                    strOutput.append("&ETH;");
                    continue block143;
                }
                case '\u00d1': {
                    strOutput.append("&Ntilde;");
                    continue block143;
                }
                case '\u00d2': {
                    strOutput.append("&Ograve;");
                    continue block143;
                }
                case '\u00d3': {
                    strOutput.append("&Oacute;");
                    continue block143;
                }
                case '\u00d4': {
                    strOutput.append("&Ocirc;");
                    continue block143;
                }
                case '\u00d5': {
                    strOutput.append("&Otilde;");
                    continue block143;
                }
                case '\u00d6': {
                    strOutput.append("&Ouml;");
                    continue block143;
                }
                case '\u00d7': {
                    strOutput.append("&times;");
                    continue block143;
                }
                case '\u00d8': {
                    strOutput.append("&Oslash;");
                    continue block143;
                }
                case '\u00d9': {
                    strOutput.append("&Ugrave;");
                    continue block143;
                }
                case '\u00da': {
                    strOutput.append("&Uacute;");
                    continue block143;
                }
                case '\u00db': {
                    strOutput.append("&Ucirc;");
                    continue block143;
                }
                case '\u00dc': {
                    strOutput.append("&Uuml;");
                    continue block143;
                }
                case '\u00dd': {
                    strOutput.append("&Yacute;");
                    continue block143;
                }
                case '\u00de': {
                    strOutput.append("&THORN;");
                    continue block143;
                }
                case '\u00df': {
                    strOutput.append("&szlig;");
                    continue block143;
                }
                case '\u00e0': {
                    strOutput.append("&agrave;");
                    continue block143;
                }
                case '\u00e1': {
                    strOutput.append("&aacute;");
                    continue block143;
                }
                case '\u00e2': {
                    strOutput.append("&acirc;");
                    continue block143;
                }
                case '\u00e3': {
                    strOutput.append("&atilde;");
                    continue block143;
                }
                case '\u00e4': {
                    strOutput.append("&auml;");
                    continue block143;
                }
                case '\u00e5': {
                    strOutput.append("&aring;");
                    continue block143;
                }
                case '\u00e6': {
                    strOutput.append("&aelig;");
                    continue block143;
                }
                case '\u00e7': {
                    strOutput.append("&ccedil;");
                    continue block143;
                }
                case '\u00e8': {
                    strOutput.append("&egrave;");
                    continue block143;
                }
                case '\u00e9': {
                    strOutput.append("&eacute;");
                    continue block143;
                }
                case '\u00ea': {
                    strOutput.append("&ecirc;");
                    continue block143;
                }
                case '\u00eb': {
                    strOutput.append("&euml;");
                    continue block143;
                }
                case '\u00ec': {
                    strOutput.append("&igrave;");
                    continue block143;
                }
                case '\u00ed': {
                    strOutput.append("&iacute;");
                    continue block143;
                }
                case '\u00ee': {
                    strOutput.append("&icirc;");
                    continue block143;
                }
                case '\u00ef': {
                    strOutput.append("&iuml;");
                    continue block143;
                }
                case '\u00f0': {
                    strOutput.append("&eth;");
                    continue block143;
                }
                case '\u00f1': {
                    strOutput.append("&ntilde;");
                    continue block143;
                }
                case '\u00f2': {
                    strOutput.append("&ograve;");
                    continue block143;
                }
                case '\u00f3': {
                    strOutput.append("&oacute;");
                    continue block143;
                }
                case '\u00f4': {
                    strOutput.append("&ocirc;");
                    continue block143;
                }
                case '\u00f5': {
                    strOutput.append("&otilde;");
                    continue block143;
                }
                case '\u00f6': {
                    strOutput.append("&ouml;");
                    continue block143;
                }
                case '\u00f7': {
                    strOutput.append("&divide;");
                    continue block143;
                }
                case '\u00f8': {
                    strOutput.append("&oslash;");
                    continue block143;
                }
                case '\u00f9': {
                    strOutput.append("&ugrave;");
                    continue block143;
                }
                case '\u00fa': {
                    strOutput.append("&uacute;");
                    continue block143;
                }
                case '\u00fb': {
                    strOutput.append("&ucirc;");
                    continue block143;
                }
                case '\u00fc': {
                    strOutput.append("&uuml;");
                    continue block143;
                }
                case '\u00fd': {
                    strOutput.append("&yacute;");
                    continue block143;
                }
                case '\u00fe': {
                    strOutput.append("&thorn;");
                    continue block143;
                }
                case '\u00ff': {
                    strOutput.append("&yuml;");
                    continue block143;
                }
                case '\u0152': {
                    strOutput.append("&OElig;");
                    continue block143;
                }
                case '\u0153': {
                    strOutput.append("&oelig;");
                    continue block143;
                }
                case '\u0160': {
                    strOutput.append("&Scaron;");
                    continue block143;
                }
                case '\u0161': {
                    strOutput.append("&scaron;");
                    continue block143;
                }
                case '\u0178': {
                    strOutput.append("&Yuml;");
                    continue block143;
                }
                case '\u017d': {
                    strOutput.append("&Zcaron;");
                    continue block143;
                }
                case '\u017e': {
                    strOutput.append("&zcaron;");
                    continue block143;
                }
                case '\u0192': {
                    strOutput.append("&fnof;");
                    continue block143;
                }
                case '\u02c6': {
                    strOutput.append("&circ;");
                    continue block143;
                }
                case '\u02dc': {
                    strOutput.append("&tilde;");
                    continue block143;
                }
                case '\u03a9': {
                    strOutput.append("&Omega;");
                    continue block143;
                }
                case '\u03c0': {
                    strOutput.append("&pi;");
                    continue block143;
                }
                case '\u2013': {
                    strOutput.append("&ndash;");
                    continue block143;
                }
                case '\u2014': {
                    strOutput.append("&mdash;");
                    continue block143;
                }
                case '\u2018': {
                    strOutput.append("&lsquo;");
                    continue block143;
                }
                case '\u2019': {
                    strOutput.append("&rsquo;");
                    continue block143;
                }
                case '\u201a': {
                    strOutput.append("&sbaquo;");
                    continue block143;
                }
                case '\u201c': {
                    strOutput.append("&ldquo;");
                    continue block143;
                }
                case '\u201d': {
                    strOutput.append("&rdquo;");
                    continue block143;
                }
                case '\u201e': {
                    strOutput.append("&bdquote;");
                    continue block143;
                }
                case '\u2020': {
                    strOutput.append("&dagger;");
                    continue block143;
                }
                case '\u2021': {
                    strOutput.append("&Dagger;");
                    continue block143;
                }
                case '\u2022': {
                    strOutput.append("&bull;");
                    continue block143;
                }
                case '\u2026': {
                    strOutput.append("&hellip;");
                    continue block143;
                }
                case '\u2030': {
                    strOutput.append("&permil;");
                    continue block143;
                }
                case '\u2039': {
                    strOutput.append("&lsaquo;");
                    continue block143;
                }
                case '\u203a': {
                    strOutput.append("&rsaquo;");
                    continue block143;
                }
                case '\u2044': {
                    strOutput.append("&frasl;");
                    continue block143;
                }
                case '\u20ac': {
                    strOutput.append("&euro;");
                    continue block143;
                }
                case '\u2122': {
                    strOutput.append("&trade;");
                    continue block143;
                }
                case '\u2202': {
                    strOutput.append("&part;");
                    continue block143;
                }
                case '\u220f': {
                    strOutput.append("&prod;");
                    continue block143;
                }
                case '\u2211': {
                    strOutput.append("&sum;");
                    continue block143;
                }
                case '\u221a': {
                    strOutput.append("&radic;");
                    continue block143;
                }
                case '\u221e': {
                    strOutput.append("&infin;");
                    continue block143;
                }
                case '\u222b': {
                    strOutput.append("&int;");
                    continue block143;
                }
                case '\u2248': {
                    strOutput.append("&asymp;");
                    continue block143;
                }
                case '\u2260': {
                    strOutput.append("&ne;");
                    continue block143;
                }
                case '\u2264': {
                    strOutput.append("&le;");
                    continue block143;
                }
                case '\u2265': {
                    strOutput.append("&ge;");
                    continue block143;
                }
                case '\u25ca': {
                    strOutput.append("&loz;");
                    continue block143;
                }
                default: {
                    strOutput.append(String.valueOf(charInput[i]));
                }
            }
        }
        return strOutput.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Letters {
        A,
        B,
        C,
        D,
        E,
        F,
        G,
        H,
        I,
        J,
        K,
        L,
        M,
        N,
        O,
        P,
        Q,
        R,
        S,
        T,
        U,
        V,
        W,
        X,
        Y,
        Z;

    }
}

