/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook.creator;

import ancestris.modules.webbook.WebBook;
import ancestris.modules.webbook.WebBookParams;
import ancestris.modules.webbook.creator.WebHelper;
import ancestris.modules.webbook.creator.WebSection;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import java.io.File;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.TreeMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebStatsImplex
extends WebSection {
    private static final boolean DEBUG = false;
    private static final String STACK_SEPARATOR = "\n";
    private double dImplexFactor;
    private Vector<GenerationInfo> vecGenerationInfo = new Vector();
    private HashSet<String> setIndi = new HashSet();
    private HashSet<String> setCommonAncestor = new HashSet();
    private TreeMap<String, Indi> mapImplexCommonIndi = new TreeMap();
    private double dConsanguinityFactor;
    private TreeMap<String, ConsanguinityInfo> mapConsanguinityCommonIndi = new TreeMap();

    public WebStatsImplex(boolean generate, WebBook wb, WebBookParams wp, WebHelper wh) {
        super(generate, wb, wp, wh);
    }

    public void init() {
        this.init(this.trs("TXT_StatsImplex"), "stats", "stats_", this.formatFromSize(this.wh.getNbIndis()), 2, 0);
    }

    @Override
    public void create() {
        if (this.wb.sectionIndividualsDetails != null) {
            this.personPage = this.wb.sectionIndividualsDetails.getPagesMap();
            this.prefixPersonDetailsDir = this.buildLinkShort(this, this.wb.sectionIndividualsDetails);
        }
        File dir = this.wh.createDir(this.wh.getDir().getAbsolutePath() + File.separator + this.sectionDir, true);
        this.exportData(dir);
    }

    private void exportData(File dir) {
        String fileStr = this.sectionPrefix + String.format(this.formatNbrs, 2) + this.sectionSuffix;
        File file = this.wh.getFileForName(dir, fileStr);
        PrintWriter out = this.wh.getWriter(file, this.UTF8);
        if (out == null) {
            return;
        }
        this.printOpenHTML(out, "TXT_StatsImplex", this);
        this.printHomeLink(out, this);
        this.clearStats();
        this.computeImplexFactor(this.wh.getIndiDeCujus(this.wp.param_decujus));
        this.computeConsanguinityFactor(this.wh.indiDeCujus);
        this.printHeader(out, this.wh.indiDeCujus);
        this.printImplexStats(out);
        this.printConsanguinityStats(out, this.wh.indiDeCujus);
        this.printCloseHTML(out);
        this.wh.log.write(fileStr + this.trs("EXEC_DONE"));
        out.close();
    }

    private void clearStats() {
        this.dImplexFactor = 0.0;
        this.vecGenerationInfo.clear();
        this.setIndi.clear();
        this.setCommonAncestor.clear();
        this.mapImplexCommonIndi.clear();
        this.dConsanguinityFactor = 0.0;
        this.mapConsanguinityCommonIndi.clear();
    }

    private void printHeader(PrintWriter out, Indi indi) {
        out.println("<div class=\"contreport\">");
        out.println("<p class=\"decal\"><br /><span class=\"gras\">" + this.htmlText(this.trs("implex_description")) + "</span></p>");
        out.println("<p class=\"description\">" + this.htmlText(this.trs("implex_info")) + "</p>");
        out.println("<div class=\"spacer\">&nbsp;</div>");
        out.println("</div>");
        out.println("<div class=\"contreport\">");
        out.println("<p class=\"decal\"><br /><span class=\"gras\">" + this.htmlText(this.trs("implex_root_individual")) + "</span></p>");
        out.println("<p class=\"column1\">");
        out.println(this.wrapEntity((Entity)indi));
        out.println("<br /><br />");
        out.println(this.htmlText(this.trs("implex_implex_factor")) + "&nbsp;" + new Double(this.dImplexFactor) + "%");
        out.println("<br />");
        out.println(this.htmlText(this.trs("implex_consanguinity_factor")) + "&nbsp;" + String.format("%.9f", new Double(this.dConsanguinityFactor)));
        out.println("<br /></p>");
    }

    private void printImplexStats(PrintWriter out) {
        out.println("<table border=\"0\" cellspacing=\"0\" cellpadding=\"5\" class=\"column1\"><thead><tr>");
        out.println("<th>" + this.htmlText(this.trs("implex_header_implex_generation")) + "</th>");
        out.println("<th>" + this.htmlText(this.trs("implex_header_implex_possible")) + "</th>");
        out.println("<th>" + this.htmlText(this.trs("implex_header_implex_known")) + "</th>");
        out.println("<th>" + this.htmlText(this.trs("implex_header_implex_known_percent")) + "</th>");
        out.println("<th>" + this.htmlText(this.trs("implex_header_implex_cumul")) + "</th>");
        out.println("<th>" + this.htmlText(this.trs("implex_header_implex_cumul_percent")) + "</th>");
        out.println("<th>" + this.htmlText(this.trs("implex_header_implex_diff")) + "</th>");
        out.println("<th>" + this.htmlText(this.trs("implex_header_implex_diffcumul")) + "</th>");
        out.println("<th>" + this.htmlText(this.trs("implex_header_implex_implex")) + "</th>");
        out.println("</tr></thead>");
        out.println("<tbody>");
        Iterator<GenerationInfo> itr = this.vecGenerationInfo.iterator();
        while (itr.hasNext()) {
            GenerationInfo info = itr.next();
            out.println("<tr>");
            out.println("<td>" + this.htmlText(info.iLevel) + "</td>");
            out.println("<td>" + this.htmlText(info.iPossibleCount) + "</td>");
            out.println("<td>" + this.htmlText(info.iKnownCount) + "</td>");
            out.println("<td>" + this.htmlText(info.dCoverage) + "</td>");
            out.println("<td>" + this.htmlText(info.iKnownCumul) + "</td>");
            out.println("<td>" + this.htmlText(info.dCoverageCumul) + "</td>");
            out.println("<td>" + this.htmlText(info.iDiffCount) + "</td>");
            out.println("<td>" + this.htmlText(info.iDiffCumul) + "</td>");
            out.println("<td>" + this.htmlText(info.dImplex) + "</td>");
            out.println("</tr>");
        }
        out.println("</tbody></table>");
        out.println("<div class=\"spacer\">&nbsp;</div></div>");
        out.println("<div class=\"contreport\">");
        out.println("<p class=\"decal\"><br /><span class=\"gras\">" + this.htmlText(this.trs("implex_header_implex_common_ancestors")) + "</span></p>");
        out.println("<p class=\"column1\">");
        Collection<Indi> col = this.mapImplexCommonIndi.values();
        Iterator<Indi> itr1 = col.iterator();
        while (itr.hasNext()) {
            out.println(this.wrapEntity((Entity)itr1.next()));
            out.println("<br />");
        }
        out.println("</p>");
        out.println("<div class=\"spacer\">&nbsp;</div>");
        out.println("</div>");
    }

    private void printConsanguinityStats(PrintWriter out, Indi indi) {
        out.println("<div class=\"contreport\">");
        out.println("<p class=\"decal\"><br /><span class=\"gras\">" + this.htmlText(this.trs("implex_header_consanguinity_common_ancestors")) + "</span></p>");
        Collection<ConsanguinityInfo> col = this.mapConsanguinityCommonIndi.values();
        ArrayList<ConsanguinityInfo> list = new ArrayList<ConsanguinityInfo>(col);
        Collections.sort(list, new Comparator<ConsanguinityInfo>(){

            @Override
            public int compare(ConsanguinityInfo o1, ConsanguinityInfo o2) {
                return Double.compare(o1.consanguinityFactor, o2.consanguinityFactor) * -1;
            }
        });
        for (ConsanguinityInfo info : list) {
            out.println("<span class=\"column1f\">");
            out.println(this.wrapEntity((Entity)info.indi));
            out.println("</span>");
            out.println("<span class=\"column2f\">" + this.htmlText(String.format("%.9f", info.consanguinityFactor)) + "</span><br />");
            out.println("<p class=\"spacer\">&nbsp;</p>");
        }
        out.println("</div>");
    }

    private void computeImplexFactor(Indi indi) {
        ArrayList<Indi> listIndi = new ArrayList<Indi>();
        listIndi.add(indi);
        int iLevel = 1;
        while (!listIndi.isEmpty()) {
            ArrayList<Indi> listParent = new ArrayList<Indi>();
            this.computeGeneration(iLevel, listIndi, listParent);
            listIndi = listParent;
            ++iLevel;
        }
        BigInteger iPossibleCumul = BigInteger.ZERO;
        int iKnownCumul = 0;
        int iDiffCumul = 0;
        for (GenerationInfo info : this.vecGenerationInfo) {
            info.iPossibleCount = BigInteger.ONE.shiftLeft(info.iLevel - 1);
            iPossibleCumul = iPossibleCumul.add(info.iPossibleCount);
            info.iPossibleCumul = iPossibleCumul;
            info.iKnownCumul = iKnownCumul += info.iKnownCount;
            info.iDiffCumul = iDiffCumul += info.iDiffCount;
            BigInteger dC = BigInteger.valueOf(10000 * info.iKnownCount);
            info.dCoverage = (double)dC.divide(info.iPossibleCount).longValue() / 100.0;
            dC = BigInteger.valueOf(10000 * info.iKnownCumul);
            info.dCoverageCumul = (double)dC.divide(info.iPossibleCumul).longValue() / 100.0;
            if (iKnownCumul == 0) continue;
            this.dImplexFactor = info.dImplex = (double)(10000 * (info.iKnownCumul - info.iDiffCumul) / info.iKnownCumul) / 100.0;
        }
    }

    private void addCommonAncestor(Indi indi) {
        if (indi == null) {
            return;
        }
        String strId = indi.getId();
        this.setCommonAncestor.add(strId);
        Fam famc = indi.getFamilyWhereBiologicalChild();
        if (famc != null) {
            this.addCommonAncestor(famc.getWife());
            this.addCommonAncestor(famc.getHusband());
        }
    }

    private void computeGeneration(int iLevel, List<Indi> listIndi, List<Indi> listParent) {
        GenerationInfo info = new GenerationInfo(iLevel);
        this.vecGenerationInfo.add(info);
        for (Indi indi : listIndi) {
            Indi indiHusband;
            String strId = indi.getId();
            if (this.setIndi.contains(strId)) {
                if (!this.setCommonAncestor.contains(strId)) {
                    this.mapImplexCommonIndi.put(strId, indi);
                    this.addCommonAncestor(indi);
                }
            } else {
                this.setIndi.add(strId);
                ++info.iDiffCount;
            }
            ++info.iKnownCount;
            Fam famc = indi.getFamilyWhereBiologicalChild();
            if (famc == null) continue;
            Indi indiWife = famc.getWife();
            if (indiWife != null) {
                listParent.add(indiWife);
            }
            if ((indiHusband = famc.getHusband()) == null) continue;
            listParent.add(indiHusband);
        }
    }

    private void computeConsanguinityFactor(Indi indi) {
        this.dConsanguinityFactor = 0.0;
        Fam famc = indi.getFamilyWhereBiologicalChild();
        if (famc == null) {
            return;
        }
        Stack<String> vecWife = new Stack<String>();
        Stack<String> vecHusband = new Stack<String>();
        this.checkRightTree(famc.getWife(), 0, vecWife, famc.getHusband(), 0, vecHusband);
    }

    private void checkRightTree(Indi indiRight, int iLevelRight, Stack<String> stackRight, Indi indiLeft, int iLevelLeft, Stack<String> stackLeft) {
        if (indiRight == null || indiLeft == null) {
            return;
        }
        this.searchInLeftTree(indiRight, iLevelRight, stackRight, indiLeft, 0, stackLeft);
        String strIdRight = indiRight.getId();
        stackRight.push(strIdRight);
        Fam famc = indiRight.getFamilyWhereBiologicalChild();
        if (famc != null) {
            this.checkRightTree(famc.getWife(), iLevelRight + 1, stackRight, indiLeft, iLevelLeft, stackLeft);
            this.checkRightTree(famc.getHusband(), iLevelRight + 1, stackRight, indiLeft, iLevelLeft, stackLeft);
        }
        stackRight.pop();
    }

    private void searchInLeftTree(Indi indiRight, int iLevelRight, Stack<String> stackRight, Indi indiLeft, int iLevelLeft, Stack<String> stackLeft) {
        if (indiRight == null || indiLeft == null) {
            return;
        }
        String strIdLeft = indiLeft.getId();
        if (stackRight.contains(strIdLeft)) {
            return;
        }
        String strIdRight = indiRight.getId();
        if (strIdRight.equals(strIdLeft)) {
            ConsanguinityInfo info = this.mapConsanguinityCommonIndi.get(strIdRight);
            if (info == null) {
                info = new ConsanguinityInfo();
                info.indi = indiRight;
            }
            this.mapConsanguinityCommonIndi.put(strIdRight, info);
            double dPower = iLevelRight + iLevelLeft + 1;
            double dConsanguinityPart = Math.pow(0.5, dPower);
            this.dConsanguinityFactor += dConsanguinityPart;
            info.consanguinityFactor += dConsanguinityPart;
            ++info.count;
            return;
        }
        stackLeft.push(strIdLeft);
        Fam famc = indiLeft.getFamilyWhereBiologicalChild();
        if (famc != null) {
            this.searchInLeftTree(indiRight, iLevelRight, stackRight, famc.getWife(), iLevelLeft + 1, stackLeft);
            this.searchInLeftTree(indiRight, iLevelRight, stackRight, famc.getHusband(), iLevelLeft + 1, stackLeft);
        }
        stackLeft.pop();
    }

    private class ConsanguinityInfo {
        public Indi indi;
        public int count;
        public double consanguinityFactor;
        public Stack stackIndi = new Stack();

        private ConsanguinityInfo() {
        }
    }

    private class GenerationInfo {
        int iLevel;
        BigInteger iPossibleCount;
        BigInteger iPossibleCumul;
        int iKnownCount;
        int iKnownCumul;
        int iDiffCount;
        int iDiffCumul;
        double dCoverage;
        double dCoverageCumul;
        double dImplex;

        GenerationInfo(int iLevel) {
            this.iLevel = iLevel;
        }
    }
}

