/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.geoplace;

import ancestris.api.place.Place;
import ancestris.api.place.PlaceFactory;
import ancestris.modules.editors.geoplace.PlaceEditorPanel;
import ancestris.modules.place.geonames.GeonamesResearcher;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomOptions;
import genj.gedcom.PropertyPlace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.openide.util.NbBundle;

public class GedcomPlaceEditorPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(GedcomPlaceEditorPanel.class.getName(), null);
    private Gedcom gedcom;
    private String[] gedcomPlaceFormat;
    private JComponent[][] gedcomFields;
    private PropertyPlace mPlace;
    boolean placeModified = false;
    boolean updateOnGoing = false;
    private PlaceEditorPanel parentPanel = null;
    private JTextField gedcomLatitudeTextField;
    private JTextField gedcomLongitudeTextField;
    private JLabel latitudeLabel;
    private JLabel longitudeLabel;
    private JButton parametersButton;
    private JLabel parametersLabel;
    private JPanel placeFieldsPanel;

    public GedcomPlaceEditorPanel() {
        this.initComponents();
    }

    private void setGedcomPanel() {
        int i;
        this.gedcomPlaceFormat = PropertyPlace.getFormat((Gedcom)this.gedcom, (boolean)true);
        this.gedcomFields = new JComponent[2][this.gedcomPlaceFormat.length];
        for (int i2 = 0; i2 < this.gedcomPlaceFormat.length; ++i2) {
            String label = this.gedcomPlaceFormat[i2].trim();
            this.gedcomFields[0][i2] = new JLabel(label);
            this.gedcomFields[1][i2] = new JTextField();
        }
        GroupLayout placeFieldsPanelLayout = new GroupLayout(this.placeFieldsPanel);
        this.placeFieldsPanel.setLayout(placeFieldsPanelLayout);
        GroupLayout.ParallelGroup groupLabels = placeFieldsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup groupTextFields = placeFieldsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING);
        for (int i3 = 0; i3 < this.gedcomPlaceFormat.length; ++i3) {
            ((GroupLayout.Group)groupLabels).addComponent(this.gedcomFields[0][i3]);
            ((GroupLayout.Group)groupTextFields).addComponent(this.gedcomFields[1][i3]);
        }
        GroupLayout.SequentialGroup groupColumns = placeFieldsPanelLayout.createSequentialGroup();
        groupColumns.addGroup(groupLabels);
        groupColumns.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
        groupColumns.addGroup(groupTextFields);
        placeFieldsPanelLayout.setHorizontalGroup(placeFieldsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupColumns));
        GroupLayout.Group[] groupLine = new GroupLayout.Group[this.gedcomPlaceFormat.length];
        for (int i4 = 0; i4 < this.gedcomPlaceFormat.length; ++i4) {
            groupLine[i4] = placeFieldsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE);
            groupLine[i4].addComponent(this.gedcomFields[0][i4]);
            groupLine[i4].addComponent(this.gedcomFields[1][i4]);
        }
        GroupLayout.SequentialGroup groupRows = placeFieldsPanelLayout.createSequentialGroup();
        for (i = 0; i < this.gedcomPlaceFormat.length; ++i) {
            groupRows.addGroup(groupLine[i]);
            groupRows.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
        }
        groupRows.addContainerGap(-1, Short.MAX_VALUE);
        placeFieldsPanelLayout.setVerticalGroup(placeFieldsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupRows));
        for (i = 0; i < this.gedcomPlaceFormat.length; ++i) {
            final int index = i;
            final JTextField jtf = (JTextField)this.gedcomFields[1][i];
            List<String> jurisdictions = Arrays.asList(PropertyPlace.getAllJurisdictions((Gedcom)this.getGedcom(), (int)i, (boolean)true));
            if (jurisdictions == null) {
                jurisdictions = new ArrayList<String>();
            }
            AutoCompleteDecorator.decorate((JTextComponent)jtf, jurisdictions, (boolean)false);
            jtf.getInputMap().put(KeyStroke.getKeyStroke(8, 0), "delete-previous");
            jtf.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.updateNextFields(index);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    GedcomPlaceEditorPanel.this.placeModified = true;
                    if (!GedcomPlaceEditorPanel.this.updateOnGoing) {
                        if (jtf.getText().isEmpty()) {
                            GedcomPlaceEditorPanel.this.updatePlace(GedcomPlaceEditorPanel.this.mPlace, index + 1);
                        }
                        GedcomPlaceEditorPanel.this.parentPanel.setSearchPlace(GedcomPlaceEditorPanel.this.getPlaceString(0));
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.updateNextFields(index);
                }

                private void updateNextFields(int index2) {
                    GedcomPlaceEditorPanel.this.placeModified = true;
                    if (!GedcomPlaceEditorPanel.this.updateOnGoing) {
                        PropertyPlace[] sameChoices = PropertyPlace.getSameChoices((Gedcom)GedcomPlaceEditorPanel.this.getGedcom(), (int)index2, (String)jtf.getText());
                        if (sameChoices.length > 0) {
                            GedcomPlaceEditorPanel.this.updatePlace(sameChoices[0], index2 + 1);
                        } else {
                            GedcomPlaceEditorPanel.this.updatePlace(GedcomPlaceEditorPanel.this.mPlace, index2 + 1);
                        }
                        GedcomPlaceEditorPanel.this.parentPanel.setSearchPlace(GedcomPlaceEditorPanel.this.getPlaceString(0));
                    }
                }
            });
        }
        this.gedcomLatitudeTextField.getDocument().addDocumentListener(new CoordinatesListener());
    }

    public void set(Gedcom gedcom, PropertyPlace place) {
        this.gedcom = gedcom;
        this.mPlace = place;
        if (this.gedcomFields == null) {
            this.setGedcomPanel();
        }
        this.updatePlace(this.mPlace, 0);
    }

    private void updatePlace(PropertyPlace place, int startIndex) {
        this.updatePlace((Place)new PlaceFactory(place), startIndex, true);
    }

    public void updatePlace(Place place, int startIndex, boolean forceReplace) {
        this.updateOnGoing = true;
        if (place != null) {
            int i;
            logger.log(Level.FINE, "startIndex {0}", new Object[]{startIndex});
            String[] map = null;
            if (place instanceof PlaceFactory) {
                map = new String[this.gedcomPlaceFormat.length];
                for (i = 0; i < this.gedcomPlaceFormat.length; ++i) {
                    map[i] = "" + i;
                }
            } else {
                String mapStr = GeonamesResearcher.getGeonamesMapString((Gedcom)this.gedcom);
                map = mapStr.isEmpty() ? this.getGeonamesMap() : PropertyPlace.getFormat((String)mapStr);
                if (map == null) {
                    this.updateOnGoing = false;
                    return;
                }
            }
            for (i = startIndex; i < this.gedcomPlaceFormat.length; ++i) {
                JTextField jtf = (JTextField)this.gedcomFields[1][i];
                String j = map[i].trim();
                if (!forceReplace && !jtf.getText().isEmpty()) continue;
                String str = j.isEmpty() ? "" : place.getJurisdiction(Integer.valueOf(j).intValue());
                jtf.setText(str == null ? "" : str);
            }
            Double latitude = place.getLatitude();
            if (forceReplace || this.gedcomLatitudeTextField.getText().isEmpty()) {
                if (latitude != null && !latitude.isNaN()) {
                    this.gedcomLatitudeTextField.setText(String.valueOf(latitude));
                } else {
                    this.gedcomLatitudeTextField.setText("");
                }
            }
            Double longitude = place.getLongitude();
            if (forceReplace || this.gedcomLongitudeTextField.getText().isEmpty()) {
                if (longitude != null && !longitude.isNaN()) {
                    this.gedcomLongitudeTextField.setText(String.valueOf(longitude));
                } else {
                    this.gedcomLongitudeTextField.setText("");
                }
            }
        } else {
            logger.log(Level.FINE, "No place found startIndex {0}", new Object[]{startIndex});
            for (int index = startIndex; index < this.gedcomPlaceFormat.length; ++index) {
                ((JTextField)this.gedcomFields[1][index]).setText("");
            }
            this.gedcomLatitudeTextField.setText("");
            this.gedcomLongitudeTextField.setText("");
        }
        this.updateOnGoing = false;
    }

    public void modifyCoordinates(String lat, String lon, boolean forceReplace) {
        this.updateOnGoing = true;
        if (forceReplace || this.gedcomLatitudeTextField.getText().isEmpty()) {
            this.gedcomLatitudeTextField.setText(lat);
        }
        if (forceReplace || this.gedcomLongitudeTextField.getText().isEmpty()) {
            this.gedcomLongitudeTextField.setText(lon);
        }
        this.updateOnGoing = false;
    }

    private void initComponents() {
        this.placeFieldsPanel = new JPanel();
        this.gedcomLatitudeTextField = new JTextField();
        this.gedcomLongitudeTextField = new JTextField();
        this.latitudeLabel = new JLabel();
        this.longitudeLabel = new JLabel();
        this.parametersLabel = new JLabel();
        this.parametersButton = new JButton();
        GroupLayout placeFieldsPanelLayout = new GroupLayout(this.placeFieldsPanel);
        this.placeFieldsPanel.setLayout(placeFieldsPanelLayout);
        placeFieldsPanelLayout.setHorizontalGroup(placeFieldsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        placeFieldsPanelLayout.setVerticalGroup(placeFieldsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 66, Short.MAX_VALUE));
        this.gedcomLatitudeTextField.setColumns(16);
        this.gedcomLatitudeTextField.setToolTipText(NbBundle.getMessage(GedcomPlaceEditorPanel.class, (String)"RightClicOnMap"));
        this.gedcomLatitudeTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!GedcomPlaceEditorPanel.this.updateOnGoing) {
                    GedcomPlaceEditorPanel.this.placeModified = true;
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                GedcomPlaceEditorPanel.this.placeModified = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!GedcomPlaceEditorPanel.this.updateOnGoing) {
                    GedcomPlaceEditorPanel.this.placeModified = true;
                }
            }
        });
        this.gedcomLongitudeTextField.setColumns(16);
        this.gedcomLongitudeTextField.setToolTipText(NbBundle.getMessage(GedcomPlaceEditorPanel.class, (String)"RightClicOnMap"));
        this.gedcomLongitudeTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!GedcomPlaceEditorPanel.this.updateOnGoing) {
                    GedcomPlaceEditorPanel.this.placeModified = true;
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                GedcomPlaceEditorPanel.this.placeModified = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!GedcomPlaceEditorPanel.this.updateOnGoing) {
                    GedcomPlaceEditorPanel.this.placeModified = true;
                }
            }
        });
        this.latitudeLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/geoplace/resources/latitude.png")));
        this.latitudeLabel.setText(NbBundle.getMessage(GedcomPlaceEditorPanel.class, (String)"GedcomPlaceEditorPanel.latitudeLabel.text"));
        this.longitudeLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/geoplace/resources/longitude.png")));
        this.longitudeLabel.setText(NbBundle.getMessage(GedcomPlaceEditorPanel.class, (String)"GedcomPlaceEditorPanel.longitudeLabel.text"));
        this.parametersLabel.setText(NbBundle.getMessage(GedcomPlaceEditorPanel.class, (String)"GedcomPlaceEditorPanel.parametersLabel.text"));
        this.parametersButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/geoplace/resources/parameters.png")));
        this.parametersButton.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/geoplace/Bundle").getString("GedcomPlaceEditorPanel.parametersButton.text"), new Object[0]));
        this.parametersButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/geoplace/Bundle").getString("GedcomPlaceEditorPanel.parametersButton.toolTipText"), new Object[0]));
        this.parametersButton.setFocusable(false);
        this.parametersButton.setHorizontalTextPosition(0);
        this.parametersButton.setVerticalTextPosition(3);
        this.parametersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GedcomPlaceEditorPanel.this.parametersButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.gedcomLatitudeTextField, -2, 102, -2).addComponent(this.latitudeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.gedcomLongitudeTextField, -2, 104, -2).addComponent(this.longitudeLabel)).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.parametersLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.parametersButton, -2, 32, -2)).addComponent(this.placeFieldsPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.placeFieldsPanel, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.latitudeLabel).addComponent(this.longitudeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.gedcomLatitudeTextField, -2, -1, -2).addComponent(this.gedcomLongitudeTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.parametersLabel).addComponent(this.parametersButton))));
    }

    private void parametersButtonActionPerformed(ActionEvent evt) {
        this.getGeonamesMap();
    }

    private String[] getGeonamesMap() {
        return GeonamesResearcher.getGeonamesMap((Gedcom)this.gedcom);
    }

    public String getPlaceString() {
        if (this.mPlace == null) {
            return "";
        }
        return this.getPlaceString(this.mPlace.getCityIndex());
    }

    public String getPlaceString(int startingFrom) {
        boolean USE_SPACES = GedcomOptions.getInstance().isUseSpacedPlaces();
        String placeString = "";
        for (int i = 0; i < this.gedcomPlaceFormat.length; ++i) {
            if (i > 0) {
                placeString = placeString + ",";
                if (USE_SPACES) {
                    placeString = placeString + " ";
                }
            }
            placeString = placeString + ((JTextField)this.gedcomFields[1][i]).getText();
        }
        return placeString;
    }

    private Gedcom getGedcom() {
        return this.gedcom;
    }

    public boolean isModified() {
        return this.placeModified;
    }

    public String getLatitude() {
        return this.gedcomLatitudeTextField.getText();
    }

    public String getLongitude() {
        return this.gedcomLongitudeTextField.getText();
    }

    void setMapHandle(PlaceEditorPanel panel) {
        this.parentPanel = panel;
    }

    private class CoordinatesListener
    implements DocumentListener {
        private CoordinatesListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.showLocation();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.showLocation();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.showLocation();
        }

        private void showLocation() {
            if (GedcomPlaceEditorPanel.this.updateOnGoing) {
                return;
            }
            try {
                if (GedcomPlaceEditorPanel.this.parentPanel != null) {
                    Double latitude = Double.parseDouble(GedcomPlaceEditorPanel.this.gedcomLatitudeTextField.getText());
                    Double longitude = Double.parseDouble(GedcomPlaceEditorPanel.this.gedcomLongitudeTextField.getText());
                    if (!latitude.isNaN() && !longitude.isNaN()) {
                        GedcomPlaceEditorPanel.this.parentPanel.showLocation(new GeoPosition(latitude.doubleValue(), longitude.doubleValue()));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

