/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.geoplace;

import ancestris.api.editor.AncestrisEditor;
import ancestris.modules.editors.geoplace.PlaceEditorPanel;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyPlace;
import genj.gedcom.UnitOfWork;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class PlaceEditor
extends AncestrisEditor {
    private PlaceEditorPanel editorPanel = null;
    private static ImageIcon editorIcon = new ImageIcon(PlaceEditor.class.getResource("resources/geo.png"));

    public boolean canEdit(Property property) {
        return property instanceof PropertyPlace;
    }

    public boolean isActive() {
        return false;
    }

    public Property edit(Property property, boolean isNew) {
        return this.edit(property, null);
    }

    public Property add(Property parent) {
        return this.edit(null, parent);
    }

    public Property edit(Property place, Object arg) {
        if (place == null) {
            return null;
        }
        Gedcom gedcom = place.getGedcom();
        GeoPosition geoPoint = null;
        if (arg != null && arg instanceof GeoPosition) {
            geoPoint = (GeoPosition)arg;
        }
        if (gedcom != null && place instanceof PropertyPlace) {
            if (this.editorPanel == null) {
                this.editorPanel = new PlaceEditorPanel();
            }
            this.editorPanel.set(gedcom, (PropertyPlace)place, true);
            this.editorPanel.setGeoPoint(geoPoint);
            String title = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"PlaceEditorPanel.edit.all", (Object)place.getDisplayValue());
            DialogManager.ADialog dialog = new DialogManager.ADialog(title, (JComponent)this.editorPanel);
            if (dialog.show() == DialogManager.ADialog.OK_OPTION) {
                try {
                    gedcom.doUnitOfWork(new UnitOfWork(){

                        public void perform(Gedcom gedcom) throws GedcomException {
                            PlaceEditor.this.editorPanel.commit();
                        }
                    });
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                return this.editorPanel.get();
            }
        }
        return null;
    }

    public String getName(boolean canonical) {
        if (canonical) {
            return ((Object)((Object)this)).getClass().getCanonicalName();
        }
        return NbBundle.getMessage(PlaceEditor.class, (String)"OpenIDE-Module-Name");
    }

    public ImageIcon getIcon() {
        return editorIcon;
    }

    public String toString() {
        return this.getName(false);
    }

    public Action getCreateParentAction(Indi indi, int sex) {
        return this.getDefaultAction((Property)indi);
    }

    public Action getCreateSpouseAction(Indi indi) {
        return this.getDefaultAction((Property)indi);
    }
}

