/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.actions;

import ancestris.api.editor.AncestrisEditor;
import ancestris.api.editor.Editor;
import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.modules.editors.standard.CygnusTopComponent;
import ancestris.modules.editors.standard.actions.ActionCreation;
import ancestris.modules.editors.standard.tools.IndiCreator;
import ancestris.view.AncestrisTopComponent;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.Note;
import genj.gedcom.Property;
import genj.gedcom.Repository;
import genj.gedcom.Source;
import genj.gedcom.Submitter;
import java.util.List;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class EditorAction
extends AncestrisEditor {
    private ImageIcon editorIcon = new ImageIcon(CygnusTopComponent.class.getResource("editeur_standard.png"));

    public boolean canEdit(Property property) {
        return property instanceof Indi || property instanceof Fam || property instanceof Note || property instanceof Media || property instanceof Source || property instanceof Repository || property instanceof Submitter || property != null;
    }

    public boolean isActive() {
        return true;
    }

    public Property edit(Property property, boolean isNew) {
        Context contextToOpen = property == null ? (Context)Utilities.actionsGlobalContext().lookup(Context.class) : new Context(property);
        if (contextToOpen != null) {
            CygnusTopComponent editorTopComponent = this.getCurrentEditorTopComponent(contextToOpen);
            if (editorTopComponent != null) {
                SelectionDispatcher.fireSelection((Context)contextToOpen);
                editorTopComponent.requestActive();
            } else {
                AncestrisTopComponent win = new CygnusTopComponent().create(contextToOpen);
                win.open();
                win.requestActive();
            }
        }
        return null;
    }

    public Property add(Property parent) {
        return null;
    }

    public String getName(boolean canonical) {
        if (canonical) {
            return ((Object)((Object)this)).getClass().getCanonicalName();
        }
        return NbBundle.getMessage(CygnusTopComponent.class, (String)"OpenIDE-Module-Name");
    }

    public ImageIcon getIcon() {
        return this.editorIcon;
    }

    public String toString() {
        return this.getName(false);
    }

    public Action getCreateParentAction(Indi indi, int sex) {
        CygnusTopComponent editorTopComponent = this.getCurrentEditorTopComponent(new Context((Entity)indi));
        if (editorTopComponent != null) {
            return new ActionCreation(editorTopComponent, IndiCreator.CREATION, sex == 1 ? IndiCreator.REL_FATHER : IndiCreator.REL_MOTHER, (Entity)indi);
        }
        return this.getDefaultAction((Property)indi);
    }

    public Action getCreateSpouseAction(Indi indi) {
        CygnusTopComponent editorTopComponent = this.getCurrentEditorTopComponent(new Context((Entity)indi));
        Fam fam = null;
        if (editorTopComponent != null) {
            Fam[] fams;
            for (Fam f : fams = indi.getFamiliesWhereSpouse(true)) {
                if (f.getOtherSpouse(indi) != null) continue;
                fam = f;
                break;
            }
            return new ActionCreation(editorTopComponent, IndiCreator.CREATION, IndiCreator.REL_PARTNER, (Entity)indi, fam);
        }
        return this.getDefaultAction((Property)indi);
    }

    private CygnusTopComponent getCurrentEditorTopComponent(Context context) {
        CygnusTopComponent ret = null;
        for (CygnusTopComponent editorTopComponent : (List)AncestrisPlugin.lookupAll(CygnusTopComponent.class)) {
            Editor editor = editorTopComponent.getEditor();
            if (editor == null) continue;
            if (editor.getEditedEntity() == context.getEntity()) {
                return editorTopComponent;
            }
            if (editor.getEditedEntity().getGedcom() != context.getEntity().getGedcom()) continue;
            ret = editorTopComponent;
        }
        return ret;
    }
}

