/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import genj.gedcom.Fam;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.PropertyHusband;
import genj.gedcom.PropertyWife;
import genj.util.Registry;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class FamChooser
extends JPanel {
    private static Integer CHOICE_SET = 0;
    private static Integer CHOICE_CHOOSE = 1;
    private static Integer CHOICE_CREATE = 2;
    private Registry registry = Registry.get(this.getClass());
    private Indi parent = null;
    private Indi child = null;
    private boolean isFather = true;
    private JButton okButton = null;
    private List<String> items = null;
    private List<Integer> choices = null;
    private List<Fam> fams = null;
    private JList jList;
    private JScrollPane jScrollPane;

    public FamChooser(Indi parent, Indi child, boolean isFather, JButton okButton) {
        this.parent = parent;
        this.child = child;
        this.isFather = isFather;
        this.okButton = okButton;
        this.initList();
        this.initComponents();
        this.jList.setSelectedIndex(0);
    }

    private void initComponents() {
        this.jScrollPane = new JScrollPane();
        this.jList = new JList();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                FamChooser.this.formComponentResized(evt);
            }
        });
        this.jList.setModel(new AbstractListModel(){
            String[] strings;
            {
                this.strings = FamChooser.this.items.toArray(new String[FamChooser.this.items.size()]);
            }

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FamChooser.this.jListMouseClicked(evt);
            }
        });
        this.jScrollPane.setViewportView(this.jList);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane, -1, 249, Short.MAX_VALUE));
    }

    private void formComponentResized(ComponentEvent evt) {
    }

    private void jListMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && evt.getClickCount() == 2 && this.okButton.isEnabled()) {
            this.okButton.doClick();
        }
    }

    private void initList() {
        String title = this.isFather ? PropertyHusband.LABEL_FATHER : PropertyWife.LABEL_MOTHER;
        Fam childFam = this.child.getFamilyWhereBiologicalChild();
        this.items = new ArrayList<String>();
        this.choices = new ArrayList<Integer>();
        this.fams = new ArrayList<Fam>();
        if (childFam != null) {
            this.addItem(NbBundle.getMessage(this.getClass(), (String)"FamChooser.Choice_Set", (Object)this.parent.toString(true), (Object)title, (Object)childFam.toString(true), (Object)this.child.toString(true), (Object[])new Object[0]), CHOICE_SET, childFam);
        }
        for (Fam fam : this.parent.getFamiliesWhereSpouse()) {
            Indi husb = fam.getHusband();
            Indi wife = fam.getWife();
            if (this.child.isDescendantOf(fam) || this.child == husb || this.child == wife) continue;
            this.addItem(NbBundle.getMessage(this.getClass(), (String)"FamChooser.Choice_Choose", (Object)fam.toString(true)), CHOICE_CHOOSE, fam);
        }
        if (childFam == null) {
            this.addItem(NbBundle.getMessage(this.getClass(), (String)"FamChooser.Choice_Create", (Object)this.child.toString(true), (Object)this.parent.toString(true), (Object)title), CHOICE_CREATE, null);
        }
    }

    private void addItem(String message, Integer type, Fam fam) {
        this.items.add(message);
        this.choices.add(type);
        this.fams.add(fam);
    }

    public boolean existChoices() {
        return this.items.size() > 1;
    }

    public void updateGedcom() {
        try {
            int i = this.jList.getSelectedIndex();
            if (CHOICE_SET.equals(this.choices.get(i))) {
                if (this.isFather) {
                    this.fams.get(i).setHusband(this.parent);
                } else {
                    this.fams.get(i).setWife(this.parent);
                }
            } else if (CHOICE_CREATE.equals(this.choices.get(i))) {
                Fam fam = (Fam)this.parent.getGedcom().createEntity("FAM");
                fam.addDefaultProperties();
                fam.addChild(this.child);
                if (this.isFather) {
                    fam.setHusband(this.parent);
                } else {
                    fam.setWife(this.parent);
                }
            } else if (CHOICE_CHOOSE.equals(this.choices.get(i))) {
                this.fams.get(i).addChild(this.child);
            }
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

