/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import ancestris.modules.editors.standard.tools.Utils;
import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Grammar;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertyXRef;
import java.io.File;
import org.openide.util.Exceptions;

public class MediaWrapper {
    private boolean recordType = true;
    private Property hostingProperty = null;
    private Entity targetMedia = null;
    private File file = null;
    private String title = "";

    public MediaWrapper(PropertyMedia propertyMedia) {
        if (propertyMedia == null) {
            return;
        }
        this.hostingProperty = propertyMedia;
        this.setTargetEntity((Media)propertyMedia.getTargetEntity());
    }

    public void setTargetEntity(Media entity) {
        this.targetMedia = entity;
        this.setInfoFromRecord((Property)this.targetMedia);
    }

    public MediaWrapper(Property propertyObje) {
        this.hostingProperty = propertyObje;
        this.setInfoFromCitation(propertyObje);
    }

    public MediaWrapper(Media entity) {
        if (entity == null) {
            return;
        }
        this.targetMedia = entity;
        this.setInfoFromRecord((Property)entity);
    }

    public MediaWrapper(File f) {
        this.setFile(f);
    }

    public MediaWrapper(String title) {
        this.setTitle(title);
    }

    public MediaWrapper(File f, String title) {
        this.setFile(f);
        this.setTitle(title);
    }

    public Property getHostingProperty() {
        return this.hostingProperty;
    }

    public void setHostingProperty(Property property) {
        this.hostingProperty = property;
    }

    public void setInfoFromRecord(Property property) {
        this.recordType = true;
        if (property == null) {
            return;
        }
        Property mediaFile = property.getProperty("FILE", true);
        if (mediaFile != null && mediaFile instanceof PropertyFile) {
            this.file = ((PropertyFile)mediaFile).getFile();
            Property mediaTitle = mediaFile.getProperty("TITL");
            if (mediaTitle != null) {
                this.title = mediaTitle.getDisplayValue();
            }
        }
    }

    private void setInfoFromCitation(Property property) {
        Property mediaTitle;
        this.recordType = false;
        if (property == null) {
            return;
        }
        Property mediaFile = property.getProperty("FILE", true);
        if (mediaFile != null && mediaFile instanceof PropertyFile) {
            this.file = ((PropertyFile)mediaFile).getFile();
        }
        if ((mediaTitle = property.getProperty("TITL")) != null) {
            this.title = mediaTitle.getDisplayValue();
        }
    }

    public void update(int index, Property mainProp) {
        if (this.hostingProperty == null) {
            Gedcom gedcom = mainProp.getGedcom();
            if (gedcom.getGrammar().equals(Grammar.V55)) {
                this.hostingProperty = mainProp.addProperty("OBJE", "");
                this.putMediaCitation(this.hostingProperty);
            } else {
                try {
                    if (this.targetMedia == null) {
                        this.targetMedia = mainProp.getGedcom().createEntity("OBJE");
                    }
                    mainProp.addMedia((Media)this.targetMedia);
                    this.putMediaRecord((Property)((Media)this.targetMedia));
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        } else if (!this.recordType) {
            this.putMediaCitation(this.hostingProperty);
        } else if (this.recordType && this.hostingProperty instanceof PropertyMedia) {
            this.putMediaRecord((Property)this.targetMedia);
            PropertyMedia pm = (PropertyMedia)this.hostingProperty;
            Media tme = (Media)pm.getTargetEntity();
            if (!this.targetMedia.equals(tme)) {
                Utils.replaceRef((PropertyXRef)pm, (Entity)tme, this.targetMedia);
            }
        } else if (this.recordType && !(this.hostingProperty instanceof PropertyMedia)) {
            this.putMediaRecord((Property)this.targetMedia);
            mainProp.addMedia((Media)this.targetMedia);
        }
        if (this.hostingProperty != null && this.hostingProperty.getParent() != null) {
            Property p = this.hostingProperty.getParent().getProperty("OBJE");
            int pos = this.hostingProperty.getParent().getPropertyPosition(p);
            this.hostingProperty.getParent().moveProperty(this.hostingProperty, pos + index);
        }
    }

    private void putMediaRecord(Property property) {
        Property mediaTitle;
        Property mediaForm;
        String extension = "";
        Property mediaFile = property.getProperty("FILE", true);
        if (mediaFile == null) {
            mediaFile = property.addProperty("FILE", "");
        }
        if (this.file != null) {
            ((PropertyFile)mediaFile).addFile(this.file);
            extension = FileChooserBuilder.getExtension((File)this.file);
        }
        if ((mediaForm = mediaFile.getProperty("FORM")) == null) {
            mediaForm = mediaFile.addProperty("FORM", "");
        }
        if (mediaForm != null) {
            Utils.setDistinctValue(mediaForm, extension);
        }
        if ((mediaTitle = mediaFile.getProperty("TITL")) == null) {
            mediaTitle = mediaFile.addProperty("TITL", "");
        }
        if (mediaTitle != null) {
            Utils.setDistinctValue(mediaTitle, this.title);
        }
    }

    private void putMediaCitation(Property property) {
        Property pForm;
        String version;
        String extension = "";
        Property mediaFile = property.getProperty("FILE", true);
        if (mediaFile == null) {
            mediaFile = property.addProperty("FILE", "");
        }
        if (this.file != null) {
            ((PropertyFile)mediaFile).addFile(this.file);
            extension = FileChooserBuilder.getExtension((File)this.file);
        }
        if ((version = property.getGedcom().getGrammar().getVersion()).contains("5.5.1")) {
            pForm = mediaFile.getProperty("FORM");
            if (pForm == null) {
                pForm = mediaFile.addProperty("FORM", "");
            }
            if (pForm != null) {
                Utils.setDistinctValue(pForm, extension);
            }
        } else {
            pForm = property.getProperty("FORM");
            if (pForm == null) {
                pForm = property.addProperty("FORM", "");
            }
            if (pForm != null) {
                Utils.setDistinctValue(pForm, extension);
            }
        }
        Property mediaTitle = property.getProperty("TITL");
        if (mediaTitle == null) {
            mediaTitle = property.addProperty("TITL", "");
        }
        if (mediaTitle != null) {
            Utils.setDistinctValue(mediaTitle, this.title != null ? this.title : "");
        }
    }

    public void remove() {
        if (this.hostingProperty == null) {
            return;
        }
        this.hostingProperty.getParent().delProperty(this.hostingProperty);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File f) {
        this.file = f;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String str) {
        this.title = str;
    }

    public Entity getTargetMedia() {
        return this.targetMedia;
    }
}

