/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import ancestris.modules.editors.standard.tools.Utils;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Note;
import genj.gedcom.Property;
import genj.gedcom.PropertyNote;
import genj.gedcom.PropertyXRef;
import org.openide.util.Exceptions;

public class NoteWrapper {
    private boolean recordType = true;
    private Property hostingProperty = null;
    private Entity targetNote = null;
    private String text = "";

    public NoteWrapper(Property property) {
        if (property == null) {
            return;
        }
        this.hostingProperty = property;
        if (this.hostingProperty instanceof PropertyNote) {
            PropertyNote pnote = (PropertyNote)property;
            this.recordType = true;
            this.targetNote = (Note)pnote.getTargetEntity();
            this.setText(this.targetNote.getValue().trim());
        } else {
            this.recordType = false;
            this.targetNote = this.hostingProperty.getEntity();
            this.setText(property.getValue().trim());
        }
    }

    public NoteWrapper(Note entity) {
        if (entity == null) {
            return;
        }
        this.recordType = true;
        this.targetNote = entity;
        this.setText(this.targetNote.getValue().trim());
    }

    public NoteWrapper(String text) {
        this.setText(text);
    }

    public Property getHostingProperty() {
        return this.hostingProperty;
    }

    public void setHostingProperty(Property property) {
        this.hostingProperty = property;
    }

    public void update(Property mainProp) {
        if (this.hostingProperty == null) {
            try {
                if (this.targetNote == null) {
                    this.targetNote = mainProp.getGedcom().createEntity("NOTE");
                }
                mainProp.addNote((Note)this.targetNote);
                Utils.setDistinctValue((Property)this.targetNote, this.text);
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return;
        }
        Entity entity = this.hostingProperty.getEntity();
        if ((entity instanceof Indi || entity instanceof Fam) && !(this.hostingProperty instanceof PropertyNote)) {
            Utils.setDistinctValue(this.hostingProperty, this.text);
        } else if ((entity instanceof Indi || entity instanceof Fam) && this.hostingProperty instanceof PropertyNote) {
            Utils.setDistinctValue((Property)this.targetNote, this.text);
            PropertyNote pnote = (PropertyNote)this.hostingProperty;
            Note tne = (Note)pnote.getTargetEntity();
            if (!this.targetNote.equals(tne)) {
                Utils.replaceRef((PropertyXRef)pnote, (Entity)tne, this.targetNote);
            }
        } else if (entity instanceof Note) {
            Utils.setDistinctValue((Property)this.targetNote, this.text);
        }
    }

    public void remove() {
        if (this.hostingProperty == null) {
            return;
        }
        this.hostingProperty.getParent().delProperty(this.hostingProperty);
    }

    public boolean isRecord() {
        return this.recordType;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String str) {
        this.text = str;
    }

    public void setTargetEntity(Note entity) {
        this.targetNote = entity;
    }

    public Entity getTargetNote() {
        return this.targetNote;
    }
}

