/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.treesharing.communication;

import ancestris.modules.treesharing.TreeSharingTopComponent;
import ancestris.modules.treesharing.communication.AncestrisMember;
import ancestris.modules.treesharing.communication.GedcomFam;
import ancestris.modules.treesharing.communication.GedcomIndi;
import ancestris.modules.treesharing.communication.GedcomNumbers;
import ancestris.modules.treesharing.communication.MemberProfile;
import ancestris.modules.treesharing.panels.SharedGedcom;
import ancestris.util.swing.DialogManager;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringEscapeUtils;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Comm {
    private TreeSharingTopComponent owner;
    private static final Logger LOG = Logger.getLogger("ancestris.treesharing");
    private static String COMM_SERVER = "vps187192.ovh.net";
    private int COMM_PORT = 4584;
    private static String COMM_CHARSET = "UTF-8";
    private static String COMM_PROTOCOL = "http://";
    private static String COMM_CREDENTIALS = "user=ancestrishare&pw=2fQB&format=xml";
    private int COMM_TIMEOUT = 1000;
    private boolean isCommError = false;
    private static DatagramSocket socket = null;
    private static String CMD_GETMB = "/get_members.php?";
    private static String TAG_MEMBER = "member";
    private static String TAG_PSEUDO = "pseudo";
    private static String TAG_IPADDR = "ipaddress";
    private static String TAG_PORTAD = "portaddress";
    private static String TAG_PIPADD = "pipaddress";
    private static String TAG_PPORTA = "pportaddress";
    private int COMM_PACKET_SIZE = 1400;
    private double COMM_COMPRESSING_FACTOR = 3.0;
    private String FMT_IDX = "%03d";
    private int COMM_CMD_PFX_SIZE = 2;
    private int COMM_CMD_SIZE = 5;
    private int COMM_PACKET_NB = 1000;
    private static String STR_DELIMITER = " ";
    private int REQUEST_TIMEOUT = 4;
    private int COMM_NB_FAILS = 6;
    private int COMM_RESPONSE_DELAY = 50;
    private static String CMD_REGIS = "REGIS";
    private static String CMD_REGOK = "REGOK";
    private static String CMD_REGKO = "REGKO";
    private static String CMD_UNREG = "UNREG";
    private static String CMD_UNROK = "UNROK";
    private static String CMD_UNRKO = "UNRKO";
    private static String CMD_CONCT = "CONCT";
    private static String CMD_PINGG = "PINGG";
    private static String CMD_PONGG = "PONGG";
    private static String CMD_GILxx = "GA";
    private static String CMD_TILxx = "TA";
    private static String CMD_GIDxx = "GB";
    private static String CMD_TIDxx = "TB";
    private static String CMD_GFLxx = "GC";
    private static String CMD_TFLxx = "TC";
    private static String CMD_GFDxx = "GD";
    private static String CMD_TFDxx = "TD";
    private static String CMD_GSTAT = "GS";
    private static String CMD_TSTAT = "TS";
    private static String CMD_GPFxx = "GP";
    private static String CMD_TPFxx = "TP";
    private static String CMD_TXPxx = "TX";
    private static String CMD_TSPRF = "TY";
    private volatile boolean sharing;
    private Thread listeningThread;
    private Thread pingingThread;
    private int refreshDelay;
    private boolean communicationInProgress = false;
    private AncestrisMember memberInProgress = null;
    private boolean expectedConnection = false;
    private Set<ExpectedResponse> expectedResponses = null;
    private boolean gedcomNumbersEOF = false;
    private GedcomNumbers gedcomNumbers = null;
    private boolean listOfIndiLastnamesEOF = false;
    private Set<String> listOfIndiLastnames = null;
    private boolean listOfIndiDetailsEOF = false;
    private Set<GedcomIndi> listOfIndiDetails = null;
    private boolean listOfFamLastnamesEOF = false;
    private Set<String> listOfFamLastnames = null;
    private boolean listOfFamDetailsEOF = false;
    private Set<GedcomFam> listOfFamDetails = null;
    private boolean memberProfileEOF = false;
    private ByteArrayOutputStream memberProfile = null;
    private String memberIPaddress = "";
    private ByteArrayOutputStream memberProfileRcv = null;
    private Map<Integer, Set<String>> packetsOfIndiLastnames = null;
    private Map<Integer, Set<GedcomIndi>> packetsOfIndiDetails = null;
    private Map<Integer, Set<String>> packetsOfFamLastnames = null;
    private Map<Integer, Set<GedcomFam>> packetsOfFamDetails = null;
    private Map<Integer, byte[]> packetsOfProfile = null;

    public Comm(TreeSharingTopComponent tstc, int refreshDelay) {
        this.owner = tstc;
        this.refreshDelay = refreshDelay;
    }

    private boolean startListeningToFriends() {
        this.sharing = true;
        this.listeningThread = new Thread(){

            public void run() {
                Comm.this.listen();
            }
        };
        this.listeningThread.setName("TreeSharing thread : loop to wait for Ancestris connections");
        this.listeningThread.start();
        this.pingingThread = new Thread(){

            public void run() {
                Comm.this.ping();
            }
        };
        this.pingingThread.setName("TreeSharing thread : loop to stay alive with server");
        this.pingingThread.start();
        LOG.log(Level.INFO, "Start thread listening to incoming calls until " + this.owner.getRegisteredEndDate());
        return true;
    }

    private boolean stopListeningToFriends() {
        LOG.log(Level.INFO, "Stopped thread listening to incoming calls");
        return true;
    }

    public List<AncestrisMember> getAncestrisMembers() {
        ArrayList<AncestrisMember> ancestrisMembers = new ArrayList<AncestrisMember>();
        String outputString = this.getQueryResult(COMM_PROTOCOL + COMM_SERVER + CMD_GETMB + COMM_CREDENTIALS);
        if (outputString == null) {
            return null;
        }
        if (outputString.isEmpty()) {
            return ancestrisMembers;
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(outputString));
            Document doc = db.parse(is);
            doc.getDocumentElement().normalize();
            NodeList nodeList = doc.getElementsByTagName(TAG_MEMBER);
            for (int temp = 0; temp < nodeList.getLength(); ++temp) {
                Node node = nodeList.item(temp);
                if (node.getNodeType() != 1) continue;
                Element member = (Element)node;
                String pseudo = StringEscapeUtils.unescapeHtml((String)member.getElementsByTagName(TAG_PSEUDO).item(0).getTextContent());
                String ipAddress = member.getElementsByTagName(TAG_IPADDR).item(0).getTextContent();
                String portAddress = member.getElementsByTagName(TAG_PORTAD).item(0).getTextContent();
                String pipAddress = member.getElementsByTagName(TAG_PIPADD).item(0).getTextContent();
                String pportAddress = member.getElementsByTagName(TAG_PPORTA).item(0).getTextContent();
                ancestrisMembers.add(new AncestrisMember(pseudo, ipAddress, portAddress, pipAddress, pportAddress));
            }
        }
        catch (Exception ex) {
            this.displayErrorMessage(false, "getAncestrisMembers Exception", "ERR_ParsingError", ex.getLocalizedMessage());
        }
        return ancestrisMembers;
    }

    private String getQueryResult(String url) {
        String ret = "";
        try {
            String responseString = "";
            URL data = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)data.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((responseString = in.readLine()) != null) {
                ret = ret + responseString;
            }
            in.close();
            connection.disconnect();
            this.isCommError = false;
        }
        catch (UnknownHostException ex) {
            this.displayErrorMessage(true, "getQueryResult UnknownHostException", "ERR_UnknownHostException", ex.getLocalizedMessage());
            ret = null;
        }
        catch (SocketException ex) {
            this.displayErrorMessage(true, "getQueryResult SocketException", "ERR_SocketException", ex.getLocalizedMessage());
            ret = null;
        }
        catch (IOException ex) {
            this.displayErrorMessage(true, "getQueryResult IOException", "ERR_IOException", ex.getLocalizedMessage());
            ret = null;
        }
        catch (Exception ex) {
            this.displayErrorMessage(true, "getQueryResult Exception", "ERR_Exception", ex.getLocalizedMessage());
            ret = null;
        }
        return ret;
    }

    public boolean registerMe(String pseudo) {
        LOG.log(Level.FINE, "***");
        LOG.log(Level.FINE, "Communication packet size is " + this.COMM_PACKET_SIZE);
        this.clearCommunicationError();
        try {
            socket = new DatagramSocket();
            String content = pseudo + " " + Comm.getLocalHostLANAddress().getHostAddress() + " " + socket.getLocalPort();
            boolean ret = this.sendCommand(CMD_REGIS, content, null, COMM_SERVER, this.COMM_PORT);
            if (!ret) {
                return false;
            }
            byte[] bytesReceived = new byte[512];
            DatagramPacket packetReceived = new DatagramPacket(bytesReceived, bytesReceived.length);
            socket.setSoTimeout(this.COMM_TIMEOUT);
            socket.receive(packetReceived);
            String reply = StringEscapeUtils.unescapeHtml((String)new String(bytesReceived).split("\u0000")[0]);
            if (reply.substring(0, this.COMM_CMD_SIZE).equals(CMD_REGOK)) {
                LOG.log(Level.FINE, "...(REGOK) Registered " + pseudo + " on the Ancestris server.");
                socket.setSoTimeout(0);
            } else if (reply.substring(0, this.COMM_CMD_SIZE).equals(CMD_REGKO)) {
                String err = reply.substring(this.COMM_CMD_SIZE);
                LOG.log(Level.FINE, "...(REGKO) Could not register " + pseudo + " on the Ancestris server. Error : " + err);
                if (err.startsWith("Duplicate entry")) {
                    err = NbBundle.getMessage(Comm.class, (String)"ERR_DuplicatePseudo");
                }
                DialogManager.create((String)NbBundle.getMessage(Comm.class, (String)"MSG_Registration"), (String)err).setMessageType(0).show();
                return false;
            }
        }
        catch (SocketTimeoutException ex) {
            String log = "...(TIMEOUT) Could not register " + pseudo + " from the Ancestris server.";
            this.displayErrorMessage(false, log, "ERR_ServerNotResponding", NbBundle.getMessage(Comm.class, (String)"MSG_Registration") + " ; " + ex.getLocalizedMessage());
            return false;
        }
        catch (IOException ex) {
            String log = "...(TIMEOUT) Could not register " + pseudo + " from the Ancestris server.";
            this.displayErrorMessage(false, log, "ERR_IOException", ex.getLocalizedMessage());
            return false;
        }
        this.startListeningToFriends();
        return true;
    }

    public boolean unregisterMe(String pseudo) {
        try {
            boolean ret = this.sendCommand(CMD_UNREG, pseudo, null, COMM_SERVER, this.COMM_PORT);
            if (!ret) {
                return false;
            }
            for (int s = 0; this.sharing && s < 200; ++s) {
                TimeUnit.MILLISECONDS.sleep(20L);
            }
            if (this.sharing) {
                String err = NbBundle.getMessage(Comm.class, (String)"ERR_ServerNotResponding");
                String log = "...(TIMEOUT) Could not unregister " + pseudo + " from the Ancestris server.";
                this.displayErrorMessage(false, log, "ERR_ServerNotResponding", NbBundle.getMessage(Comm.class, (String)"MSG_Unregistration"));
                return false;
            }
        }
        catch (Exception ex) {
            this.displayErrorMessage(false, "unregisterMe Exception", "ERR_Exception", NbBundle.getMessage(Comm.class, (String)"MSG_Unregistration") + " ; " + ex.getLocalizedMessage());
            return false;
        }
        if (socket != null) {
            socket.close();
        }
        this.stopListeningToFriends();
        return true;
    }

    private void ping() {
        while (this.sharing) {
            this.sendPing();
            try {
                TimeUnit.SECONDS.sleep(this.refreshDelay);
            }
            catch (InterruptedException ex) {
                this.displayErrorMessage(true, "ping InterruptedException", "ERR_InterruptedException", ex.getLocalizedMessage());
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public void sendPing() {
        if (this.sharing) {
            this.sendCommand(CMD_PONGG, this.owner.getRegisteredPseudo(false), null, COMM_SERVER, this.COMM_PORT);
        }
    }

    public void clearCommunicationError() {
        this.isCommError = false;
    }

    public void setCommunicationInProgress(boolean inProgress) {
        this.communicationInProgress = inProgress;
    }

    public boolean giveSimpleProfile(AncestrisMember member) {
        MemberProfile mp = this.owner.getMyProfile();
        return this.put(member, CMD_TSPRF, this.buildPacketsOfProfile(mp));
    }

    public GedcomNumbers getNbOfEntities(AncestrisMember member) {
        if (this.gedcomNumbers == null) {
            this.gedcomNumbers = new GedcomNumbers();
        }
        this.gedcomNumbers.nbIndis = 0;
        this.gedcomNumbers.nbFams = 0;
        this.gedcomNumbersEOF = false;
        this.call(member, CMD_GSTAT, null);
        return this.gedcomNumbers;
    }

    public Set<String> getSharedIndiLastnamesFromMember(AncestrisMember member) {
        if (this.listOfIndiLastnames == null) {
            this.listOfIndiLastnames = new HashSet<String>();
        } else {
            this.listOfIndiLastnames.clear();
        }
        this.listOfIndiLastnamesEOF = false;
        this.call(member, CMD_GILxx, null);
        return this.listOfIndiLastnames;
    }

    public Set<GedcomIndi> getGedcomIndisFromMember(AncestrisMember member, Set<String> commonIndiLastnames) {
        if (this.listOfIndiDetails == null) {
            this.listOfIndiDetails = new HashSet<GedcomIndi>();
        } else {
            this.listOfIndiDetails.clear();
        }
        this.listOfIndiDetailsEOF = false;
        this.call(member, CMD_GIDxx, commonIndiLastnames);
        return this.listOfIndiDetails;
    }

    public Set<String> getSharedFamLastnamesFromMember(AncestrisMember member) {
        if (this.listOfFamLastnames == null) {
            this.listOfFamLastnames = new HashSet<String>();
        } else {
            this.listOfFamLastnames.clear();
        }
        this.listOfFamLastnamesEOF = false;
        this.call(member, CMD_GFLxx, null);
        return this.listOfFamLastnames;
    }

    public Set<GedcomFam> getGedcomFamsFromMember(AncestrisMember member, Set<String> commonFamLastnames) {
        if (this.listOfFamDetails == null) {
            this.listOfFamDetails = new HashSet<GedcomFam>();
        } else {
            this.listOfFamDetails.clear();
        }
        this.listOfFamDetailsEOF = false;
        this.call(member, CMD_GFDxx, commonFamLastnames);
        return this.listOfFamDetails;
    }

    public MemberProfile getProfileMember(AncestrisMember member) {
        if (this.memberProfile == null) {
            this.memberProfile = new ByteArrayOutputStream();
        } else {
            this.memberProfile.reset();
        }
        this.memberProfileEOF = false;
        this.call(member, CMD_GPFxx, null);
        MemberProfile mp = (MemberProfile)this.unwrapObject(this.memberProfile.toByteArray());
        if (mp != null) {
            mp.ipaddress = this.memberIPaddress;
        }
        this.memberIPaddress = "";
        return mp;
    }

    public void thankMember(AncestrisMember member) {
        if (this.packetsOfProfile == null) {
            this.packetsOfProfile = this.buildPacketsOfProfile(this.owner.getMyProfile());
        }
        this.put(member, CMD_TXPxx, this.packetsOfProfile);
    }

    public boolean call(AncestrisMember member, String command, Object object) {
        if (socket == null || socket.isClosed()) {
            return false;
        }
        if (!this.communicationInProgress && !this.connectToMember(member)) {
            return false;
        }
        int iPacket = 0;
        boolean retry = true;
        int nbNoResponses = 0;
        LOG.log(Level.FINE, "Calling member " + member.getMemberName() + " with " + command);
        while (iPacket < this.COMM_PACKET_NB && nbNoResponses < this.COMM_NB_FAILS) {
            String commandIndexed = command + String.format(this.FMT_IDX, iPacket);
            try {
                this.sendCommand(commandIndexed, this.owner.getRegisteredPseudo() + STR_DELIMITER, iPacket == 0 ? object : null, member.getIPAddress(), Integer.valueOf(member.getPortAddress()));
                ExpectedResponse exResp = new ExpectedResponse(member, commandIndexed);
                this.expectedResponses.add(exResp);
                for (int s = 0; this.expectedResponses.contains(exResp) && s < this.REQUEST_TIMEOUT * 100; ++s) {
                    TimeUnit.MILLISECONDS.sleep(10L);
                }
                if (this.expectedResponses.contains(exResp)) {
                    ++nbNoResponses;
                    if (retry) {
                        LOG.log(Level.FINE, "...(TIMEOUT) No response from " + member.getMemberName() + " after " + this.REQUEST_TIMEOUT + "s timeout. Retrying once...");
                        retry = false;
                        continue;
                    }
                    LOG.log(Level.FINE, "...(TIMEOUT) No response from " + member.getMemberName() + " after " + this.REQUEST_TIMEOUT + "s timeout. Skip");
                    retry = true;
                    ++iPacket;
                    continue;
                }
                nbNoResponses = 0;
                retry = true;
                ++iPacket;
                if (!(command.equals(CMD_GSTAT) && this.gedcomNumbersEOF || command.equals(CMD_GILxx) && this.listOfIndiLastnamesEOF || command.equals(CMD_GIDxx) && this.listOfIndiDetailsEOF || command.equals(CMD_GFLxx) && this.listOfFamLastnamesEOF || command.equals(CMD_GFDxx) && this.listOfFamDetailsEOF) && (!command.equals(CMD_GPFxx) || !this.memberProfileEOF)) continue;
                break;
            }
            catch (Exception ex) {
                this.displayErrorMessage(false, "call Exception", "ERR_CallException", ex.getLocalizedMessage());
                return false;
            }
        }
        LOG.log(Level.FINE, "...(END) Returned call from member " + member.getMemberName() + " after " + iPacket + " packets");
        return true;
    }

    public boolean put(AncestrisMember member, String command, Map<Integer, byte[]> packets) {
        int iPacket;
        if (socket == null || socket.isClosed()) {
            return false;
        }
        if (!this.communicationInProgress && !this.connectToMember(member)) {
            return false;
        }
        String senderIP = member.getIPAddress();
        int senderPort = Integer.valueOf(member.getPortAddress());
        LOG.log(Level.FINE, "Putting member " + member.getMemberName() + " with " + command);
        for (iPacket = 0; iPacket < this.COMM_PACKET_NB; ++iPacket) {
            String commandIndexed = command + String.format(this.FMT_IDX, iPacket);
            byte[] set = packets.get(iPacket);
            if (set == null) {
                commandIndexed = command + String.format(this.FMT_IDX, this.COMM_PACKET_NB - 1);
                this.sendCommand(commandIndexed, this.owner.getRegisteredPseudo() + STR_DELIMITER, null, senderIP, senderPort);
                break;
            }
            this.sendCommand(commandIndexed, this.owner.getRegisteredPseudo() + STR_DELIMITER, set, senderIP, senderPort);
            try {
                TimeUnit.MILLISECONDS.sleep(this.COMM_RESPONSE_DELAY);
                continue;
            }
            catch (InterruptedException ex) {
                return false;
            }
        }
        LOG.log(Level.FINE, "...(END) Enf of put to member " + member.getMemberName() + " with " + iPacket + " packets");
        return true;
    }

    private boolean connectToMember(AncestrisMember member) {
        this.memberInProgress = member;
        try {
            this.sendCommand(CMD_CONCT, member.getMemberName(), null, COMM_SERVER, this.COMM_PORT);
            this.expectedConnection = true;
            for (int s = 0; this.expectedConnection && s < this.REQUEST_TIMEOUT * 100; ++s) {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            if (this.expectedConnection) {
                this.expectedConnection = false;
                LOG.log(Level.FINE, "...(TIMEOUT) No connection to " + member.getMemberName() + " after " + this.REQUEST_TIMEOUT + "s timeout.");
                return false;
            }
            TimeUnit.MILLISECONDS.sleep(500L);
            this.memberInProgress = null;
        }
        catch (Exception ex) {
            this.displayErrorMessage(false, "connectToMember Exception", "ERR_ConnectException", ex.getLocalizedMessage());
            return false;
        }
        LOG.log(Level.FINE, "...(SUCCESS) Connected successfully to member " + member.getMemberName());
        return true;
    }

    private byte[] extractBytes(byte[] content, byte delimiter) {
        byte[] ret = null;
        for (int i = 0; i < content.length; ++i) {
            byte b = content[i];
            if (b != delimiter && b != 0) continue;
            ret = Arrays.copyOfRange(content, 0, i);
            return ret;
        }
        ret = content;
        return ret;
    }

    public void listen() {
        String command = null;
        String senderAddress = null;
        String senderIP = null;
        int senderPort = 0;
        byte[] bytesReceived = new byte[this.COMM_PACKET_SIZE * 7];
        byte[] contentMemberBytes = null;
        String contentMemberStr = null;
        byte[] contentObj = null;
        String member = null;
        AncestrisMember aMember = null;
        LOG.log(Level.FINE, "Listening to all incoming calls indefinitely.......");
        this.packetsOfProfile = this.buildPacketsOfProfile(this.owner.getMyProfile());
        this.expectedResponses = new HashSet<ExpectedResponse>();
        try {
            while (this.sharing) {
                Object set;
                String commandIndexed;
                Integer iPacket;
                Integer iPacket2;
                ExpectedResponse er;
                DatagramPacket packetReceived = new DatagramPacket(bytesReceived, bytesReceived.length);
                socket.setSoTimeout(0);
                socket.receive(packetReceived);
                senderIP = packetReceived.getAddress().getHostAddress();
                senderPort = packetReceived.getPort();
                senderAddress = senderIP + ":" + senderPort;
                command = new String(Arrays.copyOfRange(bytesReceived, 0, this.COMM_CMD_SIZE));
                contentMemberBytes = this.extractBytes(Arrays.copyOfRange(bytesReceived, this.COMM_CMD_SIZE, bytesReceived.length), STR_DELIMITER.getBytes()[0]);
                contentMemberStr = new String(contentMemberBytes);
                LOG.log(Level.FINE, "...Incoming " + command + " command received from " + senderAddress + " with packet of size (" + packetReceived.getLength() + " bytes).");
                if (command.equals(CMD_UNROK)) {
                    this.sharing = false;
                    continue;
                }
                if (command.equals(CMD_UNRKO)) {
                    String err = new String(bytesReceived).substring(this.COMM_CMD_SIZE);
                    LOG.log(Level.FINE, "...Could not unregister " + this.owner.getRegisteredPseudo(false) + " from the Ancestris server. Error : " + err);
                    DialogManager.create((String)NbBundle.getMessage(Comm.class, (String)"MSG_Unregistration"), (String)err).setMessageType(0).show();
                    continue;
                }
                if (command.equals(CMD_CONCT)) {
                    member = StringEscapeUtils.unescapeHtml((String)contentMemberStr);
                    LOG.log(Level.FINE, "...Request to connect to " + member);
                    this.owner.updateMembersList();
                    aMember = this.owner.getMember(member);
                    if (aMember == null) {
                        LOG.log(Level.FINE, "...Member " + member + " is not in the list of members.");
                        continue;
                    }
                    if (aMember.isAllowed()) {
                        this.sendCommand(CMD_PINGG, this.owner.getRegisteredPseudo() + STR_DELIMITER, null, aMember.getxIPAddress(), Integer.valueOf(aMember.getxPortAddress()));
                        if (!aMember.getpIPAddress().isEmpty() && Integer.valueOf(aMember.getpPortAddress()) != 0) {
                            this.sendCommand(CMD_PINGG, this.owner.getRegisteredPseudo() + STR_DELIMITER, null, aMember.getpIPAddress(), Integer.valueOf(aMember.getpPortAddress()));
                        }
                        LOG.log(Level.FINE, "...Member " + member + " is allowed. Replied back with PINGG.");
                        continue;
                    }
                    LOG.log(Level.FINE, "...Member " + member + " is NOT allowed. No reply.");
                    continue;
                }
                member = StringEscapeUtils.unescapeHtml((String)contentMemberStr);
                aMember = this.owner.getMember(member);
                if (aMember == null) {
                    LOG.log(Level.FINE, "...Calling member " + member + " is not in the list of members.");
                    continue;
                }
                if (!aMember.isAllowed() || !this.isSameAddress(senderAddress, aMember)) {
                    LOG.log(Level.FINE, "...Member " + member + " is NOT allowed or address does not match the one I know. Do not reply.");
                    continue;
                }
                contentObj = Arrays.copyOfRange(bytesReceived, this.COMM_CMD_SIZE + contentMemberBytes.length + STR_DELIMITER.length(), bytesReceived.length);
                ExpectedResponse response = new ExpectedResponse(aMember, command);
                if (command.equals(CMD_PINGG)) {
                    this.sendCommand(CMD_PONGG, this.owner.getRegisteredPseudo() + STR_DELIMITER, null, senderIP, senderPort);
                    this.expectedConnection = false;
                    continue;
                }
                if (command.equals(CMD_PONGG)) {
                    this.expectedConnection = false;
                    if (this.memberInProgress != null) continue;
                    this.owner.addConnection(member);
                    continue;
                }
                if (command.substring(0, this.COMM_CMD_PFX_SIZE).equals(CMD_GSTAT)) {
                    String commandIndexed2 = CMD_TSTAT + String.format(this.FMT_IDX, this.COMM_PACKET_NB - 1);
                    GedcomNumbers gn = this.getMySharedNumbers(this.owner.getSharedGedcoms());
                    TimeUnit.MILLISECONDS.sleep(this.COMM_RESPONSE_DELAY);
                    this.sendCommand(commandIndexed2, this.owner.getRegisteredPseudo() + STR_DELIMITER, gn, senderIP, senderPort);
                    continue;
                }
                if (command.substring(0, this.COMM_CMD_PFX_SIZE).equals(CMD_TSTAT)) {
                    er = this.getExpectedResponse(response);
                    if (er == null) continue;
                    iPacket2 = Integer.valueOf(command.substring(this.COMM_CMD_PFX_SIZE, this.COMM_CMD_SIZE));
                    if (iPacket2 == this.COMM_PACKET_NB - 1) {
                        this.gedcomNumbersEOF = true;
                        this.gedcomNumbers = (GedcomNumbers)this.unwrapObject(contentObj);
                    }
                    this.expectedResponses.remove(er);
                    continue;
                }
                if (command.substring(0, this.COMM_CMD_PFX_SIZE).equals(CMD_GILxx)) {
                    iPacket = Integer.valueOf(command.substring(this.COMM_CMD_PFX_SIZE, this.COMM_CMD_SIZE));
                    if (iPacket == 0 || this.packetsOfIndiLastnames == null) {
                        this.packetsOfIndiLastnames = this.buildPacketsOfString(this.getMySharedIndiLastnames(this.owner.getSharedGedcoms()));
                    }
                    commandIndexed = CMD_TILxx + String.format(this.FMT_IDX, iPacket);
                    set = this.packetsOfIndiLastnames.get(iPacket);
                    TimeUnit.MILLISECONDS.sleep(this.COMM_RESPONSE_DELAY);
                    if (set == null) {
                        commandIndexed = CMD_TILxx + String.format(this.FMT_IDX, this.COMM_PACKET_NB - 1);
                        this.sendCommand(commandIndexed, this.owner.getRegisteredPseudo() + STR_DELIMITER, null, senderIP, senderPort);
                        continue;
                    }
                    this.sendCommand(commandIndexed, this.owner.getRegisteredPseudo() + STR_DELIMITER, set, senderIP, senderPort);
                    continue;
                }
                if (command.substring(0, this.COMM_CMD_PFX_SIZE).equals(CMD_TILxx)) {
                    er = this.getExpectedResponse(response);
                    if (er == null) continue;
                    iPacket2 = Integer.valueOf(command.substring(this.COMM_CMD_PFX_SIZE, this.COMM_CMD_SIZE));
                    if (iPacket2 == this.COMM_PACKET_NB - 1) {
                        this.listOfIndiLastnamesEOF = true;
                        this.packetsOfIndiLastnames = null;
                    } else {
                        this.listOfIndiLastnames.addAll((Set)this.unwrapObject(contentObj));
                    }
                    this.expectedResponses.remove(er);
                    continue;
                }
                if (command.substring(0, this.COMM_CMD_PFX_SIZE).equals(CMD_GIDxx)) {
                    iPacket = Integer.valueOf(command.substring(this.COMM_CMD_PFX_SIZE, this.COMM_CMD_SIZE));
                    if (iPacket == 0 || this.packetsOfIndiDetails == null) {
                        this.packetsOfIndiDetails = this.buildPacketsOfIndis(this.getMySharedGedcomIndis(this.owner.getSharedGedcoms(), (Set)this.unwrapObject(contentObj)));
                    }
                    commandIndexed = CMD_TIDxx + String.format(this.FMT_IDX, iPacket);
                    set = this.packetsOfIndiDetails.get(iPacket);
                    TimeUnit.MILLISECONDS.sleep(this.COMM_RESPONSE_DELAY);
                    if (set == null) {
                        commandIndexed = CMD_TIDxx + String.format(this.FMT_IDX, this.COMM_PACKET_NB - 1);
                        this.sendCommand(commandIndexed, this.owner.getRegisteredPseudo() + STR_DELIMITER, null, senderIP, senderPort);
                        continue;
                    }
                    this.sendCommand(commandIndexed, this.owner.getRegisteredPseudo() + STR_DELIMITER, set, senderIP, senderPort);
                    continue;
                }
                if (command.substring(0, this.COMM_CMD_PFX_SIZE).equals(CMD_TIDxx)) {
                    er = this.getExpectedResponse(response);
                    if (er == null) continue;
                    iPacket2 = Integer.valueOf(command.substring(this.COMM_CMD_PFX_SIZE, this.COMM_CMD_SIZE));
                    if (iPacket2 == this.COMM_PACKET_NB - 1) {
                        this.listOfIndiDetailsEOF = true;
                        this.packetsOfIndiDetails = null;
                    } else {
                        this.listOfIndiDetails.addAll((Set)this.unwrapObject(contentObj));
                    }
                    this.expectedResponses.remove(er);
                    continue;
                }
                if (command.substring(0, this.COMM_CMD_PFX_SIZE).equals(CMD_GFLxx)) {
                    iPacket = Integer.valueOf(command.substring(this.COMM_CMD_PFX_SIZE, this.COMM_CMD_SIZE));
                    if (iPacket == 0 || this.packetsOfFamLastnames == null) {
                        this.packetsOfFamLastnames = this.buildPacketsOfString(this.getMySharedFamLastnames(this.owner.getSharedGedcoms()));
                    }
                    commandIndexed = CMD_TFLxx + String.format(this.FMT_IDX, iPacket);
                    set = this.packetsOfFamLastnames.get(iPacket);
                    TimeUnit.MILLISECONDS.sleep(this.COMM_RESPONSE_DELAY);
                    if (set == null) {
                        commandIndexed = CMD_TFLxx + String.format(this.FMT_IDX, this.COMM_PACKET_NB - 1);
                        this.sendCommand(commandIndexed, this.owner.getRegisteredPseudo() + STR_DELIMITER, null, senderIP, senderPort);
                        continue;
                    }
                    this.sendCommand(commandIndexed, this.owner.getRegisteredPseudo() + STR_DELIMITER, set, senderIP, senderPort);
                    continue;
                }
                if (command.substring(0, this.COMM_CMD_PFX_SIZE).equals(CMD_TFLxx)) {
                    er = this.getExpectedResponse(response);
                    if (er == null) continue;
                    iPacket2 = Integer.valueOf(command.substring(this.COMM_CMD_PFX_SIZE, this.COMM_CMD_SIZE));
                    if (iPacket2 == this.COMM_PACKET_NB - 1) {
                        this.listOfFamLastnamesEOF = true;
                        this.packetsOfFamLastnames = null;
                    } else {
                        this.listOfFamLastnames.addAll((Set)this.unwrapObject(contentObj));
                    }
                    this.expectedResponses.remove(er);
                    continue;
                }
                if (command.substring(0, this.COMM_CMD_PFX_SIZE).equals(CMD_GFDxx)) {
                    iPacket = Integer.valueOf(command.substring(this.COMM_CMD_PFX_SIZE, this.COMM_CMD_SIZE));
                    if (iPacket == 0 || this.packetsOfFamDetails == null) {
                        this.packetsOfFamDetails = this.buildPacketsOfFams(this.getMySharedGedcomFams(this.owner.getSharedGedcoms(), (Set)this.unwrapObject(contentObj)));
                    }
                    commandIndexed = CMD_TFDxx + String.format(this.FMT_IDX, iPacket);
                    set = this.packetsOfFamDetails.get(iPacket);
                    TimeUnit.MILLISECONDS.sleep(this.COMM_RESPONSE_DELAY);
                    if (set == null) {
                        commandIndexed = CMD_TFDxx + String.format(this.FMT_IDX, this.COMM_PACKET_NB - 1);
                        this.sendCommand(commandIndexed, this.owner.getRegisteredPseudo() + STR_DELIMITER, null, senderIP, senderPort);
                        continue;
                    }
                    this.sendCommand(commandIndexed, this.owner.getRegisteredPseudo() + STR_DELIMITER, set, senderIP, senderPort);
                    continue;
                }
                if (command.substring(0, this.COMM_CMD_PFX_SIZE).equals(CMD_TFDxx)) {
                    er = this.getExpectedResponse(response);
                    if (er == null) continue;
                    iPacket2 = Integer.valueOf(command.substring(this.COMM_CMD_PFX_SIZE, this.COMM_CMD_SIZE));
                    if (iPacket2 == this.COMM_PACKET_NB - 1) {
                        this.listOfFamDetailsEOF = true;
                        this.packetsOfFamDetails = null;
                    } else {
                        this.listOfFamDetails.addAll((Set)this.unwrapObject(contentObj));
                    }
                    this.expectedResponses.remove(er);
                    continue;
                }
                if (command.substring(0, this.COMM_CMD_PFX_SIZE).equals(CMD_GPFxx)) {
                    iPacket = Integer.valueOf(command.substring(this.COMM_CMD_PFX_SIZE, this.COMM_CMD_SIZE));
                    if (this.packetsOfProfile == null) {
                        this.packetsOfProfile = this.buildPacketsOfProfile(this.owner.getMyProfile());
                    }
                    commandIndexed = CMD_TPFxx + String.format(this.FMT_IDX, iPacket);
                    set = this.packetsOfProfile.get(iPacket);
                    TimeUnit.MILLISECONDS.sleep(this.COMM_RESPONSE_DELAY);
                    if (set == null) {
                        commandIndexed = CMD_TPFxx + String.format(this.FMT_IDX, this.COMM_PACKET_NB - 1);
                        this.sendCommand(commandIndexed, this.owner.getRegisteredPseudo() + STR_DELIMITER, null, senderIP, senderPort);
                        continue;
                    }
                    this.sendCommand(commandIndexed, this.owner.getRegisteredPseudo() + STR_DELIMITER, set, senderIP, senderPort);
                    continue;
                }
                if (command.substring(0, this.COMM_CMD_PFX_SIZE).equals(CMD_TPFxx)) {
                    er = this.getExpectedResponse(response);
                    if (er == null) continue;
                    iPacket2 = Integer.valueOf(command.substring(this.COMM_CMD_PFX_SIZE, this.COMM_CMD_SIZE));
                    if (iPacket2 == this.COMM_PACKET_NB - 1) {
                        this.memberProfileEOF = true;
                        this.memberIPaddress = senderIP;
                    } else {
                        this.memberProfile.write((byte[])this.unwrapObject(contentObj));
                    }
                    this.expectedResponses.remove(er);
                    continue;
                }
                if (command.substring(0, this.COMM_CMD_PFX_SIZE).equals(CMD_TSPRF)) {
                    iPacket = Integer.valueOf(command.substring(this.COMM_CMD_PFX_SIZE, this.COMM_CMD_SIZE));
                    if (iPacket == 0) {
                        if (this.memberProfileRcv == null) {
                            this.memberProfileRcv = new ByteArrayOutputStream();
                        } else {
                            this.memberProfileRcv.reset();
                        }
                        this.memberProfileRcv.write((byte[])this.unwrapObject(contentObj));
                        continue;
                    }
                    if (iPacket == this.COMM_PACKET_NB - 1) {
                        this.owner.addUniqueFriend(member, (MemberProfile)this.unwrapObject(this.memberProfileRcv.toByteArray()), senderIP, false);
                        continue;
                    }
                    this.memberProfileRcv.write((byte[])this.unwrapObject(contentObj));
                    continue;
                }
                if (!command.substring(0, this.COMM_CMD_PFX_SIZE).equals(CMD_TXPxx)) continue;
                iPacket = Integer.valueOf(command.substring(this.COMM_CMD_PFX_SIZE, this.COMM_CMD_SIZE));
                if (iPacket == 0) {
                    if (this.memberProfileRcv == null) {
                        this.memberProfileRcv = new ByteArrayOutputStream();
                    } else {
                        this.memberProfileRcv.reset();
                    }
                    this.memberProfileRcv.write((byte[])this.unwrapObject(contentObj));
                    continue;
                }
                if (iPacket == this.COMM_PACKET_NB - 1) {
                    this.owner.addUniqueFriend(member, (MemberProfile)this.unwrapObject(this.memberProfileRcv.toByteArray()), senderIP, true);
                    continue;
                }
                this.memberProfileRcv.write((byte[])this.unwrapObject(contentObj));
            }
        }
        catch (Exception ex) {
            DialogManager.create((String)NbBundle.getMessage(Comm.class, (String)"MSG_CommunicationError"), (String)ex.getLocalizedMessage()).setMessageType(0).show();
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private boolean sendCommand(String command, String string, Object object, String ipAddress, int portAddress) {
        int s;
        byte[] msgBytes = null;
        String contentStr = command + string;
        byte[] contentBytes = contentStr.getBytes(Charset.forName(COMM_CHARSET));
        msgBytes = object == null ? contentBytes : this.getWrappedObject(contentBytes, object);
        if (msgBytes == null) {
            LOG.log(Level.FINE, "Sending command " + command + " with " + string + " => Cannot wrap message. Abort communication.");
            return false;
        }
        if (!command.equals(CMD_PONGG)) {
            LOG.log(Level.FINE, "Sending command " + command + " with " + string + " and object of size (" + msgBytes.length + " bytes)");
        }
        if ((s = msgBytes.length) > this.COMM_PACKET_SIZE) {
            Set testSet;
            LOG.log(Level.FINE, "./!\\ Object of size (" + s + " bytes) is larger than maximum packet size of " + this.COMM_PACKET_SIZE);
            boolean abort = true;
            if (object instanceof Set && (testSet = (Set)object).iterator().next() instanceof String) {
                abort = false;
            }
            if (!abort) {
                Set set = (Set)object;
                HashSet<String> subSet = new HashSet<String>();
                int factor = 2 * s / this.COMM_PACKET_SIZE + 3;
                int limit = set.size() / factor;
                int index = 0;
                byte[] tmpBytes = null;
                for (String str : set) {
                    subSet.add(str);
                    if (index > limit) {
                        tmpBytes = this.getWrappedObject(contentBytes, subSet);
                        s = tmpBytes.length;
                        if (s >= this.COMM_PACKET_SIZE) {
                            LOG.log(Level.FINE, ".You are the caller : number of common names has been truncated to first " + (limit - 10) + " names instead of " + set.size() + ".");
                            LOG.log(Level.FINE, ".Packet size is now (" + msgBytes.length + ") bytes.");
                            break;
                        }
                        msgBytes = tmpBytes;
                        limit += 10;
                    }
                    ++index;
                }
            } else {
                LOG.log(Level.FINE, ".You are the receiver : compression factor is currently set to " + this.COMM_COMPRESSING_FACTOR + " and should be increased by the developpers.");
                LOG.log(Level.FINE, ".=> Abort communication.");
                return false;
            }
        }
        return this.sendObject(msgBytes, ipAddress, portAddress);
    }

    private byte[] getWrappedObject(byte[] contentBytes, Object object) {
        byte[] ret = null;
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            byteStream.write(contentBytes);
            byteStream.write(this.wrapObject(object));
            ret = byteStream.toByteArray();
        }
        catch (IOException ex) {
            this.displayErrorMessage(false, "getWrappedObject", "ERR_WrappedException", ex.getLocalizedMessage());
        }
        return ret;
    }

    private byte[] wrapObject(Object object) {
        byte[] bytes = null;
        try {
            ByteArrayOutputStream contentStream = new ByteArrayOutputStream();
            GZIPOutputStream gz = new GZIPOutputStream(contentStream);
            ObjectOutputStream os = new ObjectOutputStream(gz);
            os.flush();
            os.writeObject(object);
            os.flush();
            gz.close();
            bytes = contentStream.toByteArray();
        }
        catch (IOException ex) {
            this.displayErrorMessage(false, "wrapObject", "ERR_WrapException", ex.getLocalizedMessage());
        }
        return bytes;
    }

    private Object unwrapObject(byte[] content) {
        Object object = null;
        if (content == null || content.length == 0) {
            return null;
        }
        try {
            ByteArrayInputStream byteStream = new ByteArrayInputStream(content);
            ObjectInputStream is = new ObjectInputStream(new GZIPInputStream(byteStream));
            object = is.readObject();
            is.close();
        }
        catch (EOFException ex) {
            String log = "Receiving message. Packet size was probably larger than the maximum packet size and therefore has been truncated, or packets have different sizes between the sender and the receiver. Please update your version of Ancestris or contact the Ancestris support.";
            this.displayErrorMessage(false, log, "ERR_UnwrapException", ex.getLocalizedMessage());
        }
        catch (IOException ex) {
            this.displayErrorMessage(false, "unwrapObject IOException", "ERR_UnwrapException", ex.getLocalizedMessage());
        }
        catch (ClassNotFoundException ex) {
            this.displayErrorMessage(false, "unwrapObject ClassNotFoundException", "ERR_UnwrapException", ex.getLocalizedMessage());
        }
        return object;
    }

    private boolean sendObject(byte[] bytesSent, String ipAddress, int portAddress) {
        try {
            DatagramPacket packetSent = new DatagramPacket(bytesSent, bytesSent.length, InetAddress.getByName(ipAddress), portAddress);
            socket.send(packetSent);
        }
        catch (UnknownHostException ex) {
            this.displayErrorMessage(true, "sendObject UnknownHostException", "ERR_UnknownHostException", ex.getLocalizedMessage());
            return false;
        }
        catch (IOException ex) {
            this.displayErrorMessage(false, "sendObject IOException", "ERR_SendException", ex.getLocalizedMessage());
            return false;
        }
        return true;
    }

    public GedcomNumbers getMySharedNumbers(List<SharedGedcom> sharedGedcoms) {
        GedcomNumbers gn = new GedcomNumbers();
        for (SharedGedcom sharedGedcom : sharedGedcoms) {
            gn.nbIndis += sharedGedcom.getNbOfPublicIndis();
            gn.nbFams += sharedGedcom.getNbOfPublicFams();
        }
        return gn;
    }

    public Set<String> getMySharedIndiLastnames(List<SharedGedcom> sharedGedcoms) {
        HashSet<String> ret = new HashSet<String>();
        for (SharedGedcom sharedGedcom : sharedGedcoms) {
            ret.addAll(sharedGedcom.getPublicIndiLastnames());
        }
        return ret;
    }

    public Set<String> getMySharedFamLastnames(List<SharedGedcom> sharedGedcoms) {
        HashSet<String> ret = new HashSet<String>();
        for (SharedGedcom sharedGedcom : sharedGedcoms) {
            ret.addAll(sharedGedcom.getPublicFamLastnames());
        }
        return ret;
    }

    public Set<GedcomIndi> getMySharedGedcomIndis(List<SharedGedcom> sharedGedcoms, Set<String> commonIndiLastnames) {
        HashSet<GedcomIndi> ret = new HashSet<GedcomIndi>();
        for (SharedGedcom sharedGedcom : sharedGedcoms) {
            ret.addAll(sharedGedcom.getPublicGedcomIndis(commonIndiLastnames));
        }
        return ret;
    }

    public Set<GedcomFam> getMySharedGedcomFams(List<SharedGedcom> sharedGedcoms, Set<String> commonFamLastnames) {
        HashSet<GedcomFam> ret = new HashSet<GedcomFam>();
        for (SharedGedcom sharedGedcom : sharedGedcoms) {
            ret.addAll(sharedGedcom.getPublicGedcomFams(commonFamLastnames));
        }
        return ret;
    }

    private Map<Integer, Set<String>> buildPacketsOfString(Set<String> masterSet) {
        HashMap<Integer, Set<String>> packets = new HashMap<Integer, Set<String>>();
        byte[] masterPacket = this.wrapObject(masterSet);
        int nbPackets = (int)(Math.min((double)this.COMM_PACKET_NB, (double)masterPacket.length * this.COMM_COMPRESSING_FACTOR / (double)this.COMM_PACKET_SIZE) + 1.0);
        LOG.log(Level.FINE, "......Compressing " + masterSet.size() + " strings in " + nbPackets + " packets.");
        Integer i = 0;
        while (i < nbPackets) {
            packets.put(i, new HashSet());
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        int index = 0;
        for (String obj : masterSet) {
            ((Set)packets.get(index++ % nbPackets)).add(obj);
        }
        return packets;
    }

    private Map<Integer, Set<GedcomIndi>> buildPacketsOfIndis(Set<GedcomIndi> masterSet) {
        HashMap<Integer, Set<GedcomIndi>> packets = new HashMap<Integer, Set<GedcomIndi>>();
        byte[] masterPacket = this.wrapObject(masterSet);
        int nbPackets = (int)(Math.min((double)this.COMM_PACKET_NB, (double)masterPacket.length * this.COMM_COMPRESSING_FACTOR / (double)this.COMM_PACKET_SIZE) + 1.0);
        LOG.log(Level.FINE, "......Compressing " + masterSet.size() + " indis in " + nbPackets + " packets.");
        Integer i = 0;
        while (i < nbPackets) {
            packets.put(i, new HashSet());
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        int index = 0;
        for (GedcomIndi obj : masterSet) {
            ((Set)packets.get(index++ % nbPackets)).add(obj);
        }
        return packets;
    }

    private Map<Integer, Set<GedcomFam>> buildPacketsOfFams(Set<GedcomFam> masterSet) {
        HashMap<Integer, Set<GedcomFam>> packets = new HashMap<Integer, Set<GedcomFam>>();
        byte[] masterPacket = this.wrapObject(masterSet);
        int nbPackets = (int)(Math.min((double)this.COMM_PACKET_NB, (double)masterPacket.length * this.COMM_COMPRESSING_FACTOR / (double)this.COMM_PACKET_SIZE) + 1.0);
        LOG.log(Level.FINE, "......Compressing " + masterSet.size() + " fams in " + nbPackets + " packets.");
        Integer i = 0;
        while (i < nbPackets) {
            packets.put(i, new HashSet());
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        int index = 0;
        for (GedcomFam obj : masterSet) {
            ((Set)packets.get(index++ % nbPackets)).add(obj);
        }
        return packets;
    }

    private Map<Integer, byte[]> buildPacketsOfProfile(MemberProfile profile) {
        HashMap<Integer, byte[]> packets = new HashMap<Integer, byte[]>();
        byte[] masterPacket = this.wrapObject(profile);
        int nbResized = 1024;
        int nbPackets = Math.min(this.COMM_PACKET_NB, masterPacket.length / nbResized) + 1;
        Integer i = 0;
        while (i < nbPackets) {
            if (i < nbPackets - 1) {
                packets.put(i, Arrays.copyOfRange(masterPacket, i * nbResized, (i + 1) * nbResized));
            } else {
                packets.put(i, Arrays.copyOfRange(masterPacket, i * nbResized, masterPacket.length));
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return packets;
    }

    private ExpectedResponse getExpectedResponse(ExpectedResponse response) {
        boolean sameMember = false;
        for (ExpectedResponse er : this.expectedResponses) {
            boolean bl = sameMember = response.fromMember.getMemberName().equals(er.fromMember.getMemberName()) && response.fromMember.getxIPAddress().equals(er.fromMember.getxIPAddress()) && response.fromMember.getxPortAddress().equals(er.fromMember.getxPortAddress());
            if (sameMember && response.forCommand.equals(er.forCommand)) {
                return er;
            }
            if (!sameMember) continue;
            String prefix1 = response.forCommand.substring(0, this.COMM_CMD_PFX_SIZE);
            String prefix2 = er.forCommand.substring(0, this.COMM_CMD_PFX_SIZE);
            Integer iPacket = Integer.valueOf(response.forCommand.substring(this.COMM_CMD_PFX_SIZE, this.COMM_CMD_SIZE));
            if (!prefix1.equals(prefix2) || iPacket != this.COMM_PACKET_NB - 1) continue;
            return er;
        }
        return null;
    }

    public void clearMember(AncestrisMember member) {
        HashSet<ExpectedResponse> listToRemove = new HashSet<ExpectedResponse>();
        for (ExpectedResponse er : this.expectedResponses) {
            if (!member.getMemberName().equals(er.fromMember.getMemberName()) || !member.getIPAddress().equals(er.fromMember.getIPAddress()) || !member.getPortAddress().equals(er.fromMember.getPortAddress())) continue;
            listToRemove.add(er);
        }
        if (!listToRemove.isEmpty()) {
            this.expectedResponses.removeAll(listToRemove);
        }
    }

    private boolean isSameAddress(String senderAddress, AncestrisMember aMember) {
        if (senderAddress.equals(aMember.getxIPAddress() + ":" + aMember.getxPortAddress())) {
            return true;
        }
        if (senderAddress.equals(aMember.getpIPAddress() + ":" + aMember.getpPortAddress())) {
            if (this.memberInProgress != null) {
                this.memberInProgress.setUsePrivate(true);
            }
            return true;
        }
        return false;
    }

    private void displayErrorMessage(boolean mute, String log, String err, String sub_err) {
        if (mute && this.isCommError) {
            return;
        }
        final String title = NbBundle.getMessage(TreeSharingTopComponent.class, (String)"OpenIDE-Module-Name") + " - " + NbBundle.getMessage(Comm.class, (String)"MSG_CommunicationError");
        sub_err = sub_err.replace(COMM_SERVER, "www");
        final String msg = NbBundle.getMessage(Comm.class, (String)err, (Object)sub_err);
        LOG.log(Level.FINE, log + "   (" + title + ": " + msg + ")");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DialogManager.create((String)title, (String)msg).setOptionType(10).setMessageType(0).show();
            }
        });
        this.isCommError = true;
    }

    private static InetAddress getLocalHostLANAddress() throws UnknownHostException {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception ex) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + ex);
            unknownHostException.initCause(ex);
            throw unknownHostException;
        }
    }

    private class ExpectedResponse {
        private AncestrisMember fromMember = null;
        private String forCommand = "";

        public ExpectedResponse(AncestrisMember member, String command) {
            this.fromMember = member;
            this.forCommand = command.replace("G", "T");
        }
    }
}

