/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.treesharing.communication;

import ancestris.core.TextOptions;
import ancestris.modules.treesharing.communication.GedcomFam;
import ancestris.modules.treesharing.communication.GedcomIndi;
import ancestris.modules.treesharing.panels.FriendGedcomEntity;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.TagPath;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;

public class EntityConversion {
    public static GedcomIndi indiToGedcomIndi(Indi indi) {
        GedcomIndi gedcomIndi = new GedcomIndi();
        gedcomIndi.gedcomName = indi.getGedcom().getName();
        gedcomIndi.entityID = indi.getId();
        gedcomIndi.indiSex = "" + indi.getSex();
        gedcomIndi.indiLastName = indi.getLastName();
        gedcomIndi.indiFirstName = indi.getFirstName();
        gedcomIndi.indiBirthDate = EntityConversion.getYear(indi.getBirthDate());
        gedcomIndi.indiBirthPlace = EntityConversion.getBirthPlace(indi);
        gedcomIndi.indiDeathDate = EntityConversion.getYear(indi.getDeathDate());
        gedcomIndi.indiDeathPlace = EntityConversion.getDeathPlace(indi);
        return gedcomIndi;
    }

    public static GedcomFam famToGedcomFam(Fam fam) {
        GedcomFam gedcomFam = new GedcomFam();
        gedcomFam.gedcomName = fam.getGedcom().getName();
        gedcomFam.entityID = fam.getId();
        gedcomFam.famMarrDate = EntityConversion.getYear(fam.getMarriageDate());
        gedcomFam.famMarrPlace = EntityConversion.getMarrPlace(fam);
        Indi husband = fam.getHusband();
        if (husband != null) {
            gedcomFam.husbID = husband.getId();
            gedcomFam.husbSex = "" + husband.getSex();
            gedcomFam.husbLastName = husband.getLastName();
            gedcomFam.husbFirstName = husband.getFirstName();
            gedcomFam.husbBirthDate = EntityConversion.getYear(husband.getBirthDate());
            gedcomFam.husbBirthPlace = EntityConversion.getBirthPlace(husband);
            gedcomFam.husbDeathDate = EntityConversion.getYear(husband.getDeathDate());
            gedcomFam.husbDeathPlace = EntityConversion.getDeathPlace(husband);
        } else {
            gedcomFam.husbID = "";
            gedcomFam.husbSex = "";
            gedcomFam.husbLastName = "";
            gedcomFam.husbFirstName = "";
            gedcomFam.husbBirthDate = "0";
            gedcomFam.husbBirthPlace = ",";
            gedcomFam.husbDeathDate = "0";
            gedcomFam.husbDeathPlace = ",";
        }
        Indi wife = fam.getWife();
        if (wife != null) {
            gedcomFam.wifeID = wife.getId();
            gedcomFam.wifeSex = "" + wife.getSex();
            gedcomFam.wifeLastName = wife.getLastName();
            gedcomFam.wifeFirstName = wife.getFirstName();
            gedcomFam.wifeBirthDate = EntityConversion.getYear(wife.getBirthDate());
            gedcomFam.wifeBirthPlace = EntityConversion.getBirthPlace(wife);
            gedcomFam.wifeDeathDate = EntityConversion.getYear(wife.getDeathDate());
            gedcomFam.wifeDeathPlace = EntityConversion.getDeathPlace(wife);
        } else {
            gedcomFam.wifeID = "";
            gedcomFam.wifeSex = "";
            gedcomFam.wifeLastName = "";
            gedcomFam.wifeFirstName = "";
            gedcomFam.wifeBirthDate = "0";
            gedcomFam.wifeBirthPlace = ",";
            gedcomFam.wifeDeathDate = "0";
            gedcomFam.wifeDeathPlace = ",";
        }
        return gedcomFam;
    }

    private static String getYear(PropertyDate date) {
        PointInTime pit2;
        if (date == null || !date.isValid()) {
            return "0";
        }
        PointInTime pit = date.getStart();
        if (pit == null) {
            return "0";
        }
        try {
            pit2 = pit.getPointInTime((Calendar)PointInTime.GREGORIAN);
        }
        catch (GedcomException ex) {
            return "0";
        }
        return pit2 != null ? "" + pit2.getYear() : "0";
    }

    private static String getBirthPlace(Indi indi) {
        PropertyPlace prop = (PropertyPlace)indi.getProperty(new TagPath("INDI:BIRT:PLAC"));
        return EntityConversion.getCityCountry(prop);
    }

    private static String getDeathPlace(Indi indi) {
        PropertyPlace prop = (PropertyPlace)indi.getProperty(new TagPath("INDI:DEAT:PLAC"));
        return EntityConversion.getCityCountry(prop);
    }

    private static String getMarrPlace(Fam fam) {
        PropertyPlace prop = (PropertyPlace)fam.getProperty(new TagPath("FAM:MARR:PLAC"));
        return EntityConversion.getCityCountry(prop);
    }

    private static String getCityCountry(PropertyPlace prop) {
        String juri;
        if (prop == null) {
            return "";
        }
        String city = prop.getCity();
        String[] bits = prop.getFormat();
        String country = "";
        if (bits != null && bits.length != 0 && (juri = prop.getJurisdiction(bits.length - 1)) != null) {
            country = juri;
        }
        return city + "," + country;
    }

    public static String getStringFromEntity(Entity entity, boolean useHtml) {
        if (entity instanceof Indi) {
            FriendGedcomEntity fge = new FriendGedcomEntity("", EntityConversion.indiToGedcomIndi((Indi)entity));
            return EntityConversion.getStringFromEntity(fge, useHtml);
        }
        if (entity instanceof Fam) {
            FriendGedcomEntity fge = new FriendGedcomEntity("", EntityConversion.famToGedcomFam((Fam)entity));
            return EntityConversion.getStringFromEntity(fge, useHtml);
        }
        return "";
    }

    public static String getStringFromEntity(FriendGedcomEntity fge, boolean useHtml) {
        String b = TextOptions.getInstance().getBirthSymbol();
        String m = TextOptions.getInstance().getMarriageSymbol();
        String d = TextOptions.getInstance().getDeathSymbol();
        StringBuilder ret = new StringBuilder(useHtml ? "<html>" : "");
        ret.append(fge.indiLastName);
        ret.append(", ");
        ret.append(fge.indiFirstName);
        ret.append(" (");
        ret.append(fge.indiID);
        ret.append(") {" + b);
        ret.append(fge.indiBirthDate.equals("0") ? "?" : fge.indiBirthDate);
        ret.append(" ");
        ret.append(fge.indiBirthPlace.equals(",") ? "?" : fge.indiBirthPlace);
        ret.append(" " + d);
        ret.append(fge.indiDeathDate.equals("0") ? "?" : fge.indiDeathDate);
        ret.append(" ");
        ret.append(fge.indiDeathPlace.equals(",") ? "?" : fge.indiDeathPlace);
        ret.append("}");
        if (fge.type.equals("FAM")) {
            ret.append((useHtml ? "<br>&nbsp;&nbsp;&nbsp;" : "") + " {" + m);
            ret.append(fge.famMarrDate.equals("0") ? "?" : fge.famMarrDate);
            ret.append(" ");
            ret.append(fge.famMarrPlace.equals(",") ? "?" : fge.famMarrPlace);
            ret.append("}" + (useHtml ? "<br>" : " "));
            ret.append(fge.spouLastName);
            ret.append(", ");
            ret.append(fge.spouFirstName);
            ret.append(" (");
            ret.append(fge.spouID);
            ret.append(") {" + b);
            ret.append(fge.spouBirthDate.equals("0") ? "?" : fge.spouBirthDate);
            ret.append(" ");
            ret.append(fge.spouBirthPlace.equals(",") ? "?" : fge.spouBirthPlace);
            ret.append(" " + d);
            ret.append(fge.spouDeathDate.equals("0") ? "?" : fge.spouDeathDate);
            ret.append(" ");
            ret.append(fge.spouDeathPlace.equals(",") ? "?" : fge.spouDeathPlace);
            ret.append("} (");
            ret.append(fge.entityID);
            ret.append(")");
        }
        ret.append(useHtml ? "</html>" : "");
        return ret.toString();
    }
}

