/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.treesharing.panels;

import ancestris.modules.treesharing.TreeSharingTopComponent;
import ancestris.modules.treesharing.communication.MemberProfile;
import ancestris.modules.treesharing.options.TreeSharingOptionsPanel;
import ancestris.modules.treesharing.panels.FriendGedcomEntity;
import ancestris.modules.treesharing.panels.GedcomFriendMatch;
import ancestris.modules.treesharing.panels.MatchData;
import ancestris.modules.treesharing.panels.ProfilePanel;
import ancestris.modules.treesharing.panels.SharedGedcom;
import ancestris.modules.treesharing.panels.StatsPanel;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AncestrisFriend
extends JInternalFrame {
    private final TreeSharingTopComponent owner;
    private static final ImageIcon nophoto = new ImageIcon(ImageUtilities.loadImage((String)"ancestris/modules/treesharing/resources/nophoto.png"));
    private final String name;
    private Set<MatchData> matchedIndis = null;
    private Set<MatchData> matchedFams = null;
    private MemberProfile memberProfile = null;
    private MemberProfile myProfile = null;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;

    public AncestrisFriend(TreeSharingTopComponent tstc, String name) {
        super(name);
        this.owner = tstc;
        this.name = name;
        this.matchedIndis = new HashSet<MatchData>();
        this.matchedFams = new HashSet<MatchData>();
        this.initComponents();
        this.updateStats();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.setBorder(new SoftBevelBorder(0));
        this.setIconifiable(true);
        this.setToolTipText(NbBundle.getMessage(AncestrisFriend.class, (String)"AncestrisFriend.Form.toolTipText"));
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/treesharing/resources/friend.png")));
        this.setMinimumSize(new Dimension(320, 104));
        this.setPreferredSize(new Dimension(320, 115));
        this.setVisible(true);
        this.jLabel1.setFont(new Font("DejaVu Sans", 0, 11));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/treesharing/resources/Indi.png")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(AncestrisFriend.class, (String)"AncestrisFriend.jLabel1.text"));
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/treesharing/resources/Fam.png")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(AncestrisFriend.class, (String)"AncestrisFriend.jLabel2.text"));
        this.jLabel3.setFont(new Font("DejaVu Sans", 0, 11));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(AncestrisFriend.class, (String)"AncestrisFriend.jLabel3.text"));
        this.jLabel4.setFont(new Font("DejaVu Sans", 0, 11));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(AncestrisFriend.class, (String)"AncestrisFriend.jLabel4.text"));
        this.jLabel5.setFont(new Font("DejaVu Sans", 0, 11));
        this.jLabel5.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(AncestrisFriend.class, (String)"AncestrisFriend.jLabel5.text"));
        this.jLabel6.setFont(new Font("DejaVu Sans", 0, 11));
        this.jLabel6.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(AncestrisFriend.class, (String)"AncestrisFriend.jLabel6.text"));
        this.jButton1.setFont(new Font("DejaVu Sans", 0, 11));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(AncestrisFriend.class, (String)"AncestrisFriend.jButton1.text"));
        this.jButton1.setPreferredSize(new Dimension(50, 20));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AncestrisFriend.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setFont(new Font("DejaVu Sans", 0, 11));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getMessage(AncestrisFriend.class, (String)"AncestrisFriend.jButton2.text"));
        this.jButton2.setPreferredSize(new Dimension(50, 20));
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AncestrisFriend.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/treesharing/resources/profile.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton3, (String)NbBundle.getMessage(AncestrisFriend.class, (String)"AncestrisFriend.jButton3.text"));
        this.jButton3.setEnabled(false);
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AncestrisFriend.this.jButton3ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton1, -1, 58, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton2, -1, 58, Short.MAX_VALUE).addComponent(this.jLabel6, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addComponent(this.jButton3, -2, 51, -2).addContainerGap(52, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jLabel5).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jButton1, -2, -1, -2).addComponent(this.jButton2, -2, -1, -2))).addComponent(this.jButton3, -2, 62, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.showList("INDI");
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.showList("FAM");
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        DialogManager.create((String)NbBundle.getMessage(StatsPanel.class, (String)"TITL_ProfilePanel", (Object)this.name), (JComponent)new ProfilePanel(this.memberProfile, this.myProfile)).setMessageType(-1).setResizable(false).setDialogId("profilpanel").setOptionType(10).show();
    }

    public String getFriendName() {
        return this.name;
    }

    public MemberProfile getFriendProfile() {
        return this.memberProfile;
    }

    public void addEntity(Entity entity, FriendGedcomEntity friendGedcomEntity, int matchResult) {
        if (entity instanceof Indi) {
            this.matchedIndis.add(new MatchData(entity, friendGedcomEntity, matchResult));
            return;
        }
        if (entity instanceof Fam) {
            this.matchedFams.add(new MatchData(entity, friendGedcomEntity, matchResult));
            return;
        }
    }

    public void updateStats() {
        int nbCommonIndis = this.countIds(this.matchedIndis);
        int nbCommonFams = this.countIds(this.matchedFams);
        this.jButton1.setText("" + nbCommonIndis);
        this.jButton2.setText("" + nbCommonFams);
        this.jButton1.setEnabled(nbCommonIndis != 0);
        this.jButton2.setEnabled(nbCommonFams != 0);
    }

    private int countIds(Set<MatchData> matchedEntities) {
        HashSet<String> ret = new HashSet<String>();
        for (MatchData data : matchedEntities) {
            ret.add(data.friendGedcomEntity.entityID);
        }
        return ret.size();
    }

    private void showList(String type) {
        this.owner.displayResultsPanel(NbBundle.getMessage(GedcomFriendMatch.class, (String)"TITL_AllGedcoms"), this.name, type);
    }

    public void removeGedcom(SharedGedcom sg) {
        LinkedList<MatchData> indisToRemove = new LinkedList<MatchData>();
        LinkedList<MatchData> famsToRemove = new LinkedList<MatchData>();
        Gedcom gedcom = sg.getGedcom();
        for (MatchData line : this.matchedIndis) {
            if (line.myEntity.getGedcom() != gedcom) continue;
            indisToRemove.add(line);
        }
        for (MatchData line : this.matchedFams) {
            if (line.myEntity.getGedcom() != gedcom) continue;
            famsToRemove.add(line);
        }
        for (MatchData match : indisToRemove) {
            this.matchedIndis.remove(match);
        }
        for (MatchData match : famsToRemove) {
            this.matchedFams.remove(match);
        }
    }

    public boolean isEmpty() {
        return this.matchedIndis.isEmpty() && this.matchedFams.isEmpty();
    }

    public void setTotals(int iIndis, int iFams) {
        this.jLabel5.setText("" + iIndis);
        this.jLabel6.setText("" + iFams);
    }

    public void setProfile(MemberProfile memberProfile, MemberProfile myProfile) {
        this.memberProfile = memberProfile;
        this.myProfile = myProfile;
        if (memberProfile != null) {
            this.jButton3.setEnabled(true);
            ImageIcon icon = TreeSharingOptionsPanel.getPhoto(2, memberProfile.photoBytes);
            if (icon != null) {
                this.jButton3.setIcon(icon);
            } else {
                this.jButton3.setIcon(nophoto);
            }
            this.jButton3.setToolTipText(NbBundle.getMessage(StatsPanel.class, (String)"TITL_SeeProfile", (Object)this.name));
        } else {
            this.jButton3.setEnabled(false);
            this.jButton3.setIcon(nophoto);
            this.jButton3.setToolTipText(NbBundle.getMessage(StatsPanel.class, (String)"TITL_NoProfile"));
        }
    }
}

