/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.treesharing.panels;

import ancestris.modules.treesharing.communication.EntityConversion;
import ancestris.modules.treesharing.panels.EntitiesListPanel;
import ancestris.modules.treesharing.panels.FriendGedcomEntity;
import ancestris.modules.treesharing.panels.MatchData;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityBean
extends JPanel {
    private static final ImageIcon ICON_FAM = new ImageIcon(ImageUtilities.loadImage((String)"ancestris/modules/treesharing/resources/Fam.png"));
    private static final ImageIcon ICON_MALE = new ImageIcon(ImageUtilities.loadImage((String)"ancestris/modules/treesharing/resources/Male.png"));
    private static final ImageIcon ICON_FEMALE = new ImageIcon(ImageUtilities.loadImage((String)"ancestris/modules/treesharing/resources/Female.png"));
    private static final ImageIcon ICON_STAR = new ImageIcon(ImageUtilities.loadImage((String)"ancestris/modules/treesharing/resources/star.png"));
    private JPanel jPanel1;
    private JPanel jPanel2;

    public EntityBean(Entity entity, List<MatchData> list) {
        this.initComponents();
        BoxLayout bl11 = new BoxLayout(this.jPanel1, 3);
        this.jPanel1.setLayout(bl11);
        JPanel miniPanel1 = new JPanel();
        BoxLayout bl12 = new BoxLayout(miniPanel1, 2);
        miniPanel1.setLayout(bl12);
        miniPanel1.add(new JLabel(this.getSexIcon(entity)));
        miniPanel1.add(new JLabel("   "));
        miniPanel1.add(new JLabel(EntityConversion.getStringFromEntity(entity, true)));
        this.jPanel1.add(miniPanel1);
        final Entity myEntity = entity;
        miniPanel1.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                if (evt.getClickCount() != 2) {
                    return;
                }
                SelectionDispatcher.fireSelection((Context)new Context(myEntity));
            }
        });
        miniPanel1.setToolTipText(NbBundle.getMessage(EntitiesListPanel.class, (String)"TIP_ClickableEntity"));
        BoxLayout bl2 = new BoxLayout(this.jPanel2, 3);
        this.jPanel2.setLayout(bl2);
        for (MatchData line : list) {
            JPanel miniPanel2 = new JPanel();
            BoxLayout bl3 = new BoxLayout(miniPanel2, 2);
            miniPanel2.setLayout(bl3);
            miniPanel2.add(new JLabel(this.getSexIcon(line.friendGedcomEntity)));
            miniPanel2.add(new JLabel("   "));
            miniPanel2.add(new JLabel(EntityConversion.getStringFromEntity(line.friendGedcomEntity, true)));
            miniPanel2.add(new JLabel(" "));
            for (int i = 0; i < 4 - line.matchResult; ++i) {
                miniPanel2.add(new JLabel(ICON_STAR));
            }
            this.jPanel2.add(miniPanel2);
        }
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel2.setPreferredSize(new Dimension(281, 20));
        this.jPanel1.setPreferredSize(new Dimension(230, 20));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 230, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addGap(8, 8, 8)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addGap(8, 8, 8)));
    }

    private ImageIcon getSexIcon(Entity entity) {
        Indi indi;
        ImageIcon icon = null;
        icon = entity instanceof Fam ? ICON_FAM : ((indi = (Indi)entity).getSex() == 1 ? ICON_MALE : ICON_FEMALE);
        return icon;
    }

    private ImageIcon getSexIcon(FriendGedcomEntity friendGedcomEntity) {
        ImageIcon icon = null;
        icon = friendGedcomEntity.type.equals("FAM") ? ICON_FAM : (friendGedcomEntity.indiSex == 1 ? ICON_MALE : ICON_FEMALE);
        return icon;
    }
}

