/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.treesharing.panels;

import ancestris.modules.treesharing.TreeSharingTopComponent;
import ancestris.modules.treesharing.panels.AncestrisFriend;
import ancestris.modules.treesharing.panels.FriendGedcomEntity;
import ancestris.modules.treesharing.panels.MatchData;
import ancestris.modules.treesharing.panels.SharedGedcom;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GedcomFriendMatch
extends JInternalFrame {
    private final TreeSharingTopComponent owner;
    private SharedGedcom sharedGedcom = null;
    private AncestrisFriend ancestrisFriend = null;
    private Set<MatchData> matchedIndis = null;
    private Set<MatchData> matchedFams = null;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;

    public GedcomFriendMatch(TreeSharingTopComponent tstc, SharedGedcom sharedGedcom, AncestrisFriend ancestrisFriend) {
        this.owner = tstc;
        this.sharedGedcom = sharedGedcom;
        this.ancestrisFriend = ancestrisFriend;
        this.matchedIndis = new HashSet<MatchData>();
        this.matchedFams = new HashSet<MatchData>();
        this.initComponents();
        this.setJMenuBar(null);
        this.updateStats();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.setBorder(new SoftBevelBorder(0));
        this.setIconifiable(true);
        this.setToolTipText(NbBundle.getMessage(GedcomFriendMatch.class, (String)"GedcomFriendMatch.toolTipText"));
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/treesharing/resources/allowed.png")));
        this.setVisible(false);
        this.jLabel1.setFont(new Font("DejaVu Sans", 0, 11));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/treesharing/resources/Indi.png")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(GedcomFriendMatch.class, (String)"GedcomFriendMatch.jLabel1.text"));
        this.jLabel1.setPreferredSize(new Dimension(50, 14));
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/treesharing/resources/Fam.png")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(GedcomFriendMatch.class, (String)"GedcomFriendMatch.jLabel2.text"));
        this.jLabel2.setPreferredSize(new Dimension(50, 14));
        this.jButton1.setFont(new Font("DejaVu Sans", 0, 11));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(GedcomFriendMatch.class, (String)"GedcomFriendMatch.jButton1.text"));
        this.jButton1.setPreferredSize(new Dimension(50, 20));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GedcomFriendMatch.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setFont(new Font("DejaVu Sans", 0, 11));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getMessage(GedcomFriendMatch.class, (String)"GedcomFriendMatch.jButton2.text"));
        this.jButton2.setPreferredSize(new Dimension(50, 20));
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GedcomFriendMatch.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton1, -1, 58, Short.MAX_VALUE).addComponent(this.jLabel1, -1, 58, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton2, -1, 58, Short.MAX_VALUE).addComponent(this.jLabel2, -1, 58, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -2, -1, -2).addComponent(this.jLabel1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1, -2, -1, -2).addComponent(this.jButton2, -2, -1, -2)).addContainerGap()));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.showList("INDI");
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.showList("FAM");
    }

    public SharedGedcom getSharedGedcom() {
        return this.sharedGedcom;
    }

    public AncestrisFriend getFriend() {
        return this.ancestrisFriend;
    }

    public void addEntity(Entity entity, FriendGedcomEntity friendGedcomEntity, int matchResult) {
        if (entity instanceof Indi) {
            this.matchedIndis.add(new MatchData(entity, friendGedcomEntity, matchResult));
            return;
        }
        if (entity instanceof Fam) {
            this.matchedFams.add(new MatchData(entity, friendGedcomEntity, matchResult));
            return;
        }
    }

    public void updateStats() {
        int nbCommonIndis = this.countIds(this.matchedIndis);
        int nbCommonFams = this.countIds(this.matchedFams);
        this.jButton1.setText("" + nbCommonIndis);
        this.jButton2.setText("" + nbCommonFams);
        this.jButton1.setEnabled(nbCommonIndis != 0);
        this.jButton2.setEnabled(nbCommonFams != 0);
    }

    private void showList(String type) {
        this.owner.displayResultsPanel(this.sharedGedcom.getGedcom().getName(), this.ancestrisFriend.getFriendName(), type);
    }

    private int countIds(Set<MatchData> matchedEntities) {
        HashSet<String> ret = new HashSet<String>();
        for (MatchData data : matchedEntities) {
            ret.add(data.myEntity.getId());
        }
        return ret.size();
    }
}

