/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.treesharing.panels;

import ancestris.modules.treesharing.TreeSharingTopComponent;
import ancestris.modules.treesharing.communication.AncestrisMember;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import org.openide.util.NbBundle;

public class MembersPopup
extends JPopupMenu
implements TableModelListener {
    private final TreeSharingTopComponent owner;
    private final ImageIcon ALLOWED_ICON = new ImageIcon(this.getClass().getResource("/ancestris/modules/treesharing/resources/allowed.png"));
    private final ImageIcon MEMBER_ICON = new ImageIcon(this.getClass().getResource("/ancestris/modules/treesharing/resources/friend16.png"));
    private MyTableModel model = null;
    private JTable table = null;
    private JScrollPane jscrollpane = null;

    public MembersPopup(TreeSharingTopComponent tstc) {
        this.owner = tstc;
        this.initComponents();
        this.table = new JTable();
        this.setLayout(new BorderLayout());
        this.model = new MyTableModel();
        this.table.setModel(this.model);
        this.table.getModel().addTableModelListener(this);
        this.table.setAutoCreateRowSorter(true);
        this.table.getTableHeader().setToolTipText(NbBundle.getMessage(MembersPopup.class, (String)"TIP_SortHeader"));
        this.table.getTableHeader().setResizingAllowed(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(25);
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        Border headerBorder = UIManager.getBorder("TableHeader.cellBorder");
        JLabel allowedLabel = new JLabel("", this.ALLOWED_ICON, 0);
        allowedLabel.setBorder(headerBorder);
        JLabel nameLabel = new JLabel("", this.MEMBER_ICON, 0);
        nameLabel.setBorder(headerBorder);
        HeaderCellRenderer renderer = new HeaderCellRenderer();
        this.table.getColumnModel().getColumn(0).setHeaderRenderer(renderer);
        this.table.getColumnModel().getColumn(1).setHeaderRenderer(renderer);
        this.table.getColumnModel().getColumn(0).setHeaderValue(allowedLabel);
        this.table.getColumnModel().getColumn(1).setHeaderValue(nameLabel);
        this.table.getColumnModel().getColumn(0).setCellRenderer(new TickCellRenderer());
        this.table.getColumnModel().getColumn(1).setCellRenderer(new NameCellRenderer(this.owner.getPreferredPseudo()));
        this.jscrollpane = new JScrollPane(this.table);
        this.jscrollpane.setBackground(this.table.getBackground());
        this.jscrollpane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.add(this.jscrollpane);
        this.updateTable();
    }

    public void updateTable() {
        if (this.model == null) {
            return;
        }
        this.model.refreshData();
        this.table.setRowSorter(new TableRowSorter<MyTableModel>(this.model));
        this.table.getColumnModel().getColumn(1).setPreferredWidth(this.getMaxWidth());
        Dimension preferredSize = this.table.getPreferredSize();
        preferredSize.height = this.table.getRowHeight() * Math.min(15, this.model.getRowCount() + 1) + 5;
        if (this.model.getRowCount() == 0) {
            preferredSize.height = 20;
        }
        this.table.setPreferredScrollableViewportSize(preferredSize);
        this.jscrollpane.repaint();
    }

    private int getMaxWidth() {
        FontMetrics fm = this.getFontMetrics(this.getFont().deriveFont(1));
        int width = 100;
        int w = 0;
        for (int row = 0; row < this.table.getRowCount(); ++row) {
            w = fm.stringWidth((String)this.model.getValueAt(row, 1)) + 15;
            width = Math.max(width, w);
        }
        return width;
    }

    private void initComponents() {
    }

    public void tableChanged(TableModelEvent e) {
        if (this.model == null || this.model.getRowCount() == 0) {
            return;
        }
        int row = e.getFirstRow();
        int column = e.getColumn();
        if (row >= 0 && row < this.model.getRowCount() && column >= 0 && column < this.model.getColumnCount()) {
            Object data = this.model.getValueAt(row, column);
            if (column == 0) {
                this.model.getAncestrisMember(row).setAllowed((Boolean)data);
                this.owner.rememberMembers();
            }
        }
    }

    class NameCellRenderer
    extends JLabel
    implements TableCellRenderer {
        String myPseudo = "";

        public NameCellRenderer(String myPseudo) {
            this.myPseudo = myPseudo;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Font f = this.getFont();
            String cellText = (String)table.getValueAt(row, column);
            if (cellText != null && cellText.equals(this.myPseudo)) {
                this.setFont(f.deriveFont(1));
            } else {
                this.setFont(f.deriveFont(0));
            }
            this.setText(cellText);
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setOpaque(true);
            return this;
        }
    }

    class TickCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public TickCellRenderer() {
            this.setToolTipText(NbBundle.getMessage(MembersPopup.class, (String)"TIP_Allowed"));
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setSelected(value != null && (Boolean)value != false);
            this.setOpaque(true);
            return this;
        }
    }

    class HeaderCellRenderer
    implements TableCellRenderer {
        HeaderCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return (JComponent)value;
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        List<AncestrisMember> ancestrisMembers = null;
        String[] columnNames = new String[]{"", ""};
        Object[][] data = new Object[0][2];

        private MyTableModel() {
            this.ancestrisMembers = MembersPopup.this.owner.getAncestrisMembers();
            this.refreshData();
        }

        public void refreshData() {
            this.ancestrisMembers = MembersPopup.this.owner.getAncestrisMembers();
            this.data = new Object[this.ancestrisMembers.size()][2];
            int i = 0;
            for (AncestrisMember member : this.ancestrisMembers) {
                this.data[i][0] = member.isAllowed();
                this.data[i][1] = member.getMemberName();
                ++i;
            }
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            if (this.data.length == 0) {
                return col == 0 ? new Boolean(false) : new String("");
            }
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }

        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }

        public AncestrisMember getAncestrisMember(int row) {
            for (AncestrisMember member : MembersPopup.this.owner.getAncestrisMembers()) {
                String name = (String)this.getValueAt(row, 1);
                if (!member.getMemberName().equals(name)) continue;
                return member;
            }
            return null;
        }
    }
}

