/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.treesharing.panels;

import ancestris.modules.treesharing.TreeSharingTopComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import org.openide.util.NbBundle;

public class PrivacyToggle
extends JToggleButton {
    private final TreeSharingTopComponent owner;
    private final ImageIcon PRIVACY_ON = new ImageIcon(this.getClass().getResource("/ancestris/modules/treesharing/resources/privacyOn.png"));
    private final ImageIcon PRIVACY_OFF = new ImageIcon(this.getClass().getResource("/ancestris/modules/treesharing/resources/privacyOff.png"));

    public PrivacyToggle(TreeSharingTopComponent tstc, boolean preferredPrivacy) {
        this.owner = tstc;
        this.initComponents();
        this.setPrivacy(preferredPrivacy);
    }

    private void initComponents() {
        this.setSelected(true);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PrivacyToggle.this.formActionPerformed(evt);
            }
        });
    }

    private void formActionPerformed(ActionEvent evt) {
        this.setPrivacy(this.isSelected());
    }

    public final void setPrivacy(boolean privacy) {
        this.setSelected(privacy);
        if (this.isSelected()) {
            this.setIcon(this.PRIVACY_ON);
            this.setToolTipText(NbBundle.getMessage(PrivacyToggle.class, (String)"TIP_PrivacyOn"));
        } else {
            this.setIcon(this.PRIVACY_OFF);
            this.setToolTipText(NbBundle.getMessage(PrivacyToggle.class, (String)"TIP_PrivacyOff"));
        }
        this.owner.dispatchPrivacy(privacy);
    }
}

