/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.treesharing.panels;

import ancestris.modules.treesharing.communication.MemberProfile;
import ancestris.modules.treesharing.options.TreeSharingOptionsPanel;
import ancestris.modules.treesharing.panels.TechInfoPanel;
import ancestris.util.swing.DialogManager;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class ProfilePanel
extends JPanel {
    private static final ImageIcon nophoto = new ImageIcon(ImageUtilities.loadImage((String)"ancestris/modules/treesharing/resources/nophotobig.png"));
    private MemberProfile memberProfile;
    private MemberProfile myProfile;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel8;
    private JPanel jPanel1;

    public ProfilePanel(MemberProfile mp, MemberProfile myP) {
        this.memberProfile = mp;
        this.myProfile = myP;
        this.initComponents();
        this.jLabel1.setText(this.getDescription(mp));
        ImageIcon icon = TreeSharingOptionsPanel.getPhoto(3, mp.photoBytes);
        if (icon != null) {
            this.jLabel8.setIcon(icon);
        } else {
            this.jLabel8.setIcon(nophoto);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel8.setHorizontalAlignment(0);
        this.jLabel8.setBorder(null);
        this.jLabel8.setIconTextGap(0);
        this.jLabel8.setPreferredSize(new Dimension(155, 186));
        this.jLabel8.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ProfilePanel.this.jLabel8MouseClicked(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.jLabel8.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProfilePanel.class, (String)"ProfilePanel.jLabel8.AccessibleContext.accessibleDescription"));
        this.jLabel1.setFont(new Font("DejaVu Sans", 1, 12));
        this.jLabel1.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ProfilePanel.class, (String)"ProfilePanel.jLabel1.text"));
        this.jLabel1.setVerticalAlignment(1);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/treesharing/resources/email.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(ProfilePanel.class, (String)"ProfilePanel.jButton1.text"));
        this.jButton1.setToolTipText(NbBundle.getMessage(ProfilePanel.class, (String)"ProfilePanel.jButton1.toolTipText", (Object)(this.memberProfile != null ? this.memberProfile.firstname + " " + this.memberProfile.lastname : "")));
        this.jButton1.setIconTextGap(0);
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProfilePanel.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jButton1, -2, 42, -2).addComponent(this.jLabel1, -1, 270, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(32, 32, 32).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jButton1, -2, 37, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGap(2, 2, 2))).addGap(16, 16, 16)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.sendMail(this.memberProfile.email);
    }

    private void jLabel8MouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && evt.getClickCount() == 2 && evt.isAltDown() && evt.isAltGraphDown()) {
            this.displayTecInfo();
        }
    }

    private void sendMail(String to) {
        String uriStr = String.format("mailto:%s?subject=%s&body=%s", to, ProfilePanel.urlEncode(NbBundle.getMessage(ProfilePanel.class, (String)"MailSubject")), ProfilePanel.urlEncode(NbBundle.getMessage(ProfilePanel.class, (String)"MailContent", (Object)this.memberProfile.firstname, (Object)(this.myProfile.firstname + " " + this.myProfile.lastname))));
        try {
            Desktop.getDesktop().browse(new URI(uriStr));
        }
        catch (IOException iOException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    private static final String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String getDescription(MemberProfile mp) {
        String str = "<html><center><font size=14px>" + mp.firstname + " " + mp.lastname + "<br><br>" + mp.city + ", " + mp.country + "<br><br>" + mp.email + "</font></center></html>";
        return str;
    }

    private String getTechInfo(MemberProfile mp) {
        String str = "<html><center><font size=14px>" + mp.username + "<br>" + mp.userdir + "<br><br>" + mp.osname + "<br>" + mp.osversion + "<br>" + mp.ipaddress + "<br><br>" + "</font></center></html>";
        return str;
    }

    private void displayTecInfo() {
        TechInfoPanel tip = new TechInfoPanel(this.memberProfile);
        DialogManager.create((String)"Information technique", (JComponent)tip).setMessageType(-1).setOptionType(10).show();
    }
}

