/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.treesharing.panels;

import ancestris.gedcom.privacy.standard.PrivacyPolicyImpl;
import ancestris.modules.treesharing.TreeSharingTopComponent;
import ancestris.modules.treesharing.communication.EntityConversion;
import ancestris.modules.treesharing.communication.GedcomFam;
import ancestris.modules.treesharing.communication.GedcomIndi;
import ancestris.modules.treesharing.panels.FriendGedcomEntity;
import ancestris.modules.treesharing.panels.GedcomDescriptionPanel;
import ancestris.modules.treesharing.panels.GedcomFriendMatch;
import ancestris.modules.treesharing.panels.MatchData;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.GedcomListenerAdapter;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.Timer;
import javax.swing.border.SoftBevelBorder;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedGedcom
extends JInternalFrame {
    private final TreeSharingTopComponent owner;
    private final Gedcom gedcom;
    private final PrivacyPolicyImpl ppi;
    private Popup popup;
    private int nbTotalIndis = 0;
    private int nbTotalFams;
    private int nbPublicIndis;
    private int nbPublicFams;
    private int nbCommonIndis;
    private int nbCommonFams;
    private Set<MatchData> matchedIndis = null;
    private Set<MatchData> matchedFams = null;
    private boolean busyGedcom = false;
    private JButton jButton1;
    private JButton jButton2;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private final Callback callback = new Callback();

    public SharedGedcom(TreeSharingTopComponent tstc, Gedcom gedcom, boolean respectPrivacy) {
        super(gedcom.getName());
        this.owner = tstc;
        this.gedcom = gedcom;
        this.matchedIndis = new HashSet<MatchData>();
        this.matchedFams = new HashSet<MatchData>();
        this.ppi = new PrivacyPolicyImpl();
        this.popup = null;
        this.busyGedcom = true;
        this.initComponents();
        this.setShared(false);
        this.setPrivacy(respectPrivacy);
        this.updateStats(true);
        gedcom.addGedcomListener((GedcomListener)this.callback);
        this.busyGedcom = false;
    }

    public void close() {
        this.gedcom.removeGedcomListener((GedcomListener)this.callback);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jButton1 = new JButton();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jButton2 = new JButton();
        this.jCheckBox1 = new JCheckBox();
        this.jCheckBox2 = new JCheckBox();
        this.jLabel10 = new JLabel();
        this.setBorder(new SoftBevelBorder(0));
        this.setIconifiable(true);
        this.setToolTipText(NbBundle.getMessage(SharedGedcom.class, (String)"SharedGedcom.toolTipText"));
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/treesharing/resources/tree.png")));
        this.setPreferredSize(new Dimension(340, 130));
        this.setRequestFocusEnabled(false);
        this.setVisible(true);
        this.jLabel1.setFont(new Font("DejaVu Sans", 0, 11));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/treesharing/resources/Indi.png")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SharedGedcom.class, (String)"SharedGedcom.jLabel1.text"));
        this.jLabel1.setToolTipText(NbBundle.getMessage(SharedGedcom.class, (String)"SharedGedcom.jLabel1.toolTipText"));
        this.jLabel1.setPreferredSize(new Dimension(50, 14));
        this.jLabel2.setFont(new Font("DejaVu Sans", 0, 11));
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/treesharing/resources/Fam.png")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SharedGedcom.class, (String)"SharedGedcom.jLabel2.text"));
        this.jLabel2.setToolTipText(NbBundle.getMessage(SharedGedcom.class, (String)"SharedGedcom.jLabel2.toolTipText"));
        this.jLabel2.setPreferredSize(new Dimension(50, 14));
        this.jLabel3.setFont(new Font("DejaVu Sans", 0, 11));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SharedGedcom.class, (String)"SharedGedcom.jLabel3.text"));
        this.jLabel4.setFont(new Font("DejaVu Sans", 0, 11));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(SharedGedcom.class, (String)"SharedGedcom.jLabel4.text"));
        this.jLabel5.setFont(new Font("DejaVu Sans", 0, 11));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(SharedGedcom.class, (String)"SharedGedcom.jLabel5.text"));
        this.jLabel6.setFont(new Font("DejaVu Sans", 0, 11));
        this.jLabel6.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(SharedGedcom.class, (String)"SharedGedcom.jLabel6.text"));
        this.jLabel6.setPreferredSize(new Dimension(50, 14));
        this.jLabel7.setFont(new Font("DejaVu Sans", 0, 11));
        this.jLabel7.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(SharedGedcom.class, (String)"SharedGedcom.jLabel7.text"));
        this.jLabel7.setPreferredSize(new Dimension(50, 14));
        this.jButton1.setFont(new Font("DejaVu Sans", 0, 11));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(SharedGedcom.class, (String)"SharedGedcom.jButton1.text"));
        this.jButton1.setPreferredSize(new Dimension(50, 20));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharedGedcom.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel8.setFont(new Font("DejaVu Sans", 0, 11));
        this.jLabel8.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(SharedGedcom.class, (String)"SharedGedcom.jLabel8.text"));
        this.jLabel8.setPreferredSize(new Dimension(50, 14));
        this.jLabel9.setFont(new Font("DejaVu Sans", 0, 11));
        this.jLabel9.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(SharedGedcom.class, (String)"SharedGedcom.jLabel9.text"));
        this.jLabel9.setPreferredSize(new Dimension(50, 14));
        this.jButton2.setFont(new Font("DejaVu Sans", 0, 11));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getMessage(SharedGedcom.class, (String)"SharedGedcom.jButton2.text"));
        this.jButton2.setPreferredSize(new Dimension(50, 20));
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharedGedcom.this.jButton2ActionPerformed(evt);
            }
        });
        this.jCheckBox1.setFont(new Font("DejaVu Sans", 0, 11));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox1, (String)NbBundle.getMessage(SharedGedcom.class, (String)"SharedGedcom.jCheckBox1.text"));
        this.jCheckBox1.setHorizontalAlignment(4);
        this.jCheckBox1.setHorizontalTextPosition(10);
        this.jCheckBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharedGedcom.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jCheckBox2.setFont(new Font("DejaVu Sans", 0, 11));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox2, (String)NbBundle.getMessage(SharedGedcom.class, (String)"SharedGedcom.jCheckBox2.text"));
        this.jCheckBox2.setHorizontalAlignment(4);
        this.jCheckBox2.setHorizontalTextPosition(10);
        this.jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharedGedcom.this.jCheckBox2ActionPerformed(evt);
            }
        });
        this.jLabel10.setHorizontalAlignment(0);
        this.jLabel10.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/treesharing/resources/Title.png")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(SharedGedcom.class, (String)"SharedGedcom.jLabel10.text"));
        this.jLabel10.setToolTipText(NbBundle.getMessage(SharedGedcom.class, (String)"SharedGedcom.jLabel10.toolTipText"));
        this.jLabel10.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel10.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SharedGedcom.this.jLabel10MouseClicked(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.jLabel3).addComponent(this.jLabel10, -2, 32, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton1, -1, 58, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel6, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel7, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton2, -1, 58, Short.MAX_VALUE).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel8, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel9, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jCheckBox1, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBox2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -2, -1, -2).addComponent(this.jLabel10, -2, 14, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1, -2, -1, -2).addComponent(this.jCheckBox1))).addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jLabel6, -2, -1, -2).addComponent(this.jLabel8, -2, -1, -2).addComponent(this.jCheckBox2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jLabel7, -2, -1, -2).addComponent(this.jLabel9, -2, -1, -2)).addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jButton1, -2, -1, -2).addComponent(this.jButton2, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.updateStats(true);
    }

    private void jCheckBox2ActionPerformed(ActionEvent evt) {
        this.updateStats(true);
    }

    private void jLabel10MouseClicked(MouseEvent evt) {
        Property note;
        Entity entity = this.gedcom.getFirstEntity("HEAD");
        String str = "";
        if (entity != null && (note = entity.getProperty("NOTE")) != null) {
            str = note.getValue();
        }
        GedcomDescriptionPanel descPanel = new GedcomDescriptionPanel(this, this.gedcom.getName(), this.gedcom.getOrigin().getFile().getAbsolutePath().replace(" ", "&nbsp;"), str);
        if (this.popup == null) {
            int x = evt.getXOnScreen();
            int y = evt.getYOnScreen();
            this.popup = PopupFactory.getSharedInstance().getPopup(this, descPanel, x, y);
            this.popup.show();
        } else {
            this.popup.hide();
            this.popup = null;
        }
    }

    public void closeDescription() {
        if (this.popup != null) {
            this.jLabel10MouseClicked(null);
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.showList("INDI");
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.showList("FAM");
    }

    public Gedcom getGedcom() {
        return this.gedcom;
    }

    public int getNbOfPublicIndis() {
        return this.isShared() ? (this.isPrivacySet() ? this.nbPublicIndis : this.nbTotalIndis) : 0;
    }

    public int getNbOfPublicFams() {
        return this.isShared() ? (this.isPrivacySet() ? this.nbPublicFams : this.nbTotalFams) : 0;
    }

    public void updateStats(boolean recalculate) {
        if (recalculate || this.nbTotalIndis == 0) {
            this.nbTotalIndis = this.gedcom.getEntities("INDI").size();
            this.nbTotalFams = this.gedcom.getEntities("FAM").size();
            this.nbPublicIndis = this.getNbPublicEntities("INDI");
            this.nbPublicFams = this.getNbPublicEntities("FAM");
        }
        this.nbCommonIndis = this.countIds(this.matchedIndis);
        this.nbCommonFams = this.countIds(this.matchedFams);
        this.jLabel6.setText("" + this.nbTotalIndis);
        this.jLabel8.setText("" + this.nbTotalFams);
        this.jLabel7.setText(this.isShared() ? (this.isPrivacySet() ? "" + this.nbPublicIndis : "" + this.nbTotalIndis) : "0");
        this.jLabel9.setText(this.isShared() ? (this.isPrivacySet() ? "" + this.nbPublicFams : "" + this.nbTotalFams) : "0");
        this.jButton1.setText("" + this.nbCommonIndis);
        this.jButton2.setText("" + this.nbCommonFams);
        this.jButton1.setEnabled(this.nbCommonIndis != 0);
        this.jButton2.setEnabled(this.nbCommonFams != 0);
        this.owner.updateIcon();
    }

    public final void setShared(boolean shared) {
        this.jCheckBox1.setSelected(shared);
        this.updateStats(true);
    }

    public final boolean isShared() {
        return this.jCheckBox1.isSelected();
    }

    public final void setPrivacy(boolean privacy) {
        this.jCheckBox2.setSelected(privacy);
        this.updateStats(true);
    }

    private final boolean isPrivacySet() {
        return this.jCheckBox2.isSelected();
    }

    public final void resetResults() {
        this.matchedIndis.clear();
        this.matchedFams.clear();
        this.updateStats(true);
    }

    public List<Entity> getPublicEntities(String tag) {
        this.ppi.clear();
        LinkedList<Entity> ret = new LinkedList<Entity>();
        Collection entities = this.gedcom.getEntities(tag);
        for (Entity entity : entities) {
            if (this.isPrivacySet() && this.ppi.isPrivate((Property)entity)) continue;
            ret.add(entity);
        }
        return ret;
    }

    public Set<String> getPublicIndiLastnames() {
        if (!this.isShared()) {
            return new HashSet<String>();
        }
        HashSet<String> ret = new HashSet<String>();
        List<Entity> entities = this.getPublicEntities("INDI");
        for (Entity entity : entities) {
            String str;
            Indi indi = (Indi)entity;
            if (indi == null || indi.getLastName() == null || (str = indi.getLastName().replace("?", "").trim()).isEmpty()) continue;
            ret.add(str);
        }
        return ret;
    }

    public Set<String> getPublicFamLastnames() {
        if (!this.isShared()) {
            return new HashSet<String>();
        }
        HashSet<String> ret = new HashSet<String>();
        List<Entity> entities = this.getPublicEntities("FAM");
        for (Entity entity : entities) {
            Fam fam = (Fam)entity;
            String str = this.getLastName(fam);
            if (str.equals("/")) continue;
            ret.add(str);
        }
        return ret;
    }

    public List<GedcomIndi> getPublicGedcomIndis(Set<String> commonIndiLastnames) {
        if (!this.isShared() || commonIndiLastnames == null) {
            return new ArrayList<GedcomIndi>();
        }
        ArrayList<GedcomIndi> ret = new ArrayList<GedcomIndi>();
        List<Entity> entities = this.getPublicEntities("INDI");
        for (Entity entity : entities) {
            String str;
            Indi indi = (Indi)entity;
            if (indi == null || (str = indi.getLastName()) == null || commonIndiLastnames == null || !commonIndiLastnames.contains(str.trim())) continue;
            GedcomIndi gedcomIndi = EntityConversion.indiToGedcomIndi(indi);
            ret.add(gedcomIndi);
        }
        return ret;
    }

    public List<GedcomFam> getPublicGedcomFams(Set<String> commonFamLastnames) {
        if (!this.isShared()) {
            return new ArrayList<GedcomFam>();
        }
        ArrayList<GedcomFam> ret = new ArrayList<GedcomFam>();
        List<Entity> entities = this.getPublicEntities("FAM");
        for (Entity entity : entities) {
            Fam fam = (Fam)entity;
            if (commonFamLastnames == null || !commonFamLastnames.contains(this.getLastName(fam))) continue;
            GedcomFam gedcomFam = EntityConversion.famToGedcomFam(fam);
            ret.add(gedcomFam);
        }
        return ret;
    }

    private String getLastName(Fam fam) {
        String strHusb = "";
        String strWife = "";
        if (fam != null) {
            if (fam.getHusband() != null) {
                String string = strHusb = fam.getHusband().getLastName() != null ? fam.getHusband().getLastName().replace("?", "").trim() : "";
            }
            if (fam.getWife() != null) {
                strWife = fam.getWife().getLastName() != null ? fam.getWife().getLastName().replace("?", "").trim() : "";
            }
        }
        return strHusb + "/" + strWife;
    }

    private int getNbPublicEntities(String tag) {
        if (this.gedcom == null || this.gedcom.getName() == null) {
            return 0;
        }
        this.ppi.clear();
        int ret = 0;
        Collection entities = this.gedcom.getEntities(tag);
        for (Entity entity : entities) {
            ret += this.ppi.isPrivate((Property)entity) ? 0 : 1;
        }
        return ret;
    }

    public void addEntity(Entity entity, FriendGedcomEntity friendGedcomEntity, int matchResult) {
        if (entity instanceof Indi) {
            this.matchedIndis.add(new MatchData(entity, friendGedcomEntity, matchResult));
            return;
        }
        if (entity instanceof Fam) {
            this.matchedFams.add(new MatchData(entity, friendGedcomEntity, matchResult));
        }
    }

    private void updateMe() {
        if (this.busyGedcom) {
            return;
        }
        this.busyGedcom = true;
        Timer timer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((Timer)e.getSource()).stop();
                WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                    public void run() {
                        SharedGedcom.this.updateStats(true);
                        SharedGedcom.this.busyGedcom = false;
                    }
                });
            }
        });
        timer.start();
    }

    private void showList(String type) {
        this.owner.displayResultsPanel(this.getGedcom().getName(), NbBundle.getMessage(GedcomFriendMatch.class, (String)"TITL_AllFriends"), type);
    }

    private int countIds(Set<MatchData> matchedEntities) {
        HashSet<String> ret = new HashSet<String>();
        for (MatchData data : matchedEntities) {
            ret.add(data.myEntity.getId());
        }
        return ret.size();
    }

    private class Callback
    extends GedcomListenerAdapter {
        private Callback() {
        }

        public void gedcomWriteLockReleased(Gedcom gedcom) {
            SharedGedcom.this.updateMe();
        }
    }
}

