/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.nav;

import ancestris.api.editor.AncestrisEditor;
import ancestris.awt.FilteredMouseAdapter;
import ancestris.core.actions.AncestrisActionProvider;
import ancestris.gedcom.PropertyNode;
import ancestris.modules.beans.ABluePrintBeans;
import ancestris.modules.beans.AListBean;
import ancestris.view.ExplorerHelper;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.GedcomListenerAdapter;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyEvent;
import genj.renderer.Blueprint;
import genj.renderer.BlueprintManager;
import genj.renderer.ChooseBlueprintAction;
import genj.util.Registry;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FamilyPanel
extends JPanel
implements AncestrisActionProvider {
    private static final Registry REGISTRY = Registry.get(FamilyPanel.class);
    private final Callback callback = new Callback();
    private static final String BEG_EMPTY = "<p align=center>";
    private static final String END_EMPTY = "</p>";
    private static final String HUSBAND_EMPTY_BP = "<p align=center>" + NbBundle.getMessage(FamilyPanel.class, (String)"blueprint.husband.empty") + "</p>";
    private static final String WIFE_EMPTY_BP = "<p align=center>" + NbBundle.getMessage(FamilyPanel.class, (String)"blueprint.wife.empty") + "</p>";
    private static final String FATHER_EMPTY_BP = "<p align=center>" + NbBundle.getMessage(FamilyPanel.class, (String)"blueprint.father.empty") + "</p>";
    private static final String MOTHER_EMPTY_BP = "<p align=center>" + NbBundle.getMessage(FamilyPanel.class, (String)"blueprint.mother.empty") + "</p>";
    private static final String FAMS_EMPTY_BP = "<p align=center>" + NbBundle.getMessage(FamilyPanel.class, (String)"blueprint.fams.empty") + "</p>";
    private static final String HUSBAND_BP = "navindi";
    private static final String WIFE_BP = "navspouse";
    private static final String PARENT_BP = "navparent";
    private static final String INDILINE_BP = "navindiline";
    private static final String EVENT_BP = "navevent";
    private static final String FAMI_BP = "navfamindi";
    private static final String FAMP_BP = "navfamparent";
    private static final String FAMLINE_BP = "navfamline";
    private final String TT_START = "<html>&bull;&nbsp;";
    private final String TT_BR = "<br>&bull;&nbsp;";
    private final String TT_END = "</html>";
    private final String TT_CLICKSEL = NbBundle.getMessage(FamilyPanel.class, (String)"TootlTipTextClickSel");
    private final String TT_CLICKSWITCH = NbBundle.getMessage(FamilyPanel.class, (String)"TootlTipTextClickSwitch");
    private final String TT_DCLICKEDTSEL = NbBundle.getMessage(FamilyPanel.class, (String)"TootlTipTextDClickEdtSel");
    private final String TT_DCLICKEDT = NbBundle.getMessage(FamilyPanel.class, (String)"TootlTipTextDClickEdt");
    private final String TT_DCLICKCRE = NbBundle.getMessage(FamilyPanel.class, (String)"TootlTipTextDClickCre");
    private final String TT_RCLICKMENU = NbBundle.getMessage(FamilyPanel.class, (String)"TootlTipTextRClickMenu");
    private static final String[] NAV_TAGS = new String[]{"navindi", "navspouse", "navparent", "navindiline", "navevent", "navfamindi", "navfamparent", "navfamline"};
    private Context context;
    private boolean sticky = false;
    private Component selectedPanel = null;
    private Indi focusIndi;
    private Fam focusFam;
    private EntitiesPanel oFamsPanel = null;
    private int famIndex = 0;
    private EntitiesPanel childrenPanel = null;
    private EntitiesPanel siblingsPanel = null;
    private EntitiesPanel eventsPanel = null;
    private final Map<String, String> tag2blueprint = new HashMap<String, String>();
    private JPanel eventsTab;
    private JPanel famParentPanel;
    private JPanel famSpousePanel;
    private ABluePrintBeans familyParent;
    private ABluePrintBeans familySpouse;
    private JPanel fatherPanel;
    private ABluePrintBeans husbFather;
    private ABluePrintBeans husbMother;
    private ABluePrintBeans husband;
    private JPanel indiPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTabbedPane jTabbedPane1;
    private JScrollPane jsEvents;
    private JPanel motherPanel;
    private JPanel otherSpousePanel;
    private JPanel spousePanel;
    private ABluePrintBeans wife;

    public FamilyPanel() {
        this.initComponents();
        this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(16);
        this.jScrollPane2.getVerticalScrollBar().setUnitIncrement(16);
        this.jScrollPane3.getVerticalScrollBar().setUnitIncrement(16);
    }

    public void init(Gedcom gedcom) {
        for (String tag : NAV_TAGS) {
            this.tag2blueprint.put(tag, REGISTRY.get("blueprint." + tag, tag));
        }
        this.enableBlueprint(this.husband, new ABeanHandler(), HUSBAND_EMPTY_BP);
        this.enableBlueprint(this.wife, new SpouseHandler(this.husband), WIFE_EMPTY_BP);
        this.enableBlueprint(this.husbFather, new ParentHandler(this.husband, 1), FATHER_EMPTY_BP);
        this.enableBlueprint(this.husbMother, new ParentHandler(this.husband, 2), MOTHER_EMPTY_BP);
        this.enableBlueprint(this.familySpouse, new ABeanHandler(), FAMS_EMPTY_BP);
        this.enableBlueprint(this.familyParent, new ABeanHandler(), FAMS_EMPTY_BP);
        this.childrenPanel = new EntitiesPanel(this.jScrollPane1){

            public Entity[] getEntities(Property rootProperty) {
                if (rootProperty != null && rootProperty instanceof Fam) {
                    return ((Fam)rootProperty).getChildren();
                }
                return null;
            }
        };
        this.oFamsPanel = new EntitiesPanel(this.jScrollPane2){

            public Entity[] getEntities(Property rootProperty) {
                if (rootProperty != null && rootProperty instanceof Indi) {
                    return ((Indi)rootProperty).getFamiliesWhereSpouse();
                }
                return null;
            }
        };
        this.siblingsPanel = new EntitiesPanel(this.jScrollPane3){

            public Entity[] getEntities(Property rootProperty) {
                if (rootProperty != null && rootProperty instanceof Indi) {
                    return ((Indi)rootProperty).getSiblings(false);
                }
                return null;
            }
        };
        this.eventsPanel = new EntitiesPanel(this.jsEvents){

            public Property[] getEntities(Property rootProperty) {
                if (rootProperty != null && rootProperty instanceof Indi) {
                    ArrayList<Property> result = new ArrayList<Property>(5);
                    for (Property p : rootProperty.getProperties()) {
                        if (!(p instanceof PropertyEvent)) continue;
                        result.add(p);
                    }
                    return result.toArray(new Property[0]);
                }
                return null;
            }
        };
        this.resetBlueprints();
        gedcom.addGedcomListener((GedcomListener)this.callback);
    }

    public void close(Gedcom gedcom) {
        gedcom.removeGedcomListener((GedcomListener)this.callback);
    }

    private void enableBlueprint(ABluePrintBeans bp, ABeanHandler bh, String defaultBP) {
        bp.addMouseListener((MouseListener)((Object)bh));
        bp.setEmptyBluePrint(defaultBP);
        bp.setAntialiasing(true);
        new ExplorerHelper((Component)bp).setPopupAllowed(true);
    }

    private void setPanel(EntitiesPanel panel) {
        for (Component c : panel.getComponents()) {
            if (!(c instanceof ABluePrintBeans)) continue;
            ABluePrintBeans bean = (ABluePrintBeans)c;
            bean.addMouseListener((MouseListener)((Object)new ABeanHandler()));
            this.setDynamicToolTipText(bean, true, false);
            new ExplorerHelper((Component)bean).setPopupAllowed(true);
        }
    }

    public void resetBlueprints() {
        this.husband.setBlueprint("INDI", this.getBlueprint("INDI", HUSBAND_BP).getHTML());
        this.wife.setBlueprint("INDI", this.getBlueprint("INDI", WIFE_BP).getHTML());
        this.husbFather.setBlueprint("INDI", this.getBlueprint("INDI", PARENT_BP).getHTML());
        this.husbMother.setBlueprint("INDI", this.getBlueprint("INDI", PARENT_BP).getHTML());
        this.familySpouse.setBlueprint("FAM", this.getBlueprint("FAM", FAMI_BP).getHTML());
        this.familyParent.setBlueprint("FAM", this.getBlueprint("FAM", FAMP_BP).getHTML());
        this.oFamsPanel.setBlueprint("FAM", this.getBlueprint("FAM", FAMLINE_BP).getHTML());
        this.childrenPanel.setBlueprint("INDI", this.getBlueprint("INDI", INDILINE_BP).getHTML());
        this.siblingsPanel.setBlueprint("INDI", this.getBlueprint("INDI", INDILINE_BP).getHTML());
        this.eventsPanel.setBlueprint("", this.getBlueprint("INDI", EVENT_BP).getHTML());
        this.refresh();
    }

    private Blueprint getBlueprint(String entityTag, String BPtag) {
        return BlueprintManager.getInstance().getBlueprint(entityTag, this.tag2blueprint.get(BPtag));
    }

    public void setContext(Context context) {
        if (this.sticky) {
            return;
        }
        if (context == null || context.getGedcom() == null) {
            return;
        }
        if (this.context != null && !context.getGedcom().equals(this.context.getGedcom())) {
            return;
        }
        Entity entity = context.getEntity();
        if (entity == null) {
            return;
        }
        this.context = context;
        if (entity instanceof Fam) {
            Fam family = (Fam)entity;
            if (family.getNoOfSpouses() == 0) {
                this.refresh();
                return;
            }
            if (family.equals(this.focusFam)) {
                this.refresh();
                return;
            }
            this.focusFam = (Fam)entity;
            this.focusIndi = this.focusFam.getHusband();
            if (this.focusIndi == null) {
                this.focusIndi = this.focusFam.getWife();
            }
            int i = 0;
            this.famIndex = 0;
            for (Fam fam : this.focusIndi.getFamiliesWhereSpouse()) {
                if (fam.equals(this.focusFam)) {
                    this.famIndex = i;
                    break;
                }
                ++i;
            }
        } else if (entity instanceof Indi) {
            if (((Indi)entity).equals(this.focusIndi)) {
                this.refresh();
                return;
            }
            this.focusIndi = (Indi)entity;
            this.focusFam = null;
        } else {
            this.refresh();
            return;
        }
        this.refresh();
    }

    private void refresh() {
        if (this.focusIndi == null) {
            return;
        }
        if (this.focusIndi != null && this.focusIndi.getFamiliesWhereSpouse().length > 0 && this.focusIndi.getNoOfFams() > this.famIndex) {
            this.focusFam = this.focusIndi.getFamiliesWhereSpouse()[this.famIndex];
        }
        this.husband.setContext((Property)this.focusIndi);
        this.setDynamicToolTipText(this.husband, false, true);
        this.husbFather.setContext((Property)this.focusIndi.getBiologicalFather());
        this.setDynamicToolTipText(this.husbFather, false, false);
        this.husbMother.setContext((Property)this.focusIndi.getBiologicalMother());
        this.setDynamicToolTipText(this.husbMother, false, false);
        this.familySpouse.setContext((Property)this.focusFam);
        this.setDynamicToolTipText(this.familySpouse, true, false);
        if (this.focusFam == null) {
            this.wife.setContext(null);
        } else {
            this.wife.setContext((Property)this.focusFam.getOtherSpouse(this.focusIndi));
        }
        this.setDynamicToolTipText(this.wife, false, false);
        this.oFamsPanel.update(this.husband.getProperty(), (Property)(this.focusFam != null ? this.focusFam : null));
        this.oFamsPanel.setEnabled(((Indi)this.husband.getProperty()).getNoOfFams() > 0);
        this.childrenPanel.update((Property)(this.familySpouse.getProperty() == null ? null : (Fam)this.familySpouse.getProperty().getEntity()), null);
        this.siblingsPanel.update(this.husband.getProperty(), null);
        Fam famChild = ((Indi)this.husband.getProperty()).getFamilyWhereBiologicalChild();
        this.familyParent.setContext((Property)famChild);
        this.setDynamicToolTipText(this.familyParent, true, false);
        this.eventsPanel.update(this.husband.getProperty(), null);
        this.setPanel(this.oFamsPanel);
        this.setPanel(this.childrenPanel);
        this.setPanel(this.siblingsPanel);
        this.setPanel(this.eventsPanel);
    }

    private void setDynamicToolTipText(ABluePrintBeans bean, boolean nullIfEmpty, boolean isMain) {
        boolean isoFamsPanel;
        boolean isEmpty;
        boolean bl = isEmpty = bean.getProperty() == null;
        if (isEmpty && nullIfEmpty) {
            bean.setToolTipText(null);
            return;
        }
        String tooltip = "<html>&bull;&nbsp;";
        boolean bl2 = isoFamsPanel = bean.getParent() != null && bean.getParent().equals((Object)this.oFamsPanel);
        tooltip = isMain ? tooltip + this.TT_CLICKSEL + "<br>&bull;&nbsp;" + this.TT_DCLICKEDTSEL + "<br>&bull;&nbsp;" + this.TT_RCLICKMENU : (!nullIfEmpty && isEmpty ? tooltip + this.TT_DCLICKCRE : (isoFamsPanel ? tooltip + this.TT_CLICKSWITCH + "<br>&bull;&nbsp;" + this.TT_DCLICKEDT + "<br>&bull;&nbsp;" + this.TT_RCLICKMENU : tooltip + this.TT_CLICKSEL + "<br>&bull;&nbsp;" + this.TT_DCLICKEDT + "<br>&bull;&nbsp;" + this.TT_RCLICKMENU));
        tooltip = tooltip + "</html>";
        bean.setToolTipText(tooltip);
    }

    public List<Action> getActions(boolean hasFocus, Node[] nodes) {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (!hasFocus) {
            return actions;
        }
        String bp = "";
        if (this.selectedPanel == null) {
            return actions;
        }
        if (this.selectedPanel.equals(this.indiPanel)) {
            bp = HUSBAND_BP;
        } else if (this.selectedPanel.equals(this.spousePanel)) {
            bp = WIFE_BP;
        } else if (this.selectedPanel.equals(this.fatherPanel)) {
            bp = PARENT_BP;
        } else if (this.selectedPanel.equals(this.motherPanel)) {
            bp = PARENT_BP;
        } else if (this.selectedPanel.equals((Object)this.oFamsPanel)) {
            bp = FAMLINE_BP;
        } else if (this.selectedPanel.equals(this.famSpousePanel)) {
            bp = FAMI_BP;
        } else if (this.selectedPanel.equals((Object)this.childrenPanel)) {
            bp = INDILINE_BP;
        } else if (this.selectedPanel.equals(this.famParentPanel)) {
            bp = FAMP_BP;
        } else if (this.selectedPanel.equals((Object)this.siblingsPanel)) {
            bp = INDILINE_BP;
        } else if (this.selectedPanel.equals((Object)this.eventsPanel)) {
            bp = EVENT_BP;
        }
        final String blueprintTag = bp;
        Property prop = null;
        if (nodes != null && nodes.length > 0 && nodes[0] instanceof PropertyNode && (prop = ((PropertyNode)nodes[0]).getProperty()) != null) {
            prop = prop.getEntity();
        }
        if (prop != null && prop instanceof Indi) {
            actions.add((Action)new ChooseBlueprintAction((Entity)prop, this.getBlueprint("INDI", blueprintTag)){

                protected void commit(Entity recipient, Blueprint blueprint) {
                    FamilyPanel.this.tag2blueprint.put(blueprintTag, blueprint.getName());
                    FamilyPanel.this.resetBlueprints();
                    REGISTRY.put("blueprint." + blueprintTag, blueprint.getName());
                }
            });
        }
        if (prop != null && prop instanceof Fam) {
            actions.add((Action)new ChooseBlueprintAction((Entity)prop, this.getBlueprint("FAM", blueprintTag)){

                protected void commit(Entity recipient, Blueprint blueprint) {
                    FamilyPanel.this.tag2blueprint.put(blueprintTag, blueprint.getName());
                    FamilyPanel.this.resetBlueprints();
                    REGISTRY.put("blueprint." + blueprintTag, blueprint.getName());
                }
            });
        }
        this.sticky = false;
        return actions;
    }

    private void initComponents() {
        this.fatherPanel = new JPanel();
        this.husbFather = new ABluePrintBeans();
        this.motherPanel = new JPanel();
        this.husbMother = new ABluePrintBeans();
        this.otherSpousePanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.indiPanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.husband = new ABluePrintBeans();
        this.spousePanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.wife = new ABluePrintBeans();
        this.jTabbedPane1 = new JTabbedPane();
        this.famSpousePanel = new JPanel();
        this.familySpouse = new ABluePrintBeans();
        this.jScrollPane1 = new JScrollPane();
        this.famParentPanel = new JPanel();
        this.familyParent = new ABluePrintBeans();
        this.jScrollPane3 = new JScrollPane();
        this.eventsTab = new JPanel();
        this.jsEvents = new JScrollPane();
        this.setPreferredSize(new Dimension(400, 400));
        this.setRequestFocusEnabled(false);
        this.fatherPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(0), NbBundle.getMessage(FamilyPanel.class, (String)"FamilyPanel.fatherPanel.border.title"), 2, 0, new Font("Dialog", 1, 14)));
        this.fatherPanel.setPreferredSize(new Dimension(145, 121));
        this.husbFather.setMinimumSize(new Dimension(0, 80));
        this.husbFather.setPreferredSize(new Dimension(256, 80));
        GroupLayout husbFatherLayout = new GroupLayout((Container)this.husbFather);
        this.husbFather.setLayout((LayoutManager)husbFatherLayout);
        husbFatherLayout.setHorizontalGroup(husbFatherLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        husbFatherLayout.setVerticalGroup(husbFatherLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GroupLayout fatherPanelLayout = new GroupLayout(this.fatherPanel);
        this.fatherPanel.setLayout(fatherPanelLayout);
        fatherPanelLayout.setHorizontalGroup(fatherPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.husbFather, GroupLayout.Alignment.TRAILING, -1, 112, Short.MAX_VALUE));
        fatherPanelLayout.setVerticalGroup(fatherPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.husbFather, GroupLayout.Alignment.TRAILING, -1, 80, Short.MAX_VALUE));
        this.motherPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(0), NbBundle.getMessage(FamilyPanel.class, (String)"FamilyPanel.motherPanel.border.title"), 2, 0, new Font("Dialog", 1, 14)));
        this.motherPanel.setPreferredSize(new Dimension(145, 121));
        this.husbMother.setMinimumSize(new Dimension(0, 80));
        this.husbMother.setPreferredSize(new Dimension(256, 80));
        GroupLayout husbMotherLayout = new GroupLayout((Container)this.husbMother);
        this.husbMother.setLayout((LayoutManager)husbMotherLayout);
        husbMotherLayout.setHorizontalGroup(husbMotherLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        husbMotherLayout.setVerticalGroup(husbMotherLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GroupLayout motherPanelLayout = new GroupLayout(this.motherPanel);
        this.motherPanel.setLayout(motherPanelLayout);
        motherPanelLayout.setHorizontalGroup(motherPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.husbMother, -1, 113, Short.MAX_VALUE));
        motherPanelLayout.setVerticalGroup(motherPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.husbMother, -1, 80, Short.MAX_VALUE));
        this.otherSpousePanel.setPreferredSize(new Dimension(145, 121));
        this.jLabel1.setFont(new Font("DejaVu Sans", 1, 14));
        this.jLabel1.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(FamilyPanel.class, (String)"FamilyPanel.jLabel1.text"));
        this.jScrollPane2.setBorder(BorderFactory.createBevelBorder(0));
        this.jScrollPane2.setViewportBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        GroupLayout otherSpousePanelLayout = new GroupLayout(this.otherSpousePanel);
        this.otherSpousePanel.setLayout(otherSpousePanelLayout);
        otherSpousePanelLayout.setHorizontalGroup(otherSpousePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE));
        otherSpousePanelLayout.setVerticalGroup(otherSpousePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(otherSpousePanelLayout.createSequentialGroup().addComponent(this.jLabel1).addGap(2, 2, 2).addComponent(this.jScrollPane2, -1, 85, Short.MAX_VALUE)));
        this.indiPanel.setBorder(null);
        this.indiPanel.setPreferredSize(new Dimension(256, 150));
        this.jLabel3.setFont(new Font("DejaVu Sans", 1, 14));
        this.jLabel3.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(FamilyPanel.class, (String)"FamilyPanel.jLabel3.text"));
        this.husband.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout husbandLayout = new GroupLayout((Container)this.husband);
        this.husband.setLayout((LayoutManager)husbandLayout);
        husbandLayout.setHorizontalGroup(husbandLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        husbandLayout.setVerticalGroup(husbandLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 71, Short.MAX_VALUE));
        GroupLayout indiPanelLayout = new GroupLayout(this.indiPanel);
        this.indiPanel.setLayout(indiPanelLayout);
        indiPanelLayout.setHorizontalGroup(indiPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.husband, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE));
        indiPanelLayout.setVerticalGroup(indiPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(indiPanelLayout.createSequentialGroup().addComponent(this.jLabel3).addGap(2, 2, 2).addComponent((Component)this.husband, -1, -1, Short.MAX_VALUE)));
        this.spousePanel.setBorder(null);
        this.spousePanel.setPreferredSize(new Dimension(165, 150));
        this.jLabel2.setFont(new Font("DejaVu Sans", 1, 14));
        this.jLabel2.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(FamilyPanel.class, (String)"FamilyPanel.jLabel2.text"));
        this.wife.setBorder(BorderFactory.createEtchedBorder());
        this.wife.setMinimumSize(new Dimension(0, 40));
        this.wife.setPreferredSize(new Dimension(256, 60));
        GroupLayout wifeLayout = new GroupLayout((Container)this.wife);
        this.wife.setLayout((LayoutManager)wifeLayout);
        wifeLayout.setHorizontalGroup(wifeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        wifeLayout.setVerticalGroup(wifeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 71, Short.MAX_VALUE));
        GroupLayout spousePanelLayout = new GroupLayout(this.spousePanel);
        this.spousePanel.setLayout(spousePanelLayout);
        spousePanelLayout.setHorizontalGroup(spousePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.wife, GroupLayout.Alignment.TRAILING, -1, 127, Short.MAX_VALUE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE));
        spousePanelLayout.setVerticalGroup(spousePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spousePanelLayout.createSequentialGroup().addComponent(this.jLabel2).addGap(2, 2, 2).addComponent((Component)this.wife, -1, 75, Short.MAX_VALUE).addGap(0, 0, 0)));
        this.jTabbedPane1.setBorder(null);
        this.jTabbedPane1.setFont(new Font("Dialog", 1, 14));
        this.jTabbedPane1.setPreferredSize(new Dimension(388, 200));
        this.familySpouse.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.familySpouse.setPreferredSize(new Dimension(256, 80));
        GroupLayout familySpouseLayout = new GroupLayout((Container)this.familySpouse);
        this.familySpouse.setLayout((LayoutManager)familySpouseLayout);
        familySpouseLayout.setHorizontalGroup(familySpouseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 373, Short.MAX_VALUE));
        familySpouseLayout.setVerticalGroup(familySpouseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 45, Short.MAX_VALUE));
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        GroupLayout famSpousePanelLayout = new GroupLayout(this.famSpousePanel);
        this.famSpousePanel.setLayout(famSpousePanelLayout);
        famSpousePanelLayout.setHorizontalGroup(famSpousePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 375, Short.MAX_VALUE).addComponent((Component)this.familySpouse, -1, 388, Short.MAX_VALUE));
        famSpousePanelLayout.setVerticalGroup(famSpousePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(famSpousePanelLayout.createSequentialGroup().addComponent((Component)this.familySpouse, -2, 47, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 91, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(NbBundle.getMessage(FamilyPanel.class, (String)"FamilyPanel.famSpousePanel.TabConstraints.tabTitle"), this.famSpousePanel);
        this.familyParent.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.familyParent.setPreferredSize(new Dimension(256, 80));
        GroupLayout familyParentLayout = new GroupLayout((Container)this.familyParent);
        this.familyParent.setLayout((LayoutManager)familyParentLayout);
        familyParentLayout.setHorizontalGroup(familyParentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 373, Short.MAX_VALUE));
        familyParentLayout.setVerticalGroup(familyParentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 45, Short.MAX_VALUE));
        this.jScrollPane3.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        GroupLayout famParentPanelLayout = new GroupLayout(this.famParentPanel);
        this.famParentPanel.setLayout(famParentPanelLayout);
        famParentPanelLayout.setHorizontalGroup(famParentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.familyParent, -1, 388, Short.MAX_VALUE).addComponent(this.jScrollPane3, -1, 375, Short.MAX_VALUE));
        famParentPanelLayout.setVerticalGroup(famParentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(famParentPanelLayout.createSequentialGroup().addComponent((Component)this.familyParent, -2, 47, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 91, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(NbBundle.getMessage(FamilyPanel.class, (String)"FamilyPanel.famParentPanel.TabConstraints.tabTitle"), this.famParentPanel);
        this.eventsTab.setBackground(Color.white);
        this.jsEvents.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jsEvents.setHorizontalScrollBarPolicy(31);
        GroupLayout eventsTabLayout = new GroupLayout(this.eventsTab);
        this.eventsTab.setLayout(eventsTabLayout);
        eventsTabLayout.setHorizontalGroup(eventsTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 375, Short.MAX_VALUE).addGroup(eventsTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jsEvents, -1, 375, Short.MAX_VALUE)));
        eventsTabLayout.setVerticalGroup(eventsTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 144, Short.MAX_VALUE).addGroup(eventsTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jsEvents, GroupLayout.Alignment.TRAILING, -1, 144, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(NbBundle.getMessage(FamilyPanel.class, (String)"FamilyPanel.eventsTab.TabConstraints.tabTitle"), this.eventsTab);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.fatherPanel, -1, 124, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.motherPanel, -1, 125, Short.MAX_VALUE)).addComponent(this.indiPanel, -1, 255, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.otherSpousePanel, -1, 127, Short.MAX_VALUE).addComponent(this.spousePanel, -1, 127, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.motherPanel, -1, 107, Short.MAX_VALUE).addComponent(this.fatherPanel, -1, 107, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(layout.createSequentialGroup().addComponent(this.otherSpousePanel, -1, 104, Short.MAX_VALUE).addGap(9, 9, 9))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.indiPanel, -1, 94, Short.MAX_VALUE).addComponent(this.spousePanel, -1, 94, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1, -1, 175, Short.MAX_VALUE).addContainerGap()));
    }

    public static boolean editEvent(PropertyEvent prop, boolean isNew) {
        return true;
    }

    private abstract class EntitiesPanel
    extends AListBean {
        public EntitiesPanel(JScrollPane pane) {
            this.setBackground(Color.white);
            this.setLayout(new BoxLayout((Container)((Object)this), 3));
            pane.setViewportView((Component)((Object)this));
        }

        public abstract Property[] getEntities(Property var1);

        public void update(Property rootProperty, Property exclude) {
            this.removeAll();
            this.repaint();
            if (rootProperty != null) {
                this.add(this.getEntities(rootProperty), exclude, (MouseListener)((Object)new ABeanHandler()));
            }
            this.revalidate();
        }
    }

    private class ParentHandler
    extends ABeanHandler {
        int sex;
        private final ABluePrintBeans childBean;

        public ParentHandler(ABluePrintBeans indiBean, int sex) {
            this.childBean = indiBean;
            this.sex = sex;
        }

        public ActionListener getCreateAction() {
            AncestrisEditor editor;
            Indi child = null;
            if (this.childBean != null) {
                child = (Indi)this.childBean.getProperty();
            }
            if ((editor = AncestrisEditor.findEditor(child)) == null) {
                editor = AncestrisEditor.findEditor(null);
            }
            return editor.getCreateParentAction(child, this.sex);
        }
    }

    private class SpouseHandler
    extends ABeanHandler {
        private final ABluePrintBeans otherBean;

        public SpouseHandler(ABluePrintBeans other) {
            this.otherBean = other;
        }

        public ActionListener getCreateAction() {
            AncestrisEditor editor;
            Indi indi = null;
            if (this.otherBean != null) {
                indi = (Indi)this.otherBean.getProperty();
            }
            if ((editor = AncestrisEditor.findEditor(indi)) == null) {
                editor = AncestrisEditor.findEditor(null);
            }
            return editor.getCreateSpouseAction(indi);
        }
    }

    private class ABeanHandler
    extends FilteredMouseAdapter {
        private ActionListener action = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        };

        public ABeanHandler(Action action) {
            this.action = action;
        }

        private ABeanHandler() {
        }

        public void mousePressed(MouseEvent evt) {
            ABluePrintBeans bean;
            Property prop;
            Object src;
            if (evt != null && evt.getButton() == 3 && (src = evt.getSource()) != null && src instanceof ABluePrintBeans && (prop = (bean = (ABluePrintBeans)src).getProperty()) != null) {
                FamilyPanel.this.sticky = true;
                FamilyPanel.this.selectedPanel = bean.getParent();
                SelectionDispatcher.fireSelection((AWTEvent)evt, (Context)new Context(prop));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseClickedFiltered(MouseEvent evt) {
            Container c;
            if (evt.getID() != 500 || evt.getButton() != 1) {
                return;
            }
            Object src = evt.getSource();
            if (src == null) {
                return;
            }
            ABluePrintBeans bean = null;
            if (src instanceof ABluePrintBeans) {
                bean = (ABluePrintBeans)src;
            }
            if (MouseUtils.isDoubleClick((MouseEvent)evt)) {
                try {
                    FamilyPanel.this.sticky = true;
                    if (bean != null && bean.getProperty() != null) {
                        AncestrisEditor editor = AncestrisEditor.findEditor((Property)bean.getProperty());
                        if (editor != null) {
                            editor.edit(bean.getProperty());
                        }
                    } else {
                        this.getCreateAction().actionPerformed(new ActionEvent(evt.getSource(), 0, ""));
                    }
                    FamilyPanel.this.refresh();
                }
                finally {
                    FamilyPanel.this.sticky = false;
                }
            } else if (evt.getClickCount() == 1 && bean != null && bean.getProperty() != null && (c = bean.getParent()) != null) {
                Property prop = bean.getProperty();
                if (prop instanceof Entity && c.equals((Object)FamilyPanel.this.oFamsPanel) && prop instanceof Indi) {
                    Indi spouse = (Indi)prop;
                    Fam[] fams = FamilyPanel.this.focusIndi.getFamiliesWhereSpouse();
                    for (int idx = 0; idx < fams.length; ++idx) {
                        Indi os = fams[idx].getOtherSpouse(FamilyPanel.this.focusIndi);
                        if (os == null || !os.equals(spouse)) continue;
                        FamilyPanel.this.famIndex = idx;
                        FamilyPanel.this.refresh();
                        return;
                    }
                }
                FamilyPanel.this.sticky = false;
                SelectionDispatcher.fireSelection((Context)new Context(prop));
            }
        }

        public ActionListener getCreateAction() {
            return this.action;
        }
    }

    private class Callback
    extends GedcomListenerAdapter {
        private Callback() {
        }

        public void gedcomWriteLockReleased(Gedcom gedcom) {
            FamilyPanel.this.refresh();
        }
    }
}

