/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.feedback;

import ancestris.api.core.Version;
import ancestris.modules.feedback.FeedBackPlugin;
import ancestris.modules.feedback.FeedbackPanel;
import ancestris.modules.feedback.SendMailWorker;
import ancestris.modules.feedback.Zipper;
import genj.util.EnvironmentChecker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import org.netbeans.api.options.OptionsDisplayer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class SendAction
implements ActionListener {
    private static final ResourceBundle RESOURCES = ResourceBundle.getBundle("ancestris/modules/feedback/Bundle");
    private static final String TEXTSEPARATOR = "\n=======================================\n";
    private static final String SEND = NbBundle.getMessage(SendAction.class, (String)"SEND_BUTTON");
    private Preferences modulePreferences = NbPreferences.forModule(FeedBackPlugin.class);
    private File zipFile;
    private FeedbackPanel fbPanel;

    private void setDefaultValues(FeedbackPanel panel) {
        panel.jtaText.setText(SendAction.getSystemInfo());
        panel.jtEmailTo.setText(RESOURCES.getString("fb.mailto.default"));
        panel.jtName.setText(this.modulePreferences.get("mail.name", ""));
        panel.jtEmail.setText(this.modulePreferences.get("mail.address", ""));
    }

    private void saveDefaultValues(FeedbackPanel panel) {
        this.modulePreferences.put("mail.name", panel.jtName.getText().trim());
        this.modulePreferences.put("mail.address", panel.jtEmail.getText().trim());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.zipFile = this.sendUserDir();
        }
        catch (Exception ex) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)(RESOURCES.getString("fb.msg.senderror") + "\n(" + ex.getMessage() + ")."), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
        if (this.modulePreferences.get("mail.host", "").equals("")) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)RESOURCES.getString("fb.msg.setParameters"), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            OptionsDisplayer.getDefault().open("Extensions/FeedBack");
        } else {
            this.fbPanel = new FeedbackPanel(this.zipFile);
            this.setDefaultValues(this.fbPanel);
            DialogDescriptor dd = new DialogDescriptor((Object)this.fbPanel, NbBundle.getMessage(this.getClass(), (String)"FeedbackPanel.title"));
            dd.setOptions(new Object[]{SEND, DialogDescriptor.CANCEL_OPTION});
            DialogDisplayer.getDefault().createDialog(dd);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (dd.getValue().equals(SEND)) {
                this.saveDefaultValues(this.fbPanel);
                String name = this.fbPanel.jtName.getText().trim();
                String from = this.fbPanel.jtEmail.getText().trim();
                String to = this.fbPanel.jtEmailTo.getText().trim();
                String messageBody = this.fbPanel.jtaText.getText().trim();
                String TS = new SimpleDateFormat("yyMMdd-HHmm").format(new Date());
                String subject = "[" + RESOURCES.getString("fb.tag.subject") + " " + TS + "] ";
                subject = subject + this.fbPanel.jtSubject.getText().trim();
                File attachedFile = null;
                if (this.fbPanel.sendLogCheckBox.isSelected()) {
                    attachedFile = this.zipFile;
                }
                Thread t = new Thread((Runnable)new SendMailWorker(name, from, to, subject, messageBody, attachedFile), "SendFeedback");
                t.start();
            }
        }
    }

    public static String getSystemInfo() {
        Properties p = System.getProperties();
        StringBuilder sb = new StringBuilder();
        sb.append("Ancestris ");
        sb.append(((Version)Lookup.getDefault().lookup(Version.class)).getBuildString());
        sb.append(" (");
        sb.append(Locale.getDefault());
        sb.append(")\nOS : ");
        sb.append(p.get("os.name"));
        sb.append(" ");
        sb.append(p.get("os.version"));
        sb.append(" (");
        sb.append(p.get("os.arch"));
        sb.append(")\nJRE: ");
        sb.append(p.get("java.vendor"));
        sb.append(" ");
        sb.append(p.get("java.version"));
        sb.append("\n");
        sb.append(TEXTSEPARATOR).append(RESOURCES.getString("fb.text.comment"));
        sb.append("\n");
        return sb.toString();
    }

    private File sendUserDir() throws IOException {
        String baseDir = System.getProperty("netbeans.user");
        Zipper zipUD = new Zipper(new File(baseDir));
        zipUD.addIncludePatterns("ancestris/.*");
        zipUD.addExcludePatterns("ancestris/.*\\.lck");
        zipUD.addIncludePatterns("config/Preferences/.*");
        zipUD.addIncludePatterns("config/Toolbars/.*");
        zipUD.addIncludePatterns("config/Windows2Local/.*");
        zipUD.addIncludePatterns("var/log/.*");
        File temp = File.createTempFile("ancestris", ".zip");
        zipUD.doExport(temp);
        return temp;
    }

    private class GenjLogFile {
        private File theFile;

        GenjLogFile() {
            File home = new File(EnvironmentChecker.getProperty((String)"user.home.genj", null, (String)"determining home directory"));
            this.theFile = new File(home, "ancestris.log");
        }

        long getSize() {
            return this.theFile.length();
        }

        String getContent() {
            String msg = "";
            try {
                BufferedReader in = new BufferedReader(new FileReader(this.theFile));
                while (in.ready()) {
                    msg = msg + in.readLine() + "\n";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return msg;
        }
    }
}

