/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.gedcomvalidate;

import ancestris.modules.gedcom.gedcomvalidate.GedcomValidate;
import ancestris.modules.gedcom.gedcomvalidate.Test;
import genj.gedcom.Entity;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import genj.util.WordBuffer;
import genj.view.ViewContext;
import java.util.List;
import org.openide.util.NbBundle;

public class TestAge
extends Test {
    static final int OVER = 0;
    static final int UNDER = 1;
    private TagPath path2date;
    private TagPath path2indi;
    private int comparison;
    private int years;
    private String explanation;

    TestAge(String trigger, String p2indi, int comp, int yrs, String expltn) {
        this(trigger, null, p2indi, comp, yrs, expltn);
    }

    TestAge(String trigger, String p2date, String p2indi, int comp, int yrs, String expltn) {
        super(trigger, p2date != null ? Property.class : PropertyDate.class);
        this.explanation = expltn;
        this.path2date = p2date != null ? new TagPath(p2date) : null;
        this.path2indi = new TagPath(p2indi);
        this.comparison = comp;
        this.years = yrs;
    }

    @Override
    void test(Property prop, TagPath trigger, List<ViewContext> issues, GedcomValidate report) {
        PropertyDate date = this.path2date != null ? (PropertyDate)prop.getProperty(this.path2date) : (PropertyDate)prop;
        if (date == null || !date.isValid()) {
            return;
        }
        Property[] props = prop.getProperties(this.path2indi);
        if (props == null) {
            return;
        }
        Entity mainEntity = null;
        if (prop instanceof PropertyXRef) {
            PropertyXRef pxref = (PropertyXRef)prop;
            mainEntity = pxref.getTargetEntity();
        } else {
            mainEntity = prop.getEntity();
        }
        for (Property pindi : props) {
            PointInTime pit1;
            Delta delta;
            Indi indi;
            if (!(pindi instanceof Indi) || (indi = (Indi)pindi) == mainEntity) continue;
            PointInTime pit2 = date.getStart();
            PropertyDate birt = indi.getBirthDate();
            if (birt == null || !birt.isValid() || (delta = Delta.get((PointInTime)(pit1 = birt.getStart()), (PointInTime)pit2)) == null) continue;
            boolean error = this.isError(delta.getYears());
            if (this.explanation.equals("minDiffAgeSibling")) {
                boolean likelyTwins;
                int m = delta.getMonths() + 12 * delta.getYears();
                int j = delta.getDays();
                boolean datesAreComplete = pit1.isComplete() && pit2.isComplete();
                boolean bl = likelyTwins = m == 0 && j < 2;
                if (report.showTwins && datesAreComplete && likelyTwins) {
                    WordBuffer words = new WordBuffer();
                    words.append(NbBundle.getMessage(this.getClass(), (String)"err.twins", (Object)mainEntity.toString(), (Object)indi.toString(), (Object)String.valueOf(this.years)));
                    issues.add(new ViewContext(mainEntity).setCode(this.getCode() + "-1").setText(words.toString()).setImage(prop instanceof PropertyDate ? prop.getParent().getImage(false) : prop.getImage(false)));
                    continue;
                }
                boolean bl2 = error = this.isError(m) && datesAreComplete && !likelyTwins;
            }
            if (!error) continue;
            String code = this.getCode() + "-";
            WordBuffer words = new WordBuffer();
            if (this.explanation.equals("minAgeMARR")) {
                code = code + "2";
                words.append(NbBundle.getMessage(this.getClass(), (String)("err." + this.explanation), (Object)mainEntity.toString(), (Object)delta.getYears(), (Object)String.valueOf(this.years)));
            }
            if (this.explanation.equals("minAgeMother") || this.explanation.equals("maxAgeMother") || this.explanation.equals("minAgeFather")) {
                if (this.explanation.equals("minAgeMother")) {
                    code = code + "3";
                }
                if (this.explanation.equals("maxAgeMother")) {
                    code = code + "4";
                }
                if (this.explanation.equals("minAgeFather")) {
                    code = code + "5";
                }
                if (pit1.compareTo(pit2) < 0) {
                    words.append(NbBundle.getMessage(this.getClass(), (String)("err." + this.explanation), (Object)indi.toString(), (Object)delta.getYears(), (Object)mainEntity.toString(), (Object)String.valueOf(this.years), (Object[])new Object[0]));
                } else {
                    words.append(NbBundle.getMessage(this.getClass(), (String)("err." + this.explanation), (Object)mainEntity.toString(), (Object)delta.getYears(), (Object)indi.toString(), (Object)String.valueOf(this.years), (Object[])new Object[0]));
                }
            }
            if (this.explanation.equals("maxDiffAgeSibling") || this.explanation.equals("maxDiffAgeSpouses")) {
                if (this.explanation.equals("maxDiffAgeSibling")) {
                    code = code + "7";
                }
                if (this.explanation.equals("maxDiffAgeSpouses")) {
                    code = code + "8";
                }
                words.append(NbBundle.getMessage(this.getClass(), (String)("err." + this.explanation), (Object)mainEntity.toString(), (Object)indi.toString(), (Object)delta.getYears(), (Object)String.valueOf(this.years), (Object[])new Object[0]));
            }
            if (this.explanation.equals("minDiffAgeSibling")) {
                code = code + "6";
                words.append(NbBundle.getMessage(this.getClass(), (String)("err." + this.explanation), (Object)mainEntity.toString(), (Object)indi.toString(), (Object)(12 * delta.getYears() + delta.getMonths()), (Object)String.valueOf(this.years), (Object[])new Object[0]));
            }
            words.append(", ");
            words.append(NbBundle.getMessage(this.getClass(), (String)this.explanation).toLowerCase());
            issues.add(new ViewContext(mainEntity).setCode(code).setText(words.toString()).setImage(prop instanceof PropertyDate ? prop.getParent().getImage(false) : prop.getImage(false)));
        }
    }

    private boolean isError(int age) {
        switch (this.comparison) {
            case 0: {
                return age > this.years;
            }
            case 1: {
                return age < this.years;
            }
        }
        return false;
    }

    @Override
    String getCode() {
        return "01";
    }
}

