/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.gedcomvalidate;

import ancestris.modules.gedcom.gedcomvalidate.GedcomValidate;
import ancestris.modules.gedcom.gedcomvalidate.Test;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyPlace;
import genj.gedcom.TagPath;
import genj.view.ViewContext;
import java.util.List;
import org.openide.util.NbBundle;

public class TestPlace
extends Test {
    private String globalHierarchy;

    TestPlace(Gedcom gedcom) {
        super((String[])null, PropertyPlace.class);
        this.globalHierarchy = gedcom.getPlaceFormat();
    }

    @Override
    void test(Property prop, TagPath path, List<ViewContext> issues, GedcomValidate report) {
        PropertyPlace place = (PropertyPlace)prop;
        String hierarchy = place.getFormatAsString();
        if (!hierarchy.equals(this.globalHierarchy)) {
            issues.add(new ViewContext((Property)place).setCode(this.getCode()).setText(NbBundle.getMessage(this.getClass(), (String)"warn.plac.format")));
        }
        if (!(hierarchy.length() <= 0 || place.getValue().length() <= 0 && report.isEmptyValueValid)) {
            String[] jurisdictions = place.getJurisdictions();
            String[] format = place.getFormat();
            if (format.length != jurisdictions.length) {
                issues.add(new ViewContext((Property)place).setCode(this.getCode()).setText(NbBundle.getMessage(this.getClass(), (String)"warn.plac.value", (Object)String.valueOf(jurisdictions.length), (Object)String.valueOf(format.length))));
            }
        }
    }

    @Override
    String getCode() {
        return "00-4";
    }
}

