/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports;

import ancestris.core.actions.AbstractAncestrisAction;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.PropertyDate;
import genj.gedcom.TagPath;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;

public class ReportCalendar
extends Report {
    private static final TagPath PATH_INDIDEATPLAC = new TagPath("INDI:DEAT:PLAC");
    public boolean output_births = true;
    public boolean output_deaths = true;
    public int assume_dead = 100;
    public boolean dead_birthdays = false;
    public int anniversary = 0;
    public String[] anniversarys = new String[]{this.translate("both_alive"), this.translate("one_alive"), this.translate("all"), this.translate("none")};
    public int year_mode = 0;
    public String[] year_modes = new String[]{this.translate("upcoming"), this.translate("generic")};
    public int max_names = 0;
    public String[] max_namess = new String[]{this.translate("nolimit"), "1", "2", "3"};
    private static DateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    private Writer writer;

    public void start(Gedcom gedcom) throws IOException {
        File file = this.getFileFromUser("Choose calendar file", AbstractAncestrisAction.TXT_OK, true, "ics");
        if (file == null) {
            return;
        }
        this.writer = new FileWriter(file);
        this.outputHeader();
        Collection individuals = gedcom.getEntities("INDI");
        Collection families = gedcom.getEntities("FAM");
        for (Indi indi : individuals) {
            if (this.output_births) {
                this.outputBirthday(indi);
            }
            if (!this.output_deaths) continue;
            this.outputDeathAnniv(indi);
        }
        for (Fam fam : families) {
            if (this.anniversary == 3) continue;
            this.outputWeddingAnniv(fam);
        }
        this.outputFooter();
        this.writer.close();
    }

    private void outputHeader() throws IOException {
        this.writer.write("BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:GenJ-ReportCalendar\n");
    }

    private void outputFooter() throws IOException {
        this.writer.write("END:VCALENDAR\n");
    }

    private void outputBirthday(Indi indi) throws IOException {
        Event event = this.getDate(indi.getBirthDate());
        if (event == null) {
            return;
        }
        if (!this.dead_birthdays && !this.isAlive(indi, event.date)) {
            return;
        }
        String summary = this.translate("birthday") + ": " + this.getIndiNameId(indi);
        this.outputEvent(event, summary);
    }

    private void outputDeathAnniv(Indi indi) throws IOException {
        Event event = this.getDate(indi.getDeathDate());
        if (event == null) {
            return;
        }
        String summary = this.translate("death_anniversary") + ": " + this.getIndiNameId(indi);
        this.outputEvent(event, summary);
    }

    private void outputWeddingAnniv(Fam fam) throws IOException {
        Event event = this.getDate(fam.getMarriageDate());
        if (event == null) {
            return;
        }
        Indi wife = fam.getWife();
        Indi husband = fam.getHusband();
        boolean wifeDead = false;
        boolean husbandDead = false;
        if (wife != null) {
            boolean bl = wifeDead = !this.isAlive(wife, event.date);
        }
        if (husband != null) {
            boolean bl = husbandDead = !this.isAlive(husband, event.date);
        }
        if (this.anniversary == 0 && (wifeDead || husbandDead)) {
            return;
        }
        if (this.anniversary == 1 && wifeDead && husbandDead) {
            return;
        }
        String summary = this.translate("wedding_anniversary") + ": " + this.getFamName(fam);
        this.outputEvent(event, summary);
    }

    private void outputEvent(Event event, String summary) throws IOException {
        if (this.year_mode == 0) {
            summary = event.count + " " + summary;
        }
        summary = summary.replace(",", "\\,");
        this.writer.write("BEGIN:VEVENT\n");
        this.writer.write("DTSTART:" + DATE_FORMAT.format(event.date) + "\n");
        this.writer.write("SUMMARY:" + summary + "\n");
        if (this.year_mode == 1) {
            this.writer.write("RRULE:FREQ=YEARLY\n");
        }
        this.writer.write("END:VEVENT\n");
    }

    private Event getDate(PropertyDate date) {
        if (date == null) {
            return null;
        }
        if (date.getFormat() != PropertyDate.DATE) {
            return null;
        }
        if (!date.getStart().isComplete()) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        Calendar now = Calendar.getInstance();
        PointInTime pit = date.getStart();
        cal.set(now.get(1), pit.getMonth(), pit.getDay() + 1);
        if (cal.before(now)) {
            cal.roll(1, true);
        }
        int count = cal.get(1) - date.getStart().getYear();
        return new Event(cal.getTime(), count);
    }

    private String getIndiNameId(Indi indi) {
        return (this.getIndiName(indi) + " (" + indi.getId() + ")").trim();
    }

    private String getIndiName(Indi indi) {
        return (this.getFirstNames(indi) + " " + indi.getLastName()).trim();
    }

    private String getFamName(Fam fam) {
        Indi wife = fam.getWife();
        Indi husband = fam.getHusband();
        String id = "(" + fam.getId() + ")";
        if (wife == null && husband == null) {
            return id;
        }
        if (wife == null) {
            return this.getIndiName(husband) + " + " + this.translate("wife") + " " + id;
        }
        if (husband == null) {
            return this.getIndiName(wife) + " + " + this.translate("husband") + " " + id;
        }
        return this.getFirstNames(wife) + " + " + this.getIndiName(husband) + " " + id;
    }

    private String getFirstNames(Indi indi) {
        String firstName = indi.getFirstName();
        if (this.max_names <= 0) {
            return firstName;
        }
        if (firstName.trim().equals("")) {
            return "";
        }
        String[] names = firstName.split("  *");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.max_names && i < names.length; ++i) {
            sb.append(names[i]).append(" ");
        }
        return sb.substring(0, sb.length() - 1);
    }

    private boolean isAlive(Indi indi, Date date) {
        if (indi.getDeathDate() != null || indi.getProperty(PATH_INDIDEATPLAC) != null) {
            return false;
        }
        if (this.assume_dead == 0) {
            return true;
        }
        PropertyDate birth = indi.getBirthDate();
        if (birth == null) {
            return true;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int d = cal.get(5);
        Delta delta = birth.getAnniversary(new PointInTime(d - 1, cal.get(2), cal.get(1)));
        if (delta == null) {
            return true;
        }
        return delta.getYears() < this.assume_dead;
    }

    private static class Event {
        public Date date;
        public int count;

        public Event(Date date, int count) {
            this.date = date;
            this.count = count;
        }
    }
}

