/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class ReportLinesCirc
extends Report {
    private static final Charset CHARSET = Charset.forName("ISO-8859-1");
    private int maxlevel = 10;
    public int umaxlevel = 2;
    public String[] umaxlevels = new String[]{this.translate("umaxlevel.5"), this.translate("umaxlevel.6"), this.translate("umaxlevel.7"), this.translate("umaxlevel.8"), this.translate("umaxlevel.9"), this.translate("umaxlevel.10")};
    private int x_pages = 1;
    private int y_pages = 1;
    public int unb_pages = 0;
    public String[] unb_pagess = new String[]{this.translate("unb_pages.0"), this.translate("unb_pages.1"), this.translate("unb_pages.2"), this.translate("unb_pages.3"), this.translate("unb_pages.4"), this.translate("unb_pages.5"), this.translate("unb_pages.6")};
    private int radius = 0;
    public int colourtext = 1;
    public String[] colourtexts = new String[]{this.translate("colourtext.0"), this.translate("colourtext.1")};
    public int colouroption = 0;
    public String[] colouroptions = new String[]{this.translate("colouroption.0"), this.translate("colouroption.1"), this.translate("colouroption.2")};
    private boolean alternating;
    private boolean gradient;
    public int dateformat = 1;
    public String[] dateformats = new String[]{this.translate("dateformat.0"), this.translate("dateformat.1"), this.translate("dateformat.2")};
    private boolean marrest;
    private boolean printmarr;
    public boolean uprintmarr = true;
    public int uenc_choice = 0;
    private int enc_choice = 1;
    public String[] uenc_choices = new String[]{this.translate("uenc_choice.0"), this.translate("uenc_choice.1"), this.translate("uenc_choice.2")};
    public int ufont_name = 0;
    public String[] ufont_names = new String[]{this.translate("ufont_name.0"), this.translate("ufont_name.1"), this.translate("ufont_name.2"), this.translate("ufont_name.3"), this.translate("ufont_name.4"), this.translate("ufont_name.5")};
    private String font_name = "Helvetica";
    public boolean printdate = false;
    private PrintWriter writer;
    private int indicentre = 1;
    private int numindilines = 0;
    private int nummarr = -1;
    private static final String version = "genj 1.0";
    private boolean transparent;

    private PrintWriter getWriter(OutputStream out) {
        return new PrintWriter(new OutputStreamWriter(out, CHARSET));
    }

    public File start(Indi indi) {
        this.initUserOptions();
        File file = this.getFileFromUser(this.translate("output.file"), AbstractAncestrisAction.TXT_OK, true, FileChooserBuilder.getPdfFilter().getExtensions()[0]);
        if (file == null) {
            return null;
        }
        try {
            this.writer = this.getWriter(new FileOutputStream(file));
        }
        catch (IOException ioe) {
            System.err.println("IO Exception!");
            ioe.printStackTrace();
            return null;
        }
        this.main(indi, null);
        this.writer.flush();
        this.writer.close();
        return file;
    }

    private void initUserOptions() {
        this.marrest = false;
        this.printmarr = true;
        this.alternating = this.colouroption == 0;
        this.gradient = this.colouroption == 2;
        this.maxlevel = this.umaxlevel + 5;
        this.enc_choice = 1 + this.uenc_choice;
        this.font_name = this.translate("ufont_name." + this.ufont_name);
        this.transparent = this.colouroption != 0;
        switch (this.unb_pages) {
            case 1: {
                this.x_pages = 2;
                this.y_pages = 1;
                break;
            }
            case 2: {
                this.x_pages = 2;
                this.y_pages = 2;
                break;
            }
            case 3: {
                this.x_pages = 3;
                this.y_pages = 2;
                break;
            }
            case 4: {
                this.x_pages = 4;
                this.y_pages = 3;
                break;
            }
            case 5: {
                this.x_pages = 5;
                this.y_pages = 4;
                break;
            }
            case 6: {
                this.x_pages = 6;
                this.y_pages = 4;
                break;
            }
            default: {
                this.x_pages = 1;
                this.y_pages = 1;
            }
        }
    }

    private String put_given_name(Indi person, int length) {
        return this.escapePsString(this.truncateString(this.givens(person), length));
    }

    private String put_full_name(Indi person, int sur_upper, int n_order, int length) {
        return this.fullname(person, sur_upper, n_order, length);
    }

    private void endline(int ahnen, int offset, int info, int max) {
        this.writer.println(") " + ahnen + " " + offset + " " + info + " " + max + "} addind");
    }

    private void putperson(Fam family, Indi person, int level, int ahnen, int info, int dateformat) {
        int[] levellength = new int[]{25, 26, 23, 16, 15, 15, 21, 21, 21, 21, 21};
        PersonCell pCell = new PersonCell();
        if (this.eq(level, 1)) {
            this.numindilines += pCell.add(this.surname(person), this.numindilines);
            this.numindilines += pCell.add(this.put_given_name(person, levellength[level]), this.numindilines);
            this.numindilines += pCell.add(this.getDateString(this.birth(person), this.death(person), dateformat), this.numindilines);
            this.writer.print(pCell.get(ahnen, info));
        } else if (this.and(this.ge(level, 2), this.le(level, 6))) {
            this.numindilines += pCell.add(this.surname(person), this.numindilines);
            this.numindilines += pCell.add(this.put_given_name(person, levellength[level]), this.numindilines);
            this.numindilines += pCell.add(this.getDateString(this.birth(person), this.death(person), dateformat), this.numindilines);
            this.writer.print(pCell.get(ahnen, info));
        } else if (this.or(this.eq(level, 7), this.eq(level, 8))) {
            this.numindilines += pCell.add(this.put_full_name(person, 0, 1, this.getel(levellength, level)), this.numindilines);
            this.numindilines += pCell.add(this.getDateString(this.birth(person), this.death(person), dateformat), this.numindilines);
            this.writer.print(pCell.get(ahnen, info));
        } else if (this.ge(level, 9)) {
            this.numindilines += pCell.add(this.put_full_name(person, 0, 1, this.getel(levellength, level)) + this.getDateString(this.birth(person), this.death(person), dateformat), this.numindilines);
            this.writer.print(pCell.get(ahnen, info));
        }
        if (this.printmarr) {
            if (this.marrest) {
                // empty if block
            }
            if (this.marriage(family) != null && this.eq("M", this.sex(person))) {
                ++this.nummarr;
                this.writer.println(this.d(this.nummarr) + " {(" + this.date(this.marriage(family)) + ") " + this.d(ahnen) + " " + this.d(info) + "} addmarr");
            }
        }
    }

    private void semicirc(Fam family, Indi person, int level, int ahnen, int info, int maxlevel, int dateformat) {
        if (person != null && this.le(level, maxlevel)) {
            this.putperson(family, person, level, ahnen, info, dateformat);
            int nextlevel = this.add(level, 1);
            int nextahnen = this.mul(ahnen, 2);
            this.semicirc(this.parents(person), this.father(person), nextlevel, nextahnen, info, maxlevel, dateformat);
            this.semicirc(this.parents(person), this.mother(person), nextlevel, this.add(nextahnen, 1), info, maxlevel, dateformat);
        }
    }

    boolean le(int a, int b) {
        return a <= b;
    }

    boolean gt(int a, int b) {
        return a > b;
    }

    boolean ge(int a, int b) {
        return a >= b;
    }

    boolean ne(int a, int b) {
        return a != b;
    }

    boolean eq(int a, int b) {
        return a == b;
    }

    boolean eq(String a, String b) {
        return a.equals(b);
    }

    boolean or(boolean a, boolean b) {
        return a || b;
    }

    boolean and(boolean a, boolean b) {
        return a && b;
    }

    int add(int a, int b) {
        return a + b;
    }

    int mul(int a, int b) {
        return a * b;
    }

    int getel(int[] intarray, int offset) {
        if (offset >= intarray.length) {
            return 0;
        }
        return intarray[offset];
    }

    String d(int i) {
        return "" + i;
    }

    String d(boolean b) {
        return b ? "1" : "0";
    }

    PropertyDate birth(Indi entity) {
        if (entity == null) {
            return null;
        }
        Property prop = entity.getProperty("BIRT");
        if (prop == null) {
            return null;
        }
        return (PropertyDate)prop.getProperty("DATE");
    }

    PropertyDate death(Indi entity) {
        if (entity == null) {
            return null;
        }
        Property prop = entity.getProperty("DEAT");
        if (prop == null) {
            return null;
        }
        return (PropertyDate)prop.getProperty("DATE");
    }

    String date(PropertyDate date) {
        if (date != null) {
            return date.getDisplayValue();
        }
        return "";
    }

    String year(PropertyDate date) {
        if (date != null) {
            return date.getStart().isValid() ? "" + date.getStart().getYear() : "????";
        }
        return "";
    }

    PropertyDate marriage(Fam family) {
        if (family == null) {
            return null;
        }
        Property prop = family.getProperty("MARR");
        if (prop == null) {
            return null;
        }
        return (PropertyDate)prop.getProperty("DATE");
    }

    Indi husband(Fam fam) {
        return fam == null ? null : fam.getHusband();
    }

    Indi wife(Fam fam) {
        return fam == null ? null : fam.getWife();
    }

    Fam parents(Indi person) {
        return person == null ? null : person.getFamilyWhereBiologicalChild();
    }

    Indi father(Indi person) {
        return person == null ? null : this.husband(this.parents(person));
    }

    Indi mother(Indi person) {
        return person == null ? null : this.wife(this.parents(person));
    }

    String sex(Indi indi) {
        return indi.getSex() == 1 ? "M" : "F";
    }

    private String fullname(Indi indi, int isUpper, int type, int length) {
        if (indi.getName().length() <= length) {
            return this.escapePsString(indi.getName());
        }
        return this.escapePsString(this.truncateString(indi.getName(), length));
    }

    String surname(Indi indi) {
        if (indi == null) {
            return "";
        }
        return this.escapePsString(this.truncateString(indi.getLastName(), 30));
    }

    String givens(Indi indi) {
        if (indi == null) {
            return "";
        }
        return indi.getFirstName();
    }

    private String truncateString(String s, int length) {
        if (s.length() <= length) {
            return s;
        }
        return s.substring(0, length);
    }

    private String escapePsString(String s) {
        String result = s.replaceAll("\\\\", "\\\\\\\\");
        result = result.replaceAll("\\(", "\\\\(");
        result = result.replaceAll("\\)", "\\\\)");
        return result;
    }

    private void putpageprintouts(int xn, int yn) {
        int page_num = 0;
        for (int yi = yn - 1; yi >= 0; --yi) {
            int yi_ord = yn - 1 - yi;
            for (int xi = xn - 1; xi >= 0; --xi) {
                page_num = this.add(page_num, 1);
                this.writer.println("%%Page: " + page_num + " " + page_num + "\n" + "cleartomark mark\n" + xi + " " + yi + " print-a-page\n" + "showpage\n");
            }
        }
    }

    private void printfile() {
        this.writer.println("%!PS-Adobe-3.0");
        this.writer.println("%%Title: (PS-CIRCLE.PS - Circular Genealogical Pedigree Chart in Postscript format)");
        this.writer.println("%%Creator: genj 1.0 - a Lifelines circle ancestry chart report generator");
        this.writer.println("%%CreationDate: ");
        this.writer.println("%%Pages: " + this.d(this.mul(this.x_pages, this.y_pages)));
        this.writer.println("%%PageOrder: Ascend");
        this.writer.println("%%Orientation: Portrait");
        this.writer.println("%%EndComments\n");
        this.writer.println("%%BeginDefaults");
        this.writer.println("%%ViewingOrientation: 1 0 0 1");
        this.writer.println("%%EndDefaults\n");
        this.writer.println("%%BeginProlog\n");
        this.writer.println("%   much of the code involved with font encoding and with multipaging");
        this.writer.println("%   is borrowed from Robert Simms <rsimms@ces.clemson.edu>\n");
        this.writer.println("%page margins");
        this.writer.println("/margin_top 20 def");
        this.writer.println("/margin_bottom 20 def");
        this.writer.println("/margin_left 20 def");
        this.writer.println("/margin_right 20 def\n");
        this.writer.println("%number of pages in each direction");
        this.writer.println("/xpages " + this.d(this.x_pages) + " def");
        this.writer.println("/ypages " + this.d(this.y_pages) + " def\n");
        this.writer.println("/fontname /" + this.font_name + " def\n");
        this.writer.println("/portrait true def\n");
        this.writer.println("/inch {72 mul} def\n");
        this.writer.println("/*SF {                 % Complete selectfont emulation");
        this.writer.println("  exch findfont exch");
        this.writer.println("  dup type /arraytype eq {makefont}{scalefont} ifelse setfont");
        this.writer.println("} bind def\n");
        this.writer.println("/BuildRectPath{");
        this.writer.println("\tdup type dup /integertype eq exch /realtype eq or{");
        this.writer.println("\t\t\t4 -2 roll moveto \t%Operands are: x y width height");
        this.writer.println("\t\t\tdup 0 exch rlineto");
        this.writer.println("\t\t\texch 0 rlineto");
        this.writer.println("\t\t\tneg 0 exch rlineto");
        this.writer.println("\t\t\tclosepath");
        this.writer.println("\t\t}{");
        this.writer.println("\t\t\tdup length 4 sub 0 exch 4 exch{");
        this.writer.println("\t\t\t\t1 index exch 4 getinterval aload pop");
        this.writer.println("\t\t\t\tBuildRectPath");
        this.writer.println("\t\t\t}for");
        this.writer.println("\t\t\tpop");
        this.writer.println("\t\t}ifelse");
        this.writer.println("} bind def\n");
        this.writer.println("/*RC { gsave newpath BuildRectPath fill grestore } bind def\n");
        this.writer.println("% install Level 2 emulations, or substitute built-in Level 2 operators");
        this.writer.println("/languagelevel where");
        this.writer.println("  {pop languagelevel}{1} ifelse");
        this.writer.println("2 lt {");
        this.writer.println("  /RC /*RC load def");
        this.writer.println("  /SF /*SF load def");
        this.writer.println("}{");
        this.writer.println("  /RC /rectclip load def      % use RC instead of rectclip");
        this.writer.println("  /SF /selectfont load def    % use SF instead of selectfont");
        this.writer.println("} ifelse\n");
        this.writer.println("%Coordinate conversion utilities");
        this.writer.println("/polar { %(ang rad) -> (x y)");
        this.writer.println("\t/rad exch def\t\t/ang exch def");
        this.writer.println("\t/x rad ang cos mul def\t\t/y rad ang sin mul def");
        this.writer.println("\tx y");
        this.writer.println("} def\n");
        this.writer.println("/midang {");
        this.writer.println("\t/inf exch def");
        this.writer.println("\tinf 1 eq {360 2 maxlevel exp div mul -90.0 add}           %for first level male, go counter clockwise from bottom");
        this.writer.println("\t\t\t\t{360 2 maxlevel exp div mul 90.0 add} ifelse     %for first level female, go clockwise from bottom");
        this.writer.println("} def\n");
        this.writer.println("%Shortcut macros");
        this.writer.println("/m {moveto} def\t\t/l {lineto} def\n");
        this.writer.println("%Constants");
        this.writer.println("/pi 3.14159265358979 def");
        this.writer.println("/ptsize 10 def");
        this.writer.println("/offset ptsize 1.25 mul neg def\n");
        this.writer.println("/radius {4.0 7.0 div exch indicentre add mul inch} def");
        this.writer.println("%begin font encoding   borrowed from Robert Simms");
        if (this.ne(this.enc_choice, 0)) {
            this.writer.println("/encvecmod* {  % on stack should be /Encoding and an encoding array");
            this.writer.println("\t% make an array copy so we don't try to modify the original via pointer");
            this.writer.println("\tdup length array copy");
            this.writer.println("\tencvecmod aload length dup 2 idiv exch 2 add -1 roll exch");
            this.writer.println("\t{dup 4 2 roll put}");
            this.writer.println("\trepeat");
            this.writer.println("} def");
            this.writer.println("/reenc {");
            this.writer.println("\tfindfont");
            this.writer.println("\tdup length dict begin");
            this.writer.println("\t\t{1 index /FID eq {pop pop} {");
            this.writer.println("\t\t\t1 index /Encoding eq {");
            this.writer.println("\t\t\t\t\tencvecmod* def");
            this.writer.println("\t\t\t\t}{def} ifelse");
            this.writer.println("\t\t\t} ifelse");
            this.writer.println("\t\t} forall");
            this.writer.println("\t\tcurrentdict");
            this.writer.println("\tend");
            this.writer.println("\tdefinefont pop");
            this.writer.println("} def");
        }
        if (this.eq(this.enc_choice, 1)) {
            this.writer.println("% Adjust the font so that it is iso-8859-1 compatible");
            this.writer.println("/languagelevel where {pop languagelevel}{1} ifelse 2 ge {");
            this.writer.println("\t/encvecmod* {pop ISOLatin1Encoding} def\t% Use built-in ISOLatin1Encoding if PS interpreter is Level 2");
            this.writer.println("}{");
            this.writer.println("\t/encvecmod [");
            this.writer.println("\t\t16#90 /dotlessi   16#91 /grave        16#92 /acute      16#93 /circumflex");
            this.writer.println("\t\t16#94 /tilde      16#95 /macron       16#96 /breve      16#97 /dotaccent");
            this.writer.println("\t\t16#98 /dieresis   16#99 /.notdef      16#9a /ring       16#9b /cedilla");
            this.writer.println("\t\t16#9c /.notdef    16#9d /hungarumlaut 16#9e /ogonek     16#9f /caron");
            this.writer.println("\t\t16#a0 /space      16#a1 /exclamdown   16#a2 /cent       16#a3 /sterling");
            this.writer.println("\t\t16#a4 /currency   16#a5 /yen         16#a6 /brokenbar   16#a7 /section");
            this.writer.println("\t\t16#a8 /dieresis   16#a9 /copyright   16#aa /ordfeminine 16#ab /guillemotleft");
            this.writer.println("\t\t16#ac /logicalnot 16#ad /hyphen      16#ae /registered  16#af /macron");
            this.writer.println("\t\t16#b0 /degree     16#b1 /plusminus   16#b2 /twosuperior 16#b3 /threesuperior");
            this.writer.println("\t\t16#b4 /acute      16#b5 /mu          16#b6 /paragraph    16#b7 /periodcentered");
            this.writer.println("\t\t16#b8 /cedilla    16#b9 /onesuperior 16#ba /ordmasculine 16#bb /guillemotright");
            this.writer.println("\t\t16#bc /onequarter 16#bd /onehalf    16#be /threequarters 16#bf /questiondown");
            this.writer.println("\t\t16#c0 /Agrave      16#c1 /Aacute    16#c2 /Acircumflex 16#c3 /Atilde");
            this.writer.println("\t\t16#c4 /Adieresis   16#c5 /Aring     16#c6 /AE          16#c7 /Ccedilla");
            this.writer.println("\t\t16#c8 /Egrave      16#c9 /Eacute    16#ca /Ecircumflex 16#cb /Edieresis");
            this.writer.println("\t\t16#cc /Igrave      16#cd /Iacute    16#ce /Icircumflex 16#cf /Idieresis");
            this.writer.println("\t\t16#d0 /Eth         16#d1 /Ntilde    16#d2 /Ograve      16#d3 /Oacute");
            this.writer.println("\t\t16#d4 /Ocircumflex 16#d5 /Otilde    16#d6 /Odieresis   16#d7 /multiply");
            this.writer.println("\t\t16#d8 /Oslash      16#d9 /Ugrave    16#da /Uacute      16#db /Ucircumflex");
            this.writer.println("\t\t16#dc /Udieresis   16#dd /Yacute    16#de /Thorn       16#df /germandbls");
            this.writer.println("\t\t16#e0 /agrave      16#e1 /aacute    16#e2 /acircumflex 16#e3 /atilde");
            this.writer.println("\t\t16#e4 /adieresis   16#e5 /aring     16#e6 /ae          16#e7 /ccedilla");
            this.writer.println("\t\t16#e8 /egrave      16#e9 /eacute    16#ea /ecircumflex 16#eb /edieresis");
            this.writer.println("\t\t16#ec /igrave      16#ed /iacute    16#ee /icircumflex 16#ef /idieresis");
            this.writer.println("\t\t16#f0 /eth         16#f1 /ntilde    16#f2 /ograve      16#f3 /oacute");
            this.writer.println("\t\t16#f4 /ocircumflex 16#f5 /otilde    16#f6 /odieresis   16#f7 /divide");
            this.writer.println("\t\t16#f8 /oslash      16#f9 /ugrave    16#fa /uacute      16#fb /ucircumflex");
            this.writer.println("\t\t16#fc /udieresis   16#fd /yacute    16#fe /thorn       16#ff /ydieresis");
            this.writer.println("\t] def");
            this.writer.println("} ifelse\n");
        } else if (this.eq(this.enc_choice, 2)) {
            this.writer.println("/encvecmod [");
            this.writer.println("\t16#a0 /space     16#a1 /Aogonek 16#a2 /breve     16#a3 /Lslash");
            this.writer.println("\t16#a4 /currency  16#a5 /Lcaron  16#a6 /Sacute    16#a7 /section");
            this.writer.println("\t16#a8 /dieresis  16#a9 /Scaron  16#aa /Scedilla  16#ab /Tcaron");
            this.writer.println("\t16#ac /Zacute    16#ad /hyphen  16#ae /Zcaron    16#af /Zdotaccent");
            this.writer.println("\t16#b0 /degree    16#b1 /aogonek 16#b2 /ogonek    16#b3 /lslash");
            this.writer.println("\t16#b4 /acute     16#b5 /lcaron  16#b6 /sacute    16#b7 /caron");
            this.writer.println("\t16#b8 /cedilla   16#b9 /scaron  16#ba /scedilla  16#bb /tcaron");
            this.writer.println("\t16#bc /zacute    16#bd /hungarumlaut 16#be /zcaron 16#bf /zdotaccent");
            this.writer.println("\t16#c0 /Racute    16#c1 /Aacute  16#c2 /Acircumflex 16#c3 /Abreve");
            this.writer.println("\t16#c4 /Adieresis 16#c5 /Lacute  16#c6 /Cacute    16#c7 /Ccedilla");
            this.writer.println("\t16#c8 /Ccaron    16#c9 /Eacute  16#ca /Eogonek   16#cb /Edieresis");
            this.writer.println("\t16#cc /Ecaron    16#cd /Iacute  16#ce /Icircumflex 16#cf /Dcaron");
            this.writer.println("\t16#d0 /Dcroat    16#d1 /Nacute   16#d2 /Ncaron    16#d3 /Oacute");
            this.writer.println("\t16#d4 /Ocircumflex 16#d5 /Ohungarumlaut 16#d6 /Odieresis 16#d7 /multiply");
            this.writer.println("\t16#d8 /Rcaron    16#d9 /Uring   16#da /Uacute    16#db /Uhungarumlaut");
            this.writer.println("\t16#dc /Udieresis 16#dd /Yacute  16#de /Tcommaaccent 16#df /germandbls");
            this.writer.println("\t16#e0 /racute    16#e1 /aacute  16#e2 /acircumflex 16#e3 /abreve");
            this.writer.println("\t16#e4 /adieresis 16#e5 /lacute  16#e6 /cacute    16#e7 /ccedilla");
            this.writer.println("\t16#e8 /ccaron    16#e9 /eacute  16#ea /eogonek   16#eb /edieresis");
            this.writer.println("\t16#ec /ecaron    16#ed /iacute  16#ee /icircumflex 16#ef /dcaron");
            this.writer.println("\t16#f0 /dcroat    16#f1 /nacute  16#f2 /ncaron     16#f3 /oacute");
            this.writer.println("\t16#f4 /ocircumflex 16#f5 /ohungarumlaut 16#f6 /odieresis 16#f7 /divide");
            this.writer.println("\t16#f8 /rcaron    16#f9 /uring   16#fa /uacute    16#fb /uhungarumlaut");
            this.writer.println("\t16#fc /udieresis 16#fd /yacute  16#fe /tcommaaccent  16#ff /dotaccent");
            this.writer.println("] def\n");
        } else if (this.eq(this.enc_choice, 3)) {
            this.writer.println("/encvecmod [");
            this.writer.println("\t16#80 /Ccedilla    16#81 /udieresis 16#82 /eacute      16#83 /acircumflex");
            this.writer.println("\t16#84 /adieresis   16#85 /agrave    16#86 /aring       16#87 /ccedilla");
            this.writer.println("\t16#88 /ecircumflex 16#89 /edieresis 16#8a /egrave      16#8b /idieresis");
            this.writer.println("\t16#8c /icircumflex 16#8d /igrave    16#8e /Adieresis   16#8f /Aring");
            this.writer.println("\t16#90 /Eacute      16#91 /ae        16#92 /AE          16#93 /ocircumflex");
            this.writer.println("\t16#94 /odieresis   16#95 /ograve    16#96 /ucircumflex 16#97 /ugrave");
            this.writer.println("\t16#98 /ydieresis   16#99 /Odieresis 16#9a /Udieresis   16#9b /cent");
            this.writer.println("\t16#9c /sterling    16#9d /yen       16#9e /.notdef     16#9f /florin");
            this.writer.println("\t16#a0 /aacute      16#a1 /iacute    16#a2 /oacute      16#a3 /uacute");
            this.writer.println("\t16#a4 /ntilde      16#a5 /Ntilde    16#a6 /ordfeminine 16#a7 /ordmasculine");
            this.writer.println("\t16#a8 /questiondown 16#a9 /.notdef  16#aa /.notdef     16#ab /onehalf");
            this.writer.println("\t16#ac /onequarter  16#ad /exclamdown 16#ae /guillemotleft  16#af /guillemotright");
            this.writer.println("\t16#e1 /germandbls  16#ed /oslash    16#f1 /plusminus   16#f6 /divide");
            this.writer.println("\t16#f8 /degree      16#f9 /bullet");
            this.writer.println("] def\n");
        }
        if (this.ne(this.enc_choice, 0)) {
            this.writer.println("/gedfont fontname reenc");
            this.writer.println("/fontname /gedfont def\n");
        }
        this.writer.println("%end font encoding   end of section borrowed from Robert Simms");
        if (this.gradient) {
            this.writer.println("/gradient{   %draw and fill 256 circles with a decreasing radius and slightly diffent colour");
            this.writer.println("\t/blue2 exch def\t/green2 exch def\t/red2 exch def");
            this.writer.println("\t/blue1 exch def\t/green1 exch def\t/red1 exch def\n");
            this.writer.println("\t/maxrad maxlevel radius def");
            this.writer.println("\t/delta_r maxrad neg 256 div def                          %find radius step to use\n");
            this.writer.println("\tgsave");
            this.writer.println("\t\tmaxrad delta_r 0.0 {                                  %step through the circles from large to small");
            this.writer.println("\t\t\t/r exch def");
            this.writer.println("\t\t\t/ratio r maxrad div def");
            this.writer.println("\t\t\t/red red1 red2 sub ratio mul red2 add def          % work out the new colour");
            this.writer.println("\t\t\t/blue blue1 blue2 sub ratio mul blue2 add def");
            this.writer.println("\t\t\t/green green1 green2 sub ratio mul green2 add def\n");
            this.writer.println("\t\t\tred green blue setrgbcolor");
            this.writer.println("\t\t\tnewpath 0.0 0.0 r 0 360 arc fill                   %draw and fill circles");
            this.writer.println("\t\t} for");
            this.writer.println("\tgrestore");
            this.writer.println("} def\n");
        }
        this.writer.println("/fan{  %Fan Template");
        this.writer.println("\tgsave");
        if (this.or(!this.printmarr, !this.transparent)) {
            this.writer.println("\t%begin gender specific shading of boxes");
            this.writer.println("\t/c 1 def                          %flag for the alternating colours");
            this.writer.println("\t1 indicentre sub 1 maxlevel {%shade the boxes if necessary");
            this.writer.println("\t\t/i exch def");
            this.writer.println("\t\t/delta_ang 360.0 2 i exp div def  %set the angle stepsize");
            this.writer.println("\t\t/r1 i radius def\t\t/r2 i 1 sub radius def        %find the inner and outer radius for the box");
            if (this.ge(this.maxlevel, 8)) {
                this.writer.println("\t\ti 8 ge {0}{0.7 radfactor div} ifelse");
            } else {
                this.writer.println("\t\t.7 radfactor div");
            }
            this.writer.println(" setlinewidth                %if level is beyond 7 make lines thinnest possible\n");
            this.writer.println("\t\t90.0 delta_ang 449.99 { %step through all angles from 90deg to 90deg+360deg (450deg)");
            this.writer.println("\t\t\t/ang1 exch def\t\t/ang2 ang1 delta_ang add def     %find the beginning and ending angle for each box");
            this.writer.println("\t\t\tnewpath");
            this.writer.println("\t\t\t\ti 0 gt{%draw the box");
            this.writer.println("\t\t\t\t\tang1 r1 polar m 0 0 r1 ang1 ang2 arc ang2 r2 polar l 0 0 r2 ang2 ang1 arcn");
            this.writer.println("\t\t\t\t}{");
            this.writer.println("\t\t\t\t\t0 0 1 radius 0 0 1 radius 0 360 arc");
            this.writer.println("\t\t\t\t}ifelse");
            this.writer.println("\t\t\tclosepath");
            if (!this.transparent) {
                this.writer.println("\t\t\t\ti 0 gt {                              %fill in box if necessary");
                this.writer.println("\t\t\t\t\tc 1 eq {/c1 0 def rf gf bf setrgbcolor} {/c1 1 def rm gm bm setrgbcolor} ifelse");
                this.writer.println("\t\t\t\t}{");
                this.writer.println("\t\t\t\t\tcentrepersonsex 0 eq {rm gm bm setrgbcolor} {rf gf bf setrgbcolor} ifelse");
                this.writer.println("\t\t\t\t}ifelse");
                this.writer.println("\t\t\t\tgsave fill grestore");
                this.writer.println("\t\t\t\ti 0 gt{/c c1 def}if                                    %exchange color for next box");
                this.writer.println("\t\t\trl gl bl setrgbcolor\n");
            }
            if (!this.printmarr) {
                if (!this.transparent) {
                    this.writer.println("\t\t\t\ti 9 le {stroke} if              %draw outline of box if level is less than 10");
                } else {
                    this.writer.println("\t\t\t\tstroke");
                }
            }
            this.writer.println("\t\t}for");
            this.writer.println("\t}for %end gender specific shading of boxes");
        }
        if (this.printmarr) {
            this.writer.println("\t%begin draw boxes around husband and wife");
            this.writer.println("\trl gl bl setrgbcolor");
            this.writer.println("\t2 indicentre sub 1 maxlevel {                    %step through the levels");
            this.writer.println("\t\t/i exch def");
            if (this.ge(this.maxlevel, 8)) {
                this.writer.println("\t\ti 8 ge {0}{0.7 radfactor div} ifelse");
            } else {
                this.writer.println("\t\t.7 radfactor div");
            }
            this.writer.println(" setlinewidth\n");
            this.writer.println("\t\t/delta_ang 360.0 2 i 1 sub exp div def  %set the angle stepsize");
            this.writer.println("\t\t90.0 delta_ang 449.99 {");
            this.writer.println("\t\t\t/ang1 exch def\t\t/ang2 ang1 delta_ang add def");
            this.writer.println("\t\t\t/r1 i radius def\t/r2 i 1 sub radius def\n");
            this.writer.println("\t\t\t%draw tic marks around marriage date");
            this.writer.println("\t\t\t/delta_r r1 r2 sub 15 div def");
            this.writer.println("\t\t\t/angave ang1 delta_ang 2 div add def");
            this.writer.println("\t\t\t/r_inner r2 delta_r add def");
            this.writer.println("\t\t\t/r_outer r1 delta_r sub def\n");
            this.writer.println("\t\t\tnewpath angave r_outer polar m angave r1 polar l stroke");
            this.writer.println("\t\t\tr2 0 gt{");
            this.writer.println("\t\t\t\tnewpath angave r2 polar m angave r_inner polar l stroke");
            this.writer.println("\t\t\t}if\n");
            if (!this.transparent) {
                this.writer.println("\t\t\trm gm bm setrgbcolor         %erase small gap between male and female");
                this.writer.println("\t\t\t.5 setlinewidth");
                this.writer.println("\t\t\tnewpath angave r_outer polar m angave r_inner polar l stroke");
                this.writer.println("\t\t\trl gl bl setrgbcolor");
                if (this.ge(this.maxlevel, 8)) {
                    this.writer.println("\t\ti 8 ge {0}{0.7 radfactor div} ifelse");
                } else {
                    this.writer.println("\t\t.7 radfactor div");
                }
                this.writer.println(" setlinewidth");
            }
            this.writer.println("\t\t\t%finish tic marks\n");
            this.writer.println("\t\t\tnewpath\t%draw box around parents");
            this.writer.println("\t\t\t\tang1 r1 polar m 0 0 r1 ang1 ang2 arc");
            this.writer.println("\t\t\t\tang2 r2 polar l 0 0 r2 ang2 ang1 arcn closepath");
            this.writer.println("\t\t\tstroke");
            this.writer.println("\t\t}for");
            this.writer.println("\t}for\t%end draw boxes around husband and wife\n");
        }
        if (this.printdate) {
            this.writer.println("\t0 0 0 setrgbcolor");
            this.writer.println("\tfontname 5 SF");
            this.writer.println("\t/radiusprint maxlevel radius 1.01 mul def");
            this.writer.println("\tdatetoday radiusprint 300 circtext");
        }
        this.writer.println("\tgrestore");
        this.writer.println("} def\n");
        this.writer.println("/angtext{   %Angled Line Printing Procedure for outer lines than do not curve");
        this.writer.println("\t/inf exch def\t\t/offst exch def\t\t/ang exch def\t\t/levelnum exch def\t\t/str exch def\n");
        this.writer.println("\tgsave");
        this.writer.println("\tang rotate                                               %rotate coordinate system for printing\n");
        this.writer.println("\t/r1 levelnum 1 sub radius def\t\t/r2 levelnum radius def");
        if (this.printmarr) {
            this.writer.println("\tlevelnum 1 eq indicentre 0 eq and{/r1 0 def /r2 0 def}if\n");
        }
        this.writer.println("\t/y r1 r2 add 2 div def\n");
        this.writer.println("\tinf 0 eq{0 offst -10 mul 15 add translate}{y 0.0 translate}ifelse\n");
        this.writer.println("\tstr stringwidth pop 2 div neg offst moveto");
        this.writer.println("\tstr show");
        this.writer.println("\tgrestore");
        this.writer.println("} def\n");
        this.writer.println("/circtext{   %Circular Line Printing Procedure for inner lines than do curve\n");
        this.writer.println("\t/angle exch def\t/textradius exch def\t/str exch def\n");
        this.writer.println("\t/xradius textradius ptsize 4 div add def");
        this.writer.println("\tgsave");
        this.writer.println("\t\tangle str findhalfangle add rotate");
        this.writer.println("\t\tstr {/charcode exch def ( ) dup 0 charcode put circchar} forall");
        this.writer.println("\tgrestore");
        this.writer.println("} def\n");
        this.writer.println("/findhalfangle {stringwidth pop 2 div 2 xradius mul pi mul div 360 mul} def\n");
        this.writer.println("/circchar{   %print each character at a different angle around the circle");
        this.writer.println("\t/char exch def\n");
        this.writer.println("\t/halfangle char findhalfangle def");
        this.writer.println("\t\tgsave");
        this.writer.println("\t\thalfangle neg  rotate");
        this.writer.println("\t\ttextradius 0 translate");
        this.writer.println("\t\t-90 rotate");
        this.writer.println("\t\tchar stringwidth pop 2 div neg 0 moveto");
        this.writer.println("\t\tchar show");
        this.writer.println("\tgrestore");
        this.writer.println("\thalfangle 2 mul neg rotate");
        this.writer.println("} def\n");
        this.writer.println("/setprintcolor{");
        this.writer.println("\t/ahnen exch def\t\t/inf exch def");
        this.writer.println("\tahnen 2 div dup cvi eq {redmale greenmale bluemale setrgbcolor}{redfemale greenfemale bluefemale setrgbcolor} ifelse");
        this.writer.println("\tahnen inf mul 1 eq {redmale greenmale bluemale setrgbcolor} if");
        this.writer.println("} def\n");
        this.writer.println("/position{  %compute position from ahnentafel number");
        this.writer.println("\t/ahnenn exch def");
        this.writer.println("\tahnenn 2 maxlevel -1 add exp lt {");
        this.writer.println("\t\t/a 2 ahnenn log 1.9999 log div floor exp def");
        this.writer.println("\t\t/numerator 2 a mul -1 add -2 ahnenn a neg add mul add def");
        this.writer.println("\t\t/fact 2 maxlevel -2 add exp def");
        this.writer.println("\t\tnumerator a div fact mul");
        this.writer.println("\t}{2 maxlevel exp ahnenn neg add} ifelse");
        this.writer.println("} def\n");
        this.writer.println("/level {1 add log 2 log div ceiling cvi} def %compute generation level from ahnentafel number\n");
        this.writer.println("/info{");
        this.writer.println("\t/max exch def\t\t/inf exch def\t\t/noffset exch def\t\t/ahnen exch def");
        this.writer.println("\t/fntfactor {[0 0.85 0.85 0.8 0.7 0.5 0.4 0.3 0.3 0.25 0.25 0.25 0.25] exch get} def %set different font sizes for each level\n");
        this.writer.println("\tahnen 2 maxlevel exp lt {");
        this.writer.println("\t\t/place ahnen position def");
        this.writer.println("\t\t/levelnum ahnen level def    %get the level number of the current person");
        this.writer.println("\t\t/radtab levelnum radius def  %get the radius of the current level");
        this.writer.println("\t\t/ftsize ptsize levelnum fntfactor mul def  %find the new fontsize depending on the current level number");
        this.writer.println("\t\t/offset ftsize 1.25 mul neg def            %find the distance that the text should be printed from the ring");
        this.writer.println("\t\tinf ahnen setprintcolor      %print the names and information in alternating colors as defined below in line #350");
        this.writer.println("\t\tfontname ftsize SF %set the font to use\n");
        this.writer.println("\t\tlevelnum 5 lt {levelnum radtab place noffset inf max inner}  % the inner four rings");
        this.writer.println("\t\t\t\t\t\t{levelnum place noffset inf 0 max outer} ifelse  % all outer rings");
        this.writer.println("\t} if");
        this.writer.println("} def\n");
        if (this.eq(this.indicentre, 1)) {
            this.writer.println("/indiinfo{");
            this.writer.println("\t/inf exch def\t\t/noffset exch def\t\t/ahnen exch def");
            this.writer.println("\t/ftsize ptsize 0.9 mul def  %find the new fontsize depending on the current level number");
            this.writer.println("\t/offset ftsize 1.25 mul neg def            %find the distance that the text should be printed from the ring");
            this.writer.println("\tinf ahnen setprintcolor      %print the names and information in alternating colors as defined below in line #350");
            this.writer.println("\tfontname ftsize SF %set the font to use\n");
            this.writer.println("\t0 0 noffset 0 angtext");
            this.writer.println("} def\n");
        }
        this.writer.println("/nstr 7 string def");
        this.writer.println("/prtn {-0.5 inch 5.5 inch m nstr cvs show} def");
        this.writer.println("/prt {-0.5 inch 5.5 inch m\tshow} def\n");
        if (this.printmarr) {
            this.writer.println("/minfo{");
            this.writer.println("\t/inf exch def\t\t/ahnen exch def");
            this.writer.println("\t/fntfactor {[0 0.7 0.7 0.6 0.6 0.5 0.4 0.3 0.3 0.25 0.25 0.25 0.25] exch get} def %set different font sizes for each level\n");
            this.writer.println("\tahnen 2 maxlevel exp lt {");
            this.writer.println("\t\t/place ahnen 1 eq {0}{ahnen 2 div position}ifelse def  %get the position of the text counting on the outer ring from bottom upwards");
            this.writer.println("\t\t/levelnum ahnen level def   %get the level number of the current person");
            this.writer.println("\t\t/ftsize ptsize levelnum fntfactor mul 0.80 mul def  %find the new fontsize depending on the current level number");
            this.writer.println("\t\t/offset ftsize 0.35 mul neg def            %find the distance that the text should be printed from the ring");
            this.writer.println("\t\trl gl bl setrgbcolor");
            this.writer.println("\t\tdup");
            this.writer.println("\t\t/namelength exch length def");
            this.writer.println("\t\t/f namelength 11 lt {1}{11 namelength div}ifelse def");
            this.writer.println("\t\tfontname ftsize f mul SF %set the font to use\n");
            this.writer.println("\t\tlevelnum place 0 inf 1 1 outer");
            this.writer.println("\t} if");
            this.writer.println("} def\n");
        }
        this.writer.println("/inner{");
        this.writer.println("\t/max exch def\t\t/inf exch def\t\t/noffset exch def\t\t/place exch def\t\t/radtab exch def\t\t/levelnum exch def");
        this.writer.println("\t% slight modifications for each level for line spacing");
        if (this.eq(this.indicentre, 0)) {
            this.writer.println("\t\tmax 3 eq {/factor {[0.0 0.98 0.97 0.97 0.975] exch get} def}if");
            this.writer.println("\t\tmax 2 eq {/factor {[0.0 0.80 0.885 0.935 0.94] exch get} def}if");
            this.writer.println("\t\tmax 1 eq {/factor {[0.0 0.70 0.835 0.905 0.91] exch get} def}if\n");
        }
        if (this.eq(this.indicentre, 1)) {
            this.writer.println("\t\tmax 3 eq {/factor {[0.0 0.96 0.98 0.98 0.975] exch get} def}if");
            this.writer.println("\t\tmax 2 eq {/factor {[0.0 0.96 0.935 0.945 0.94] exch get} def}if");
            this.writer.println("\t\tmax 1 eq {/factor {[0.0 0.96 0.905 0.915 0.91] exch get} def}if\n");
        }
        this.writer.println("\tlevelnum 1 eq indicentre 0 eq and{/offset offset 0.75 mul def} if  %max the offset a bit smaller for the first level");
        this.writer.println("\tradtab levelnum factor mul noffset offset mul add place inf midang circtext");
        this.writer.println("} def\n");
        this.writer.println("/outer{");
        this.writer.println("\t/max exch def\t/marr exch def\t\t/inf exch def\t\t/noffset exch def\t\t/place exch def\t\t/levelnum exch def\n");
        this.writer.println("\t\t\t% in the following:");
        this.writer.println("\t\t\t%      f1 spreads the text out apart from eachother when more positive (larger)");
        this.writer.println("\t\t\t%      f2 shifts the set of text counter clockwise when more positive (larger)");
        if (this.eq(this.maxlevel, 5)) {
            this.writer.println("\t\tmax 3 eq {levelnum 5 eq {/f1 -2.5 def\t/f2 1.35 def} if}if");
            this.writer.println("\t\tmax 2 eq {levelnum 5 eq {/f1 -2.5 def\t/f2 0.25 def} if}if\n");
        }
        if (this.eq(this.maxlevel, 6)) {
            this.writer.println("\t\tmax 3 eq {levelnum 5 eq {/f1 -2.5 def\t/f2 6.50 def} if");
            this.writer.println("\t\t\t\t\t levelnum 6 eq {/f1 -1.7 def\t/f2 1.50 def} if}if");
            this.writer.println("\t\tmax 2 eq {");
            this.writer.println("\t\t\t\t\t levelnum 5 eq {/f1 -2.5 def\t/f2 4.85 def} if");
            this.writer.println("\t\t\t\t\t levelnum 6 eq {/f1 -1.7 def\t/f2 1.50 def} if}if\n");
        }
        if (this.eq(this.maxlevel, 7)) {
            this.writer.println("\t\tmax 3 eq {levelnum 5 eq {/f1 -2.5 def\t/f2 6.50 def} if");
            this.writer.println("\t\t\t\t\t levelnum 6 eq {/f1 -1.6 def\t/f2 4.30 def} if}if");
            this.writer.println("\t\tmax 2 eq {");
            this.writer.println("\t\t\t \t\t levelnum 5 eq {/f1 -2.5 def\t/f2 4.85 def} if");
            this.writer.println("\t\t\t\t\t levelnum 6 eq {/f1 -1.6 def\t/f2 3.30 def} if");
            this.writer.println("\t\t\t\t\t levelnum 7 eq {/f1 -1.0 def\t/f2 0.70 def} if}if");
            this.writer.println("\t\tmax 1 eq {");
            this.writer.println("\t\t\t\t\t levelnum 5 eq {/f1 -2.5 def\t/f2 4.85 def} if");
            this.writer.println("\t\t\t\t\t levelnum 6 eq {/f1 -1.6 def\t/f2 4.30 def} if");
            this.writer.println("\t\t\t\t\t levelnum 7 eq {/f1 -2.0 def\t/f2 1.20 def} if}if\n");
        }
        if (this.eq(this.maxlevel, 8)) {
            this.writer.println("\t\tmax 3 eq {levelnum 5 eq {/f1 -2.5 def\t/f2 6.50 def} if");
            this.writer.println("\t\t\t\t\t levelnum 6 eq {/f1 -1.6 def\t/f2 4.30 def} if}if");
            this.writer.println("\t\tmax 2 eq {");
            this.writer.println("\t\t\t\t\t levelnum 5 eq {/f1 -2.5 def\t/f2 4.85 def} if");
            this.writer.println("\t\t\t\t\t levelnum 6 eq {/f1 -1.6 def\t/f2 3.30 def} if");
            this.writer.println("\t\t\t\t\t levelnum 7 eq {/f1 -1.0 def\t/f2 2.20 def} if");
            this.writer.println("\t\t\t\t\t levelnum 8 eq {/f1 -0.7 def\t/f2 0.80 def} if}if");
            this.writer.println("\t\tmax 1 eq {");
            this.writer.println("\t\t\t\t\t levelnum 5 eq {/f1 -2.5 def\t/f2 4.85 def} if");
            this.writer.println("\t\t\t\t\t levelnum 6 eq {/f1 -1.6 def\t/f2 3.30 def} if");
            this.writer.println("\t\t\t\t\t levelnum 7 eq {/f1 -1.0 def\t/f2 1.50 def} if");
            this.writer.println("\t\t\t\t\t levelnum 8 eq {/f1 -0.7 def\t/f2 0.50 def} if}if\n");
        }
        if (this.eq(this.maxlevel, 9)) {
            this.writer.println("\t\tmax 3 eq {levelnum 5 eq {/f1 -2.5 def\t/f2 6.50 def} if");
            this.writer.println("\t\t\t\t\t levelnum 6 eq {/f1 -1.6 def\t/f2 4.30 def} if}if");
            this.writer.println("\t\tmax 2 eq {");
            this.writer.println("\t\t\t\t\t levelnum 5 eq {/f1 -2.5 def\t/f2 4.85 def} if");
            this.writer.println("\t\t\t\t\t levelnum 6 eq {/f1 -1.6 def\t/f2 4.00 def} if");
            this.writer.println("\t\t\t\t\t levelnum 7 eq {/f1 -1.0 def\t/f2 2.00 def} if");
            this.writer.println("\t\t\t\t\t levelnum 8 eq {/f1 -0.6 def\t/f2 1.40 def} if}if");
            this.writer.println("\t\tmax 1 eq {");
            this.writer.println("\t\t\t\t\t levelnum 5 eq {/f1 -2.5 def\t/f2 4.85 def} if");
            this.writer.println("\t\t\t\t\t levelnum 6 eq {/f1 -1.6 def\t/f2 4.00 def} if");
            this.writer.println("\t\t\t\t\t levelnum 7 eq {/f1 -1.0 def\t/f2 2.00 def} if");
            this.writer.println("\t\t\t\t\t levelnum 8 eq {/f1 -0.6 def\t/f2 1.40 def} if");
            this.writer.println("\t\t\t\t\t levelnum 9 eq {/f1  0.0 def\t/f2 0.00 def} if}if\n");
        }
        if (this.eq(this.maxlevel, 10)) {
            this.writer.println("\t\tmax 3 eq {levelnum 5 eq {/f1 -2.5 def\t/f2 6.50 def} if");
            this.writer.println("\t\t\t\t\t levelnum 6 eq {/f1 -1.6 def\t/f2 4.30 def} if}if");
            this.writer.println("\t\tmax 2 eq {");
            this.writer.println("\t\t\t\t\t levelnum 5 eq {/f1 -2.5 def\t/f2 4.85 def} if");
            this.writer.println("\t\t\t\t\t levelnum 6 eq {/f1 -1.6 def\t/f2 4.00 def} if");
            this.writer.println("\t\t\t\t\t levelnum 7 eq {/f1 -1.0 def\t/f2 2.00 def} if");
            this.writer.println("\t\t\t\t\t levelnum 8 eq {/f1 -0.6 def\t/f2 1.40 def} if}if");
            this.writer.println("\t\tmax 1 eq {");
            this.writer.println("\t\t\t\t\t levelnum 5 eq {/f1 -2.5 def\t/f2 4.85 def} if");
            this.writer.println("\t\t\t\t\t levelnum 6 eq {/f1 -1.6 def\t/f2 4.00 def} if");
            this.writer.println("\t\t\t\t\t levelnum 7 eq {/f1 -1.0 def\t/f2 1.70 def} if");
            this.writer.println("\t\t\t\t\t levelnum 8 eq {/f1 -0.6 def\t/f2 1.20 def} if");
            this.writer.println("\t\t\t\t\t levelnum 9 eq {/f1  0.0 def\t/f2 0.40 def} if");
            this.writer.println("\t\t\t\t\t levelnum 10 ge{/f1  0.0 def\t/f2 0.225 def}if}if\n");
        }
        this.writer.println("\tmarr 1 eq {/f1 0.0 def\t\t/f2 0.0 def} if\n");
        this.writer.println("\t/ang place inf midang f1 noffset mul f2 add add def");
        this.writer.println("\tlevelnum ang offset inf angtext");
        this.writer.println("} def\n");
        this.writer.println("%   borrowed from Robert Simms");
        if (this.eq(this.indicentre, 1)) {
            this.writer.println("/addcenterindi {centerperson_array 3 1 roll put} def");
        }
        if (this.printmarr) {
            this.writer.println("/addmarr {marriage_array 3 1 roll put} def");
        }
        this.writer.println("/addind {person_array 3 1 roll put} def\n");
    }

    private void main(Indi person, Fam fam) {
        int psex = person.getSex() == 1 ? 0 : 1;
        this.printfile();
        if (this.printdate) {
            this.writer.println("/datetoday (Date: " + PointInTime.getNow().toString() + ") def\n\n");
        }
        this.writer.println("/indicentre " + this.d(this.indicentre) + " def %1=put individual in centre,0=family at centre");
        if (this.eq(this.indicentre, 1)) {
            this.writer.println("/centrepersonsex " + psex + " def %0=male; 1=female\n\n");
        }
        this.writer.println("/maxlevel " + this.d(this.maxlevel) + " def");
        this.writer.println("% color  of the text in RGB format");
        if (this.eq(this.colourtext, 1)) {
            this.writer.println("/redmale   0.0 def  /greenmale   0.0 def  /bluemale   1.0 def");
            this.writer.println("/redfemale 1.0 def  /greenfemale 0.0 def  /bluefemale 0.0 def\n");
        } else {
            this.writer.println("/redmale   0.0 def  /greenmale   0.0 def  /bluemale   0.0 def");
            this.writer.println("/redfemale 0.0 def  /greenfemale 0.0 def  /bluefemale 0.0 def\n");
        }
        if (this.gradient) {
            this.writer.println("/transparent 1 def         % 1=transparent, 0=color shading\n");
            this.writer.println("/rf 0.0 def /gf 0.0 def /bf 0.0 def %rgb female box fill");
            this.writer.println("/rm 0.0 def /gm 0.0 def /bm 0.0 def %rgb male box fill\n");
        } else if (!this.alternating) {
            this.writer.println("/transparent 1 def         % 1=transparent, 0=color shading\n");
            this.writer.println("/rf 1.0 def /gf 1.0 def /bf 1.0 def %rgb female box fill");
            this.writer.println("/rm 1.0 def /gm 1.0 def /bm 1.0 def %rgb male box fill\n");
        } else {
            this.writer.println("/transparent 0 def         % 1=transparent, 0=color shading\n");
            this.writer.println("/rf 0.8 def /gf 0.8 def /bf 1.0 def %rgb female box fill");
            this.writer.println("/rm 1.0 def /gm 0.8 def /bm 0.8 def %rgb male box fill\n");
        }
        this.writer.println("/rl 0.0 def /gl 0.0 def /bl 0.0 def %  rgb for lines");
        this.writer.println("%     partially borrowed from Robert Simms");
        this.writer.println("% Find printable dimension for chart with a sequence of steps\n");
        this.writer.println("% get printable area for each page");
        this.writer.println("clippath pathbbox newpath");
        this.writer.println("/ury exch def /urx exch def");
        this.writer.println("/lly exch def /llx exch def\n");
        this.writer.println("/llx llx margin_left add def /lly lly margin_bottom add def");
        this.writer.println("/urx urx margin_right sub def /ury ury margin_top sub def\n");
        this.writer.println("% get available width and height for printing on a sheet of paper");
        this.writer.println("/wp urx llx sub def");
        this.writer.println("/hp ury lly sub def\n");
        this.writer.println("% get width and height of the multi-page printable area");
        this.writer.println("/tw0 wp xpages mul def");
        this.writer.println("/th0 hp ypages mul def\n");
        this.writer.println("tw0 th0 gt {");
        if (this.eq(this.radius, 0)) {
            this.writer.println("\t/mindim th0 def\n");
        }
        this.writer.println("\tth0 wp div ceiling cvi xpages lt {/xpages th0 wp div ceiling cvi def /tw0 wp xpages mul def /ypages ypages def}{/xpages xpages def /ypages ypages def}ifelse");
        this.writer.println("}{");
        if (this.eq(this.radius, 0)) {
            this.writer.println("\t/mindim tw0 def\n");
        }
        this.writer.println("\ttw0 hp div ceiling cvi ypages lt {/ypages tw0 hp div ceiling cvi def /th0 hp ypages mul def /xpages xpages def}{/xpages xpages def /ypages ypages def}ifelse");
        this.writer.println("}ifelse\n");
        if (this.gt(this.radius, 0)) {
            this.writer.println("/radfactor " + this.d(this.radius) + " inch 8 inch div def");
        } else {
            this.writer.println("/radfactor mindim 8 inch div def");
        }
        this.writer.println("/scalefactor 7.0 maxlevel indicentre add div radfactor mul def\n");
        this.writer.println("/print-a-page { % page printing procedure");
        this.writer.println("\t/ypage exch ypages 2 div 1 sub sub def  %y-correction to center chart");
        this.writer.println("\t/xpage exch xpages 2 div 1 sub sub def  %x-correction to center chart");
        this.writer.println("\typage ypages lt xpage xpages lt and { %only print if page is in correct range");
        this.writer.println("\t\tgsave");
        this.writer.println("\t\t\tllx lly translate");
        this.writer.println("\t\t\t0 0 wp hp RC\t\t% specify (rectangular) clipping path to keep the margins clean");
        this.writer.println("\t\t\txpage wp mul ypage hp mul translate\t% move origin so that desired portion of chart lands within clipping path");
        this.writer.println("\t\t\tscalefactor dup scale  %enlarge scale to fit page");
        if (this.gradient) {
            this.writer.println("0.6431 0.3255 0.0228  % inside centre color in RGB format");
            this.writer.println("0.9922 0.7686 0.5490  % outside rim color in RGB format    to form a radial gradient");
            this.writer.println("gradient\n");
        }
        this.writer.println("\t\t\tfan  %draw circle template");
        if (this.eq(this.indicentre, 1)) {
            this.writer.println("\t\t\tcenterperson_array {exec indiinfo} forall %put in center person\n");
        }
        this.writer.println("\t\t\tperson_array {exec info} forall %put in all people with dates");
        if (this.printmarr) {
            this.writer.println("\t\t\tmarriage_array {exec minfo} forall %put in marriage dates\n");
        }
        this.writer.println("\t\t\t1 dup scale %reset scale to normal");
        this.writer.println("\t\tgrestore");
        this.writer.println("\t} if");
        this.writer.println("} def      % print-a-page procedure\n");
        this.writer.println("%%EndProlog");
        this.writer.println("%%BeginSetUp\n");
        this.writer.println("/fillarray{% store vertical lines and individual records in arrays");
        if (this.eq(this.indicentre, 1)) {
            PersonCell pCell = new PersonCell();
            int index = 0;
            index += pCell.add(this.surname(person), index);
            index += pCell.add(this.put_given_name(person, 25), index);
            index += pCell.add(this.getDateString(this.birth(person), this.death(person), this.dateformat), index);
            this.writer.print(pCell.getCenter(psex));
            this.semicirc(this.parents(person), this.father(person), 1, 1, 1, this.maxlevel, this.dateformat);
            this.semicirc(this.parents(person), this.mother(person), 1, 1, 2, this.maxlevel, this.dateformat);
        } else {
            this.semicirc(fam, this.husband(fam), 1, 1, 1, this.maxlevel, this.dateformat);
            this.semicirc(fam, this.wife(fam), 1, 1, 2, this.maxlevel, this.dateformat);
        }
        this.writer.println("} def\n");
        if (this.eq(this.indicentre, 1)) {
            this.writer.println("/centerperson_array 3 array def\n");
        }
        if (this.printmarr) {
            this.writer.println("/marriage_array " + this.d(this.add(this.nummarr, 1)) + " array def\n");
        }
        this.writer.println("/person_array " + this.numindilines + " array def");
        this.writer.println("fillarray\n");
        this.writer.println("mark\n");
        this.writer.println("%%EndSetUp");
        this.putpageprintouts(this.x_pages, this.y_pages);
        this.writer.println("%%EOF");
    }

    private String getDateString(PropertyDate birth, PropertyDate death, int dateformat) {
        String result = "";
        String birthstr = "";
        String deathstr = "";
        if (birth != null && !birth.isValid()) {
            birth = null;
        }
        if (death != null && !death.isValid()) {
            death = null;
        }
        if (birth == null && death == null) {
            return "";
        }
        switch (dateformat) {
            case 2: {
                birthstr = "    ";
                deathstr = "    ";
            }
            case 1: {
                if (death != null) {
                    deathstr = this.year(death);
                }
                if (birth != null) {
                    birthstr = this.year(birth);
                }
                result = "(" + birthstr + "-" + deathstr + ")";
                break;
            }
            default: {
                if (death != null) {
                    if (birth != null) {
                        result = result + this.year(birth);
                    }
                    result = result + "-" + this.year(death);
                    break;
                }
                if (birth == null) break;
                result = result + this.OPTIONS.getBirthSymbol() + birth.getDisplayValue();
            }
        }
        return result;
    }

    private static class PersonCell {
        List<String> cells = new ArrayList<String>(5);
        int max = 0;

        PersonCell() {
        }

        int add(String text, int index) {
            if (text == null || text.length() == 0) {
                return 0;
            }
            this.cells.add("" + index + " {(" + text);
            ++this.max;
            return 1;
        }

        String get(int ahnen, int info) {
            String result = "";
            for (int offset = 1; offset <= this.max; ++offset) {
                result = result + this.cells.get(offset - 1) + ") " + ahnen + " " + offset + " " + info + " " + this.max + "} addind\n";
            }
            return result;
        }

        String getCenter(int sex) {
            String result = "";
            for (int offset = 1; offset <= this.max; ++offset) {
                result = result + this.cells.get(offset - 1) + ") " + sex + " " + offset + " 0} addcenterindi\n";
            }
            return result;
        }
    }
}

