/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.TagPath;
import genj.gedcom.time.PointInTime;
import genj.report.Report;

public class ReportMissingInformation
extends Report {
    public boolean checkBirthDate = true;
    public boolean checkBirthPlace = true;
    public boolean checkBaptismDate = true;
    public boolean checkBaptismPlace = true;
    public boolean checkDeathDate = true;
    public boolean checkDeathPlace = true;
    public boolean checkSex = true;
    public boolean checkGiven = true;
    public boolean checkSurname = true;
    private String textTitle = this.translate("title");
    private String textSubject = this.translate("subject");
    private String textBirth = this.translate("birth");
    private String textBaptism = this.translate("baptism");
    private String textDeath = this.translate("death");
    private String textDate = this.translate("date");
    private String textPlace = this.translate("place");
    private String textSex = this.translate("sex");
    private String textGiven = this.translate("given");
    private String textSurname = this.translate("surname");
    private String textKey = this.translate("key");
    private int colName = 30;
    private int colData = 6;
    private int numDataCols = 9;

    public void start(Indi indi) {
        this.displayHeader(indi.getName());
        this.checkIndi(indi);
    }

    public void checkIndi(Indi indi) {
        Boolean flagOk2;
        Boolean flagOk1;
        PropertyPlace tempPlace;
        PropertyDate tempDate;
        String strNameID = indi.getName() + " " + indi.getId();
        String strDataRow = ReportMissingInformation.align((String)strNameID, (int)this.colName, (int)3);
        strDataRow = this.checkBirthDate ? ((tempDate = indi.getBirthDate()) == null || !tempDate.isValid() ? strDataRow + ReportMissingInformation.align((String)"X", (int)this.colData, (int)1) : strDataRow + ReportMissingInformation.align((String)"ok", (int)this.colData, (int)1)) : strDataRow + ReportMissingInformation.align((String)"-", (int)this.colData, (int)1);
        strDataRow = this.checkBirthPlace ? ((tempPlace = (PropertyPlace)indi.getProperty(new TagPath("INDI:BIRT:PLAC"))) == null ? strDataRow + ReportMissingInformation.align((String)"X", (int)this.colData, (int)1) : strDataRow + ReportMissingInformation.align((String)"ok", (int)this.colData, (int)1)) : strDataRow + ReportMissingInformation.align((String)"-", (int)this.colData, (int)1);
        if (this.checkBaptismDate) {
            flagOk1 = true;
            flagOk2 = true;
            tempDate = (PropertyDate)indi.getProperty(new TagPath("INDI:BAPM:DATE"));
            if (tempDate == null || !tempDate.isValid()) {
                flagOk1 = false;
            }
            if ((tempDate = (PropertyDate)indi.getProperty(new TagPath("INDI:CHR:DATE"))) == null || !tempDate.isValid()) {
                flagOk2 = false;
            }
            strDataRow = flagOk1.booleanValue() || flagOk2.booleanValue() ? strDataRow + ReportMissingInformation.align((String)"ok", (int)this.colData, (int)1) : strDataRow + ReportMissingInformation.align((String)"X", (int)this.colData, (int)1);
        } else {
            strDataRow = strDataRow + ReportMissingInformation.align((String)"-", (int)this.colData, (int)1);
        }
        if (this.checkBaptismPlace) {
            flagOk1 = true;
            flagOk2 = true;
            tempPlace = (PropertyPlace)indi.getProperty(new TagPath("INDI:BAPM:PLAC"));
            if (tempPlace == null || tempPlace.getValue() == "") {
                flagOk1 = false;
            }
            if ((tempPlace = (PropertyPlace)indi.getProperty(new TagPath("INDI:CHR:PLAC"))) == null || tempPlace.getValue().length() == 0) {
                flagOk2 = false;
            }
            strDataRow = flagOk1.booleanValue() || flagOk2.booleanValue() ? strDataRow + ReportMissingInformation.align((String)"ok", (int)this.colData, (int)1) : strDataRow + ReportMissingInformation.align((String)"X", (int)this.colData, (int)1);
        } else {
            strDataRow = strDataRow + ReportMissingInformation.align((String)"-", (int)this.colData, (int)1);
        }
        if (this.checkDeathDate) {
            tempDate = indi.getDeathDate();
            strDataRow = indi.getDeathDate() == null || !tempDate.isValid() ? strDataRow + ReportMissingInformation.align((String)"X", (int)this.colData, (int)1) : strDataRow + ReportMissingInformation.align((String)"ok", (int)this.colData, (int)1);
        } else {
            strDataRow = strDataRow + ReportMissingInformation.align((String)"-", (int)this.colData, (int)1);
        }
        strDataRow = this.checkDeathPlace ? ((tempPlace = (PropertyPlace)indi.getProperty(new TagPath("INDI:DEAT:PLAC"))) == null ? strDataRow + ReportMissingInformation.align((String)"X", (int)this.colData, (int)1) : strDataRow + ReportMissingInformation.align((String)"ok", (int)this.colData, (int)1)) : strDataRow + ReportMissingInformation.align((String)"-", (int)this.colData, (int)1);
        strDataRow = this.checkSex ? (indi.getSex() != 1 && indi.getSex() != 2 ? strDataRow + ReportMissingInformation.align((String)"X", (int)this.colData, (int)1) : strDataRow + ReportMissingInformation.align((String)"ok", (int)this.colData, (int)1)) : strDataRow + ReportMissingInformation.align((String)"-", (int)this.colData, (int)1);
        strDataRow = this.checkGiven ? (indi.getFirstName() == "" ? strDataRow + ReportMissingInformation.align((String)"X", (int)this.colData, (int)1) : strDataRow + ReportMissingInformation.align((String)"ok", (int)this.colData, (int)1)) : strDataRow + ReportMissingInformation.align((String)"-", (int)this.colData, (int)1);
        strDataRow = this.checkSurname ? (indi.getLastName() == "" ? strDataRow + ReportMissingInformation.align((String)"X", (int)this.colData, (int)1) : strDataRow + ReportMissingInformation.align((String)"ok", (int)this.colData, (int)1)) : strDataRow + ReportMissingInformation.align((String)"-", (int)this.colData, (int)1);
        this.println(strDataRow);
    }

    public void start(Gedcom gedcom) {
        this.displayHeader(gedcom.getName());
        Entity[] individuals = gedcom.getEntities("INDI", "");
        for (int loop = 0; loop < individuals.length; ++loop) {
            Indi person = (Indi)individuals[loop];
            this.checkIndi(person);
        }
    }

    public void displayHeader(String strSubject) {
        this.println(ReportMissingInformation.align((String)this.textTitle, (int)(this.colName + this.numDataCols * this.colData), (int)1));
        this.println();
        this.println(this.textSubject + ": " + strSubject);
        this.println(this.textDate + ": " + PointInTime.getNow().toString());
        this.println(this.textKey);
        this.println();
        String strUnderLine = "-";
        for (int loop = 1; loop < this.colName + this.numDataCols * this.colData - 1; ++loop) {
            strUnderLine = strUnderLine + "-";
        }
        String strColHeader1 = ReportMissingInformation.align((String)" ", (int)this.colName, (int)1) + ReportMissingInformation.align((String)this.textBirth, (int)this.colData, (int)1) + ReportMissingInformation.align((String)this.textBirth, (int)this.colData, (int)1) + ReportMissingInformation.align((String)this.textBaptism, (int)this.colData, (int)1) + ReportMissingInformation.align((String)this.textBaptism, (int)this.colData, (int)1) + ReportMissingInformation.align((String)this.textDeath, (int)this.colData, (int)1) + ReportMissingInformation.align((String)this.textDeath, (int)this.colData, (int)1);
        String strColHeader2 = ReportMissingInformation.align((String)" ", (int)this.colName, (int)1) + ReportMissingInformation.align((String)this.textDate, (int)this.colData, (int)1) + ReportMissingInformation.align((String)this.textPlace, (int)this.colData, (int)1) + ReportMissingInformation.align((String)this.textDate, (int)this.colData, (int)1) + ReportMissingInformation.align((String)this.textPlace, (int)this.colData, (int)1) + ReportMissingInformation.align((String)this.textDate, (int)this.colData, (int)1) + ReportMissingInformation.align((String)this.textPlace, (int)this.colData, (int)1) + ReportMissingInformation.align((String)this.textSex, (int)this.colData, (int)1) + ReportMissingInformation.align((String)this.textGiven, (int)this.colData, (int)1) + ReportMissingInformation.align((String)this.textSurname, (int)this.colData, (int)1);
        this.println(strColHeader1);
        this.println(strColHeader2);
        this.println(strUnderLine);
    }
}

