/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports;

import genj.gedcom.Entity;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.report.Report;
import genj.view.ViewContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class ReportRelatives
extends Report {
    private static final int UNKNOWN = 0;
    private static final int MALE = 1;
    private static final int FEMALE = 2;
    private static final Relative[] RELATIVES = new Relative[]{new Relative("farfar", "father+father"), new Relative("farmor", "father+mother"), new Relative("morfar", "mother+father"), new Relative("mormor", "mother+mother"), new Relative("father", "INDI:FAMC:*:..:HUSB:*"), new Relative("mother", "INDI:FAMC:*:..:WIFE:*"), new Relative("husband", "INDI:FAMS:*:..:HUSB:*"), new Relative("wife", "INDI:FAMS:*:..:WIFE:*"), new Relative("daughter", "INDI:FAMS:*:..:CHIL:*", 2), new Relative("son", "INDI:FAMS:*:..:CHIL:*", 1), new Relative("brother", "INDI:FAMC:*:..:CHIL:*", 1), new Relative("sister", "INDI:FAMC:*:..:CHIL:*", 2), new Relative("grandson", "son+son|daughter+son", 1), new Relative("granddaughter", "son+daughter|daughter+daughter", 2), new Relative("uncle.paternal", "father+brother|father+sister +husband"), new Relative("uncle.maternal", "mother+brother|mother+sister +husband"), new Relative("aunt.paternal", "father+sister |father+brother+wife"), new Relative("aunt.maternal", "mother+sister |mother+brother+wife"), new Relative("nephew.fraternal", "brother+son"), new Relative("niece.fraternal", "brother+daughter"), new Relative("nephew.sororal", "sister+son"), new Relative("niece.sororal", "sister+daughter"), new Relative("cousin.paternal", "uncle.paternal+son"), new Relative("cousin.maternal", "uncle.maternal+son"), new Relative("cousine.paternal", "uncle.paternal+daughter"), new Relative("cousine.maternal", "uncle.maternal+daughter")};

    public List<ViewContext> start(Indi indi) {
        HashMap<String, Relative> key2relative = new HashMap<String, Relative>();
        for (int i = 0; i < RELATIVES.length; ++i) {
            Relative relative = RELATIVES[i];
            key2relative.put(relative.key, relative);
        }
        ArrayList<ViewContext> result = new ArrayList<ViewContext>();
        result.add(new ViewContext((Entity)indi));
        for (int i = 0; i < RELATIVES.length; ++i) {
            Relative relative = RELATIVES[i];
            for (Indi found : this.find((Property)indi, relative.expression, relative.sex, key2relative)) {
                result.add(new ViewContext((Entity)found).setText(this.translate(relative.key) + ": " + found));
            }
        }
        return result;
    }

    private List<Indi> find(List<Indi> roots, String expression, int sex, Map<String, Relative> key2relative) {
        ArrayList<Indi> result = new ArrayList<Indi>();
        for (int i = 0; i < roots.size(); ++i) {
            result.addAll(this.find((Property)roots.get(i), expression, sex, key2relative));
        }
        return result;
    }

    private List<Indi> find(Property root, String expression, int sex, Map<String, Relative> key2relative) {
        int or = expression.indexOf(124);
        if (or > 0) {
            ArrayList<Indi> result = new ArrayList<Indi>();
            StringTokenizer ors = new StringTokenizer(expression, "|");
            while (ors.hasMoreTokens()) {
                result.addAll(this.find(root, ors.nextToken().trim(), sex, key2relative));
            }
            return result;
        }
        int dot = expression.indexOf(43);
        if (dot > 0) {
            List<Indi> roots = new ArrayList<Indi>();
            roots.add((Indi)root.getEntity());
            StringTokenizer cont = new StringTokenizer(expression, "+");
            while (cont.hasMoreTokens()) {
                roots = this.find(roots, cont.nextToken(), sex, key2relative);
            }
            return roots;
        }
        int colon = expression.indexOf(58);
        if (colon < 0) {
            Relative relative = key2relative.get(expression.trim());
            return this.find(root, relative.expression, relative.sex, key2relative);
        }
        ArrayList<Indi> result = new ArrayList<Indi>();
        Property[] found = root.getProperties(new TagPath(expression));
        for (int i = 0; i < found.length; ++i) {
            Indi indi = (Indi)found[i].getEntity();
            if (indi == root || sex != 0 && indi.getSex() != sex) continue;
            result.add(indi);
        }
        return result;
    }

    static class Relative {
        String key;
        String expression;
        int sex;

        Relative(String key, String expression) {
            this(key, expression, 0);
        }

        Relative(String key, String expression, int sex) {
            this.key = key;
            this.expression = expression.trim();
            this.sex = sex;
        }
    }
}

