/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.gedart;

import ancestris.reports.gedart.GedartResources;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.TreeMap;
import org.openide.modules.Places;

class GedartTemplate
implements Cloneable {
    private String name;
    private String description;
    private String path;
    private String format;
    private GedartResources resources;
    private TreeMap<String, String> context = new TreeMap();

    public GedartTemplate(File dir) {
        this.name = dir.getName();
        this.path = dir.getAbsolutePath();
        int index = this.name.lastIndexOf(46);
        if (index > 0) {
            this.format = this.name.substring(index + 1);
            this.description = this.name.substring(0, index);
        }
        if (this.format != null) {
            this.description = this.description + " (" + this.format + ")";
        }
        try {
            this.resources = new GedartResources(new FileInputStream(new File(dir, "resources.properties")));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (this.resources != null) {
            String value = this.resources.translate("name");
            if (value != null) {
                this.description = value;
            }
            this.setContext("Indi");
            this.setContext("Indi[]");
            this.setContext("Fam");
            this.setContext("Fam[]");
            this.setContext("Gedcom");
        }
    }

    static GedartTemplate create(File dir) {
        if (!dir.isDirectory()) {
            return null;
        }
        if (!new File(dir, "index.vm").exists()) {
            return null;
        }
        return new GedartTemplate(dir);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescription(String ctx) {
        if (this.context.isEmpty()) {
            return this.getDescription();
        }
        return this.context.get(ctx);
    }

    public String getPath() {
        String base = Places.getUserDirectory().getAbsolutePath();
        return this.path.substring(base.length() + 1);
    }

    public String getFormat() {
        return this.format;
    }

    public void setContext(String tag) {
        String value = this.resources.translate(tag, null, false);
        if (value != null) {
            this.context.put(tag, value);
        }
    }

    public String toString() {
        return this.getDescription();
    }

    public static String[] getDescription(GedartTemplate[] templates) {
        String[] descriptions = new String[templates.length];
        for (int i = 0; i < templates.length; ++i) {
            descriptions[i] = templates[i].getDescription();
        }
        return descriptions;
    }

    protected GedartTemplate clone() throws CloneNotSupportedException {
        return (GedartTemplate)super.clone();
    }

    public void setDescription(String description2) {
        this.description = description2;
    }
}

