/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.phonetics;

import ancestris.reports.phonetics.DoubleMetaphone;
import ancestris.reports.phonetics.Metaphone;
import ancestris.reports.phonetics.Nysiis;
import ancestris.reports.phonetics.Phonetics;
import ancestris.reports.phonetics.Phonex;
import ancestris.reports.phonetics.Soundex;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.report.Report;
import genj.util.ReferenceSet;
import java.util.Comparator;
import java.util.TreeSet;

public class ReportPhonetics
extends Report {
    public int outputFormat = 0;
    public boolean reportFirstNames = true;
    public static Phonetics[] outputFormats = new Phonetics[]{new Soundex(), new Metaphone(), new DoubleMetaphone(), new Nysiis(), new Phonex()};

    public boolean isReadOnly() {
        return true;
    }

    public String accepts(Object context) {
        return context instanceof Indi || context instanceof Gedcom ? this.getName() : null;
    }

    public void start(Gedcom gedcom) {
        Entity[] indis = gedcom.getEntities("INDI", "");
        this.printPhonetic(gedcom, indis, outputFormats[this.outputFormat]);
    }

    public void start(Indi indi) {
        Phonetics phonetic = (Phonetics)this.getValueFromUser(this.translate("select"), outputFormats, outputFormats[this.outputFormat]);
        if (phonetic == null) {
            return;
        }
        this.printPhonetic(indi, phonetic);
    }

    private void printPhonetic(Gedcom gedcom, Entity[] indis, Phonetics phonetics) {
        Indi indi2 = null;
        String str2 = "";
        this.println(this.translate("outputFormat") + ": " + outputFormats[this.outputFormat]);
        this.println();
        if (this.reportFirstNames) {
            ReferenceSet names = new ReferenceSet();
            for (int i = 0; i < indis.length; ++i) {
                indi2 = (Indi)indis[i];
                names.add((Object)indi2.getLastName(), (Object)indi2);
            }
            for (String str2 : names.getKeys((Comparator)gedcom.getCollator())) {
                this.println(str2 + ": " + this.encode(str2, phonetics));
                for (Indi indi2 : names.getReferences((Object)str2)) {
                    this.println(this.getIndent(2) + indi2.getFirstName() + " (" + indi2.getId() + ")" + ": " + this.encode(str2, phonetics));
                }
            }
        } else {
            TreeSet<String> names = new TreeSet<String>();
            for (int i = 0; i < indis.length; ++i) {
                indi2 = (Indi)indis[i];
                names.add(indi2.getLastName());
            }
            for (String str2 : names) {
                this.println(str2 + ": " + this.encode(str2, phonetics));
            }
        }
    }

    private void printPhonetic(Indi indi, Phonetics phonetics) {
        String firstName = indi.getFirstName();
        String lastName = indi.getLastName();
        this.println(this.translate("outputFormat") + ": " + phonetics);
        this.println();
        if (this.reportFirstNames) {
            this.println(firstName + ": " + this.encode(firstName, phonetics));
            this.println(lastName + ": " + this.encode(lastName, phonetics));
        } else {
            this.println(lastName + ": " + this.encode(lastName, phonetics));
        }
    }

    private String encode(String input, Phonetics phonetics) {
        String result = phonetics.encode(input);
        return result == null ? "" : result;
    }
}

