/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.tools;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.reports.tools.Log;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyAge;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.gedcom.UnitOfWork;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.JOptionPane;

public class ReportToolBox
extends Report {
    private static final int TOOL_GENE_ID = 0;
    private static final int TOOL_TREE_TOP = 1;
    private static final int TOOL_REMOVE_TAG = 2;
    private static final int TOOL_MNG_PLACES = 3;
    private static final int TOOL_MNG_ASSO = 4;
    private static final int TOOL_GENE_NAME = 5;
    private static final int TOOL_GENE_AGES = 6;
    public int toolToRun = 0;
    public String[] toolToRuns = new String[]{this.translate("geneIds"), this.translate("geneTreeTop"), this.translate("geneRemoveTag"), this.translate("geneMngPlaces"), this.translate("geneManageAsso"), this.translate("geneGivnSurn"), this.translate("geneAges")};
    private static final int ENT_ALL = 0;
    private static final int ENT_INDI = 1;
    private static final int ENT_FAM = 2;
    private static final int ENT_NOTE = 3;
    private static final int ENT_SOUR = 4;
    private static final int ENT_SUBM = 5;
    private static final int ENT_REPO = 6;
    public boolean logOption = false;
    private Log log = null;
    private Comparator sortEntities = new Comparator(){

        public int compare(Object o1, Object o2) {
            Entity ent1 = (Entity)o1;
            Entity ent2 = (Entity)o2;
            String id1 = ent1.getId();
            String id2 = ent2.getId();
            String tag1 = ent1.getTag();
            String tag2 = ent2.getTag();
            String s1 = "";
            String s2 = "";
            int n1 = 0;
            int n2 = 0;
            if (tag1 == "INDI") {
                s1 = "A";
            } else if (tag1 == "FAM") {
                s1 = "B";
            } else if (tag1 == "NOTE") {
                s1 = "C";
            } else if (tag1 == "SOUR") {
                s1 = "D";
            } else if (tag1 == "REPO") {
                s1 = "E";
            } else if (tag1 == "SUBM") {
                s1 = "F";
            }
            if (tag2 == "INDI") {
                s2 = "A";
            } else if (tag2 == "FAM") {
                s2 = "B";
            } else if (tag2 == "NOTE") {
                s2 = "C";
            } else if (tag2 == "SOUR") {
                s2 = "D";
            } else if (tag2 == "REPO") {
                s2 = "E";
            } else if (tag2 == "SUBM") {
                s2 = "F";
            }
            if (s1.compareTo(s2) != 0) {
                return s1.compareTo(s2);
            }
            n1 = ReportToolBox.extractNumber(id1);
            n2 = ReportToolBox.extractNumber(id2);
            return n1 - n2;
        }
    };

    public boolean usesStandardOut() {
        return false;
    }

    public void start(Gedcom gedcom) {
        this.start(gedcom, null);
    }

    private void start(Gedcom gedcom, Indi indiDeCujus) {
        boolean ret = false;
        String title = this.translate("option_title") + " " + this.toolToRuns[this.toolToRun];
        this.log = new Log(this, title, this.translate("chooseLog"), this.logOption);
        if (this.logOption && (this.log == null || !this.log.writeFile)) {
            return;
        }
        switch (this.toolToRun) {
            case 0: {
                SettingIDs settings = new SettingIDs();
                if (!this.getOptionsFromUser(title, settings)) {
                    return;
                }
                ret = this.toolSettingIDs(gedcom, settings);
                break;
            }
            case 1: {
                SettingTreeTops settings = new SettingTreeTops();
                if (!this.getOptionsFromUser(title, settings)) {
                    return;
                }
                ret = this.toolGeneSosaNbs(gedcom, settings, indiDeCujus, this.toolToRun);
                break;
            }
            case 2: {
                SettingRmTags settings = new SettingRmTags();
                if (!this.getOptionsFromUser(title, settings)) {
                    return;
                }
                ret = this.deleteTags(gedcom, settings.removeTag, settings.entToDo);
                break;
            }
            case 3: {
                SettingMngPlaceTags settings = new SettingMngPlaceTags();
                if (!this.getOptionsFromUser(title, settings)) {
                    return;
                }
                ret = this.managePlaces(gedcom, settings);
                break;
            }
            case 4: {
                SettingMngAssoTags settings = new SettingMngAssoTags();
                if (!this.getOptionsFromUser(title, settings)) {
                    return;
                }
                ret = this.manageAsso(gedcom, settings);
                break;
            }
            case 5: {
                SettingGeneGivnSurn settings = new SettingGeneGivnSurn();
                if (!this.getOptionsFromUser(title, settings)) {
                    return;
                }
                ret = this.geneGivnSurn(gedcom, settings);
                break;
            }
            case 6: {
                SettingGeneAge settings = new SettingGeneAge();
                if (!this.getOptionsFromUser(title, settings)) {
                    return;
                }
                ret = this.geneAges(gedcom, settings);
                break;
            }
            default: {
                throw new IllegalArgumentException("no such report type");
            }
        }
        if (ret) {
            this.log.write(this.translate("Completed"));
        } else {
            this.log.write(this.translate("Error"));
        }
        if (this.logOption) {
            this.log.close();
        }
    }

    private boolean toolSettingIDs(Gedcom gedcom, Object object) {
        final SettingIDs settings = (SettingIDs)object;
        String[] entityTypes = new String[]{"all", "INDI", "FAM", "NOTE", "SOUR", "SUBM", "REPO"};
        int pad = 1;
        if (settings.paddingId > 0 && settings.paddingId < 11) {
            pad = settings.paddingId;
        }
        final DecimalFormat formatNbrs = new DecimalFormat("000000000000".substring(0, pad));
        for (int i = 0; i < entityTypes.length; ++i) {
            if (i == 0 || settings.entToDo != 0 && settings.entToDo != i) continue;
            Collection entities = gedcom.getEntities(entityTypes[i]);
            final String entityIDPrefix = gedcom.getNextAvailableID(entityTypes[i]).substring(0, 1);
            final TreeMap<String, String> listID = new TreeMap<String, String>();
            this.log.write(this.translate("Entity") + " " + entityTypes[i] + "...");
            this.log.write("(" + this.translate("MustPrefix") + " '" + entityIDPrefix + "')");
            for (Entity entity : entities) {
                String ID = entity.getId();
                String key = entity.toString();
                listID.put(key, ID);
            }
            this.log.write(this.translate("Size") + " " + listID.size());
            try {
                gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        String newID;
                        Entity entity;
                        String oldID;
                        int iCounter = 0;
                        for (String key : listID.keySet()) {
                            oldID = (String)listID.get(key);
                            entity = gedcom.getEntity(oldID);
                            ReportToolBox.this.log.write(oldID + " --> " + entityIDPrefix + settings.prefixID + formatNbrs.format(++iCounter) + settings.suffixID, false);
                            newID = entityIDPrefix + settings.prefixID + "XYZAWZ" + iCounter + settings.suffixID;
                            try {
                                entity.setId(newID);
                                listID.put(key, newID);
                            }
                            catch (GedcomException e) {
                                ReportToolBox.this.log.write(e.getMessage());
                            }
                        }
                        iCounter = 0;
                        for (String key : listID.keySet()) {
                            oldID = (String)listID.get(key);
                            entity = gedcom.getEntity(oldID);
                            newID = entityIDPrefix + settings.prefixID + formatNbrs.format(++iCounter) + settings.suffixID;
                            try {
                                entity.setId(newID);
                            }
                            catch (GedcomException e) {
                                ReportToolBox.this.log.write(e.getMessage());
                            }
                        }
                    }
                });
                continue;
            }
            catch (GedcomException e) {
                this.log.write(e.getMessage());
            }
        }
        this.log.write(this.translate("EntityIdDone"));
        return true;
    }

    private boolean toolGeneSosaNbs(Gedcom gedcom, Object object, Indi indiDeCujus, int action) {
        String msg;
        DecimalFormat formatNbrs = new DecimalFormat("0");
        SettingSosas settings1 = new SettingSosas();
        SettingTreeTops settings2 = new SettingTreeTops();
        settings2 = (SettingTreeTops)object;
        String tagStr = settings2.treeTopTag;
        if (indiDeCujus == null && (indiDeCujus = (Indi)this.getEntityFromUser(msg = this.translate(this.toolToRuns[action]) + " - " + this.translate("AskDeCujus"), gedcom, "INDI")) == null) {
            return false;
        }
        this.deleteTags(gedcom, tagStr, 1);
        ArrayList<Pair> sosaList = new ArrayList<Pair>();
        Pair pair = new Pair("", 0);
        String indiID = "";
        int sosaCounter = 0;
        int sosaFathers = 0;
        int sosaMothers = 0;
        boolean sosaDabo = false;
        boolean sosaOSiblings = false;
        boolean sosaYSiblings = false;
        int treeTops = 0;
        sosaList.add(new Pair(indiDeCujus.getId(), 1));
        if (action == 1 && settings2.DisplayIndi) {
            String line = "-----------------------------------------------------------";
            this.log.write(this.translate("DisplayIndi"));
            this.log.write(line.substring(0, this.translate("DisplayIndi").length()));
        }
        ListIterator<Pair> listIter = sosaList.listIterator();
        while (listIter.hasNext()) {
            pair = (Pair)listIter.next();
            indiID = pair.ID;
            sosaCounter = pair.sosa;
            Indi indi = (Indi)gedcom.getEntity(indiID);
            Fam famc = indi.getFamilyWhereBiologicalChild();
            if (famc != null) {
                Indi indiOther = famc.getWife();
                if (indiOther != null) {
                    listIter.add(new Pair(indiOther.getId(), 2 * sosaCounter + 1));
                    listIter.previous();
                    ++sosaMothers;
                }
                if ((indiOther = famc.getHusband()) == null) continue;
                listIter.add(new Pair(indiOther.getId(), 2 * sosaCounter));
                listIter.previous();
                ++sosaFathers;
                continue;
            }
            if (action != 1 || indi.getProperty(tagStr) != null) continue;
            indi.addProperty(tagStr, settings2.treeTopValue);
            ++treeTops;
            this.log.write(indi.toString(), settings2.DisplayIndi);
        }
        formatNbrs = new DecimalFormat("000000");
        if (action == 1) {
            this.log.write(" ");
            this.log.write(" ");
            this.log.write(this.translate("CreatedTT") + " " + formatNbrs.format(treeTops));
            this.log.write(" ");
        }
        this.changeGedcom(gedcom);
        return true;
    }

    private boolean deleteTags(Gedcom gedcom, String removeTag, int entityType) {
        String[] entityTypes = new String[]{"all", "INDI", "FAM", "NOTE", "SOUR", "SUBM", "REPO"};
        this.log.write(this.translate("deleting_tag") + " " + removeTag + "...");
        this.log.write(" ");
        Collection entities = null;
        entities = entityType == 0 ? gedcom.getEntities() : gedcom.getEntities(entityTypes[entityType]);
        final String tag = removeTag;
        final ArrayList listEntities = new ArrayList(entities);
        Gedcom gedFile = gedcom;
        Collections.sort(listEntities, this.sortEntities);
        try {
            gedcom.doUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) throws GedcomException {
                    int iCounter = 0;
                    ArrayList propsToDelete = new ArrayList();
                    for (Entity ent : listEntities) {
                        ReportToolBox.this.getPropertiesRecursively((Property)ent, propsToDelete, tag);
                        for (Property prop : propsToDelete) {
                            Property parent;
                            if (prop == null || (parent = prop.getParent()) == null) continue;
                            String propText = parent.getTag() + " " + tag + " '" + prop.toString() + "'";
                            parent.delProperty(prop);
                            ++iCounter;
                            ReportToolBox.this.log.write(ent.getTag() + " " + ent.toString() + " - " + ReportToolBox.this.translate("DeletedProp") + ": " + propText, false);
                        }
                    }
                    DecimalFormat formatNbrs = new DecimalFormat("000000");
                    ReportToolBox.this.log.write(" ");
                    ReportToolBox.this.log.write(ReportToolBox.this.translate("DeletedNb") + " " + formatNbrs.format(iCounter));
                    if (ReportToolBox.this.logOption) {
                        ReportToolBox.this.log.write(ReportToolBox.this.translate("Details"));
                    }
                    ReportToolBox.this.log.write(" ");
                }
            });
        }
        catch (GedcomException e) {
            this.log.write(e.getMessage());
        }
        this.changeGedcom(gedcom);
        return true;
    }

    private void getPropertiesRecursively(Property parent, List props, String tag) {
        Property[] children = parent.getProperties();
        for (int c = 0; c < children.length; ++c) {
            Property child = children[c];
            if (child.getTag().compareTo(tag) == 0) {
                props.add(child);
            }
            this.getPropertiesRecursively(child, props, tag);
        }
    }

    private boolean managePlaces(Gedcom gedcom, SettingMngPlaceTags setting) {
        this.log.write(" ");
        this.log.write(this.translate("placeAssessingCurrent"));
        String[] tags = this.validatePlaceFormat(gedcom.getPlaceFormat());
        String currentPlaceFormat = this.convertPlaceFormat(tags);
        int size = tags != null ? tags.length : 0;
        List entities = gedcom.getEntities();
        ArrayList placesProps = new ArrayList();
        for (Entity ent : entities) {
            if (ent.getTag().equalsIgnoreCase("HEAD")) continue;
            this.getPropertiesRecursively((Property)ent, placesProps, "PLAC");
        }
        int volume = placesProps.size();
        int[] counters = new int[100];
        int max = 0;
        ArrayList<Property> anomalies = new ArrayList<Property>();
        for (Property prop : placesProps) {
            String[] place = prop.toString().split("\\,", -1);
            if (size > 0 && place.length != size) {
                if (this.isEmpty(place) && setting.emptyTagsAllowed) continue;
                anomalies.add(prop);
            }
            if (place.length > max) {
                max = place.length;
            }
            for (int i = 0; i < Math.min(counters.length, place.length); ++i) {
                if (place[i].length() == 0) continue;
                int n = i;
                counters[n] = counters[n] + 1;
            }
        }
        this.log.write(" ");
        this.log.write(this.translate("placeStats"));
        this.log.write("   " + this.translate("placeVolume") + ": " + volume);
        this.log.write("   " + this.translate("placeMax") + ": " + max);
        this.log.write("   " + this.translate("placeFieldsCount"));
        for (int i = 0; i < Math.min(max, 100); ++i) {
            String field = i < size ? tags[i] : "" + (i + 1);
            this.log.write("      " + field + ":\t" + counters[i]);
        }
        this.log.write(" ");
        this.log.write(this.translate("placeAnomalies"));
        for (Property prop : anomalies) {
            this.log.write("   " + prop.getEntity().getId() + " -  " + prop.getPath().toString() + ":" + prop.toString());
        }
        if (anomalies.size() == 0) {
            this.log.write("   " + this.translate("placeNoAnomalies"));
        }
        boolean[] flags = this.getFlagsFromUser(size > 0, volume > 0, this.translate("placeInputChoice"));
        String newPlaceFormat = "";
        String[] tags1 = null;
        if (flags[0]) {
            this.log.write(" ");
            this.log.write(this.translate("placeAssessingNew"));
            newPlaceFormat = this.getValueFromUser("keyNewPlace", this.translate("placeInputNew") + " - " + currentPlaceFormat);
            if (newPlaceFormat == null) {
                return false;
            }
            tags1 = this.validatePlaceFormat(newPlaceFormat);
            newPlaceFormat = this.convertPlaceFormat(tags1);
            gedcom.setPlaceFormat(newPlaceFormat);
            this.log.write("   " + this.translate("placeFormatChangedTo"));
            this.log.write("   " + newPlaceFormat);
        }
        int[] placeMap = null;
        if (flags[1]) {
            int i;
            this.log.write(" ");
            this.log.write(this.translate("placeMapping"));
            placeMap = new int[tags1.length];
            ArrayList<Object> tags2 = null;
            ArrayList<Object> tagsTemp = null;
            if (tags == null) {
                tags2 = new ArrayList();
                tagsTemp = new ArrayList();
            } else {
                tags2 = new ArrayList<String>(Arrays.asList(tags));
                tagsTemp = new ArrayList<String>(Arrays.asList(tags));
            }
            for (i = tags2.size(); i < tags1.length; ++i) {
                tags2.add(this.translate("placeNewField") + " (" + (i + 1) + ")");
                tagsTemp.add(this.translate("placeNewField") + " (" + (i + 1) + ")");
            }
            for (i = 0; i < tags1.length; ++i) {
                String tag = tags1[i];
                String msg2 = this.translate("placeAskMapping", new Object[]{tag});
                String selection = (String)this.getValueFromUser(msg2, tags2.toArray(), tags2.get(0));
                int iSel = 0;
                if (selection == null) {
                    selection = (String)tags2.get(0);
                }
                iSel = tags2.indexOf(selection);
                placeMap[i] = tagsTemp.indexOf(selection);
                this.log.write("   " + tags1[i] + " <- " + tags2.get(iSel));
                if (tags2.size() <= 1) continue;
                tags2.remove(iSel);
            }
        }
        if (flags[2]) {
            this.log.write(" ");
            this.log.write(this.translate("placeRemapping"));
            if (placeMap == null) {
                placeMap = new int[size];
                for (int i = 0; i < size; ++i) {
                    placeMap[i] = i;
                }
            }
            final int[] uowplaceMap = placeMap;
            final ArrayList uowplacesProps = placesProps;
            try {
                gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        int changes = 0;
                        for (Property propPlace : uowplacesProps) {
                            String place = propPlace.toString();
                            String[] placeTab = place.split("\\,", -1);
                            String newPlace = "";
                            for (int i = 0; i < uowplaceMap.length; ++i) {
                                newPlace = uowplaceMap[i] < placeTab.length ? newPlace + placeTab[uowplaceMap[i]].trim() + "," : newPlace + ",";
                            }
                            newPlace = newPlace.substring(0, newPlace.length() - 1);
                            propPlace.setValue(newPlace);
                            ++changes;
                        }
                        ReportToolBox.this.log.write("   " + ReportToolBox.this.translate("placeChanged") + ": " + changes);
                    }
                });
            }
            catch (GedcomException e) {
                this.log.write(e.getMessage());
            }
        }
        if (flags[3]) {
            final Gedcom uowGedcom = gedcom;
            try {
                gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        uowGedcom.setPlaceFormat("");
                        Entity entity = uowGedcom.createEntity("INDI", uowGedcom.getNextAvailableID("INDI"));
                        uowGedcom.deleteEntity(entity);
                    }
                });
            }
            catch (GedcomException e) {
                this.log.write(e.getMessage());
            }
            this.log.write(" ");
            this.log.write(this.translate("placeRemoved"));
        }
        this.log.write(" ");
        this.changeGedcom(gedcom);
        return true;
    }

    private boolean manageAsso(Gedcom gedcom, SettingMngAssoTags setting) {
        this.log.write(this.translate("processing_tag") + " RELA...");
        this.log.write(" ");
        List entities = gedcom.getEntities();
        final ArrayList listEntities = new ArrayList(entities);
        final Properties rela_properties = new Properties();
        String exportFile = null;
        Gedcom gedcomX = null;
        if (setting.action == 0) {
            this.log.write(this.translate("SettingMngAssoTags.test"));
            this.log.write(" ");
        }
        if (setting.action == 1) {
            this.log.write(this.translate("SettingMngAssoTags.remove"));
            this.log.write(" ");
        }
        if (setting.action == 0 || setting.action == 1) {
            try {
                gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        int iCounter = 0;
                        for (Entity ent : listEntities) {
                            Property[] relaToDelete = ent.getProperties(new TagPath(".:ASSO:RELA"));
                            for (int i = 0; i < relaToDelete.length; ++i) {
                                Property prop = relaToDelete[i];
                                if (prop == null) continue;
                                String strParent = prop.getParent().getValue();
                                String strFrom = prop.getValue();
                                if (strFrom == null || strFrom.lastIndexOf("@") <= 0) continue;
                                String strTo = strFrom.substring(0, strFrom.lastIndexOf("@"));
                                String logText = prop.getTag() + " RELA " + strFrom;
                                String strKey = ent.getId() + strParent + strTo;
                                String strExists = rela_properties.getProperty(strKey);
                                if (strExists != null) {
                                    ReportToolBox.this.log.write(ReportToolBox.this.translate("WarningDuplicate", new Object[]{ent.toString()}));
                                }
                                rela_properties.setProperty(strKey, strFrom);
                                ++iCounter;
                                ReportToolBox.this.log.write(ent.getTag() + " " + ent.toString() + " - " + strParent + " - " + ReportToolBox.this.translate("ProcessedProp") + ": " + strFrom + " => " + strTo, false);
                            }
                        }
                        DecimalFormat formatNbrs = new DecimalFormat("000000");
                        ReportToolBox.this.log.write(" ");
                        ReportToolBox.this.log.write(ReportToolBox.this.translate("ProcessedNb") + " " + formatNbrs.format(iCounter));
                        if (ReportToolBox.this.logOption) {
                            ReportToolBox.this.log.write(ReportToolBox.this.translate("DetailsProcessed"));
                        }
                        ReportToolBox.this.log.write(" ");
                    }
                });
            }
            catch (GedcomException e) {
                this.log.write(e.getMessage());
            }
            try {
                String fileName = gedcom.getOrigin().getFile().getParentFile().getAbsolutePath() + File.separator + gedcom.getOrigin().getName() + "_rela.txt";
                FileOutputStream out = new FileOutputStream(fileName);
                if (out != null) {
                    rela_properties.store(out, "");
                    ((OutputStream)out).close();
                    this.log.write(this.translate("RelaFile") + " " + fileName);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                String gedcomFile = gedcom.getOrigin().getFile().getAbsolutePath();
                exportFile = gedcom.getOrigin().getFile().getParentFile().getAbsolutePath() + File.separator + gedcom.getOrigin().getName() + "_export.ged";
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(gedcomFile));
                FileOutputStream out = new FileOutputStream(exportFile);
                if (in != null && out != null) {
                    int bytes_read;
                    Object export = null;
                    String record = null;
                    int LINE_SIZE = 512;
                    byte[] bufferIn = new byte[LINE_SIZE];
                    byte[] bufferOut = new byte[LINE_SIZE];
                    int recCount = 0;
                    int i = 0;
                    in.mark(LINE_SIZE);
                    block10: while ((bytes_read = in.read(bufferIn)) != -1) {
                        for (i = 0; i < bytes_read; ++i) {
                            int j;
                            if (bufferIn[i] != System.getProperty("line.separator").charAt(0)) continue;
                            ++recCount;
                            record = new String(bufferIn, 0, i);
                            if (record.startsWith("2 RELA")) {
                                j = 0;
                                while (bufferIn[j] != "@".charAt(0)) {
                                    bufferOut[j] = bufferIn[j];
                                    ++j;
                                }
                                out.write(bufferOut, 0, j);
                                out.write(System.getProperty("line.separator").charAt(0));
                            } else {
                                for (j = 0; j <= i; ++j) {
                                    bufferOut[j] = bufferIn[j];
                                }
                                out.write(bufferOut, 0, i + 1);
                            }
                            in.reset();
                            in.skip(i + 1);
                            in.mark(LINE_SIZE);
                            continue block10;
                        }
                    }
                    out.close();
                    this.log.write(this.translate("ExportFile", new Object[]{exportFile, String.valueOf(recCount)}));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (setting.action == 0) {
            this.log.write(" ");
            this.log.write(this.translate("Opening Export"));
            gedcomX = this.openGedcomFile(exportFile);
        }
        if (setting.action == 2) {
            gedcomX = gedcom;
        }
        if (setting.action == 0 || setting.action == 2) {
            this.log.write(this.translate("SettingMngAssoTags.restore"));
            this.log.write(" ");
            entities = gedcomX.getEntities();
            final ArrayList listEntitiesX = new ArrayList(entities);
            String fileName = "";
            try {
                File file = this.getFileFromUser(this.translate("ImportTags"), AbstractAncestrisAction.TXT_OK);
                if (file == null) {
                    return false;
                }
                fileName = file.getAbsolutePath();
                FileInputStream in = new FileInputStream(fileName);
                if (in != null) {
                    rela_properties.load(in);
                    ((InputStream)in).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.log.write(this.translate("NoRelaFile") + " " + fileName);
                return false;
            }
            try {
                gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcomX) throws GedcomException {
                        int iCounter = 0;
                        for (Entity ent : listEntitiesX) {
                            Property[] relaToDelete = ent.getProperties(new TagPath(".:ASSO:RELA"));
                            for (int i = 0; i < relaToDelete.length; ++i) {
                                String strKey;
                                String strTo;
                                Property prop = relaToDelete[i];
                                if (prop == null) continue;
                                String strParent = prop.getParent().getValue();
                                String strFrom = prop.getValue();
                                if (strFrom == null || (strTo = rela_properties.getProperty(strKey = ent.getId() + strParent + strFrom.substring(0, strFrom.lastIndexOf("@")))) == null || strTo.length() == 0) continue;
                                String logText = prop.getTag() + " RELA " + strFrom;
                                prop.setValue(strTo);
                                ++iCounter;
                                ReportToolBox.this.log.write(ent.getTag() + " " + ent.toString() + " - " + strParent + " - " + ReportToolBox.this.translate("ProcessedProp") + ": " + strTo, false);
                            }
                        }
                        DecimalFormat formatNbrs = new DecimalFormat("000000");
                        ReportToolBox.this.log.write(" ");
                        ReportToolBox.this.log.write(ReportToolBox.this.translate("ProcessedNb") + " " + formatNbrs.format(iCounter));
                        if (ReportToolBox.this.logOption) {
                            ReportToolBox.this.log.write(ReportToolBox.this.translate("DetailsProcessed"));
                        }
                        ReportToolBox.this.log.write(" ");
                    }
                });
            }
            catch (GedcomException e) {
                this.log.write(e.getMessage());
            }
            this.changeGedcom(gedcomX);
        }
        if (setting.action == 0) {
            this.saveGedcom(gedcomX);
        }
        this.log.write(" ");
        return true;
    }

    private boolean geneGivnSurn(Gedcom gedcom, Object object) {
        final SettingGeneGivnSurn settings = (SettingGeneGivnSurn)object;
        Collection entities = gedcom.getEntities("INDI");
        final ArrayList listEntities = new ArrayList(entities);
        Gedcom gedFile = gedcom;
        try {
            gedcom.doUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) throws GedcomException {
                    boolean iCounter = false;
                    boolean propChange = false;
                    int rep = 0;
                    ArrayList propsToChange = new ArrayList();
                    for (Indi indi : listEntities) {
                        String firstname;
                        String surname = indi.getLastName();
                        if (ReportToolBox.this.isToBeExcluded(surname, firstname = indi.getFirstName(), settings.geneExclude)) {
                            ReportToolBox.this.log.write(ReportToolBox.this.translate("geneExcluded") + " : " + indi.toString());
                            continue;
                        }
                        String surnValue = "";
                        String givnValue = "";
                        String surnValueNew = "";
                        String givnValueNew = "";
                        Property surnProp = indi.getPropertyByPath("INDI:NAME:SURN");
                        Property givnProp = indi.getPropertyByPath("INDI:NAME:GIVN");
                        if (surnProp != null) {
                            surnValue = surnProp.toString();
                        }
                        if (givnProp != null) {
                            givnValue = givnProp.toString();
                        }
                        if (surname.length() > 0 && (surnProp == null || surnValue.length() == 0)) {
                            surnValueNew = surname;
                            propChange = true;
                        }
                        if (firstname.length() > 0 && (givnProp == null || givnValue.length() == 0)) {
                            givnValueNew = firstname;
                            propChange = true;
                        }
                        if (propChange) {
                            Property propName = indi.getPropertyByPath("INDI:NAME");
                            if (surnValueNew.length() == 0) {
                                surnValueNew = surnValue;
                            }
                            if (givnValueNew.length() == 0) {
                                givnValueNew = givnValue;
                            }
                            String msg = surname + ", " + firstname + " (" + indi.getId().toString() + ") :\r\n   SURN: '" + surnValue + "'\t ==> \t'" + surnValueNew + "'\r\n   GIVN: '" + givnValue + "'\t ==> \t'" + givnValueNew + "'";
                            if (settings.geneAuto || (rep = JOptionPane.showConfirmDialog(null, msg, ReportToolBox.this.translate("geneGSAsk"), 1)) == 0) {
                                if (surnProp == null) {
                                    propName.addProperty("SURN", surnValueNew);
                                } else {
                                    surnProp.setValue(surnValueNew);
                                }
                                if (givnProp == null) {
                                    propName.addProperty("GIVN", givnValueNew);
                                } else {
                                    givnProp.setValue(givnValueNew);
                                }
                                ReportToolBox.this.log.write(msg);
                            }
                            propChange = false;
                        }
                        if (rep != 2) continue;
                        ReportToolBox.this.log.write(ReportToolBox.this.translate("geneGSCancel"));
                        break;
                    }
                }
            });
        }
        catch (GedcomException e) {
            this.log.write(e.getMessage());
        }
        this.changeGedcom(gedcom);
        return true;
    }

    private boolean geneAges(Gedcom gedcom, Object object) {
        final SettingGeneAge settings = (SettingGeneAge)object;
        this.log.write(this.translate("geneAgeUpdatedIndi") + " : ");
        ArrayList entities = new ArrayList(gedcom.getEntities("INDI"));
        Collections.sort(entities, this.sortEntities);
        final ArrayList listEntities = new ArrayList(entities);
        Gedcom gedFile = gedcom;
        try {
            gedcom.doUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) throws GedcomException {
                    ArrayList propsToChange = new ArrayList();
                    for (Indi indi : listEntities) {
                        if (!settings.geneForce && !ReportToolBox.this.preciseBirth(indi)) continue;
                        ReportToolBox.this.updateAge(indi, "ADOP", settings.geneForce, settings.geneRefresh);
                        ReportToolBox.this.updateAge(indi, "CHR", settings.geneForce, settings.geneRefresh);
                        ReportToolBox.this.updateAge(indi, "DEAT", settings.geneForce, settings.geneRefresh);
                        ReportToolBox.this.updateAge(indi, "GRAD", settings.geneForce, settings.geneRefresh);
                        ReportToolBox.this.updateAge(indi, "EVEN", settings.geneForce, settings.geneRefresh);
                        ReportToolBox.this.updateAge(indi, "IMMI", settings.geneForce, settings.geneRefresh);
                        ReportToolBox.this.updateAge(indi, "NATU", settings.geneForce, settings.geneRefresh);
                    }
                }
            });
        }
        catch (GedcomException e) {
            this.log.write(e.getMessage());
        }
        this.log.write(" ");
        this.log.write(" ");
        this.log.write(" ");
        this.log.write(this.translate("geneAgeUpdatedFam") + " : ");
        entities = new ArrayList(gedcom.getEntities("FAM"));
        Collections.sort(entities, this.sortEntities);
        final ArrayList listFamilies = new ArrayList(entities);
        try {
            gedcom.doUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) throws GedcomException {
                    ArrayList propsToChange = new ArrayList();
                    for (Fam fam : listFamilies) {
                        ReportToolBox.this.updateAge(fam, "MARR", settings.geneForce, settings.geneRefresh);
                        ReportToolBox.this.updateAge(fam, "MARS", settings.geneForce, settings.geneRefresh);
                        ReportToolBox.this.updateAge(fam, "DIV", settings.geneForce, settings.geneRefresh);
                        ReportToolBox.this.updateAge(fam, "DIVF", settings.geneForce, settings.geneRefresh);
                        ReportToolBox.this.updateAge(fam, "ENGA", settings.geneForce, settings.geneRefresh);
                        ReportToolBox.this.updateAge(fam, "EVEN", settings.geneForce, settings.geneRefresh);
                    }
                }
            });
        }
        catch (GedcomException e) {
            this.log.write(e.getMessage());
        }
        this.changeGedcom(gedcom);
        this.log.write(" ");
        this.log.write(" ");
        return true;
    }

    private int setPropertyPosition(Property prop) {
        if (prop == null) {
            return 1;
        }
        Property pName = prop.getProperty("NAME");
        if (pName == null) {
            return 1;
        }
        return prop.getPropertyPosition(pName) + 1;
    }

    private void updateAge(Indi indi, String eventTag, boolean force, boolean refresh) {
        boolean preciseDate = false;
        boolean afterDeath = false;
        Property evenProp = indi.getPropertyByPath("INDI:" + eventTag);
        if (evenProp != null) {
            Property prop = indi.getPropertyByPath("INDI:" + eventTag + ":DATE");
            if (prop != null && prop instanceof PropertyDate) {
                PropertyDate pDate = (PropertyDate)prop;
                preciseDate = this.preciseDate(pDate);
                PropertyDate deathDate = indi.getDeathDate();
                if (deathDate != null && deathDate.isValid() && pDate.compareTo((Property)deathDate) > 0) {
                    afterDeath = true;
                }
            }
            PropertyAge ageProp = (PropertyAge)indi.getPropertyByPath("INDI:" + eventTag + ":AGE");
            this.updateAge(indi, evenProp, ageProp, eventTag, force, refresh, preciseDate, afterDeath);
        }
    }

    private void updateAge(Fam fam, String eventTag, boolean force, boolean refresh) {
        Indi husband = fam.getHusband();
        Indi wife = fam.getWife();
        boolean preciseDate = false;
        boolean afterDeathHusband = false;
        boolean afterDeathWife = false;
        Property evenProp = fam.getPropertyByPath("FAM:" + eventTag);
        String msg = "";
        boolean famChanged = false;
        if (evenProp != null) {
            PropertyAge ageProp;
            Property prop = fam.getPropertyByPath("FAM:" + eventTag + ":DATE");
            if (prop != null && prop instanceof PropertyDate) {
                PropertyDate deathDateWife;
                PropertyDate deathDateHusband;
                PropertyDate pDate = (PropertyDate)prop;
                preciseDate = this.preciseDate(pDate);
                PropertyDate propertyDate = deathDateHusband = husband == null ? null : husband.getDeathDate();
                if (deathDateHusband != null && deathDateHusband.isValid() && pDate.compareTo((Property)deathDateHusband) > 0) {
                    afterDeathHusband = true;
                }
                PropertyDate propertyDate2 = deathDateWife = wife == null ? null : wife.getDeathDate();
                if (deathDateWife != null && deathDateWife.isValid() && pDate.compareTo((Property)deathDateWife) > 0) {
                    afterDeathWife = true;
                }
            }
            if (husband != null && (this.preciseBirth(husband) && preciseDate && !afterDeathHusband || force && !afterDeathHusband)) {
                Property pHusb = fam.getPropertyByPath("FAM:" + eventTag + ":HUSB");
                if (pHusb == null) {
                    pHusb = evenProp.addProperty("HUSB", "");
                    this.log.write("  " + this.translate("geneEventAddingHusb"));
                    famChanged = true;
                }
                ageProp = (PropertyAge)pHusb.getProperty("AGE");
                famChanged |= this.updateAge(husband, pHusb, ageProp, eventTag, force, refresh, preciseDate, afterDeathHusband);
            }
            if (wife != null && (this.preciseBirth(wife) && preciseDate && !afterDeathWife || force && !afterDeathWife)) {
                Property pWife = fam.getPropertyByPath("FAM:" + eventTag + ":WIFE");
                if (pWife == null) {
                    pWife = evenProp.addProperty("WIFE", "");
                    this.log.write("  " + this.translate("geneEventAddingWife"));
                    famChanged = true;
                }
                ageProp = (PropertyAge)pWife.getProperty("AGE");
                famChanged |= this.updateAge(wife, pWife, ageProp, eventTag, force, refresh, preciseDate, afterDeathWife);
            }
            if (famChanged) {
                this.log.write("      " + this.translate("geneEventFam") + " " + fam.toString() + " - " + eventTag + ":");
                this.log.write(" ");
            }
        }
    }

    private boolean updateAge(Indi indi, Property prop, PropertyAge ageProp, String eventTag, boolean force, boolean refresh, boolean preciseDate, boolean afterDeath) {
        boolean ret = false;
        if (!(force || preciseDate && this.preciseBirth(indi))) {
            return false;
        }
        if (afterDeath) {
            this.log.write("   " + indi.toString() + " - " + eventTag + " " + this.translate("geneEventAfterDeath"));
            ret = true;
        }
        if (ageProp == null && !afterDeath) {
            ageProp = (PropertyAge)prop.addProperty("AGE", "0d");
            ageProp.updateAge();
            if (!force && ageProp.getValue().toString().compareTo("0d") == 0) {
                Property parent = ageProp.getParent();
                parent.delProperty((Property)ageProp);
                Property grandParent = parent.getParent();
                if (grandParent != null && (parent.getTag().equals("HUSB") || parent.getTag().equals("WIFE"))) {
                    grandParent.delProperty(parent);
                    this.log.write("   " + indi.toString() + " - " + eventTag + " - " + this.translate("geneEventRemovingAge"));
                }
                ret = false;
            } else {
                this.log.write("   " + indi.toString() + " - " + eventTag + " - " + this.translate("geneEventAddingAge"));
                ret = true;
            }
        } else if (ageProp != null && (force || refresh)) {
            String ageBefore = ageProp.getValue();
            if (!afterDeath) {
                ageProp.updateAge();
            } else {
                ageProp.setValue("0y");
            }
            String ageAfter = ageProp.getValue();
            if (ageAfter.compareTo(ageBefore) != 0) {
                this.log.write("   " + indi.toString() + " - " + eventTag + " " + this.translate("geneAgeForcedFrom") + ageBefore + " " + this.translate("geneAgeForcedTo") + " " + ageProp.getValue());
                ret = true;
            }
        }
        return ret;
    }

    private boolean isToBeExcluded(String surname, String firstname, String parameter) {
        String[] bits = parameter.split(";");
        for (int i = 0; i < bits.length; ++i) {
            if (!(bits[i].trim().length() == 0 ? surname.trim().length() == 0 || firstname.trim().length() == 0 : surname.indexOf(bits[i]) > -1 || firstname.indexOf(bits[i]) > -1)) continue;
            return true;
        }
        return false;
    }

    private static int extractNumber(String str) {
        int start;
        int end = str.length() - 1;
        for (start = 0; start <= end && !Character.isDigit(str.charAt(start)); ++start) {
        }
        for (end = start; end <= str.length() - 1 && Character.isDigit(str.charAt(end)); ++end) {
        }
        if (end == start) {
            return 0;
        }
        return Integer.parseInt(str.substring(start, end));
    }

    private String[] validatePlaceFormat(String placeFormat) {
        String[] tags = null;
        if (placeFormat.length() == 0) {
            this.log.write("   " + this.translate("noPlaceFormat"));
        } else {
            this.log.write("   " + this.translate("placeFormatToValidate"));
            this.log.write("   " + placeFormat);
            tags = placeFormat.split("\\,", -1);
            for (int i = 0; i < tags.length; ++i) {
                if (tags[i].trim().length() == 0) {
                    this.log.write("   " + this.translate("placeMissingTagMsg") + " (" + (i + 1) + ")");
                    tags[i] = this.translate("placeMissingTag") + "_" + (i + 1);
                    continue;
                }
                tags[i] = tags[i].trim();
            }
        }
        return tags;
    }

    private String convertPlaceFormat(String[] tags) {
        String newPlaceStr = "";
        if (tags == null) {
            return "";
        }
        for (int i = 0; i < tags.length; ++i) {
            newPlaceStr = newPlaceStr + tags[i].trim() + ",";
        }
        newPlaceStr = newPlaceStr.substring(0, newPlaceStr.length() - 1);
        return newPlaceStr;
    }

    private boolean isEmpty(String[] tags) {
        if (tags == null) {
            return true;
        }
        for (int i = 0; i < tags.length; ++i) {
            if (tags[i].trim().length() <= 0) continue;
            return false;
        }
        return true;
    }

    private boolean[] getFlagsFromUser(boolean existPlaceInHeader, boolean existPlaceTags, String msg) {
        String[] todos = new String[]{this.translate("place_assess"), this.translate("place_add"), this.translate("place_remap"), this.translate("place_realign"), this.translate("place_remove")};
        ArrayList<String> choices = new ArrayList<String>(Arrays.asList(todos));
        if (existPlaceInHeader && existPlaceTags) {
            choices.remove(1);
        }
        if (existPlaceInHeader && !existPlaceTags) {
            choices.remove(3);
            choices.remove(2);
        }
        if (!existPlaceInHeader && existPlaceTags) {
            choices.remove(4);
            choices.remove(3);
            choices.remove(1);
        }
        if (!existPlaceInHeader && !existPlaceTags) {
            choices.remove(4);
            choices.remove(3);
            choices.remove(2);
        }
        String todo = (String)this.getValueFromUser(msg, choices.toArray(), choices.get(0));
        boolean[] flags = new boolean[]{false, false, false, false};
        if (todo == todos[1]) {
            flags[0] = true;
        }
        if (todo == todos[2]) {
            flags[0] = true;
            flags[1] = true;
            flags[2] = true;
        }
        if (todo == todos[3]) {
            flags[2] = true;
        }
        if (todo == todos[4]) {
            flags[3] = true;
        }
        return flags;
    }

    private boolean changeGedcom(Gedcom gedcom) {
        final Gedcom uowGedcom = gedcom;
        try {
            gedcom.doUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) throws GedcomException {
                    Entity entity = uowGedcom.createEntity("INDI", uowGedcom.getNextAvailableID("INDI"));
                    uowGedcom.deleteEntity(entity);
                }
            });
        }
        catch (GedcomException e) {
            this.log.write(e.getMessage());
        }
        return true;
    }

    private Gedcom openGedcomFile(String filepath) {
        throw new UnsupportedOperationException("Open gedcom file must be recoded in toolbox");
    }

    private boolean linkGedcom(Gedcom gedcomX) {
        List ents = gedcomX.getEntities();
        for (Entity ent : ents) {
            List ps = ent.getProperties(PropertyXRef.class);
            for (PropertyXRef xref : ps) {
                PropertyXRef target = xref.getTarget();
                if (target != null) continue;
                try {
                    xref.link();
                }
                catch (GedcomException e) {
                    this.log.write("Linking:GedcomException:" + (Object)((Object)e));
                    this.log.write("Warning at Linking: " + (Object)((Object)e));
                    return false;
                }
            }
        }
        return true;
    }

    private boolean saveGedcom(Gedcom gedcomX) {
        throw new UnsupportedOperationException("Save gedcom file must be recoded in toolbox");
    }

    private boolean preciseBirth(Indi indi) {
        if (indi == null) {
            return false;
        }
        return this.preciseDate(indi.getBirthDate());
    }

    private boolean preciseDate(PropertyDate pDate) {
        if (pDate == null || !pDate.isValid() || pDate.isRange()) {
            return false;
        }
        PropertyDate.Format pf = pDate.getFormat();
        if (pf != PropertyDate.DATE) {
            return false;
        }
        PointInTime pit = pDate.getStart();
        return pit.isValid() && pit.isComplete();
    }

    public class SettingGeneAge {
        public boolean geneForce = false;
        public boolean geneRefresh = true;
    }

    public class SettingGeneGivnSurn {
        public boolean geneAuto = false;
        public String geneExclude = "anonyme; ;?;";
    }

    public class SettingMngAssoTags {
        public int action = 1;
        public String[] actions = new String[]{ReportToolBox.this.translate("SettingMngAssoTags.test"), ReportToolBox.this.translate("SettingMngAssoTags.remove"), ReportToolBox.this.translate("SettingMngAssoTags.restore")};
    }

    public class SettingMngPlaceTags {
        public boolean emptyTagsAllowed = false;
    }

    public class SettingRmTags {
        public String removeTag = "_XXXX";
        public int entToDo = 1;
        public String[] entToDos = new String[]{ReportToolBox.this.translate("SettingIDs.All"), ReportToolBox.this.translate("SettingIDs.INDI"), ReportToolBox.this.translate("SettingIDs.FAM"), ReportToolBox.this.translate("SettingIDs.NOTE"), ReportToolBox.this.translate("SettingIDs.SOUR"), ReportToolBox.this.translate("SettingIDs.SUBM"), ReportToolBox.this.translate("SettingIDs.REPO")};
    }

    public class SettingTreeTops {
        public String treeTopTag = "_TREETOP";
        public String treeTopValue = ReportToolBox.this.translate("Find_parents");
        public boolean DisplayIndi = false;
    }

    public class SettingSosas {
        public boolean daboville = false;
        public String olderSign = "+";
        public String youngerSign = "-";
        public int paddingSize = 8;
    }

    public class SettingIDs {
        public int entToDo = 1;
        public String[] entToDos = new String[]{ReportToolBox.this.translate("SettingIDs.All"), ReportToolBox.this.translate("SettingIDs.INDI"), ReportToolBox.this.translate("SettingIDs.FAM"), ReportToolBox.this.translate("SettingIDs.NOTE"), ReportToolBox.this.translate("SettingIDs.SOUR"), ReportToolBox.this.translate("SettingIDs.SUBM"), ReportToolBox.this.translate("SettingIDs.REPO")};
        public String prefixID = "";
        public String suffixID = "";
        public int paddingId = 0;
    }

    private class Pair2 {
        String ID = "";
        String dabo = "";

        public Pair2(String ID, String dabo) {
            this.ID = ID;
            this.dabo = dabo;
        }
    }

    private class Pair {
        String ID = "";
        int sosa = 0;

        public Pair(String ID, int sosa) {
            this.ID = ID;
            this.sosa = sosa;
        }
    }
}

