/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.commonAncestor;

import ancestris.modules.commonAncestor.PreviewTopComponent;
import ancestris.modules.commonAncestor.Renderer;
import ancestris.modules.commonAncestor.Step;
import ancestris.modules.commonAncestor.graphics.GraphicsOutputFactory;
import ancestris.modules.commonAncestor.graphics.IGraphicsOutput;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonAncestorTree {
    private GraphicsOutputFactory outputs = new GraphicsOutputFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Indi> findCommonAncestors(Indi indi1, Indi indi2) {
        try {
            SelectionDispatcher.muteSelection((boolean)true);
            Set<Indi> ancestorList = new LinkedHashSet<Indi>();
            if (indi1 == null || indi2 == null) {
                LinkedHashSet<Indi> linkedHashSet = ancestorList;
                return linkedHashSet;
            }
            if (indi1.isAncestorOf(indi2)) {
                ancestorList.add(indi1);
            } else if (indi2.isAncestorOf(indi1)) {
                ancestorList.add(indi2);
            } else {
                this.getCommonAncestor(indi1, indi2, ancestorList);
                this.getCommonAncestor(indi2, indi1, ancestorList);
                ancestorList = this.filterAncestors(ancestorList);
            }
            LinkedHashSet<Indi> linkedHashSet = ancestorList;
            return linkedHashSet;
        }
        finally {
            SelectionDispatcher.muteSelection((boolean)false);
        }
    }

    public void createPreview(Indi indi1, Indi indi2, Indi ancestor, boolean displayedId, boolean displayRecentYears, int husband_or_wife_first, PreviewTopComponent previewTopComponent) {
        if (indi1 == null || indi2 == null) {
            previewTopComponent.updatePreView(indi1, indi2, new ArrayList<Step>(), new ArrayList<Step>(), displayedId, displayRecentYears, husband_or_wife_first);
        }
        if (ancestor != null) {
            ArrayList<Step> firstIndiDirectLinks = new ArrayList<Step>();
            firstIndiDirectLinks.add(new Step(this.getLastFamilyWhereSpouse(indi1), indi1, indi1.getSex()));
            this.getAncestorListBetween(ancestor, indi1, firstIndiDirectLinks);
            Collections.reverse(firstIndiDirectLinks);
            ArrayList<Step> secondIndiDirectLinks = new ArrayList<Step>();
            secondIndiDirectLinks.add(new Step(this.getLastFamilyWhereSpouse(indi2), indi2, indi2.getSex()));
            this.getAncestorListBetween(ancestor, indi2, secondIndiDirectLinks);
            Collections.reverse(secondIndiDirectLinks);
            previewTopComponent.updatePreView(indi1, indi2, firstIndiDirectLinks, secondIndiDirectLinks, displayedId, displayRecentYears, husband_or_wife_first);
        } else if (ancestor == null) {
            previewTopComponent.updatePreView(indi1, indi2, new ArrayList<Step>(), new ArrayList<Step>(), displayedId, displayRecentYears, husband_or_wife_first);
        }
    }

    public void createCommonTree(Indi indi1, Indi indi2, Indi ancestor, File outputFile, boolean displayedId, boolean displayRecentYears, int husband_or_wife_first, String fileTypeName) {
        if (indi1 == null || indi2 == null) {
            return;
        }
        if (ancestor != null) {
            ArrayList<Step> firstIndiDirectLinks = new ArrayList<Step>();
            firstIndiDirectLinks.add(new Step(this.getLastFamilyWhereSpouse(indi1), indi1, indi1.getSex()));
            this.getAncestorListBetween(ancestor, indi1, firstIndiDirectLinks);
            Collections.reverse(firstIndiDirectLinks);
            ArrayList<Step> secondIndiDirectLinks = new ArrayList<Step>();
            secondIndiDirectLinks.add(new Step(this.getLastFamilyWhereSpouse(indi2), indi2, indi2.getSex()));
            this.getAncestorListBetween(ancestor, indi2, secondIndiDirectLinks);
            Collections.reverse(secondIndiDirectLinks);
            IGraphicsOutput output = this.outputs.createOutput(outputFile, fileTypeName);
            if (output == null) {
                return;
            }
            try {
                output.output(new Renderer(indi1, indi2, firstIndiDirectLinks, secondIndiDirectLinks, displayedId, displayRecentYears, husband_or_wife_first));
            }
            catch (IOException e) {
                System.out.println(e.toString());
                return;
            }
        }
    }

    private Set<Indi> filterAncestors(Set<Indi> ancestorList) {
        LinkedHashSet<Indi> filteredList = new LinkedHashSet<Indi>();
        boolean found = false;
        for (Indi ancestor : ancestorList) {
            found = false;
            Fam[] families = ancestor.getFamiliesWhereSpouse();
            for (int i = 0; i < families.length; ++i) {
                Indi otherSpouse = families[i].getOtherSpouse(ancestor);
                if (!filteredList.contains(otherSpouse)) continue;
                found = true;
            }
            if (found) continue;
            filteredList.add(ancestor);
        }
        return filteredList;
    }

    private Fam getLastFamilyWhereSpouse(Indi indi) {
        Fam[] fams = indi.getFamiliesWhereSpouse();
        if (fams == null || fams.length == 0) {
            return null;
        }
        return fams[fams.length - 1];
    }

    private void getCommonAncestor(Indi firstIndi, Indi secondIndi, Set<Indi> ancestorList) {
        Indi mother;
        Indi father = firstIndi.getBiologicalFather();
        if (father != null) {
            if (father.isAncestorOf(secondIndi)) {
                ancestorList.add(father);
            } else {
                this.getCommonAncestor(father, secondIndi, ancestorList);
            }
        }
        if ((mother = firstIndi.getBiologicalMother()) != null) {
            if (mother.isAncestorOf(secondIndi)) {
                ancestorList.add(mother);
            } else {
                this.getCommonAncestor(mother, secondIndi, ancestorList);
            }
        }
    }

    private void getAncestorListBetween(Indi ancestor, Indi descendant, List<Step> directLinks) {
        Indi link = this.getParentInDirectLine(ancestor, descendant);
        if (link != null) {
            directLinks.add(new Step(descendant.getFamilyWhereBiologicalChild(), link, link.getSex()));
            this.getAncestorListBetween(ancestor, link, directLinks);
        }
    }

    private Indi getParentInDirectLine(Indi ancestor, Indi child) {
        Indi father = child.getBiologicalFather();
        if (father != null && (father.isDescendantOf(ancestor) || father.equals(ancestor))) {
            return father;
        }
        Indi mother = child.getBiologicalMother();
        if (mother != null && (mother.isDescendantOf(ancestor) || mother.equals(ancestor))) {
            return mother;
        }
        return null;
    }

    public Map<String, IGraphicsOutput> getOutputList() {
        return this.outputs.getOutputList();
    }

    public List<String> getFileTypeNames() {
        return this.outputs.getFileTypeNames();
    }
}

