/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.commonAncestor;

import ancestris.modules.commonAncestor.CommonAncestorTopComponent;
import ancestris.modules.commonAncestor.PreviewView;
import ancestris.modules.commonAncestor.Renderer;
import ancestris.modules.commonAncestor.SamePanel;
import ancestris.modules.commonAncestor.Step;
import ancestris.modules.commonAncestor.graphics.IGraphicsOutput;
import ancestris.modules.commonAncestor.graphics.ScreenOutput;
import ancestris.swing.ToolBar;
import genj.gedcom.Context;
import genj.gedcom.Indi;
import genj.util.Registry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreviewTopComponent
extends TopComponent
implements AncestorListener {
    private static final String PREFERRED_ID = "PreviewTopComponent";
    private static final String DOCK_MODE = "dockMode";
    private static final String SEPARATED_WINDOW = "separatedWindow";
    private static final String PREVIEW_ZOOM = "previewZoom";
    private PreviewView view;
    ToolBar bar = null;
    private Context context;
    IGraphicsOutput output = new ScreenOutput();
    protected Registry registry;
    private String dockMode;
    private boolean separatedWindowFlag = false;
    private boolean isDocking = false;
    SamePanel samePanel;

    public static synchronized PreviewTopComponent createInstance(SamePanel samePanel) {
        Context currentContext = null;
        if (samePanel.getContext() != null) {
            currentContext = samePanel.getContext();
        } else {
            Context lookupContext = (Context)Utilities.actionsGlobalContext().lookup(Context.class);
            if (lookupContext != null && lookupContext.getGedcom() != null) {
                currentContext = lookupContext;
            }
        }
        if (currentContext != null) {
            if (currentContext.getGedcom() != null) {
                PreviewTopComponent previewTopComponent = new PreviewTopComponent();
                previewTopComponent.init(currentContext, samePanel);
                previewTopComponent.addAncestorListener(previewTopComponent);
                return previewTopComponent;
            }
            return null;
        }
        return null;
    }

    public void init(Context context, SamePanel samePanel) {
        this.context = context;
        this.samePanel = samePanel;
        this.setName(context.getGedcom().getName());
        this.setToolTipText(NbBundle.getMessage(CommonAncestorTopComponent.class, (String)"HINT_PreviewTopComponent") + ": " + context.getGedcom().getName());
        this.registry = new Registry(Registry.get(PreviewTopComponent.class), this.getClass().getName());
        this.setLayout(new BorderLayout());
        this.view = new PreviewView();
        this.add(this.view, "Center");
        this.view.setZoom(Double.valueOf(this.registry.get(PREVIEW_ZOOM, "1.0")));
        this.bar = new ToolBar();
        this.bar.beginUpdate();
        this.view.populate(this.bar);
        this.bar.endUpdate();
        if (this.bar != null && this.bar.getToolBar() != null) {
            this.bar.setOrientation(0);
            this.add(this.bar.getToolBar(), "North");
        }
        this.repaint();
        this.separatedWindowFlag = this.registry.get(SEPARATED_WINDOW, true);
        this.dockMode = this.registry.get(DOCK_MODE, "ancestris-output");
        if (!this.separatedWindowFlag) {
            this.dock();
        } else {
            this.open();
            this.undock();
        }
    }

    public void dock() {
        Mode mode = WindowManager.getDefault().findMode(this.dockMode);
        if (mode != null) {
            this.isDocking = true;
            mode.dockInto((TopComponent)this);
            this.isDocking = false;
        }
        this.open();
        this.requestActive();
    }

    public void undock() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PreviewTopComponent.this.requestActive();
                KeyEvent evt = new KeyEvent((Component)((Object)PreviewTopComponent.this), 401, System.currentTimeMillis() + 100L, 576, 85, 'U');
                PreviewTopComponent.this.dispatchEvent(evt);
                Dimension dimension = PreviewTopComponent.this.getTopLevelAncestor().getSize();
                if (dimension.width < 600) {
                    dimension.width = 600;
                }
                if (dimension.height < 400) {
                    dimension.height = 400;
                }
                PreviewTopComponent.this.getTopLevelAncestor().setSize(dimension);
            }
        });
    }

    public boolean canClose() {
        if (!this.isDocking) {
            this.registry.put(DOCK_MODE, this.dockMode);
            this.registry.put(SEPARATED_WINDOW, Boolean.valueOf(this.separatedWindowFlag));
            this.registry.put(PREVIEW_ZOOM, Double.toString(this.view.getZoom()));
            this.samePanel.onClosePreview();
        }
        return super.canClose();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public int getPersistenceType() {
        return 2;
    }

    public Image getIcon() {
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/ancestris/modules/commonAncestor/CommonAncestor.png"));
        return icon.getImage();
    }

    public Context getContext() {
        return this.context;
    }

    public void updatePreView(Indi indi1, Indi indi2, List<Step> firstIndiDirectLinks, List<Step> secondIndiDirectLinks, boolean displayedId, boolean displayRecentYears, int husband_or_wife_first) {
        try {
            Renderer renderer = new Renderer(indi1, indi2, firstIndiDirectLinks, secondIndiDirectLinks, displayedId, displayRecentYears, husband_or_wife_first);
            this.view.setRenderer(renderer);
            this.output.output(renderer);
            this.view.showResult(this.output.result());
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public boolean getSeparatedWindowFlag() {
        return this.separatedWindowFlag;
    }

    public void setSeparatedWindowFlag(boolean separatedWindowFlag) {
        this.separatedWindowFlag = separatedWindowFlag;
        if (separatedWindowFlag) {
            this.undock();
        } else {
            this.dock();
        }
    }

    @Override
    public void ancestorAdded(AncestorEvent ae) {
        Mode dockModeTemp = WindowManager.getDefault().findMode((TopComponent)this);
        if (dockModeTemp == null || dockModeTemp != null && dockModeTemp.getName().startsWith("anonymous")) {
            this.separatedWindowFlag = true;
        } else {
            this.separatedWindowFlag = false;
            this.dockMode = dockModeTemp.getName();
        }
    }

    @Override
    public void ancestorRemoved(AncestorEvent ae) {
    }

    @Override
    public void ancestorMoved(AncestorEvent ae) {
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }
}

