/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.commonAncestor;

import ancestris.modules.commonAncestor.Step;
import ancestris.modules.commonAncestor.graphics.IGraphicsRenderer;
import genj.gedcom.Indi;
import genj.gedcom.PropertyDate;
import genj.gedcom.time.PointInTime;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Calendar;
import java.util.List;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Renderer
implements IGraphicsRenderer {
    private static final int FAMILY_WIDTH = 300;
    private static final int FAMILY_HEIGH = 100;
    private static final int SPACE_BETWEEN_RECTANGLES = 20;
    private static final int SPACE_BETWEEN_TITLE_AND_COMMON_ANCESTOR = 30;
    private static final int SPACE_BETWEEN_LINES = 18;
    private static final int SPACE_BEFORE_DATE = 20;
    private static final int SHADOW_SIZE = 3;
    private static final int SPACE_BETWEEN_BORDER_AND_RECTANGLE = 5;
    private static final int SPACE_BETWEEN_BORDER_AND_TITLE = 25;
    private Font boldFontStyle;
    private Font plainFontStyle;
    private Font dateFontStyle;
    private Font titleFontStyle;
    private Font smallFontStyle;
    private final int YEAR_LIMIT_NUMBER = 81;
    private final int YEAR_LIMIT = Calendar.getInstance().get(1) - 81;
    public boolean use_colors = true;
    private boolean displayedId = true;
    public boolean displayRecentYears = true;
    public int husband_or_wife_first = 0;
    public String[] husband_or_wife_firsts = new String[]{"wife", "husband"};
    public int ufont_name = 0;
    public String[] ufont_names = new String[]{"ufont_name.0", "ufont_name.1", "ufont_name.2", "ufont_name.3", "ufont_name.4", "ufont_name.5"};
    private String font_name = "Times-Roman";
    protected static final int OPTION_YESNO = 0;
    protected static final int OPTION_OKCANCEL = 1;
    protected static final int OPTION_OK = 2;
    private double zoom = 1.0;
    private Indi firstIndi;
    private Indi secondIndi;
    private List<Step> firstIndiDirectLinks;
    private List<Step> secondIndiDirectLinks;
    private int width;
    private int height;
    private double cx;
    private double cy;

    public Renderer(Indi firstIndi, Indi secondIndi, List<Step> firstIndiDirectLinks, List<Step> secondIndiDirectLinks, boolean displayedId, boolean displayRecentYears, int husband_or_wife_first) {
        this.firstIndi = firstIndi;
        this.secondIndi = secondIndi;
        this.firstIndiDirectLinks = firstIndiDirectLinks;
        this.secondIndiDirectLinks = secondIndiDirectLinks;
        this.displayedId = displayedId;
        this.displayRecentYears = displayRecentYears;
        this.husband_or_wife_first = husband_or_wife_first;
        this.titleFontStyle = new Font(this.font_name, 1, 20);
        this.boldFontStyle = new Font(this.font_name, 1, 16);
        this.plainFontStyle = new Font(this.font_name, 0, 16);
        this.dateFontStyle = new Font(this.font_name, 0, 12);
        this.smallFontStyle = new Font(this.font_name, 1, 12);
        this.width = 1050;
        this.height = Math.max(firstIndiDirectLinks.size(), secondIndiDirectLinks.size()) * 100 + (Math.max(firstIndiDirectLinks.size(), secondIndiDirectLinks.size()) + 3) * 20 + 20 + 30 + 5 + 25;
        this.cx = this.width / 2;
    }

    @Override
    public void render(Graphics2D graphics) {
        Rectangle2D rect;
        graphics.scale(this.zoom, this.zoom);
        this.cy = 0.0;
        graphics.setPaint(Color.BLACK);
        graphics.setBackground(Color.WHITE);
        graphics.clearRect(0, 0, this.width, this.height);
        if (this.firstIndi == null || this.secondIndi == null) {
            return;
        }
        graphics.drawRoundRect(5, 5, this.width - 10, this.height - 10, 50, 50);
        graphics.setFont(this.plainFontStyle);
        graphics.setStroke(new BasicStroke(2.0f));
        this.cy += 5.0;
        int nbMaxGen = Math.max(this.firstIndiDirectLinks.size(), this.secondIndiDirectLinks.size());
        graphics.setFont(this.titleFontStyle);
        this.cy += 25.0;
        String titleString = this.getTitleLine(this.firstIndi, this.secondIndi, nbMaxGen);
        for (int fontSize = this.titleFontStyle.getSize(); fontSize >= 8 && (int)(rect = graphics.getFont().getStringBounds(titleString, graphics.getFontRenderContext())).getWidth() > this.width - 20; --fontSize) {
            this.titleFontStyle = new Font(this.titleFontStyle.getFontName(), this.titleFontStyle.getStyle(), fontSize);
        }
        this.centerString(graphics, NbBundle.getMessage(Renderer.class, (String)"Renderer.title1"), (int)this.cx, (int)this.cy);
        this.cy += 30.0;
        this.centerString(graphics, this.getTitleLine(this.firstIndi, this.secondIndi, nbMaxGen), (int)this.cx, (int)this.cy);
        this.cy += 30.0;
        if (this.firstIndiDirectLinks.isEmpty() || this.secondIndiDirectLinks.isEmpty()) {
            return;
        }
        int familyWidth = 300;
        String largestName = "";
        for (int i = 1; i < nbMaxGen; ++i) {
            Rectangle2D rect2;
            Step step;
            String name = "";
            if (this.firstIndiDirectLinks.size() > i) {
                step = this.firstIndiDirectLinks.get(i);
                name = this.getNameLine(step.getHusband());
                rect2 = graphics.getFont().getStringBounds(name, graphics.getFontRenderContext());
                if ((int)rect2.getWidth() + 5 > familyWidth) {
                    familyWidth = (int)rect2.getWidth() + 5;
                    largestName = name;
                }
                name = this.getNameLine(step.getWife());
                rect2 = graphics.getFont().getStringBounds(name, graphics.getFontRenderContext());
                if ((int)rect2.getWidth() + 5 > familyWidth) {
                    familyWidth = (int)rect2.getWidth() + 5;
                    largestName = name;
                }
            }
            if (this.secondIndiDirectLinks.size() <= i) continue;
            step = this.secondIndiDirectLinks.get(i);
            name = this.getNameLine(step.getHusband());
            rect2 = graphics.getFont().getStringBounds(name, graphics.getFontRenderContext());
            if ((int)rect2.getWidth() + 5 > familyWidth) {
                familyWidth = (int)rect2.getWidth() + 5;
                largestName = name;
            }
            name = this.getNameLine(step.getWife());
            rect2 = graphics.getFont().getStringBounds(name, graphics.getFontRenderContext());
            if ((int)rect2.getWidth() + 5 <= familyWidth) continue;
            familyWidth = (int)rect2.getWidth() + 5;
            largestName = name;
        }
        if (familyWidth > this.width / 2 - 25) {
            Rectangle2D rect3;
            familyWidth = this.width / 2 - 25;
            graphics.setFont(this.boldFontStyle);
            for (int fontSize = this.boldFontStyle.getSize(); fontSize >= 8 && (int)(rect3 = graphics.getFont().getStringBounds(largestName, graphics.getFontRenderContext())).getWidth() > familyWidth - 5; --fontSize) {
                this.boldFontStyle = new Font(this.boldFontStyle.getFontName(), this.boldFontStyle.getStyle(), fontSize);
                this.plainFontStyle = new Font(this.plainFontStyle.getFontName(), this.plainFontStyle.getStyle(), fontSize);
                graphics.setFont(this.boldFontStyle);
            }
        }
        int cxLeft = (int)(this.cx - 5.0) / 2;
        int cxRight = (int)((double)(this.width - 5) + this.cx) / 2;
        graphics.setFont(this.plainFontStyle);
        this.render(graphics, this.firstIndiDirectLinks.get(0), familyWidth, (int)this.cx);
        graphics.drawLine((int)this.cx, (int)this.cy + 100, (int)this.cx, (int)this.cy + 100 + 20);
        if (this.firstIndiDirectLinks.size() > 1) {
            graphics.drawLine(cxLeft, (int)this.cy + 100 + 20, (int)this.cx, (int)this.cy + 100 + 20);
        }
        if (this.secondIndiDirectLinks.size() > 1) {
            graphics.drawLine((int)this.cx, (int)this.cy + 100 + 20, cxRight, (int)this.cy + 100 + 20);
        }
        this.cy += 20.0;
        for (int i = 1; i < nbMaxGen; ++i) {
            this.cy += 120.0;
            if (this.firstIndiDirectLinks.size() > i) {
                graphics.drawLine(cxLeft, (int)this.cy - 20, cxLeft, (int)this.cy);
                this.render(graphics, this.firstIndiDirectLinks.get(i), familyWidth, cxLeft);
            }
            if (this.secondIndiDirectLinks.size() <= i) continue;
            graphics.drawLine(cxRight, (int)this.cy - 20, cxRight, (int)this.cy);
            this.render(graphics, this.secondIndiDirectLinks.get(i), familyWidth, cxRight);
        }
        graphics.setFont(this.smallFontStyle);
        this.centerString(graphics, PointInTime.getNow().toString(), (int)this.cx + 300, (int)this.cy + 100 + 20);
    }

    @Override
    public double getZoom() {
        return this.zoom;
    }

    @Override
    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    @Override
    public int getImageWidth() {
        return (int)((double)this.width * this.zoom);
    }

    @Override
    public int getImageHeight() {
        return (int)((double)this.height * this.zoom);
    }

    private void render(Graphics2D graphics, Step step, int familyWidth, int cxStep) {
        graphics.setPaint(Color.BLACK);
        int recWidth = familyWidth;
        graphics.setFont(this.boldFontStyle);
        graphics.setPaint(Color.LIGHT_GRAY);
        graphics.fillRect(cxStep - recWidth / 2 + 3, (int)this.cy + 3, recWidth + 3, 103);
        graphics.setPaint(Color.BLACK);
        graphics.clearRect(cxStep - recWidth / 2, (int)this.cy, recWidth, 100);
        graphics.drawRect(cxStep - recWidth / 2, (int)this.cy, recWidth, 100);
        if (this.husband_or_wife_first == 0) {
            this.renderWife(graphics, step, cxStep, (int)this.cy);
            this.renderHusband(graphics, step, cxStep, (int)this.cy + 36);
        } else {
            this.renderHusband(graphics, step, cxStep, (int)this.cy);
            this.renderWife(graphics, step, cxStep, (int)this.cy + 36);
        }
        if (step.famWhereSpouse != null && step.famWhereSpouse.getMarriageDate() != null) {
            graphics.setFont(this.dateFontStyle);
            this.centerString(graphics, this.getMarriageLine(step), cxStep, (int)this.cy + 90);
        }
    }

    private void renderWife(Graphics2D graphics, Step step, int cxStep, int cyStep) {
        if (step.getWife() != null) {
            if (step.linkSex == 2) {
                graphics.setFont(this.boldFontStyle);
                if (this.use_colors) {
                    graphics.setPaint(Color.MAGENTA);
                }
                this.centerString(graphics, this.getNameLine(step.getWife()), cxStep, cyStep + 18);
                graphics.setFont(this.plainFontStyle);
                graphics.setPaint(Color.BLACK);
            } else {
                graphics.setFont(this.plainFontStyle);
                this.centerString(graphics, this.getNameLine(step.getWife()), cxStep, cyStep + 18);
            }
            graphics.setFont(this.dateFontStyle);
            this.centerString(graphics, this.getDateLine(step.getWife()), cxStep, cyStep + 36);
            graphics.setFont(this.plainFontStyle);
        }
    }

    private void renderHusband(Graphics2D graphics, Step step, int cxStep, int cyStep) {
        if (step.getHusband() != null) {
            if (step.linkSex == 1) {
                graphics.setFont(this.boldFontStyle);
                if (this.use_colors) {
                    graphics.setPaint(Color.BLUE);
                }
                this.centerString(graphics, this.getNameLine(step.getHusband()), cxStep, cyStep + 18);
                graphics.setFont(this.plainFontStyle);
                graphics.setPaint(Color.BLACK);
            } else {
                graphics.setFont(this.plainFontStyle);
                this.centerString(graphics, this.getNameLine(step.getHusband()), cxStep, cyStep + 18);
            }
            graphics.setFont(this.dateFontStyle);
            this.centerString(graphics, this.getDateLine(step.getHusband()), cxStep, cyStep + 36);
            graphics.setFont(this.plainFontStyle);
        }
    }

    private String getNameLine(Indi indi) {
        StringBuilder sb = new StringBuilder();
        if (indi != null) {
            sb.append(indi.getFirstName()).append(" ").append(indi.getLastName());
            if (this.displayedId) {
                sb.append(" [").append(indi.getId()).append("]");
            }
        } else {
            sb.append("");
        }
        return sb.toString();
    }

    private String getDateLine(Indi indi) {
        StringBuilder sb = new StringBuilder();
        if (this.displayRecentYears || indi.getDeathDate(true).getStart().getYear() < this.YEAR_LIMIT || indi.getBirthDate(true).getStart().getYear() < this.YEAR_LIMIT) {
            sb.append(indi.getBirthDate(true).getDisplayValue()).append(" - ").append(indi.getDeathDate(true).getDisplayValue());
        }
        return sb.toString();
    }

    private String getMarriageLine(Step step) {
        StringBuilder sb = new StringBuilder();
        if (this.displayRecentYears || step.famWhereSpouse.getMarriageDate(true).getStart().getYear() < this.YEAR_LIMIT) {
            PropertyDate date = step.famWhereSpouse.getMarriageDate(true);
            sb.append(NbBundle.getMessage(Renderer.class, (String)"Renderer.marriage.date")).append(" ").append(date.getDisplayValue());
            if (this.displayedId) {
                sb.append(" [").append(step.famWhereSpouse.getId()).append("]");
            }
        }
        return sb.toString();
    }

    private String getTitleLine(Indi indi, Indi other, int generationCount) {
        Object[] args = new Object[]{this.getNameLine(indi), this.getNameLine(other)};
        return NbBundle.getMessage(Renderer.class, (String)"Renderer.title2", (Object[])args);
    }

    private void centerString(Graphics2D graphics, String text, int x, int y) {
        Rectangle2D rect = graphics.getFont().getStringBounds(text, graphics.getFontRenderContext());
        int iwidth = (int)rect.getWidth();
        graphics.drawString(text, x - iwidth / 2, y);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Position {
        LEFT,
        RIGHT,
        CENTER;

    }
}

