/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.place.geonames;

import ancestris.api.place.Place;
import ancestris.api.place.SearchPlace;
import ancestris.libs.geonames.GeonamesOptions;
import ancestris.modules.place.geonames.GeonamesPlace;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Gedcom;
import genj.gedcom.PropertyPlace;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.JComponent;
import modules.editors.gedcomproperties.utils.PlaceFormatConverterPanel;
import org.geonames.PostalCode;
import org.geonames.Style;
import org.geonames.Toponym;
import org.geonames.ToponymSearchCriteria;
import org.geonames.ToponymSearchResult;
import org.geonames.WebService;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.TaskListener;

public class GeonamesResearcher
implements SearchPlace {
    private static Toponym DEFAULT_TOPONYM = GeonamesResearcher.defaultToponym();
    private static final int DEFAULT_LAT = 45;
    private static final int DEFAULT_LON = -4;
    private static final Logger logger = Logger.getLogger(GeonamesResearcher.class.getName(), null);
    private RequestProcessor.Task theTask;
    private RequestProcessor RP = null;
    private static String KEYMAP = "geonamesPlaceConversionMap";

    public GeonamesResearcher() {
        if (this.RP == null) {
            this.RP = new RequestProcessor("GeonamesResearcher", 1, true);
        }
    }

    public RequestProcessor.Task getTask() {
        return this.theTask;
    }

    public void searchPlace(String place, String city, String code, final List<Place> placesList, final int maxResults, TaskListener taskListener) {
        final String searchedPlace = this.clean(place);
        if (searchedPlace.isEmpty()) {
            return;
        }
        final String searchedCity = (city = this.clean(city)).isEmpty() ? this.getCity(searchedPlace) : city;
        code = this.clean(code);
        final String searchedCode = code.isEmpty() ? this.getCode(searchedPlace) : code;
        if (taskListener != null) {
            Runnable runnable = new Runnable(){

                @Override
                public synchronized void run() {
                    placesList.addAll(GeonamesResearcher.this.doSearch(searchedPlace, searchedCity, searchedCode, maxResults));
                }
            };
            this.theTask = this.RP.create(runnable);
            this.theTask.addTaskListener(taskListener);
            this.theTask.schedule(0);
        } else {
            placesList.addAll(this.doSearch(searchedPlace, searchedCity, searchedCode, maxResults));
        }
    }

    private List<Place> doSearch(String searchedPlace, String searchedCity, String searchedCode, int maxResults) {
        ArrayList<Place> mPlacesList = new ArrayList<Place>();
        HashSet<String> tmpListDedup = new HashSet<String>();
        Place place = null;
        try {
            String str;
            PostalCode pc;
            ToponymSearchResult toponymSearchResult;
            WebService.setUserName((String)GeonamesOptions.getInstance().getUserName());
            ToponymSearchCriteria searchCriteria = new ToponymSearchCriteria();
            searchCriteria.setStyle(Style.FULL);
            searchCriteria.setLanguage(Locale.getDefault().toString());
            searchCriteria.setMaxRows(maxResults == 0 ? 99 : Math.min(maxResults, 99));
            if (!searchedPlace.isEmpty()) {
                searchCriteria.setQ(searchedPlace);
                toponymSearchResult = WebService.search((ToponymSearchCriteria)searchCriteria);
                for (Toponym iTopo : toponymSearchResult.getToponyms()) {
                    pc = new PostalCode();
                    pc.setPostalCode(iTopo.getAdminCode4());
                    place = new GeonamesPlace(iTopo, pc);
                    str = place.toString();
                    if (!tmpListDedup.contains(str)) {
                        mPlacesList.add(place);
                        tmpListDedup.add(str);
                    }
                    if (maxResults != 1) continue;
                    break;
                }
            }
            if (!searchedCode.isEmpty() && (mPlacesList.isEmpty() || maxResults != 1)) {
                searchCriteria.setQ(searchedCode);
                toponymSearchResult = WebService.search((ToponymSearchCriteria)searchCriteria);
                for (Toponym iTopo : toponymSearchResult.getToponyms()) {
                    pc = new PostalCode();
                    pc.setPostalCode(iTopo.getAdminCode4());
                    place = new GeonamesPlace(iTopo, pc);
                    str = place.toString();
                    if (this.matches(str, searchedPlace) && !tmpListDedup.contains(str)) {
                        mPlacesList.add(place);
                        tmpListDedup.add(str);
                    }
                    if (maxResults != 1) continue;
                    break;
                }
            }
            if (!searchedCity.isEmpty() && (mPlacesList.isEmpty() || maxResults != 1)) {
                searchCriteria.setNameStartsWith(searchedCity);
                searchCriteria.setQ(null);
                toponymSearchResult = WebService.search((ToponymSearchCriteria)searchCriteria);
                for (Toponym iTopo : toponymSearchResult.getToponyms()) {
                    pc = new PostalCode();
                    pc.setPostalCode(iTopo.getAdminCode4());
                    place = new GeonamesPlace(iTopo, pc);
                    str = place.toString();
                    if (this.matches(str, searchedPlace) && !tmpListDedup.contains(str)) {
                        mPlacesList.add(place);
                        tmpListDedup.add(str);
                    }
                    if (maxResults != 1) continue;
                    break;
                }
            }
            if (mPlacesList.isEmpty()) {
                place = this.defaultPlace();
                mPlacesList.add(place);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mPlacesList;
    }

    public Place defaultPlace() {
        return new GeonamesPlace(DEFAULT_TOPONYM, null);
    }

    public Place searchNearestPlace(double latitude, double longitude) {
        WebService.setUserName((String)GeonamesOptions.getInstance().getUserName());
        try {
            List results = WebService.findNearbyPlaceName((double)latitude, (double)longitude);
            if (!results.isEmpty()) {
                int geonameId = ((Toponym)results.get(0)).getGeoNameId();
                Toponym toponym = WebService.get((int)geonameId, null, null);
                return new GeonamesPlace(toponym, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getGeonamesMapString(Gedcom gedcom) {
        return gedcom.getRegistry().get(KEYMAP, "");
    }

    public static String[] getGeonamesMap(Gedcom gedcom) {
        String map = "";
        String[] format = null;
        String placeMap = GeonamesResearcher.getGeonamesMapString(gedcom);
        PlaceFormatConverterPanel pfc = new PlaceFormatConverterPanel(GeonamesPlace.getPlaceFormat(), gedcom.getPlaceFormat(), placeMap);
        pfc.setTextTitle(NbBundle.getMessage(GeonamesResearcher.class, (String)"TITL_PlaceFormatConversionTitle"));
        pfc.setLeftTitle(NbBundle.getMessage(GeonamesResearcher.class, (String)"TITL_PlaceFormatConversionLeftTitle"));
        pfc.setRightTitle(NbBundle.getMessage(GeonamesResearcher.class, (String)"TITL_PlaceFormatConversionRightTitle"));
        Object o = DialogManager.create((String)NbBundle.getMessage(GeonamesResearcher.class, (String)"TITL_PlaceFormatConversion"), (JComponent)pfc).setMessageType(-1).show();
        if (o == DialogManager.OK_OPTION) {
            map = pfc.getConversionMapAsString();
            if (!map.replace(",", "").trim().isEmpty()) {
                gedcom.getRegistry().put(KEYMAP, map);
                format = PropertyPlace.getFormat((String)map);
            } else if (placeMap.isEmpty()) {
                DialogManager.create((String)NbBundle.getMessage(GeonamesResearcher.class, (String)"TITL_PlaceFormatConversion"), (String)NbBundle.getMessage(GeonamesResearcher.class, (String)"ERR_EmptyConversion")).setMessageType(0).show();
            } else {
                DialogManager.create((String)NbBundle.getMessage(GeonamesResearcher.class, (String)"TITL_PlaceFormatConversion"), (String)NbBundle.getMessage(GeonamesResearcher.class, (String)"ERR_NothingSaved")).setMessageType(0).show();
            }
        }
        return format;
    }

    private String clean(String str) {
        return str.replaceAll(",", " ").replaceAll(" +", " ").trim();
    }

    private String getCity(String text) {
        String[] bits;
        for (String bit : bits = text.split(" ")) {
            String str = bit.replaceAll("[0-9]", "");
            if (str.length() <= 1) continue;
            return str;
        }
        return text;
    }

    private String getCode(String text) {
        String[] bits;
        for (String bit : bits = text.split(" ")) {
            String str = bit.replaceAll("[^0-9]", "");
            if (str.length() <= 1) continue;
            return str;
        }
        return "";
    }

    private boolean matches(String text, String searchedPlace) {
        String[] bits;
        int matches = 0;
        for (String bit : bits = searchedPlace.split(" ")) {
            if (text.contains(bit)) {
                ++matches;
            }
            if (matches != 2) continue;
            return true;
        }
        return false;
    }

    private static Toponym defaultToponym() {
        Toponym topo = new Toponym();
        topo.setLatitude(45.0);
        topo.setLongitude(-4.0);
        topo.setPopulation(Long.getLong("0"));
        return topo;
    }
}

