/*
 * Decompiled with CFR 0.152.
 */
package ancestris.welcome.content;

import ancestris.welcome.content.Constants;
import ancestris.welcome.content.Utils;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ContentSection
extends JPanel
implements Constants {
    private static final int PANEL_MAX_WIDTH = 800;
    private boolean maxSize;
    private boolean showSeparator;
    private static final Stroke SEPARATOR_STROKE = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{1.0f, 1.0f}, 0.0f);

    public ContentSection(String title, JComponent content, boolean createBorder, boolean showSeparator, boolean maxSize) {
        this.setOpaque(false);
        this.maxSize = maxSize;
        this.showSeparator = showSeparator;
        this.setLayout(new BoxLayout(this, 1));
        if (createBorder) {
            this.setBorder(BorderFactory.createEmptyBorder(10, 25, 5, 25));
        }
        if (title != null) {
            JLabel lblTitle = new JLabel(title);
            lblTitle.setFont(SECTION_HEADER_FONT);
            lblTitle.setBorder(BorderFactory.createEmptyBorder(12, 0, 12, 0));
            lblTitle.setForeground(Utils.getColor("SectionHeaderColor"));
            lblTitle.setAlignmentX(0.0f);
            lblTitle.setAlignmentY(0.0f);
            this.add(lblTitle);
        }
        this.add(content);
        content.setLayout(new BoxLayout(content, 1));
        content.setAlignmentX(0.0f);
        content.setAlignmentY(0.0f);
    }

    public ContentSection(JComponent content, boolean showSeparator) {
        this(null, content, false, showSeparator, false);
    }

    public ContentSection(String title, JComponent content) {
        this(title, content, true, false, false);
    }

    public ContentSection(JComponent content) {
        this(null, content, true, false, false);
    }

    public ContentSection(String title, JComponent content, boolean isTopLevel, boolean showSeparator) {
        this(title, content, isTopLevel, showSeparator, false);
    }

    protected void paintComponent(Graphics g) {
        if (this.showSeparator) {
            int height = this.getHeight();
            Graphics2D g2d = (Graphics2D)g;
            Stroke oldStroke = g2d.getStroke();
            g2d.setStroke(SEPARATOR_STROKE);
            g.setColor(Utils.getColor("SectionSeparatorColor"));
            g.drawLine(0, 50, 0, height - 35);
            g2d.setStroke(oldStroke);
        }
    }

    public void setBounds(Rectangle r) {
        if (this.maxSize && r.width > 800) {
            r = new Rectangle(r);
            r.width = 800;
        }
        super.setBounds(r);
    }

    public void setBounds(int x, int y, int w, int h) {
        if (this.maxSize && w > 800) {
            w = 800;
        }
        super.setBounds(x, y, w, h);
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this.maxSize && d.width > 800) {
            d = new Dimension(d);
            d.width = 800;
        }
        return d;
    }
}

