/*
 * Decompiled with CFR 0.152.
 */
package ancestris.welcome.ui;

import ancestris.welcome.content.BundleSupport;
import ancestris.welcome.content.Constants;
import ancestris.welcome.content.LinkButton;
import ancestris.welcome.content.Utils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

class PluginsPanel
extends JPanel
implements Constants {
    private final Image ICON = ImageUtilities.loadImage((String)"ancestris/welcome/resources/ico_extension.png");

    public PluginsPanel(boolean showInstallPlugins) {
        super(new GridBagLayout());
        this.setOpaque(false);
        if (showInstallPlugins) {
            this.addInstallPlugins(BundleSupport.getLabel("InstallPlugins"), BundleSupport.getLabel("InstallPluginsDescr"));
        } else {
            this.addActivateFeatures(BundleSupport.getLabel("ActivateFeaturesFullIDE"), BundleSupport.getLabel("ActivateFeaturesDescrFullIDE"));
        }
    }

    private void addActivateFeatures(String label, String description) {
        LinkButton b = new LinkButton(label, Utils.getColor("HeaderForegroundColor"), true, "ActivateFeatures"){

            public void actionPerformed(ActionEvent e) {
                this.logUsage();
                new ShowPluginManagerAction("installed").actionPerformed(e);
            }
        };
        b.setFont(GET_STARTED_FONT);
        this.add((Component)b, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)new JLabel(description), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 9, 5, 5), 0, 0));
    }

    private void addInstallPlugins(String label, String description) {
        LinkButton b = new LinkButton(label, Utils.getColor("HeaderForegroundColor"), true, "InstallPlugins"){

            public void actionPerformed(ActionEvent e) {
                this.logUsage();
                new ShowPluginManagerAction("available").actionPerformed(e);
            }
        };
        b.setFont(GET_STARTED_FONT);
        b.setIcon(new ImageIcon(this.ICON));
        this.add(b);
        JLabel jDesc = new JLabel(description);
        jDesc.setBorder(BorderFactory.createEmptyBorder(5, 9, 2, 0));
        this.add(jDesc);
    }

    private static class ShowPluginManagerAction
    extends AbstractAction {
        private final String initialTab;

        public ShowPluginManagerAction(String initialTab) {
            super(BundleSupport.getLabel("AddPlugins"));
            this.initialTab = initialTab;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                FileObject fo = FileUtil.getConfigFile((String)"Actions/System/org-netbeans-modules-autoupdate-ui-actions-PluginManagerAction.instance");
                Action a = (Action)((InstanceCookie)DataObject.find((FileObject)fo).getLookup().lookup(InstanceCookie.class)).instanceCreate();
                a.actionPerformed(new ActionEvent(e.getSource(), 100, this.initialTab));
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

