/*
 * Decompiled with CFR 0.152.
 */
package ancestris.welcome.ui;

import ancestris.welcome.content.BundleSupport;
import ancestris.welcome.content.Constants;
import ancestris.welcome.content.LinkButton;
import ancestris.welcome.content.Utils;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.api.options.OptionsDisplayer;
import org.openide.util.ImageUtilities;

class PreferencesPanel
extends JPanel
implements Constants {
    private final Image ICON = ImageUtilities.loadImage((String)"ancestris/welcome/resources/ico_settings.png");

    public PreferencesPanel() {
        super(new GridBagLayout());
        this.setOpaque(false);
        this.addPreferences(BundleSupport.getLabel("Preferences"), BundleSupport.getLabel("PreferencesDescr"));
    }

    private void addPreferences(String label, String description) {
        LinkButton b = new LinkButton(label, Utils.getColor("HeaderForegroundColor"), true, "GoPreferences"){

            public void actionPerformed(ActionEvent e) {
                this.logUsage();
                new ShowPreferencesAction("available").actionPerformed(e);
            }
        };
        b.setFont(GET_STARTED_FONT);
        b.setIcon(new ImageIcon(this.ICON));
        this.add(b);
        JLabel jDesc = new JLabel(description);
        jDesc.setBorder(BorderFactory.createEmptyBorder(5, 9, 2, 0));
        this.add(jDesc);
    }

    private static class ShowPreferencesAction
    extends AbstractAction {
        private final String initialTab;

        public ShowPreferencesAction(String initialTab) {
            super(BundleSupport.getLabel("GoPreferences"));
            this.initialTab = initialTab;
        }

        public void actionPerformed(ActionEvent evt) {
            OptionsDisplayer.getDefault().open();
        }
    }
}

