/*
 * Decompiled with CFR 0.152.
 */
package ancestris.welcome.ui;

import ancestris.api.sample.SampleProvider;
import ancestris.app.ActionOpen;
import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.welcome.content.ActionButton;
import ancestris.welcome.content.BundleSupport;
import ancestris.welcome.content.Constants;
import genj.gedcom.Gedcom;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openide.filesystems.FileUtil;

public class SamplePanel
extends JPanel
implements Constants {
    private static final int MAX_FILES = 10;
    private PropertyChangeListener changeListener;

    public SamplePanel() {
        super(new BorderLayout());
        this.setOpaque(false);
    }

    public void addNotify() {
        super.addNotify();
        this.removeAll();
        this.add((Component)this.rebuildContent(), "Center");
    }

    public void removeNotify() {
        super.removeNotify();
    }

    private JPanel rebuildContent() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        int row = 0;
        Collection files = AncestrisPlugin.lookupAll(SampleProvider.class);
        for (SampleProvider p : files) {
            this.addFile(panel, row++, p);
            if (row < 10) continue;
            break;
        }
        if (0 == row) {
            panel.add((Component)new JLabel(BundleSupport.getLabel("NoSample")), new GridBagConstraints(0, row, 1, 1, 1.0, 1.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        } else {
            panel.add((Component)new JLabel(), new GridBagConstraints(0, row, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        return panel;
    }

    private void addFile(JPanel panel, int row, SampleProvider sample) {
        OpenGedcomFileAction action = new OpenGedcomFileAction(sample);
        ActionButton b = new ActionButton((Action)((Object)action), sample.getSampleGedcomURL().toString(), false, "RecentFile");
        b.setFont(BUTTON_FONT);
        b.getAccessibleContext().setAccessibleName(b.getText());
        b.getAccessibleContext().setAccessibleDescription(BundleSupport.getAccessibilityDescription("RecentFile", b.getText()));
        ImageIcon gedcomIcon = sample.getIcon();
        b.setIcon(gedcomIcon != null ? gedcomIcon : Gedcom.getImage());
        panel.add((Component)b, new GridBagConstraints(0, row, 1, 1, 1.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
    }

    private static class OpenGedcomFileAction
    extends ActionOpen {
        public OpenGedcomFileAction(SampleProvider sample) {
            super(FileUtil.toFileObject((File)sample.getSampleGedcomFile()));
            this.setText(sample.getName());
            this.setTip(sample.getDescription());
        }
    }
}

