/*
 * Decompiled with CFR 0.152.
 */
package genj.tree;

import ancestris.awt.FilteredMouseAdapter;
import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.core.actions.AbstractAncestrisContextAction;
import ancestris.core.actions.AncestrisActionProvider;
import ancestris.core.actions.CommonActions;
import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.gedcom.GedcomDirectory;
import ancestris.modules.views.tree.style.Style;
import ancestris.modules.views.tree.style.TreeStyleManager;
import ancestris.swing.ToolBar;
import ancestris.util.swing.DialogManager;
import ancestris.util.swing.SelectIndiOrFamPanel;
import ancestris.view.ExplorerHelper;
import ancestris.view.SelectionActionEvent;
import ancestris.view.SelectionDispatcher;
import ancestris.view.TemplateToolTip;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import genj.io.Filter;
import genj.renderer.Blueprint;
import genj.renderer.BlueprintRenderer;
import genj.renderer.ChooseBlueprintAction;
import genj.renderer.DPI;
import genj.renderer.RenderOptions;
import genj.renderer.RenderSelectionHintKey;
import genj.tree.Bookmark;
import genj.tree.ContentRenderer;
import genj.tree.Images;
import genj.tree.Model;
import genj.tree.ModelListener;
import genj.tree.TreeNode;
import genj.tree.TreeViewSettings;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.ButtonHelper;
import genj.util.swing.ImageIcon;
import genj.util.swing.PopupWidget;
import genj.util.swing.ScrollPaneWidget;
import genj.util.swing.SliderWidget;
import genj.util.swing.UnitGraphics;
import genj.util.swing.ViewPortAdapter;
import genj.util.swing.ViewPortOverview;
import genj.view.ScreenshotAction;
import genj.view.SettingsAction;
import genj.view.View;
import genj.view.ViewContext;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.awt.DropDownButtonFactory;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class TreeView
extends View
implements Filter,
AncestrisActionProvider {
    private static final Logger LOG = Logger.getLogger("ancestris.tree");
    protected static final ImageIcon BOOKMARK_ICON = new ImageIcon(TreeView.class, "images/Bookmark");
    protected static final Registry REGISTRY = Registry.get(TreeView.class);
    protected static final Resources RESOURCES = Resources.get(TreeView.class);
    protected static final String TITLE = RESOURCES.getString("title");
    private final Point2D DPMM;
    private final Model model;
    private final Content content;
    private final JScrollPane scroll;
    private final Overview overview;
    private final ContentRenderer contentRenderer;
    private static float MINZOOM = 0.1f;
    private static float MAXZOOM = 1.0f;
    private static float DEFZOOM = 0.5f;
    private double zoom = DEFZOOM;
    private SliderWidget sliderZoom;
    private boolean isFolded = true;
    private ActionFamsAndSpouses famAndSpouseAction;
    private ActionGotoContext gotoContext;
    private ActionGotoRoot gotoRoot;
    private TreeStyleManager styleManager;
    private Style style;
    private final Point2D.Double center = new Point2D.Double(0.0, 0.0);
    private Context context = new Context();
    private boolean ignoreContextChange = false;
    private final Sticky sticky = new Sticky();
    private Lookup.Result<SelectionActionEvent> result;
    private final TemplateToolTip tt = new TemplateToolTip();
    private JLabel rootTitle;
    private JButton rootMenu;
    private JButton gotoMenu;
    private boolean forceCenterCurrentAtOpening = true;

    public TreeView() {
        DPI dpi = RenderOptions.getInstance().getDPI();
        this.DPMM = new Point2D.Float((float)dpi.horizontal() / 2.54f / 10.0f, (float)dpi.vertical() / 2.54f / 10.0f);
        this.styleManager = TreeStyleManager.getInstance(REGISTRY);
        this.style = this.styleManager.getStyle(REGISTRY.get("style", "default"));
        this.zoom = Math.max(MINZOOM, Math.min(MAXZOOM, REGISTRY.get("zoom", DEFZOOM)));
        this.model = new Model(this, this.style);
        this.model.setVertical(REGISTRY.get("vertical", true));
        this.model.setFamilies(REGISTRY.get("families", true));
        this.model.setHideAncestorsIDs(REGISTRY.get("hide.ancestors", new ArrayList()));
        this.model.setHideDescendantsIDs(REGISTRY.get("hide.descendants", new ArrayList()));
        this.model.setMaxGenerations(REGISTRY.get("maxgenerations", 20));
        this.contentRenderer = new ContentRenderer();
        this.content = new Content();
        this.setExplorerHelper(new ExplorerHelper((Component)this.content));
        this.scroll = new ScrollPaneWidget((JComponent)new ViewPortAdapter((JComponent)this.content));
        this.overview = new Overview(this.scroll);
        this.overview.setVisible(REGISTRY.get("overview", true));
        this.overview.setSize(REGISTRY.get("overview", new Dimension(160, 80)));
        this.add((Component)((Object)this.overview));
        this.add(this.scroll);
        this.setCenteringPolicy();
    }

    public Gedcom getGedcom() {
        if (this.context != null && this.context.getGedcom() != null) {
            return this.context.getGedcom();
        }
        return this.model.getRoot() == null ? null : this.model.getRoot().getGedcom();
    }

    public void addNotify() {
        super.addNotify();
        AncestrisPlugin.register((Object)((Object)this));
        this.forceCenterCurrentAtOpening = true;
    }

    public void removeNotify() {
        this.forceCenterCurrentAtOpening = true;
        AncestrisPlugin.unregister((Object)((Object)this));
        super.removeNotify();
    }

    public void writeProperties() {
        REGISTRY.put("overview", Boolean.valueOf(this.overview.isVisible()));
        REGISTRY.put("overview", this.overview.getSize());
        REGISTRY.put("zoom", (float)this.zoom);
        REGISTRY.put("vertical", Boolean.valueOf(this.model.isVertical()));
        REGISTRY.put("families", Boolean.valueOf(this.model.isFamilies()));
        REGISTRY.put("maxgenerations", this.model.getMaxGenerations());
        REGISTRY.put("style", this.style.key);
        if (this.style.key.equals("perso")) {
            this.saveStyle();
        }
        if (this.model.getRoot() != null) {
            Registry r = this.getGedcom().getRegistry();
            r.put("tree.root", this.model.getRoot().getId());
            r.put("tree.center", this.getCenter());
        }
        REGISTRY.put("hide.ancestors", this.model.getHideAncestorsIDs());
        REGISTRY.put("hide.descendants", this.model.getHideDescendantsIDs());
    }

    public void saveStyle() {
        this.styleManager.putStyle(REGISTRY);
    }

    public boolean confirmStyleOverwrite() {
        Style persoStyle = this.getStyleManager().getPersoStyle();
        if (this.getStyle() != persoStyle) {
            String msg;
            String title = NbBundle.getMessage(Style.class, (String)"TITL_WarnStyleChange");
            Object o = DialogManager.create((String)title, (String)(msg = NbBundle.getMessage(Style.class, (String)"MSG_WarnStyleChange"))).setOptionType(0).setDialogId("style.change").show();
            return o.equals(DialogManager.OK_OPTION);
        }
        return true;
    }

    public static boolean isAutoScroll() {
        return REGISTRY.get("auto.scroll", false);
    }

    public static void setAutoScroll(boolean autoScroll) {
        REGISTRY.put("auto.scroll", Boolean.valueOf(autoScroll));
    }

    public static boolean showPopup() {
        return REGISTRY.get("show.popup", false);
    }

    public static void setShowPopup(boolean showPopup) {
        REGISTRY.put("show.popup", Boolean.valueOf(showPopup));
    }

    public static TreeViewSettings.OnAction getOnAction() {
        return (TreeViewSettings.OnAction)REGISTRY.get("on.action", (Enum)TreeViewSettings.OnAction.SETROOT);
    }

    public static void setOnAction(TreeViewSettings.OnAction action) {
        REGISTRY.put("on.action", (Enum)action);
    }

    public void doLayout() {
        Component[] cs;
        int w = this.getWidth();
        int h = this.getHeight();
        for (Component c : cs = this.getComponents()) {
            if (c == this.overview) continue;
            c.setBounds(0, 0, w, h);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(480, 480);
    }

    public boolean isOptimizedDrawingEnabled() {
        return !this.overview.isVisible();
    }

    public boolean isAntialising() {
        return this.style.antialiasing;
    }

    public void setAntialiasing(boolean set) {
        if (this.style.antialiasing == set) {
            return;
        }
        this.style.antialiasing = set;
        this.repaint();
    }

    public Font getContentFont() {
        return this.style.font;
    }

    public void setContentFont(Font set) {
        if (set == null || this.style.font.equals(set)) {
            return;
        }
        this.style.font = set;
        this.repaint();
    }

    public void setColors(Map<String, Color> set) {
        for (String key : this.style.colors.keySet()) {
            Color c = set.get(key);
            if (c == null) continue;
            this.style.colors.put(key, c);
        }
        this.repaint();
    }

    public Map<String, Color> getColors() {
        return Collections.unmodifiableMap(this.style.colors);
    }

    public Model getModel() {
        return this.model;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style set) {
        if (set == null || this.style.equals(set)) {
            return;
        }
        this.model.getCenteredEntities();
        this.style = set;
        this.zoom = this.style.zoom;
        this.sliderZoom.setValue((int)(this.zoom * 100.0));
        this.getModel().setStyle(set);
    }

    public TreeStyleManager getStyleManager() {
        return this.styleManager;
    }

    private Lookup.Result<SelectionActionEvent> addLookupListener(Context context) {
        Lookup.Result r;
        try {
            r = GedcomDirectory.getDefault().getDataObject(context).getLookup().lookupResult(SelectionActionEvent.class);
        }
        catch (GedcomDirectory.ContextNotFoundException ex) {
            r = null;
        }
        final Lookup.Result returnValue = r;
        if (returnValue != null) {
            returnValue.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent ev) {
                    for (SelectionActionEvent e : returnValue.allInstances()) {
                        if (e == null) continue;
                        if (e.isAction()) {
                            TreeView.this.fireAction(e.getSource(), e.getContext());
                            continue;
                        }
                        if (!TreeView.this.isEventInMe(e.getSource())) continue;
                        TreeView.this.setContext(e.getContext());
                    }
                }
            });
        }
        return returnValue;
    }

    private boolean isEventInMe(Object comp) {
        if (comp == null) {
            return false;
        }
        Container source = null;
        if (comp instanceof Component) {
            source = SwingUtilities.getAncestorOfClass(TreeView.class, (Component)comp);
        }
        return source != null && source == this;
    }

    public void fireAction(Object comp, Context context) {
        if (context == null) {
            return;
        }
        if (this.ignoreContextChange) {
            return;
        }
        if (this.sticky.isSelected()) {
            return;
        }
        Container source = null;
        if (comp != null && comp instanceof Component) {
            source = SwingUtilities.getAncestorOfClass(TreeView.class, (Component)comp);
        }
        if (source != null && source == this) {
            this.setRoot(context.getEntity());
        } else {
            switch (TreeView.getOnAction()) {
                case NONE: {
                    break;
                }
                case SETROOT: {
                    this.setRoot(context.getEntity());
                    break;
                }
                case CENTER: {
                    this.show(context.getEntity(), true);
                }
            }
        }
    }

    public void setContext(Context newContext) {
        if (newContext == null) {
            return;
        }
        if (this.result == null) {
            this.result = this.addLookupListener(newContext);
        }
        if (this.context.getGedcom() != null && !newContext.getGedcom().equals(this.context.getGedcom())) {
            return;
        }
        if (this.ignoreContextChange) {
            return;
        }
        if (this.sticky.isSelected()) {
            return;
        }
        this.setContextImpl(newContext);
    }

    private void setContextImpl(Context newContext) {
        this.context = new Context(newContext.getGedcom(), (Collection)newContext.getEntities());
        if (this.context.getEntity() == null) {
            return;
        }
        this.show(this.context.getEntity());
    }

    public boolean show(Entity entity) {
        return this.show(entity, false);
    }

    private boolean show(Entity entity, boolean forceCenter) {
        if (!(entity instanceof Indi) && !(entity instanceof Fam)) {
            return true;
        }
        TreeNode node = this.model.getNode(entity);
        if (node == null) {
            return false;
        }
        this.scrollTo(node.pos, forceCenter);
        this.content.repaint();
        this.overview.repaint();
        return true;
    }

    private void scrollTo(Point2D p, boolean forceCenter) {
        if (forceCenter || TreeView.isAutoScroll()) {
            this.center.setLocation(p);
            Rectangle b = this.model.getBounds();
            Dimension d = this.getSize();
            Rectangle r = new Rectangle((int)((p.getX() - b.getMinX()) * (this.DPMM.getX() * this.zoom)) - d.width / 2, (int)((p.getY() - b.getMinY()) * (this.DPMM.getY() * this.zoom)) - d.height / 2, d.width, d.height);
            this.content.scrollRectToVisible(r);
        }
    }

    public Point getCenter() {
        if (this.scroll == null) {
            return null;
        }
        JViewport v = this.scroll.getViewport();
        return this.view2model(new Point(v.getViewPosition().x + v.getExtentSize().width / 2, v.getViewPosition().y + v.getExtentSize().height / 2));
    }

    private void scrollToCurrent(boolean forceCentering, boolean forceCurrent) {
        TreeNode node;
        Entity current;
        if ((forceCurrent || TreeView.isAutoScroll()) && (current = this.context.getEntity()) != null && (node = this.model.getNode(current)) != null) {
            this.scrollTo(node.pos, forceCurrent);
            return;
        }
        TreeNode node2 = null;
        for (Entity entity : this.model.getDefaultEntities()) {
            node2 = this.model.getNode(entity);
            if (node2 == null) continue;
            this.model.clearDefaultEntities();
            break;
        }
        if (node2 == null) {
            return;
        }
        this.scrollTo(node2.pos, forceCentering);
    }

    private void setZoom(double d) {
        Point centr = this.getCenter();
        this.zoom = Math.max((double)MINZOOM, Math.min((double)MAXZOOM, d));
        if (this.getStyleManager().getPersoStyle() == this.style) {
            this.style.zoom = this.zoom;
        }
        this.content.invalidate();
        if (TreeView.isAutoScroll()) {
            this.scrollToCurrent(false, false);
        } else {
            this.scrollTo(centr, true);
        }
        this.validate();
        this.repaint();
    }

    public void populate(ToolBar toolbar) {
        this.sliderZoom = new SliderWidget(1, 100, (int)(this.zoom * 100.0));
        this.sliderZoom.addChangeListener((ChangeListener)new ZoomGlue());
        this.sliderZoom.setAlignmentX(0.0f);
        this.sliderZoom.setOpaque(false);
        this.sliderZoom.setFocusable(false);
        toolbar.add((JComponent)this.sliderZoom);
        ButtonHelper bh = new ButtonHelper();
        toolbar.add((JComponent)bh.create((Action)((Object)new ActionOverview()), null, this.overview.isVisible()));
        toolbar.addSeparator();
        toolbar.add((JComponent)bh.create((Action)((Object)new ActionOrientation()), Images.imgVert, this.model.isVertical()));
        this.famAndSpouseAction = new ActionFamsAndSpouses();
        toolbar.add((JComponent)bh.create((Action)((Object)this.famAndSpouseAction), null, this.model.isFamilies()));
        toolbar.add((JComponent)bh.create((Action)((Object)new ActionFoldSymbols()), null, this.model.isFoldSymbols()));
        toolbar.add((JComponent)bh.create((Action)((Object)new ActionFoldUnfoldAll())));
        toolbar.addSeparator();
        this.rootMenu = DropDownButtonFactory.createDropDownButton((Icon)Images.imgView, null);
        ActionRootContext def1 = new ActionRootContext(this.rootMenu);
        ActionChooseRoot def2 = new ActionChooseRoot(this.rootMenu);
        this.rootMenu.putClientProperty("dropDownMenu", Utilities.actionsToPopup((Action[])new Action[]{def1, def2}, (Lookup)Lookup.EMPTY));
        this.rootMenu.setAction((Action)((Object)def1));
        this.gotoMenu = DropDownButtonFactory.createDropDownButton((Icon)Images.imgGotoRoot, null);
        this.gotoContext = new ActionGotoContext(this.gotoMenu);
        this.gotoRoot = new ActionGotoRoot(this.gotoMenu);
        this.gotoMenu.putClientProperty("dropDownMenu", Utilities.actionsToPopup((Action[])new Action[]{this.gotoContext, this.gotoRoot}, (Lookup)Lookup.EMPTY));
        this.gotoMenu.setAction((Action)((Object)this.gotoContext));
        toolbar.add((JComponent)this.rootMenu);
        toolbar.add((JComponent)this.gotoMenu);
        PopupWidget pb = new PopupWidget("", (Icon)BOOKMARK_ICON){

            public void showPopup() {
                this.removeItems();
                for (Bookmark bookmark : TreeView.this.model.getBookmarks()) {
                    this.addItem((Action)((Object)new ActionGoto(bookmark)));
                }
                super.showPopup();
            }
        };
        pb.setToolTipText(RESOURCES.getString("bookmark.tip"));
        pb.setOpaque(false);
        toolbar.add((JComponent)pb);
        toolbar.addSeparator();
        toolbar.add((Action)new ScreenshotAction((JComponent)this.content));
        this.rootTitle = new JLabel();
        this.rootTitle.setHorizontalAlignment(0);
        toolbar.add((Component)this.rootTitle, (Object)"growx, pushx, center");
        this.setRootTitle("");
        toolbar.addSeparator();
        toolbar.add((JComponent)new JToggleButton((Action)((Object)this.sticky)));
        toolbar.add((Action)((Object)new ActionBluePrint()));
        toolbar.add((Action)((Object)new Settings()));
        toolbar.setFloatable(false);
    }

    private void setRootTitle(String title) {
        title = title.replaceAll("\\) \\+", ")<br>+");
        this.rootTitle.setText("<html><center>" + RESOURCES.getString("root.name") + " " + title + "</center></html");
    }

    public Entity getEntityAt(Point entityPos) {
        if (this.model == null) {
            return null;
        }
        ViewPortAdapter va = (ViewPortAdapter)this.content.getParent();
        JViewport vp = (JViewport)va.getParent();
        Point viewPosition = vp.getViewPosition();
        Point contentShift = this.content.getLocation();
        Point entityContentPos = new Point();
        entityContentPos.x = entityPos.x + viewPosition.x - contentShift.x;
        entityContentPos.y = entityPos.y + viewPosition.y - contentShift.y;
        Point modelPos = this.view2model(entityContentPos);
        return this.model.getEntityAt(modelPos.x, modelPos.y);
    }

    public Entity getRoot() {
        if (this.model == null) {
            return null;
        }
        return this.model.getRoot();
    }

    public void setRoot(Entity root) {
        Gedcom gedcom;
        Entity old = this.model.getRoot();
        if (old != null) {
            gedcom = old.getGedcom();
            REGISTRY.put(gedcom.getName() + ".bookmarks", this.model.getBookmarks());
        }
        if (root == null || root instanceof Indi || root instanceof Fam) {
            this.model.setRoot(root);
            this.show(root, true);
            String title = root == null ? "" : root.toString(true);
            this.setRootTitle(title);
            this.famAndSpouseAction.updateButton();
        }
        if (root != null) {
            gedcom = root.getGedcom();
            ArrayList<Bookmark> bookmarks = new ArrayList<Bookmark>();
            for (String b : REGISTRY.get(gedcom.getName() + ".bookmarks", new String[0])) {
                try {
                    bookmarks.add(new Bookmark(gedcom, b));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.model.setBookmarks(bookmarks);
        }
    }

    private Point view2model(Point pos) {
        Rectangle bounds = this.model.getBounds();
        return new Point((int)Math.rint((double)pos.x / (this.DPMM.getX() * this.zoom) + bounds.getMinX()), (int)Math.rint((double)pos.y / (this.DPMM.getY() * this.zoom) + bounds.getMinY()));
    }

    private BlueprintRenderer getEntityRenderer(String tag) {
        if (tag.equals("INDI")) {
            return new BlueprintRenderer(this.style.blueprintIndi);
        }
        return new BlueprintRenderer(this.style.blueprintFam);
    }

    public List<Action> getActions(boolean hasFocus, Node[] nodes) {
        if (!hasFocus) {
            return new ArrayList<Action>();
        }
        ArrayList<Action> actions = new ArrayList<Action>();
        if (nodes.length == 1) {
            actions.add((Action)((Object)new ActionBluePrint()));
        }
        return actions;
    }

    private void setCenteringPolicy() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TreeView.this.scrollToCurrent(false, TreeView.this.forceCenterCurrentAtOpening);
            }
        });
        Timer timer = new Timer("once");
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                TreeView.this.forceCenterCurrentAtOpening = false;
            }
        };
        timer.schedule(task, 3000L);
    }

    public void forceFamilies(boolean b) {
        this.famAndSpouseAction.setImage((Icon)Images.imgDontFams);
        this.famAndSpouseAction.setTip("<html>" + RESOURCES.getString("familiesnot.tip") + "</html>");
    }

    public Action getRootAction(Entity e, boolean b) {
        if (e instanceof Indi || e instanceof Fam) {
            return new ActionRoot(e, false);
        }
        return CommonActions.NOOP;
    }

    public Action getBookmarkAction(Entity e, boolean local) {
        if (e instanceof Indi || e instanceof Fam) {
            return new ActionBookmark(e, local);
        }
        return CommonActions.NOOP;
    }

    public boolean veto(Property prop) {
        return false;
    }

    public boolean veto(Entity ent) {
        Entity[] refs;
        Set ents = this.model.getEntities();
        if (ent instanceof Indi) {
            return !ents.contains(ent);
        }
        if (ent instanceof Fam) {
            boolean b = ents.contains(ent);
            if (this.model.isFamilies() || b) {
                return !b;
            }
            Fam fam = (Fam)ent;
            boolean father = ents.contains(fam.getHusband());
            boolean mother = ents.contains(fam.getWife());
            boolean child = false;
            Indi[] children = fam.getChildren();
            for (int i = 0; !child && i < children.length; ++i) {
                if (!ents.contains(children[i])) continue;
                child = true;
            }
            return !(father && mother || father && child || mother && child);
        }
        if (this.model.getRoot().getGedcom().getSubmitter() == ent) {
            return false;
        }
        for (Entity ref : refs = PropertyXRef.getReferences((Entity)ent)) {
            if (!ents.contains(ref)) continue;
            return false;
        }
        return true;
    }

    public String getFilterName() {
        return NbBundle.getMessage(TreeView.class, (String)"TTL_Filter", (Object)this.model.getEntities().size(), (Object)TITLE);
    }

    public boolean canApplyTo(Gedcom gedcom) {
        return gedcom != null && gedcom.equals(this.getGedcom());
    }

    private class TreeContext
    extends ViewContext {
        public TreeContext(Context context) {
            super(context);
        }
    }

    private class ActionGotoContext
    extends AbstractAncestrisContextAction {
        private Entity entity;
        private JButton bMenu = null;
        private boolean isContextPresent = false;

        public ActionGotoContext() {
            this(null);
        }

        public ActionGotoContext(JButton b) {
            this.bMenu = b;
            this.setImage((Icon)Images.imgGotoContext);
        }

        protected void contextChanged() {
            if (!this.contextProperties.isEmpty()) {
                Property prop = (Property)this.contextProperties.get(0);
                if (prop.getEntity() instanceof Indi || prop.getEntity() instanceof Fam) {
                    this.entity = prop.getEntity();
                } else if (this.entity == null) {
                    this.entity = prop.getGedcom().getFirstEntity("INDI");
                }
            }
            this.updateButton();
            super.contextChanged();
        }

        protected void actionPerformedImpl(ActionEvent event) {
            if (!this.isContextPresent) {
                return;
            }
            TreeView.this.scrollToCurrent(true, true);
            if (this.bMenu.getAction() != this) {
                this.bMenu.setAction((Action)((Object)this));
            }
        }

        public void updateButton() {
            String label = "";
            if (this.entity != null && TreeView.this.model.getNode(this.entity) != null) {
                if (this.bMenu.getAction() != this) {
                    this.bMenu.setAction((Action)((Object)this));
                }
                label = NbBundle.getMessage(ActionGotoContext.class, (String)"goto.context.tip", (Object)this.entity.toString(true));
                this.setImage((Icon)Images.imgGotoContext);
                this.isContextPresent = true;
            } else {
                if (this.bMenu.getAction() == this) {
                    this.bMenu.setAction((Action)((Object)TreeView.this.gotoRoot));
                }
                label = NbBundle.getMessage(ActionGotoContext.class, (String)"goto.contextnotintree.tip", (Object)(this.entity != null ? this.entity.toString(true) : ""));
                this.setImage(ImageUtilities.createDisabledIcon((Icon)Images.imgGotoContext));
                this.isContextPresent = false;
            }
            this.setTip(label);
            this.setText(label);
        }
    }

    private class ActionBluePrint
    extends AbstractAncestrisContextAction {
        private final ImageIcon IMAGE = new ImageIcon(ChooseBlueprintAction.class, "Blueprint.png");
        private Entity entity;

        public ActionBluePrint() {
            this.setImage((Icon)this.IMAGE);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Icon icon = ActionBluePrint.this.getImage();
                    String text = ActionBluePrint.this.getText();
                    String tt = ActionBluePrint.this.getTip();
                    ActionBluePrint.this.setImage((Icon)ActionBluePrint.this.IMAGE).setImage(icon);
                    ActionBluePrint.this.setText("").setText(text);
                    ActionBluePrint.this.setTip("").setTip(tt);
                }
            });
        }

        protected void contextChanged() {
            if (!this.contextProperties.isEmpty()) {
                Property prop = (Property)this.contextProperties.get(0);
                if (prop.getEntity() instanceof Indi || prop.getEntity() instanceof Fam) {
                    this.entity = prop.getEntity();
                } else if (this.entity == null) {
                    this.entity = prop.getGedcom().getFirstEntity("INDI");
                }
            }
            if (this.entity == null) {
                this.entity = new Indi();
            }
            this.setImageText(this.IMAGE.getOverLayed(this.entity.getImage(false)), NbBundle.getMessage(ChooseBlueprintAction.class, (String)"blueprint.select.for", (Object)Gedcom.getName((String)this.entity.getTag(), (boolean)true)));
            super.contextChanged();
        }

        protected void actionPerformedImpl(ActionEvent event) {
            if (this.entity != null) {
                Blueprint styleBlueprint = this.entity instanceof Indi ? ((TreeView)TreeView.this).style.blueprintIndi : ((TreeView)TreeView.this).style.blueprintFam;
                new ChooseBlueprintAction(this.entity, styleBlueprint){

                    protected void commit(Entity recipient, Blueprint blueprint) {
                        if (!TreeView.this.confirmStyleOverwrite()) {
                            return;
                        }
                        Style persoStyle = TreeView.this.getStyleManager().getPersoStyle();
                        TreeView.this.setStyle(persoStyle);
                        if (recipient instanceof Indi) {
                            ((TreeView)TreeView.this).style.blueprintIndi = blueprint;
                        } else {
                            ((TreeView)TreeView.this).style.blueprintFam = blueprint;
                        }
                        TreeView.this.saveStyle();
                        TreeView.this.repaint();
                    }
                }.actionPerformed(null);
            }
        }
    }

    private class Sticky
    extends AbstractAncestrisAction {
        protected Sticky() {
            super.setImage((Icon)ancestris.core.resources.Images.imgStickOff);
            super.setTip(RESOURCES.getString("action.stick.tip"));
            super.setSelected(false);
        }

        public void actionPerformed(ActionEvent event) {
            this.setSelected(this.isSelected());
        }

        public boolean setSelected(boolean selected) {
            super.setImage((Icon)(selected ? ancestris.core.resources.Images.imgStickOn : ancestris.core.resources.Images.imgStickOff));
            return super.setSelected(selected);
        }
    }

    private class Settings
    extends SettingsAction {
        private Settings() {
        }

        protected TreeViewSettings getEditor() {
            return new TreeViewSettings(TreeView.this);
        }
    }

    private class ActionBookmark
    extends AbstractAncestrisAction {
        private Entity entity;

        private ActionBookmark(Entity e, boolean local) {
            this.putValue("hideWhenDisabled", true);
            this.entity = e;
            this.setImage((Icon)BOOKMARK_ICON);
            if (local) {
                this.setText(RESOURCES.getString("bookmark.add"));
                this.setTip(RESOURCES.getString("bookmark.add.tip"));
            } else {
                this.setText(RESOURCES.getString("bookmark.in", new Object[]{TITLE}));
                this.setTip(RESOURCES.getString("bookmark.in.tip"));
            }
        }

        public void actionPerformed(ActionEvent event) {
            String name = this.entity.getDisplayTitle();
            name = DialogManager.create((String)TITLE, (String)RESOURCES.getString("bookmark.name"), (String)name).show();
            if (name == null) {
                return;
            }
            TreeView.this.model.addBookmark(new Bookmark(name, this.entity));
            Entity root = TreeView.this.model.getRoot();
            if (root != null) {
                REGISTRY.put(root.getGedcom().getName() + ".bookmarks", TreeView.this.model.getBookmarks());
            }
        }
    }

    private class ActionGoto
    extends AbstractAncestrisAction {
        private Bookmark bookmark;

        private ActionGoto(Bookmark bookmark) {
            this.bookmark = bookmark;
            this.setText(bookmark.getName());
            this.setImage((Icon)Gedcom.getEntityImage((String)bookmark.getEntity().getTag()));
        }

        public void actionPerformed(ActionEvent event) {
            Context newContext = new Context(this.bookmark.getEntity());
            try {
                TreeView.this.ignoreContextChange = true;
                SelectionDispatcher.fireSelection((Context)newContext);
            }
            finally {
                TreeView.this.ignoreContextChange = false;
            }
            TreeView.this.setRoot(this.bookmark.getEntity());
            TreeView.this.setContextImpl(newContext);
        }
    }

    private class ActionGotoRoot
    extends AbstractAncestrisAction {
        private JButton bMenu = null;

        private ActionGotoRoot() {
            this(null);
        }

        private ActionGotoRoot(JButton b) {
            this.bMenu = b;
            this.setTip(RESOURCES.getString("goto.root.tip"));
            this.setText(RESOURCES.getString("goto.root.tip"));
            this.setImage((Icon)Images.imgGotoRoot);
        }

        public void actionPerformed(ActionEvent event) {
            TreeView.this.show(TreeView.this.getRoot(), true);
            if (this.bMenu.getAction() != this) {
                this.bMenu.setAction((Action)((Object)this));
            }
        }
    }

    private class ActionRootContext
    extends AbstractAncestrisContextAction {
        private Entity entity;
        private JButton bMenu = null;

        public ActionRootContext() {
            this(null);
        }

        public ActionRootContext(JButton b) {
            this.bMenu = b;
            Entity e = null;
            Context c = TreeView.this.context;
            if (c != null) {
                e = c.getEntity();
            }
            if (e == null) {
                e = TreeView.this.getRoot();
            }
            this.setTip(RESOURCES.getString("root.context", new Object[]{e == null ? "" : e.toString(true)}));
            this.setText(RESOURCES.getString("root.context", new Object[]{e == null ? "" : e.toString(true)}));
            this.setImage((Icon)Images.imgView);
        }

        protected void contextChanged() {
            if (!this.contextProperties.isEmpty()) {
                Property prop = (Property)this.contextProperties.get(0);
                if (prop.getEntity() instanceof Indi || prop.getEntity() instanceof Fam) {
                    this.entity = prop.getEntity();
                } else if (this.entity == null) {
                    this.entity = prop.getGedcom().getFirstEntity("INDI");
                }
            }
            if (this.entity != null) {
                this.setTip(RESOURCES.getString("root.context", new Object[]{this.entity == null ? "" : this.entity.toString(true)}));
                this.setText(RESOURCES.getString("root.context", new Object[]{this.entity == null ? "" : this.entity.toString(true)}));
            }
            super.contextChanged();
        }

        protected void actionPerformedImpl(ActionEvent event) {
            TreeView.this.setRoot(this.entity);
            if (this.bMenu.getAction() != this) {
                this.bMenu.setAction((Action)((Object)this));
            }
        }
    }

    private class ActionChooseRoot
    extends AbstractAncestrisAction {
        private JButton bMenu = null;

        private ActionChooseRoot() {
            this(null);
        }

        private ActionChooseRoot(JButton b) {
            this.setText(RESOURCES.getString("select.root"));
            this.setTip(RESOURCES.getString("select.root"));
            this.setImage((Icon)Images.imgView);
            this.bMenu = b;
        }

        public void actionPerformed(ActionEvent event) {
            SelectIndiOrFamPanel select = new SelectIndiOrFamPanel(TreeView.this.context.getGedcom(), TreeView.this.model.getRoot().getTag(), NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"treeview.askentity"), null);
            if (DialogManager.OK_OPTION != DialogManager.create((String)this.getText(), (JComponent)select).setMessageType(3).setOptionType(2).setDialogId("select.root").show()) {
                return;
            }
            TreeView.this.setRoot(select.getSelection());
            if (this.bMenu.getAction() != this) {
                this.bMenu.setAction((Action)((Object)this));
            }
        }
    }

    private class ActionFoldUnfoldAll
    extends AbstractAncestrisAction {
        private ActionFoldUnfoldAll() {
            super.setImage((Icon)(TreeView.this.isFolded ? Images.imgUnfoldAll : Images.imgFoldAll));
            super.setTip(RESOURCES.getString(TreeView.this.isFolded ? "unfoldall.tip" : "foldall.tip", new Object[]{TreeView.this.model.getMaxGenerations()}));
        }

        public void actionPerformed(ActionEvent event) {
            if (TreeView.this.isFolded) {
                TreeView.this.model.unfoldAll();
            } else {
                TreeView.this.model.foldAll();
            }
            TreeView.this.isFolded = !TreeView.this.isFolded;
            super.setImage((Icon)(TreeView.this.isFolded ? Images.imgUnfoldAll : Images.imgFoldAll));
            super.setTip(RESOURCES.getString(TreeView.this.isFolded ? "unfoldall.tip" : "foldall.tip", new Object[]{TreeView.this.model.getMaxGenerations()}));
            TreeView.this.scrollToCurrent(true, false);
        }
    }

    private class ActionFoldSymbols
    extends AbstractAncestrisAction {
        private ActionFoldSymbols() {
            super.setImage((Icon)Images.imgFoldSymbols);
            super.setTip(RESOURCES.getString("foldsymbols.tip"));
        }

        public void actionPerformed(ActionEvent event) {
            TreeView.this.model.setFoldSymbols(!TreeView.this.model.isFoldSymbols());
            TreeView.this.scrollToCurrent(true, false);
        }
    }

    private class ActionFamsAndSpouses
    extends AbstractAncestrisAction {
        public void updateButton() {
            boolean forceFamily = TreeView.this.getRoot() instanceof Fam;
            super.setEnabled(!forceFamily);
            String addition = "";
            if (forceFamily) {
                TreeView.this.model.setFamilies(forceFamily);
                addition = RESOURCES.getString("familiesforced.tip");
            }
            super.setImage((Icon)(TreeView.this.model.isFamilies() ? Images.imgDontFams : Images.imgDoFams));
            super.setTip("<html>" + RESOURCES.getString(TreeView.this.model.isFamilies() ? "familiesnot.tip" : "families.tip") + "<br>" + addition + "</html>");
        }

        private ActionFamsAndSpouses() {
            this.updateButton();
        }

        public void actionPerformed(ActionEvent event) {
            TreeView.this.model.setFamilies(!TreeView.this.model.isFamilies());
            this.updateButton();
            TreeView.this.scrollToCurrent(true, false);
        }
    }

    private class ActionOrientation
    extends AbstractAncestrisAction {
        private ActionOrientation() {
            super.setImage((Icon)Images.imgHori);
            super.setTip(RESOURCES.getString("orientation.tip"));
        }

        public void actionPerformed(ActionEvent event) {
            TreeView.this.model.setVertical(!TreeView.this.model.isVertical());
            TreeView.this.scrollToCurrent(false, false);
        }
    }

    private class ActionRoot
    extends AbstractAncestrisAction {
        private Entity root;

        private ActionRoot(Entity entity, boolean in) {
            this.putValue("hideWhenDisabled", true);
            this.root = entity;
            this.setText(RESOURCES.getString("root"));
            this.setTip(RESOURCES.getString("root.tip"));
            this.setImage((Icon)Images.imgView);
        }

        public void actionPerformed(ActionEvent event) {
            TreeView.this.setRoot(this.root);
        }
    }

    private class ActionOverview
    extends AbstractAncestrisAction {
        private ActionOverview() {
            this.setImage((Icon)Images.imgOverview);
            this.setTip(RESOURCES.getString("overview.tip"));
        }

        public void actionPerformed(ActionEvent event) {
            TreeView.this.overview.setVisible(!TreeView.this.overview.isVisible());
        }
    }

    private class ZoomGlue
    implements ChangeListener {
        private ZoomGlue() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            TreeView.this.setZoom((double)TreeView.this.sliderZoom.getValue() * 0.01);
        }
    }

    private class Content
    extends JComponent
    implements ModelListener {
        private transient FilteredMouseAdapter mouseAdapter;
        private Entity oldTTEntity = null;
        private Point ttPosition = null;

        private Content() {
            this.putClientProperty("print.printable", Boolean.TRUE);
            this.mouseAdapter = new FilteredMouseAdapter(){

                public void mouseWheelMoved(MouseWheelEvent e) {
                    Content.this.mouseWheelMoved(e);
                }

                public void mousePressed(MouseEvent e) {
                    Content.this.mousePressed(e);
                }

                public void mouseClickedFiltered(MouseEvent me) {
                    Content.this.mouseClicked(me);
                }

                public void mouseEntered(MouseEvent e) {
                }
            };
            this.addMouseListener((MouseListener)this.mouseAdapter);
            this.addMouseWheelListener((MouseWheelListener)this.mouseAdapter);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            TreeView.this.model.addListener(this);
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        @Override
        public void removeNotify() {
            TreeView.this.model.removeListener(this);
            super.removeNotify();
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }

        @Override
        public JToolTip createToolTip() {
            TreeView.this.tt.setComponent((JComponent)this);
            return TreeView.this.tt;
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            if (!TreeView.showPopup()) {
                this.oldTTEntity = null;
                return null;
            }
            Entity entity = this.getEntityForEvent(event);
            if (entity != this.oldTTEntity) {
                this.ttPosition = null;
                this.oldTTEntity = entity;
            }
            TreeView.this.tt.setEntity(this.oldTTEntity);
            if (this.oldTTEntity == null) {
                return null;
            }
            return this.oldTTEntity.getId();
        }

        private Entity getEntityForEvent(MouseEvent event) {
            Entity entity = null;
            Point p = TreeView.this.view2model(event.getPoint());
            Object content = TreeView.this.model.getContentAt(p.x, p.y);
            if (content != null && content instanceof Entity) {
                entity = (Entity)content;
            }
            if (content != null && content instanceof Model.NextFamily) {
                entity = ((Model.NextFamily)content).getSpouse();
            }
            return entity;
        }

        @Override
        public Point getToolTipLocation(MouseEvent event) {
            if (!TreeView.showPopup() || this.oldTTEntity == null) {
                return null;
            }
            if (this.ttPosition == null) {
                this.ttPosition = new Point(event.getX() - 5, event.getY() + 2);
            }
            return this.ttPosition;
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.isControlDown()) {
                TreeView.this.sliderZoom.setValue(TreeView.this.sliderZoom.getValue() - e.getWheelRotation() * 10);
                return;
            }
            JViewport viewport = (JViewport)this.getParent().getParent();
            Rectangle r = viewport.getVisibleRect();
            if (e.isShiftDown()) {
                r.x += e.getWheelRotation() * 32;
            } else {
                r.y += e.getWheelRotation() * 32;
            }
            viewport.scrollRectToVisible(r);
        }

        @Override
        public void structureChanged(Model model) {
            this.invalidate();
            TreeView.this.validate();
            this.repaint();
            TreeView.this.scrollToCurrent(true, false);
            TreeView.this.famAndSpouseAction.updateButton();
            TreeView.this.gotoContext.updateButton();
        }

        @Override
        public void nodesChanged(Model model, Collection<TreeNode> nodes) {
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            Rectangle bounds = TreeView.this.model.getBounds();
            double w = ((RectangularShape)bounds).getWidth() * (TreeView.this.DPMM.getX() * TreeView.this.zoom);
            double h = ((RectangularShape)bounds).getHeight() * (TreeView.this.DPMM.getY() * TreeView.this.zoom);
            return new Dimension((int)w, (int)h);
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(((TreeView)TreeView.this).style.colors.get("background"));
            Rectangle r = g.getClipBounds();
            g.fillRect(r.x, r.y, r.width, r.height);
            UnitGraphics gw = new UnitGraphics(g, TreeView.this.DPMM.getX() * TreeView.this.zoom, TreeView.this.DPMM.getY() * TreeView.this.zoom);
            gw.setAntialiasing(((TreeView)TreeView.this).style.antialiasing);
            Boolean selection = (Boolean)((Graphics2D)g).getRenderingHint(RenderSelectionHintKey.KEY);
            if (selection == null) {
                selection = true;
            }
            ((TreeView)TreeView.this).contentRenderer.overview = false;
            ((TreeView)TreeView.this).contentRenderer.font = ((TreeView)TreeView.this).style.font;
            ((TreeView)TreeView.this).contentRenderer.cBackground = ((TreeView)TreeView.this).style.colors.get("background");
            ((TreeView)TreeView.this).contentRenderer.cMaleIndiShape = ((TreeView)TreeView.this).style.colors.get("maleindis");
            ((TreeView)TreeView.this).contentRenderer.cFemaleIndiShape = ((TreeView)TreeView.this).style.colors.get("femaleindis");
            ((TreeView)TreeView.this).contentRenderer.cUnknownIndiShape = ((TreeView)TreeView.this).style.colors.get("unknownindis");
            ((TreeView)TreeView.this).contentRenderer.cFamShape = ((TreeView)TreeView.this).style.colors.get("fams");
            ((TreeView)TreeView.this).contentRenderer.cArcs = ((TreeView)TreeView.this).style.colors.get("arcs");
            ((TreeView)TreeView.this).contentRenderer.cSelectedShape = ((TreeView)TreeView.this).style.colors.get("selects");
            ((TreeView)TreeView.this).contentRenderer.cRootShape = ((TreeView)TreeView.this).style.colors.get("roots");
            ((TreeView)TreeView.this).contentRenderer.indisThick = ((TreeView)TreeView.this).model.getMetrics().indisThick;
            ((TreeView)TreeView.this).contentRenderer.famsThick = ((TreeView)TreeView.this).model.getMetrics().famsThick;
            ((TreeView)TreeView.this).contentRenderer.selected = selection != false ? TreeView.this.context.getEntities() : new ArrayList();
            ((TreeView)TreeView.this).contentRenderer.root = TreeView.this.getRoot();
            ((TreeView)TreeView.this).contentRenderer.indiRenderer = TreeView.this.getEntityRenderer("INDI");
            ((TreeView)TreeView.this).contentRenderer.famRenderer = TreeView.this.getEntityRenderer("FAM");
            TreeView.this.contentRenderer.render(gw, TreeView.this.model);
        }

        public void mousePressed(MouseEvent e) {
            this.requestFocusInWindow();
            Point p = TreeView.this.view2model(e.getPoint());
            Object content = TreeView.this.model.getContentAt(p.x, p.y);
            if (content == null) {
                this.repaint();
                TreeView.this.overview.repaint();
            }
            if (content instanceof Entity) {
                Entity entity = (Entity)content;
                if ((e.getModifiers() & 0x80) != 0) {
                    ArrayList<Entity> entities = new ArrayList<Entity>(TreeView.this.context.getEntities());
                    if (entities.contains(entity)) {
                        entities.remove(entity);
                    } else {
                        entities.add(entity);
                    }
                } else {
                    TreeView.this.context = new Context(entity);
                }
                SelectionDispatcher.fireSelection((AWTEvent)e, (Context)TreeView.this.context);
            }
        }

        public void mouseClicked(MouseEvent e) {
            this.requestFocusInWindow();
            Point p = TreeView.this.view2model(e.getPoint());
            Object content = TreeView.this.model.getContentAt(p.x, p.y);
            if (content instanceof Runnable) {
                ((Runnable)content).run();
            }
        }

        private class Up
        extends AbstractAncestrisAction {
            private Up() {
            }

            public void actionPerformed(ActionEvent e) {
                System.out.println("up");
            }
        }
    }

    private class Overview
    extends ViewPortOverview
    implements ModelListener {
        private Overview(JScrollPane scroll) {
            super(scroll.getViewport());
            super.setSize(new Dimension(TreeView.this.getWidth() / 4, TreeView.this.getHeight() / 4));
        }

        public void addNotify() {
            super.addNotify();
            TreeView.this.model.addListener(this);
        }

        public void removeNotify() {
            TreeView.this.model.removeListener(this);
            super.removeNotify();
        }

        public void setSize(int width, int height) {
            width = Math.max(32, width);
            height = Math.max(32, height);
            super.setSize(width, height);
        }

        protected void renderContent(Graphics g, double zoomx, double zoomy) {
            g.setColor(Color.WHITE);
            Rectangle r = g.getClipBounds();
            g.fillRect(r.x, r.y, r.width, r.height);
            UnitGraphics gw = new UnitGraphics(g, TreeView.this.DPMM.getX() * zoomx * TreeView.this.zoom, TreeView.this.DPMM.getY() * zoomy * TreeView.this.zoom);
            ((TreeView)TreeView.this).contentRenderer.overview = true;
            ((TreeView)TreeView.this).contentRenderer.cBackground = ((TreeView)TreeView.this).style.colors.get("background");
            ((TreeView)TreeView.this).contentRenderer.cMaleIndiShape = Color.BLACK;
            ((TreeView)TreeView.this).contentRenderer.cFemaleIndiShape = Color.BLACK;
            ((TreeView)TreeView.this).contentRenderer.cUnknownIndiShape = Color.BLACK;
            ((TreeView)TreeView.this).contentRenderer.cFamShape = Color.BLACK;
            ((TreeView)TreeView.this).contentRenderer.cArcs = Color.LIGHT_GRAY;
            ((TreeView)TreeView.this).contentRenderer.cSelectedShape = ((TreeView)TreeView.this).style.colors.get("selects");
            ((TreeView)TreeView.this).contentRenderer.cRootShape = ((TreeView)TreeView.this).style.colors.get("roots");
            ((TreeView)TreeView.this).contentRenderer.indisThick = 1;
            ((TreeView)TreeView.this).contentRenderer.famsThick = 1;
            ((TreeView)TreeView.this).contentRenderer.selected = TreeView.this.context.getEntities();
            ((TreeView)TreeView.this).contentRenderer.root = TreeView.this.getRoot();
            ((TreeView)TreeView.this).contentRenderer.indiRenderer = null;
            ((TreeView)TreeView.this).contentRenderer.famRenderer = null;
            TreeView.this.contentRenderer.render(gw, TreeView.this.model);
            gw.popTransformation();
        }

        @Override
        public void nodesChanged(Model arg0, Collection<TreeNode> arg1) {
            this.repaint();
        }

        @Override
        public void structureChanged(Model arg0) {
            this.repaint();
        }
    }
}

