/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.imports.gedcom;

import ancestris.api.imports.Import;
import ancestris.modules.gedcom.utilities.GedcomUtilities;
import ancestris.modules.imports.gedcom.Bundle;
import ancestris.modules.imports.gedcom.ImportHeredis;
import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyFile;
import genj.gedcom.TagPath;
import java.io.File;
import java.io.IOException;
import java.util.Stack;
import org.openide.util.NbBundle;

public class ImportFamilyTreeMaker
extends Import {
    public boolean isGeneric() {
        return false;
    }

    public String toString() {
        return Bundle.importfamilytreemaker_name();
    }

    protected String getImportComment() {
        return Bundle.importfamilytreemaker_note();
    }

    protected void firstPass() {
        super.firstPass();
    }

    protected boolean process() throws IOException {
        String tag = this.input.getTag();
        TagPath path = this.input.getPath();
        if (this.input.getLevel() == 2 && this.input.getTag().equals("VERS") && this.input.getValue().startsWith("5.5")) {
            GEDCOM_VERSION = "5.5.1";
            this.output.writeLine(2, "VERS", GEDCOM_VERSION);
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixVersion", (Object)GEDCOM_VERSION));
            ++this.nbChanges;
            return true;
        }
        if ("OBJE:FILE:TEXT".equalsIgnoreCase(path.toString())) {
            String result = this.output.writeLine(this.input.getLevel(), "_" + tag, this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if ("OBJE:FILE:DATE".equalsIgnoreCase(path.toString())) {
            String result = this.output.writeLine(this.input.getLevel(), "_" + tag, this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if ("INDI:ALIA".equalsIgnoreCase(path.toString())) {
            String result = this.output.writeLine(this.input.getLevel(), "NAME", this.input.getValue());
            result = result + "\n" + this.output.writeLine(this.input.getLevel() + 1, "TYPE", "aka");
            this.console.println(NbBundle.getMessage(Import.class, (String)"Import.fixNames", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if ("INDI:NAME:OBJE".equalsIgnoreCase(path.toString())) {
            this.output.writeLine(this.input.getLevel() - 1, this.input.getXref(), tag, this.input.getValue());
            return true;
        }
        return super.process();
    }

    protected void finalise() throws IOException {
        super.finalise();
    }

    public boolean fixGedcom(Gedcom gedcom) {
        boolean ret = super.fixGedcom(gedcom);
        this.incrementProgress();
        return ret |= this.fixOther(gedcom);
    }

    public void complete() {
        super.complete();
    }

    public boolean fixOther(Gedcom gedcom) {
        boolean hasErrors = false;
        Property[] props = null;
        Property prop = null;
        Property host = null;
        Stack<Property> propToDelete = new Stack<Property>();
        for (Entity entity : gedcom.getEntities()) {
            for (Property page : entity.getAllProperties("PAGE")) {
                String value = page.getValue();
                int n = page.getNoOfProperties();
                for (int i = 0; i < n; ++i) {
                    prop = page.getProperty(i);
                    if (prop.getTag().equals("CONC")) {
                        value = value + prop.getValue();
                        propToDelete.add(prop);
                        continue;
                    }
                    if (!prop.getTag().equals("CONT")) continue;
                    value = value + " " + prop.getValue();
                    propToDelete.add(prop);
                }
                if (n <= 0) continue;
                page.setValue(value);
                while (!propToDelete.empty()) {
                    page.delProperty((Property)propToDelete.pop());
                }
                ++this.nbChanges;
                hasErrors = true;
            }
            if (entity.getTag().equals("INDI") && (host = entity.getProperty("NAME")) != null) {
                for (Property sour : props = host.getProperties("SOUR")) {
                    try {
                        GedcomUtilities.movePropertyRecursively((Property)sour, (Property)entity);
                        ++this.nbChanges;
                    }
                    catch (GedcomException ex) {
                        // empty catch block
                    }
                }
                for (Property note : props = host.getProperties("NOTE")) {
                    try {
                        GedcomUtilities.movePropertyRecursively((Property)note, (Property)entity);
                        ++this.nbChanges;
                    }
                    catch (GedcomException ex) {
                        // empty catch block
                    }
                }
            }
            if (entity.getTag().equals("INDI")) {
                this.reduceEvents(entity, "BIRT");
                this.reduceEvents(entity, "BAPM");
                this.reduceEvents(entity, "DEAT");
                this.reduceEvents(entity, "BURI");
                this.reduceEvents(entity, "CREM");
            }
            if (!entity.getTag().equals("OBJE")) continue;
            prop = entity.getProperty("FORM");
            if (prop != null && (host = entity.getProperty("FILE")) != null) {
                host.addProperty("FORM", prop.getValue());
                prop.getParent().delProperty(prop);
                hasErrors = true;
            }
            if ((host = entity.getProperty("FILE")) != null) {
                prop = host.getProperty("FORM");
                if (prop == null) {
                    String ext = FileChooserBuilder.getExtension((String)host.getValue());
                    if (ext == null) {
                        ext = "none";
                    }
                    host.addProperty("FORM", ext);
                    hasErrors = true;
                }
                if ((prop = host.getProperty("TITL")) != null) continue;
                PropertyFile filep = (PropertyFile)host;
                File file = filep.getFile();
                String title = file != null ? file.getName() : "";
                int i = title.indexOf(".");
                host.addProperty("TITL", i == -1 ? title : title.substring(0, i));
                hasErrors = true;
                continue;
            }
            entity.addDefaultProperties();
        }
        return hasErrors;
    }
}

