/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.imports.gedcom;

import ancestris.api.imports.Import;
import ancestris.modules.imports.gedcom.Bundle;
import ancestris.modules.imports.gedcom.ImportGramps;
import ancestris.modules.imports.gedcom.ImportHeredis;
import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.Gedcom;
import genj.gedcom.Grammar;
import genj.gedcom.Property;
import genj.gedcom.PropertyFile;
import genj.gedcom.TagPath;
import java.io.IOException;
import java.util.List;
import org.openide.util.NbBundle;

public class ImportGeneatique
extends Import {
    public boolean isGeneric() {
        return false;
    }

    public String toString() {
        return Bundle.importgeneatique_name();
    }

    protected String getImportComment() {
        return Bundle.importgeneatique_note();
    }

    protected void firstPass() {
        super.firstPass();
    }

    protected boolean process() throws IOException {
        String tag = this.input.getTag();
        TagPath path = this.input.getPath();
        if (path.toString().endsWith("ASSO:TYPE")) {
            String result = this.output.writeLine(this.input.getLevel(), "RELA", this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixAssoRela", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if (super.process()) {
            return true;
        }
        return this.processOther();
    }

    protected void finalise() throws IOException {
        super.finalise();
    }

    public boolean fixGedcom(Gedcom gedcom) {
        boolean ret = super.fixGedcom(gedcom);
        ret |= this.fixOther(gedcom);
        this.incrementProgress();
        return ret |= super.convertAssociations(gedcom);
    }

    public void complete() {
        super.complete();
    }

    private boolean processOther() {
        return false;
    }

    public boolean fixOther(Gedcom gedcom) {
        boolean hasErrors = false;
        Object props = null;
        Property prop = null;
        Property host = null;
        if (gedcom.getGrammar().equals(Grammar.V55)) {
            List fileList = gedcom.getPropertiesByClass(PropertyFile.class);
            for (Property file : fileList) {
                host = file.getParent();
                prop = host.getProperty("FORM");
                if (prop != null) continue;
                String ext = FileChooserBuilder.getExtension((String)file.getValue());
                if (ext == null) {
                    ext = "none";
                }
                host.addProperty("FORM", ext);
                this.console.println(NbBundle.getMessage(ImportGramps.class, (String)"Import.fixMediaForm", (Object)file.toString()));
                hasErrors = true;
            }
        }
        return hasErrors;
    }
}

