/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.imports.gedcom;

import ancestris.api.imports.Import;
import ancestris.modules.gedcom.utilities.GedcomUtilities;
import ancestris.modules.imports.gedcom.Bundle;
import ancestris.modules.imports.gedcom.ImportHeredis;
import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertySource;
import genj.gedcom.Source;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.openide.util.NbBundle;

public class ImportLegacy
extends Import {
    protected static Pattern tag_plac_pattern = Pattern.compile("(PLAC|FORM|FONE|TYPE|ROMN|MAP|LATI|LONG|NOTE|CONC|CONT)");
    private static String PLACE_RECORD_TAG = "_PLAC_DEFN";
    private static HashMap<String, ImportPlace> hashPlaces;
    private static String EVENT_RECORD_TAG;
    private static HashMap<String, String> hashEventsToNoteID;
    private int eventIndex = 0;
    private static String TODO_RECORD_TAG;
    private int todoIndex = 0;
    private static String HASHTAG_RECORD_TAG;
    private static String STORY_RECORD_TAG;
    private boolean fixindi = false;
    private boolean fixaddr = false;

    public ImportLegacy() {
        hashPlaces = new HashMap();
        hashEventsToNoteID = new HashMap();
    }

    public boolean isGeneric() {
        return false;
    }

    public String toString() {
        return Bundle.importlegacy_name();
    }

    protected String getImportComment() {
        return Bundle.importlegacy_note();
    }

    protected void init() {
        super.init();
        hashPlaces.clear();
        hashEventsToNoteID.clear();
        this.eventIndex = 0;
        this.todoIndex = 0;
        this.fixindi = false;
        this.fixaddr = false;
    }

    protected void firstPass() {
        super.firstPass();
        if (this.input.getLevel() == 0 && this.input.getTag().equals(PLACE_RECORD_TAG)) {
            String key = "";
            ImportPlace importPlace = null;
            String tag = "";
            try {
                this.input.getNextLine(false);
                key = this.input.getValue();
                if (!hashPlaces.containsKey(key)) {
                    importPlace = new ImportPlace();
                    hashPlaces.put(key, importPlace);
                }
                importPlace = hashPlaces.get(key);
                importPlace.used = false;
                while (this.input.getLevel() != 0) {
                    this.input.getNextLine(true);
                    tag = this.input.getTag();
                    if (!tag.startsWith("_") && !tag_plac_pattern.matcher(tag).matches()) {
                        tag = "_" + tag;
                    }
                    importPlace.addLine(this.input.getLevel() - 1, tag, this.input.getValue());
                    this.input.getNextLine(false);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(Import.class, (String)"error.unknown") + e);
                return;
            }
            return;
        }
        if (this.input.getLevel() == 0 && this.input.getTag().equals(EVENT_RECORD_TAG)) {
            ++this.eventIndex;
            hashEventsToNoteID.put(this.input.getValue(), "E" + this.eventIndex);
            return;
        }
        if ("INDI:BURI:CREM".equalsIgnoreCase(this.input.getPath().toString())) {
            this.fixindi = true;
        }
        if ("INDI:ADDR".equalsIgnoreCase(this.input.getPath().toString())) {
            this.fixindi = true;
        }
        if (this.input.getPath().toString().endsWith("ADDR:MAP")) {
            this.fixaddr = true;
        }
        if (this.input.getPath().toString().endsWith("ADDR:NOTE")) {
            this.fixaddr = true;
        }
    }

    protected boolean process() throws IOException {
        String path = this.input.getPath().toString();
        if ("FAM:BLES".equalsIgnoreCase(path)) {
            String tag = "MARR";
            String result = null;
            int level = this.input.getLevel();
            String line = this.input.getLine();
            if (this.input.getValue().length() != 0) {
                if (this.input.getValue().equalsIgnoreCase("y")) {
                    this.output.writeLine(level, tag, this.input.getValue());
                } else {
                    result = this.output.writeLine(level, tag, null);
                    result = result + "\n" + this.output.writeLine(level + 1, "NOTE", this.input.getValue());
                }
            } else {
                String temp = this.input.getNextLine(false);
                if (temp != null && this.input.getLevel() == level + 1) {
                    this.output.writeLine(level, tag, null);
                } else {
                    result = this.output.writeLine(level, tag, "Y");
                }
            }
            if (result != null) {
                ++this.nbChanges;
                this.console.println(NbBundle.getMessage(ImportLegacy.class, (String)"Import.fixTagNotAllowed", (Object)(line + " ==> " + "MARR")));
            }
            return true;
        }
        if ("REPO:ADDR:MAP".equalsIgnoreCase(path)) {
            this.output.writeLine(this.input.getLevel(), "_MAP", this.input.getValue());
            ++this.nbChanges;
            return true;
        }
        if ("REPO:ADDR:MAP:LATI".equalsIgnoreCase(path)) {
            this.output.writeLine(this.input.getLevel(), "_LATI", this.input.getValue());
            ++this.nbChanges;
            return true;
        }
        if ("REPO:ADDR:MAP:LONG".equalsIgnoreCase(path)) {
            this.output.writeLine(this.input.getLevel(), "_LONG", this.input.getValue());
            ++this.nbChanges;
            return true;
        }
        if ("REPO:ADDR:OBJE".equalsIgnoreCase(path)) {
            this.output.writeLine(this.input.getLevel(), "_OBJE", this.input.getValue());
            ++this.nbChanges;
            return true;
        }
        if ("REPO:ADDR:OBJE:FILE".equalsIgnoreCase(path)) {
            this.output.writeLine(this.input.getLevel(), "_FILE", this.input.getValue());
            ++this.nbChanges;
            return true;
        }
        if ("REPO:ADDR:OBJE:FORM".equalsIgnoreCase(path)) {
            this.output.writeLine(this.input.getLevel(), "_FORM", this.input.getValue());
            ++this.nbChanges;
            return true;
        }
        if (this.input.getTag().equals(STORY_RECORD_TAG)) {
            this.output.writeLine(this.input.getLevel(), this.input.getXref(), "NOTE", this.input.getValue());
            ++this.nbChanges;
            return true;
        }
        if ((STORY_RECORD_TAG + ":TITL").equalsIgnoreCase(path)) {
            String result = this.output.writeLine(1, "CONC", this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if ((STORY_RECORD_TAG + ":DATE").equalsIgnoreCase(path)) {
            String result = this.output.writeLine(1, "CONT", this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if ((STORY_RECORD_TAG + ":PLAC").equalsIgnoreCase(path)) {
            String result = this.output.writeLine(1, "CONT", this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if ((STORY_RECORD_TAG + ":TEXT").equalsIgnoreCase(path)) {
            String result = this.output.writeLine(1, "CONT", this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if ((STORY_RECORD_TAG + ":TEXT:CONC").equalsIgnoreCase(path)) {
            String result = this.output.writeLine(1, "CONC", this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if ((STORY_RECORD_TAG + ":TEXT:CONT").equalsIgnoreCase(path)) {
            String result = this.output.writeLine(1, "CONT", this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if ((HASHTAG_RECORD_TAG + ":NOTE").equalsIgnoreCase(path)) {
            this.output.writeLine(this.input.getLevel(), "_NOTE", this.input.getValue());
            ++this.nbChanges;
            return true;
        }
        if ("DATE".equals(this.input.getTag())) {
            String date = this.input.getValue().toLowerCase().replace(".", "").replace("okt", "Oct").replace("maj", "May").replace("eft", "AFT").replace("omkr", "ABT").replace("omk", "ABT").replace("f\u00f8r", "BEF").replace("ansl", "EST").replace("ansl", "EST").replace("fra", "FROM").replace("til", "TO").replace("mel", "BET").replace("og", "AND");
            if (date.contains("/")) {
                date = this.convertDate(date);
            }
            this.output.writeLine(this.input.getLevel(), "DATE", date);
            ++this.nbChanges;
            return true;
        }
        if (super.process()) {
            return true;
        }
        if ("PLAC".equals(this.input.getTag()) && this.input.getLevel() > 1) {
            int rootlevel = this.input.getLevel();
            String key = this.input.getValue();
            ImportPlace importPlace = hashPlaces.get(key);
            if (importPlace != null) {
                importPlace.used = true;
                for (int i = 0; i < importPlace.levels.size(); ++i) {
                    this.output.writeLine(rootlevel + importPlace.levels.get(i), importPlace.tags.get(i), importPlace.values.get(i));
                }
            } else {
                this.output.writeLine(this.input.getLevel(), this.input.getTag(), this.input.getValue());
            }
            ++this.nbChanges;
            return true;
        }
        if ("TYPE".equals(this.input.getTag()) && this.input.getLevel() == 2) {
            this.output.writeLine(this.input.getLevel(), this.input.getTag(), this.input.getValue());
            String xref = hashEventsToNoteID.get(this.input.getValue());
            if (xref != null) {
                this.output.writeLine(this.input.getLevel(), "NOTE", "@" + xref + "@");
            }
            ++this.nbChanges;
            return true;
        }
        if (this.input.getLevel() == 0 && this.input.getTag().equals(EVENT_RECORD_TAG)) {
            String xref = hashEventsToNoteID.get(this.input.getValue());
            this.output.writeLine(this.input.getLevel(), xref, "NOTE", this.input.getValue());
            String tag = "";
            this.input.getNextLine(false);
            while (this.input.getLevel() != 0) {
                this.input.getNextLine(true);
                tag = this.input.getTag();
                if (!tag.startsWith("_")) {
                    tag = "_" + tag;
                }
                this.output.writeLine(this.input.getLevel(), tag, this.input.getValue());
                this.input.getNextLine(false);
            }
            ++this.nbChanges;
            return true;
        }
        if (this.input.getLevel() == 0 && this.input.getTag().equals(TODO_RECORD_TAG)) {
            ++this.todoIndex;
            int level = this.input.getLevel();
            String value = this.input.getValue();
            if (value == null || value.isEmpty()) {
                this.input.getNextLine(false);
                value = this.input.getValue();
            }
            this.output.writeLine(level, "T" + this.todoIndex, "NOTE", value);
            String tag = "";
            this.input.getNextLine(false);
            while (this.input.getLevel() != 0) {
                this.input.getNextLine(true);
                tag = this.input.getTag();
                if ("DESC".equals(tag)) {
                    tag = "TODO";
                }
                if (!tag.startsWith("_")) {
                    tag = "_" + tag;
                }
                this.output.writeLine(this.input.getLevel(), tag, this.input.getValue());
                this.input.getNextLine(false);
            }
            ++this.nbChanges;
            return true;
        }
        if (this.input.getLevel() > 0 && this.input.getTag().equals(TODO_RECORD_TAG)) {
            int rootLevel = this.input.getLevel();
            this.output.writeLine(this.input.getLevel(), this.input.getTag(), this.input.getValue());
            String tag = "";
            this.input.getNextLine(false);
            while (this.input.getLevel() > rootLevel) {
                this.input.getNextLine(true);
                tag = this.input.getTag();
                if ("DESC".equals(tag)) {
                    tag = "_TODO";
                }
                if (!tag.startsWith("_")) {
                    tag = "_" + tag;
                }
                this.output.writeLine(this.input.getLevel(), tag, this.input.getValue());
                this.input.getNextLine(false);
            }
            ++this.nbChanges;
            return true;
        }
        if ("SOUR:MEDI".equalsIgnoreCase(path)) {
            String result = this.output.writeLine(this.input.getLevel(), "NOTE", this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportLegacy.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            ++this.nbChanges;
            return true;
        }
        return this.processOther();
    }

    protected void finalise() throws IOException {
        super.finalise();
        int p = 0;
        String tag = "";
        for (String key : hashPlaces.keySet()) {
            ImportPlace importPlace = hashPlaces.get(key);
            if (!importPlace.used) {
                this.output.writeLine(0, "P" + ++p, "NOTE", importPlace.values.get(0));
                for (int i = 0; i < importPlace.levels.size(); ++i) {
                    tag = importPlace.tags.get(i);
                    if (!tag.startsWith("_")) {
                        tag = "_" + tag;
                    }
                    this.output.writeLine(1 + importPlace.levels.get(i), tag, importPlace.values.get(i));
                }
            }
            ++this.nbChanges;
        }
    }

    public boolean fixGedcom(Gedcom gedcom) {
        boolean ret = this.fixNames(gedcom);
        ret |= this.fixOther(gedcom);
        this.incrementProgress();
        this.incrementProgress();
        return ret |= this.fixPlaces(gedcom);
    }

    public void complete() {
        super.complete();
    }

    private boolean processOther() {
        return false;
    }

    public boolean fixOther(Gedcom gedcom) {
        boolean hasErrors = false;
        Property[] props = null;
        Property prop = null;
        Property host = null;
        if (this.fixindi) {
            Property crem = null;
            for (Entity entity : gedcom.getIndis()) {
                for (Property buri : entity.getProperties("BURI")) {
                    crem = buri.getProperty("CREM");
                    if (crem == null) continue;
                    buri.delProperty(crem);
                    try {
                        crem = entity.addProperty("CREM", buri.getValue());
                        for (Property p : buri.getProperties()) {
                            GedcomUtilities.movePropertyRecursively((Property)p, (Property)crem);
                        }
                    }
                    catch (GedcomException ex) {
                        continue;
                    }
                    entity.delProperty(buri);
                    ++this.nbChanges;
                }
                for (Property addr : entity.getProperties("ADDR")) {
                    prop = entity.getProperty("RESI");
                    if (prop == null) {
                        prop = entity.addProperty("RESI", "");
                    }
                    try {
                        GedcomUtilities.movePropertyRecursively((Property)addr, (Property)prop);
                        ++this.nbChanges;
                    }
                    catch (GedcomException ex) {
                        // empty catch block
                    }
                }
                for (Property phon : entity.getProperties("PHON")) {
                    prop = entity.getProperty("RESI");
                    if (prop == null) {
                        prop = entity.addProperty("RESI", "");
                    }
                    prop.addProperty(phon.getTag(), phon.getValue());
                    entity.delProperty(phon);
                    ++this.nbChanges;
                }
                for (Property email : entity.getProperties("EMAIL")) {
                    prop = entity.getProperty("RESI");
                    if (prop == null) {
                        prop = entity.addProperty("RESI", "");
                    }
                    prop.addProperty(email.getTag(), email.getValue());
                    entity.delProperty(email);
                    ++this.nbChanges;
                }
                for (Property www : entity.getProperties("WWW")) {
                    prop = entity.getProperty("RESI");
                    if (prop == null) {
                        prop = entity.addProperty("RESI", "");
                    }
                    prop.addProperty(www.getTag(), www.getValue());
                    entity.delProperty(www);
                    ++this.nbChanges;
                }
                for (Property cause : entity.getAllProperties("CAUS")) {
                    for (Property source : props = cause.getProperties()) {
                        try {
                            GedcomUtilities.movePropertyRecursively((Property)source, (Property)cause.getParent());
                            ++this.nbChanges;
                        }
                        catch (GedcomException ex) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        if (this.fixaddr) {
            for (Entity entity : gedcom.getEntities()) {
                for (Property addr : entity.getAllProperties("ADDR")) {
                    for (Property map : addr.getAllProperties("MAP")) {
                        String city = addr.getPropertyValue("CITY");
                        String stae = addr.getPropertyValue("STAE");
                        String ctry = addr.getPropertyValue("CTRY");
                        Property plac = addr.getParent().addProperty("PLAC", city + "," + stae + "," + ctry);
                        try {
                            GedcomUtilities.movePropertyRecursively((Property)map, (Property)plac);
                            ++this.nbChanges;
                        }
                        catch (GedcomException ex) {}
                    }
                    for (Property note : addr.getAllProperties("NOTE")) {
                        try {
                            GedcomUtilities.movePropertyRecursively((Property)note, (Property)addr.getParent());
                            ++this.nbChanges;
                        }
                        catch (GedcomException ex) {}
                    }
                }
            }
        }
        for (Entity entity : gedcom.getEntities()) {
            int n;
            for (Property obje : entity.getAllProperties("OBJE")) {
                prop = obje.getProperty("FORM");
                if (prop != null && (host = obje.getProperty("FILE")) != null) {
                    host.addProperty("FORM", prop.getValue());
                    prop.getParent().delProperty(prop);
                    hasErrors = true;
                    ++this.nbChanges;
                }
                if ((host = obje.getProperty("FILE")) == null) continue;
                prop = host.getProperty("FORM");
                if (prop == null) {
                    host.addProperty("FORM", FileChooserBuilder.getExtension((String)host.getValue()));
                    hasErrors = true;
                    ++this.nbChanges;
                }
                if ((prop = obje.getProperty("TITL")) != null || !(host instanceof PropertyFile)) continue;
                PropertyFile filep = (PropertyFile)host;
                File file = filep.getFile();
                String title = file != null ? file.getName() : "";
                int i = title.indexOf(".");
                obje.addProperty("TITL", i == -1 ? title : title.substring(0, i));
                hasErrors = true;
                ++this.nbChanges;
            }
            for (Property source : entity.getAllProperties("SOUR")) {
                Property[] data;
                Property[] dates = source.getProperties("DATE");
                if (dates != null && dates.length > 0) {
                    data = source.getProperty("DATA");
                    if (data == null) {
                        data = source.addProperty("DATA", "");
                    }
                    Property[] propertyArray = dates;
                    n = propertyArray.length;
                    for (int ctry = 0; ctry < n; ++ctry) {
                        Property date = propertyArray[ctry];
                        data.addProperty("DATE", date.getValue());
                        source.delProperty(date);
                    }
                    ++this.nbChanges;
                }
                for (Property page : source.getProperties("PAGE")) {
                    Property[] conts;
                    Property[] concs;
                    String value = page.getValue();
                    for (Property conc : concs = page.getProperties("CONC")) {
                        value = value + conc.getValue();
                        page.delProperty(conc);
                    }
                    for (Property cont : conts = page.getProperties("CONT")) {
                        value = value + cont.getValue();
                        page.delProperty(cont);
                    }
                    page.setValue(value);
                    ++this.nbChanges;
                }
                data = source.getProperties("REFN");
                int n2 = data.length;
                for (n = 0; n < n2; ++n) {
                    Property refn = data[n];
                    if (source instanceof PropertySource) {
                        PropertySource pSource = (PropertySource)source;
                        Source sourceEntity = (Source)pSource.getTargetEntity();
                        sourceEntity.addProperty("REFN", refn.getValue());
                    } else {
                        source.addProperty("_REFN", refn.getValue());
                    }
                    source.delProperty(refn);
                    ++this.nbChanges;
                }
            }
            for (Property note : entity.getAllProperties("NOTE")) {
                Property[] tags;
                Property[] data = tags = note.getProperties("DATE");
                int n3 = data.length;
                for (n = 0; n < n3; ++n) {
                    Property tag = data[n];
                    note.addProperty("_DATE", tag.getValue());
                    note.delProperty(tag);
                    ++this.nbChanges;
                }
            }
            for (Property type : entity.getAllProperties("TYPE")) {
                Property date = type.getProperty("DATE");
                if (date == null) continue;
                Property even = entity.addProperty("EVEN", "");
                even.addProperty("TYPE", type.getValue());
                even.addProperty("DATE", date.getValue());
                type.delProperty(date);
                type.getParent().delProperty(type);
                ++this.nbChanges;
            }
            if (!entity.getTag().equals("SOUR")) continue;
            for (Property date : entity.getAllProperties("DATE")) {
                entity.addProperty("_DATE", date.getValue());
                entity.delProperty(date);
                ++this.nbChanges;
            }
        }
        return hasErrors;
    }

    static {
        EVENT_RECORD_TAG = "_EVENT_DEFN";
        TODO_RECORD_TAG = "_TODO";
        HASHTAG_RECORD_TAG = "_HASHTAG_DEFN";
        STORY_RECORD_TAG = "_STORY";
    }

    private class ImportPlace {
        protected boolean used = false;
        protected List<Integer> levels = new LinkedList<Integer>();
        protected List<String> tags = new LinkedList<String>();
        protected List<String> values = new LinkedList<String>();

        private ImportPlace() {
        }

        private void addLine(int level, String tag, String value) {
            this.levels.add(level);
            this.tags.add(tag);
            this.values.add(value);
        }
    }
}

