/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.imports.gedcom;

import ancestris.api.imports.Import;
import ancestris.modules.imports.gedcom.Bundle;
import ancestris.modules.imports.gedcom.ImportGramps;
import ancestris.modules.imports.gedcom.ImportHeredis;
import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Grammar;
import genj.gedcom.Property;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertySource;
import genj.gedcom.TagPath;
import java.io.IOException;
import java.util.List;
import org.openide.util.NbBundle;

public class ImportMyHeritage
extends Import {
    public boolean isGeneric() {
        return false;
    }

    public String toString() {
        return Bundle.importmyheritage_name();
    }

    protected String getImportComment() {
        return Bundle.importmyheritage_note();
    }

    protected void firstPass() {
        super.firstPass();
    }

    protected boolean process() throws IOException {
        if (super.process()) {
            return true;
        }
        return this.processOther();
    }

    protected void finalise() throws IOException {
        super.finalise();
    }

    public boolean fixGedcom(Gedcom gedcom) {
        boolean ret = super.fixGedcom(gedcom);
        this.incrementProgress();
        return ret |= this.fixOther(gedcom);
    }

    public void complete() {
        super.complete();
    }

    private boolean processOther() throws IOException {
        String tag = this.input.getTag();
        TagPath path = this.input.getPath();
        if ("RIN".equals(tag) && path.length() != 2) {
            String result = this.output.writeLine(this.input.getLevel(), "_" + tag, this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if ("FAM:NCHI:NOTE".equalsIgnoreCase(path.toString())) {
            String result = this.output.writeLine(this.input.getLevel(), "_" + tag, this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        return false;
    }

    public boolean fixOther(Gedcom gedcom) {
        boolean hasErrors = false;
        if (gedcom.getGrammar().equals(Grammar.V551)) {
            List fileList = gedcom.getPropertiesByClass(PropertyFile.class);
            Property obje = null;
            Property form = null;
            for (Property file : fileList) {
                obje = file.getParent();
                form = obje.getProperty("FORM");
                if (form != null) {
                    if (file.getProperty("FORM") == null) {
                        file.addProperty("FORM", form.getValue());
                    }
                    obje.delProperty(form);
                    this.console.println(NbBundle.getMessage(ImportGramps.class, (String)"Import.fixMediaForm", (Object)file.toString()));
                    hasErrors = true;
                    continue;
                }
                if (file.getProperty("FORM") != null) continue;
                String value = file.getValue();
                String ext = "";
                ext = value.startsWith("http") ? "web" : FileChooserBuilder.getExtension((String)value);
                if (ext == null) {
                    ext = "none";
                }
                file.addProperty("FORM", ext);
                this.console.println(NbBundle.getMessage(ImportGramps.class, (String)"Import.fixMediaForm", (Object)file.toString()));
                hasErrors = true;
            }
        }
        List sourceLinks = gedcom.getPropertiesByClass(PropertySource.class);
        for (PropertySource ps : sourceLinks) {
            Property[] props = ps.getProperties("PAGE");
            if (props.length <= 1) continue;
            int cnt = 0;
            for (Property page : props) {
                if (++cnt <= 1) continue;
                ps.addProperty("_PAGE", page.getValue());
                ps.delProperty(page);
            }
            this.console.println(NbBundle.getMessage(ImportGramps.class, (String)"Import.fixSource") + " : " + ps.toString());
            hasErrors = true;
        }
        for (Entity entity : gedcom.getEntities()) {
            if (!entity.getTag().equals("INDI")) continue;
            this.reduceEvents(entity, "BIRT");
            this.reduceEvents(entity, "BAPM");
            this.reduceEvents(entity, "DEAT");
            this.reduceEvents(entity, "BURI");
            this.reduceEvents(entity, "CREM");
            this.reduceEvents(entity, "CONF");
        }
        return hasErrors;
    }
}

