/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.Vector;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waiter;

public class EventTool
implements Timeoutable,
Outputable {
    private static final long WAIT_EVENT_TIMEOUT = 60000L;
    private static final long WAIT_NO_EVENT_TIMEOUT = 180000L;
    private static final long EVENT_CHECKING_DELTA = 10L;
    private static ListenerSet listenerSet;
    private static long currentEventMask;
    private TestOut output;
    private Timeouts timeouts;

    public EventTool() {
        this.setOutput(JemmyProperties.getProperties().getOutput());
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
    }

    public static long getLastEventTime(long eventMask) {
        return listenerSet.getLastEventTime(eventMask);
    }

    public static AWTEvent getLastEvent(long eventMask) {
        return listenerSet.getLastEvent(eventMask);
    }

    public static long getLastEventTime() {
        return EventTool.getLastEventTime(listenerSet.getTheWholeMask());
    }

    public static AWTEvent getLastEvent() {
        return EventTool.getLastEvent(listenerSet.getTheWholeMask());
    }

    public static void addListeners(long eventMask) {
        EventTool.removeListeners();
        listenerSet.addListeners(eventMask);
        currentEventMask = eventMask;
    }

    public static void addListeners() {
        EventTool.addListeners(listenerSet.getTheWholeMask());
    }

    public static void removeListeners() {
        listenerSet.removeListeners();
    }

    public static long getCurrentEventMask() {
        return currentEventMask;
    }

    public static long getTheWholeEventMask() {
        return listenerSet.getTheWholeMask();
    }

    @Override
    public void setTimeouts(Timeouts ts) {
        this.timeouts = ts;
    }

    @Override
    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    @Override
    public void setOutput(TestOut out) {
        this.output = out;
    }

    @Override
    public TestOut getOutput() {
        return this.output;
    }

    public AWTEvent waitEvent(long eventMask) {
        return this.waitEvent(eventMask, this.timeouts.getTimeout("EventTool.WaitEventTimeout"), this.output.createErrorOutput());
    }

    public AWTEvent waitEvent() {
        return this.waitEvent(listenerSet.getTheWholeMask());
    }

    public boolean checkNoEvent(long eventMask, long waitTime) {
        return this.checkNoEvent(eventMask, waitTime, this.output);
    }

    public boolean checkNoEvent(long waitTime) {
        return this.checkNoEvent(listenerSet.getTheWholeMask(), waitTime);
    }

    public void waitNoEvent(long eventMask, long waitTime) {
        NoEventWaiter waiter = new NoEventWaiter(eventMask, waitTime);
        waiter.setTimeouts(this.timeouts.cloneThis());
        waiter.getTimeouts().setTimeout("Waiter.WaitingTime", this.timeouts.getTimeout("EventTool.WaitNoEventTimeout"));
        waiter.getTimeouts().setTimeout("Waiter.TimeDelta", this.timeouts.getTimeout("EventTool.EventCheckingDelta"));
        try {
            waiter.waitAction(null);
        }
        catch (InterruptedException e) {
            this.output.printStackTrace(e);
        }
    }

    public void waitNoEvent(long waitTime) {
        ListenerSet ls = listenerSet;
        if (ls != null) {
            this.waitNoEvent(ls.getTheWholeMask(), waitTime);
        }
    }

    private AWTEvent waitEvent(long eventMask, long waitTime, TestOut waiterOutput) {
        EventWaiter waiter = new EventWaiter(eventMask);
        waiter.setTimeouts(this.timeouts.cloneThis());
        waiter.setOutput(waiterOutput);
        waiter.getTimeouts().setTimeout("Waiter.WaitingTime", waitTime);
        waiter.getTimeouts().setTimeout("Waiter.TimeDelta", this.timeouts.getTimeout("EventTool.EventCheckingDelta"));
        try {
            return (AWTEvent)waiter.waitAction(null);
        }
        catch (InterruptedException e) {
            this.output.printStackTrace(e);
            return null;
        }
    }

    private boolean checkNoEvent(long eventMask, long waitTime, TestOut waiterOutput) {
        try {
            AWTEvent event = this.waitEvent(eventMask, waitTime, TestOut.getNullOutput());
            waiterOutput.printLine("AWT event was produced during waiting: ");
            waiterOutput.printLine(event.getClass().getName());
            return false;
        }
        catch (TimeoutExpiredException e) {
            return true;
        }
    }

    static {
        currentEventMask = 0L;
        Timeouts.initDefault("EventTool.WaitEventTimeout", 60000L);
        Timeouts.initDefault("EventTool.WaitNoEventTimeout", 180000L);
        Timeouts.initDefault("EventTool.EventCheckingDelta", 10L);
        listenerSet = new ListenerSet();
        if (System.getProperty("jemmy.event_listening") == null || !System.getProperty("jemmy.event_listening").equals("no")) {
            listenerSet.addListeners();
        }
    }

    private static class EventType
    implements AWTEventListener {
        long eventMask;
        long eventTime;
        private Reference eventRef;

        public EventType(long eventMask) {
            this.eventMask = eventMask;
            this.eventRef = new WeakReference<Object>(null);
            this.eventTime = -1L;
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            this.eventRef = new WeakReference<AWTEvent>(event);
            this.eventTime = System.currentTimeMillis();
        }

        public AWTEvent getEvent() {
            return (AWTEvent)this.eventRef.get();
        }

        public long getTime() {
            return this.eventTime;
        }

        public long getEventMask() {
            return this.eventMask;
        }
    }

    private static class EventWaiter
    extends Waiter {
        long eventMask;
        long startTime;

        public EventWaiter(long eventMask) {
            this.eventMask = eventMask;
            this.startTime = EventTool.getLastEventTime(eventMask);
        }

        @Override
        public Object actionProduced(Object obj) {
            EventType et = listenerSet.getLastEventType(this.eventMask);
            if (et != null && et.getTime() > this.startTime) {
                return et.getEvent();
            }
            return null;
        }

        @Override
        public String getDescription() {
            return "Last event under " + Long.toString(this.eventMask, 2) + " event mask";
        }
    }

    private static class ListenerSet {
        private Vector eventTypes = new Vector();
        private long theWholeMask;

        public ListenerSet() {
            try {
                Class<?> eventClass = Class.forName("java.awt.AWTEvent");
                Field[] fields = eventClass.getFields();
                this.theWholeMask = 0L;
                for (int i = 0; i < fields.length; ++i) {
                    if ((fields[i].getModifiers() & 9) == 0 || !fields[i].getType().equals(Long.TYPE) || !fields[i].getName().endsWith("_EVENT_MASK")) continue;
                    long eventMask = (Long)fields[i].get(null);
                    this.eventTypes.add(new EventType(eventMask));
                    this.theWholeMask |= eventMask;
                }
            }
            catch (ClassNotFoundException e) {
                JemmyProperties.getCurrentOutput().printStackTrace(e);
            }
            catch (IllegalAccessException e) {
                JemmyProperties.getCurrentOutput().printStackTrace(e);
            }
        }

        public void addListeners(long eventMask) {
            Toolkit dtk = Toolkit.getDefaultToolkit();
            for (int i = 0; i < this.eventTypes.size(); ++i) {
                EventType et = (EventType)this.eventTypes.get(i);
                if ((et.getEventMask() & eventMask) == 0L) continue;
                dtk.addAWTEventListener(et, et.getEventMask());
            }
        }

        public void addListeners() {
            this.addListeners(this.getTheWholeMask());
        }

        public void removeListeners() {
            Toolkit dtk = Toolkit.getDefaultToolkit();
            for (int i = 0; i < this.eventTypes.size(); ++i) {
                dtk.removeAWTEventListener((EventType)this.eventTypes.get(i));
            }
        }

        public long getTheWholeMask() {
            return this.theWholeMask;
        }

        public long getLastEventTime(long eventMask) {
            EventType et = this.getLastEventType(eventMask);
            return et == null ? -1L : et.getTime();
        }

        public AWTEvent getLastEvent(long eventMask) {
            EventType et = this.getLastEventType(eventMask);
            return et == null ? null : et.getEvent();
        }

        private EventType getLastEventType(long eventMask) {
            long maxTime = -1L;
            EventType maxType = null;
            for (int i = 0; i < this.eventTypes.size(); ++i) {
                EventType et = (EventType)this.eventTypes.get(i);
                if ((eventMask & et.getEventMask()) == 0L || et.getTime() <= maxTime) continue;
                maxType = et;
                maxTime = maxType.getTime();
            }
            return maxType;
        }
    }

    private class NoEventWaiter
    extends Waiter {
        long eventMask;
        long waitTime;

        public NoEventWaiter(long eventMask, long waitTime) {
            this.eventMask = eventMask;
            this.waitTime = waitTime;
        }

        @Override
        public Object actionProduced(Object obj) {
            return EventTool.this.checkNoEvent(this.eventMask, this.waitTime, TestOut.getNullOutput()) ? "Reached!" : null;
        }

        @Override
        public String getDescription() {
            return "No event under " + Long.toString(this.eventMask, 2) + " event mask during " + Long.toString(this.waitTime) + " milliseconds";
        }
    }
}

