/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.TableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.TableDriver;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JScrollPaneOperator;
import org.netbeans.jemmy.operators.JTableHeaderOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.util.EmptyVisualizer;

public class JTableOperator
extends JComponentOperator
implements Outputable,
Timeoutable {
    public static final String CELL_PREFIX_DPROP = "Cell";
    public static final String COLUMN_PREFIX_DPROP = "Column";
    public static final String SELECTED_COLUMN_PREFIX_DPROP = "SelectedColumn";
    public static final String SELECTED_ROW_PREFIX_DPROP = "SelectedRow";
    public static final String COLUMN_COUNT_DPROP = "Column count";
    public static final String ROW_COUNT_DPROP = "Row count";
    private static final long WAIT_EDITING_TIMEOUT = 60000L;
    private TestOut output;
    private Timeouts timeouts;
    TableDriver driver = DriverManager.getTableDriver(this.getClass());

    public JTableOperator(JTable b) {
        super(b);
    }

    public JTableOperator(ContainerOperator cont, ComponentChooser chooser, int index) {
        this((JTable)cont.waitSubComponent(new JTableFinder(chooser), index));
        this.copyEnvironment(cont);
    }

    public JTableOperator(ContainerOperator cont, ComponentChooser chooser) {
        this(cont, chooser, 0);
    }

    public JTableOperator(ContainerOperator cont, String text, int row, int column, int index) {
        this((JTable)JTableOperator.waitComponent(cont, (ComponentChooser)new JTableByCellFinder(text, row, column, cont.getComparator()), index));
        this.copyEnvironment(cont);
    }

    public JTableOperator(ContainerOperator cont, String text, int row, int column) {
        this(cont, text, row, column, 0);
    }

    public JTableOperator(ContainerOperator cont, String text, int index) {
        this(cont, text, -1, -1, index);
    }

    public JTableOperator(ContainerOperator cont, String text) {
        this(cont, text, 0);
    }

    public JTableOperator(ContainerOperator cont, int index) {
        this((JTable)JTableOperator.waitComponent(cont, (ComponentChooser)new JTableFinder(), index));
        this.copyEnvironment(cont);
    }

    public JTableOperator(ContainerOperator cont) {
        this(cont, 0);
    }

    public static JTable findJTable(Container cont, ComponentChooser chooser, int index) {
        return (JTable)JTableOperator.findComponent(cont, new JTableFinder(chooser), index);
    }

    public static JTable findJTable(Container cont, ComponentChooser chooser) {
        return JTableOperator.findJTable(cont, chooser, 0);
    }

    public static JTable findJTable(Container cont, String text, boolean ce, boolean ccs, int row, int column, int index) {
        return JTableOperator.findJTable(cont, new JTableByCellFinder(text, row, column, new Operator.DefaultStringComparator(ce, ccs)), index);
    }

    public static JTable findJTable(Container cont, String text, boolean ce, boolean ccs, int row, int column) {
        return JTableOperator.findJTable(cont, text, ce, ccs, row, column, 0);
    }

    public static JTable waitJTable(Container cont, ComponentChooser chooser, int index) {
        return (JTable)JTableOperator.waitComponent(cont, (ComponentChooser)new JTableFinder(chooser), index);
    }

    public static JTable waitJTable(Container cont, ComponentChooser chooser) {
        return JTableOperator.waitJTable(cont, chooser, 0);
    }

    public static JTable waitJTable(Container cont, String text, boolean ce, boolean ccs, int row, int column, int index) {
        return JTableOperator.waitJTable(cont, new JTableByCellFinder(text, row, column, new Operator.DefaultStringComparator(ce, ccs)), index);
    }

    public static JTable waitJTable(Container cont, String text, boolean ce, boolean ccs, int row, int column) {
        return JTableOperator.waitJTable(cont, text, ce, ccs, row, column, 0);
    }

    @Override
    public void setTimeouts(Timeouts times) {
        this.timeouts = times;
        super.setTimeouts(this.timeouts);
    }

    @Override
    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    @Override
    public void setOutput(TestOut out) {
        this.output = out;
        super.setOutput(this.output);
    }

    @Override
    public TestOut getOutput() {
        return this.output;
    }

    @Override
    public void copyEnvironment(Operator anotherOperator) {
        super.copyEnvironment(anotherOperator);
        this.driver = (TableDriver)DriverManager.getDriver("drivers.table", this.getClass(), anotherOperator.getProperties());
    }

    public Point findCell(String text, Operator.StringComparator comparator, int index) {
        return this.findCell(new BySubStringTableCellChooser(text, comparator), index);
    }

    public Point findCell(String text, Operator.StringComparator comparator, int[] rows, int[] columns, int index) {
        return this.findCell(new BySubStringTableCellChooser(text, comparator), rows, columns, index);
    }

    public int findCellRow(String text, Operator.StringComparator comparator, int index) {
        return this.findCell((String)text, (Operator.StringComparator)comparator, (int)index).y;
    }

    public int findCellRow(String text, Operator.StringComparator comparator, int column, int index) {
        return this.findCell((String)text, (Operator.StringComparator)comparator, null, (int[])new int[]{column}, (int)index).y;
    }

    public int findCellColumn(String text, Operator.StringComparator comparator, int index) {
        return this.findCell((String)text, (Operator.StringComparator)comparator, (int)index).x;
    }

    public int findCellColumn(String text, Operator.StringComparator comparator, int row, int index) {
        return this.findCell((String)text, (Operator.StringComparator)comparator, (int[])new int[]{row}, null, (int)index).x;
    }

    public int findCellRow(String text, boolean ce, boolean ccs, int index) {
        return this.findCell((String)text, (boolean)ce, (boolean)ccs, (int)index).y;
    }

    public int findCellColumn(String text, boolean ce, boolean ccs, int index) {
        return this.findCell((String)text, (boolean)ce, (boolean)ccs, (int)index).x;
    }

    public int findCellRow(String text, boolean ce, boolean ccs) {
        return this.findCellRow(text, ce, ccs, 0);
    }

    public int findCellColumn(String text, boolean ce, boolean ccs) {
        return this.findCellColumn(text, ce, ccs, 0);
    }

    public int findCellRow(String text, Operator.StringComparator comparator) {
        return this.findCellRow(text, comparator, 0);
    }

    public int findCellColumn(String text, Operator.StringComparator comparator) {
        return this.findCellColumn(text, comparator, 0);
    }

    public int findCellRow(String text, int index) {
        return this.findCell((String)text, (int)index).y;
    }

    public int findCellRow(String text, int column, int index) {
        return this.findCell((String)text, null, (int[])new int[]{column}, (int)index).y;
    }

    public int findCellColumn(String text, int index) {
        return this.findCell((String)text, (int)index).x;
    }

    public int findCellColumn(String text, int row, int index) {
        return this.findCell((String)text, (int[])new int[]{row}, null, (int)index).x;
    }

    public Point findCell(String text, int index) {
        return this.findCell(text, this.getComparator(), index);
    }

    public Point findCell(String text, int[] rows, int[] columns, int index) {
        return this.findCell(new BySubStringTableCellChooser(text, this.getComparator()), rows, columns, index);
    }

    public int findCellRow(String text) {
        return this.findCellRow(text, 0);
    }

    public int findCellColumn(String text) {
        return this.findCellColumn(text, 0);
    }

    public int findCellRow(ComponentChooser chooser, int index) {
        return this.findCell((ComponentChooser)chooser, (int)index).y;
    }

    public int findCellRow(ComponentChooser chooser, int column, int index) {
        return this.findCell((ComponentChooser)chooser, null, (int[])new int[]{column}, (int)index).y;
    }

    public int findCellColumn(ComponentChooser chooser, int index) {
        return this.findCell((ComponentChooser)chooser, (int)index).x;
    }

    public int findCellColumn(ComponentChooser chooser, int row, int index) {
        return this.findCell((ComponentChooser)chooser, (int[])new int[]{row}, null, (int)index).x;
    }

    public Point findCell(ComponentChooser chooser, int index) {
        return this.findCell(new ByRenderedComponentTableCellChooser(chooser), index);
    }

    public Point findCell(ComponentChooser chooser, int[] rows, int[] columns, int index) {
        return this.findCell(new ByRenderedComponentTableCellChooser(chooser), rows, columns, index);
    }

    public int findCellRow(ComponentChooser chooser) {
        return this.findCellRow(chooser, 0);
    }

    public int findCellColumn(ComponentChooser chooser) {
        return this.findCellColumn(chooser, 0);
    }

    public Point findCell(ComponentChooser chooser) {
        return this.findCell(chooser, 0);
    }

    public int findCellRow(TableCellChooser chooser, int index) {
        return this.findCell((TableCellChooser)chooser, (int)index).y;
    }

    public int findCellRow(TableCellChooser chooser, int column, int index) {
        return this.findCell((TableCellChooser)chooser, null, (int[])new int[]{column}, (int)index).y;
    }

    public int findCellColumn(TableCellChooser chooser, int index) {
        return this.findCell((TableCellChooser)chooser, (int)index).x;
    }

    public int findCellColumn(TableCellChooser chooser, int row, int index) {
        return this.findCell((TableCellChooser)chooser, (int[])new int[]{row}, null, (int)index).x;
    }

    public Point findCell(TableCellChooser chooser, int index) {
        return this.findCell(chooser, null, null, index);
    }

    public Point findCell(TableCellChooser chooser, int[] rows, int[] columns, int index) {
        int[] realColumns;
        int[] realRows;
        TableModel model = this.getModel();
        if (rows != null) {
            realRows = rows;
        } else {
            realRows = new int[model.getRowCount()];
            for (int i = 0; i < model.getRowCount(); ++i) {
                realRows[i] = i;
            }
        }
        if (columns != null) {
            realColumns = columns;
        } else {
            realColumns = new int[model.getColumnCount()];
            for (int i = 0; i < model.getColumnCount(); ++i) {
                realColumns[i] = i;
            }
        }
        int count = 0;
        for (int i = 0; i < realRows.length; ++i) {
            for (int j = 0; j < realColumns.length; ++j) {
                if (!chooser.checkCell(this, realRows[i], realColumns[j])) continue;
                if (count == index) {
                    return new Point(realColumns[j], realRows[i]);
                }
                ++count;
            }
        }
        return new Point(-1, -1);
    }

    public int findCellRow(TableCellChooser chooser) {
        return this.findCellRow(chooser, 0);
    }

    public int findCellColumn(TableCellChooser chooser) {
        return this.findCellColumn(chooser, 0);
    }

    public Point findCell(TableCellChooser chooser) {
        return this.findCell(chooser, 0);
    }

    public void clickOnCell(final int row, final int column, final int clickCount, final int button, final int modifiers) {
        this.output.printLine("Click on (" + Integer.toString(row) + ", " + Integer.toString(column) + ") cell");
        this.output.printGolden("Click on cell");
        this.makeComponentVisible();
        this.scrollToCell(row, column);
        this.getQueueTool().invokeSmoothly(new QueueTool.QueueAction("Path selecting"){

            @Override
            public Object launch() {
                Point point = JTableOperator.this.getPointToClick(row, column);
                JTableOperator.this.clickMouse(point.x, point.y, clickCount, button, modifiers);
                return null;
            }
        });
    }

    public void clickOnCell(int row, int column, int clickCount, int button) {
        this.clickOnCell(row, column, clickCount, button, 0);
    }

    public void clickOnCell(int row, int column, int clickCount) {
        this.clickOnCell(row, column, clickCount, JTableOperator.getDefaultMouseButton());
    }

    public void clickOnCell(int row, int column) {
        this.clickOnCell(row, column, 1);
    }

    public void clickForEdit(int row, int column) {
        this.clickOnCell(row, column, 2);
    }

    public void changeCellText(int row, int column, String newText) {
        this.changeCellObject(row, column, newText);
    }

    public void changeCellObject(int row, int column, Object newValue) {
        this.driver.editCell(this, row, column, newValue);
    }

    public void scrollToCell(int row, int column) {
        this.output.printTrace("Scroll JTable to (" + Integer.toString(row) + "," + Integer.toString(column) + ") cell\n    : " + this.toStringSource());
        this.output.printGolden("Scroll JTable to (" + Integer.toString(row) + "," + Integer.toString(column) + ")");
        this.makeComponentVisible();
        JScrollPane scroll = (JScrollPane)this.getContainer(new JScrollPaneOperator.JScrollPaneFinder(ComponentSearcher.getTrueChooser("JScrollPane")));
        if (scroll == null) {
            return;
        }
        JScrollPaneOperator scroller = new JScrollPaneOperator(scroll);
        scroller.copyEnvironment(this);
        scroller.setVisualizer(new EmptyVisualizer());
        Rectangle rect = this.getCellRect(row, column, false);
        scroller.scrollToComponentRectangle(this.getSource(), (int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
    }

    public void selectCell(int row, int column) {
        this.driver.selectCell(this, row, column);
    }

    public int findColumn(String name, Operator.StringComparator comparator) {
        int columnCount = this.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            if (!comparator.equals(this.getColumnName(i), name)) continue;
            return i;
        }
        return -1;
    }

    public int findColumn(String name) {
        return this.findColumn(name, this.getComparator());
    }

    public JPopupMenu callPopupOnCell(int row, int column) {
        this.output.printLine("Call popup on (" + row + ", " + column + ") cell");
        this.output.printGolden("Call popup on cell");
        this.makeComponentVisible();
        Point point = this.getPointToClick(row, column);
        return JPopupMenuOperator.callPopup(this.getSource(), (int)point.getX(), (int)point.getY(), JTableOperator.getPopupMouseButton());
    }

    public Component getRenderedComponent(int row, int column, boolean isSelected, boolean cellHasFocus) {
        return this.getCellRenderer(row, column).getTableCellRendererComponent((JTable)this.getSource(), this.getValueAt(row, column), isSelected, cellHasFocus, row, column);
    }

    public Component getRenderedComponent(int row, int column) {
        return this.getRenderedComponent(row, column, this.isCellSelected(row, column), false);
    }

    public Point getPointToClick(int row, int column) {
        Rectangle rect = this.getCellRect(row, column, false);
        return new Point((int)(rect.getX() + rect.getWidth() / 2.0), (int)(rect.getY() + rect.getHeight() / 2.0));
    }

    public JTableHeaderOperator getHeaderOperator() {
        return new JTableHeaderOperator(this.getTableHeader());
    }

    public Component waitCellComponent(ComponentChooser chooser, int row, int column) {
        CellComponentWaiter waiter = new CellComponentWaiter(chooser, row, column);
        waiter.setOutput(this.getOutput());
        waiter.setTimeoutsToCloneOf(this.getTimeouts(), "JTableOperator.WaitEditingTimeout");
        try {
            return (Component)waiter.waitAction(null);
        }
        catch (InterruptedException e) {
            throw new JemmyException("Waiting has been interrupted", e);
        }
    }

    public void waitCell(String cellText, int row, int column) {
        this.getOutput().printLine("Wait \"" + cellText + "\" text at (" + Integer.toString(row) + "," + Integer.toString(column) + ")" + " position in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait  \"" + cellText + "\" text at (" + Integer.toString(row) + "," + Integer.toString(column) + ")" + " position");
        this.waitState(new JTableByCellFinder(cellText, row, column, this.getComparator()));
    }

    @Override
    public Hashtable getDump() {
        int j;
        Hashtable result = super.getDump();
        TableModel model = ((JTable)this.getSource()).getModel();
        int colCount = model.getColumnCount();
        int rowCount = model.getRowCount();
        Object[][] items = new String[rowCount][colCount];
        for (int i = 0; i < rowCount; ++i) {
            for (j = 0; j < colCount; ++j) {
                items[i][j] = model.getValueAt(i, j) != null ? model.getValueAt(i, j).toString() : "null";
            }
        }
        this.addToDump(result, CELL_PREFIX_DPROP, items);
        Object[] columns = new String[colCount];
        for (j = 0; j < colCount; ++j) {
            columns[j] = ((JTable)this.getSource()).getColumnName(j);
        }
        this.addToDump(result, COLUMN_PREFIX_DPROP, columns);
        int[] selColNums = ((JTable)this.getSource()).getSelectedColumns();
        Object[] selColumns = new String[selColNums.length];
        for (int j2 = 0; j2 < selColNums.length; ++j2) {
            selColumns[j2] = Integer.toString(selColNums[j2]);
        }
        this.addToDump(result, SELECTED_COLUMN_PREFIX_DPROP, selColumns);
        int[] selRowNums = ((JTable)this.getSource()).getSelectedRows();
        Object[] selRows = new String[selRowNums.length];
        for (int i = 0; i < selRowNums.length; ++i) {
            selRows[i] = Integer.toString(selRowNums[i]);
        }
        this.addToDump(result, SELECTED_ROW_PREFIX_DPROP, selRows);
        result.put(COLUMN_COUNT_DPROP, Integer.toString(colCount));
        result.put(ROW_COUNT_DPROP, Integer.toString(rowCount));
        return result;
    }

    public void addColumn(final TableColumn tableColumn) {
        this.runMapping(new Operator.MapVoidAction("addColumn"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).addColumn(tableColumn);
            }
        });
    }

    public void addColumnSelectionInterval(final int i, final int i1) {
        this.runMapping(new Operator.MapVoidAction("addColumnSelectionInterval"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).addColumnSelectionInterval(i, i1);
            }
        });
    }

    public void addRowSelectionInterval(final int i, final int i1) {
        this.runMapping(new Operator.MapVoidAction("addRowSelectionInterval"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).addRowSelectionInterval(i, i1);
            }
        });
    }

    public void clearSelection() {
        this.runMapping(new Operator.MapVoidAction("clearSelection"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).clearSelection();
            }
        });
    }

    public void columnAdded(final TableColumnModelEvent tableColumnModelEvent) {
        this.runMapping(new Operator.MapVoidAction("columnAdded"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).columnAdded(tableColumnModelEvent);
            }
        });
    }

    public int columnAtPoint(final Point point) {
        return this.runMapping(new Operator.MapIntegerAction("columnAtPoint"){

            @Override
            public int map() {
                return ((JTable)JTableOperator.this.getSource()).columnAtPoint(point);
            }
        });
    }

    public void columnMarginChanged(final ChangeEvent changeEvent) {
        this.runMapping(new Operator.MapVoidAction("columnMarginChanged"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).columnMarginChanged(changeEvent);
            }
        });
    }

    public void columnMoved(final TableColumnModelEvent tableColumnModelEvent) {
        this.runMapping(new Operator.MapVoidAction("columnMoved"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).columnMoved(tableColumnModelEvent);
            }
        });
    }

    public void columnRemoved(final TableColumnModelEvent tableColumnModelEvent) {
        this.runMapping(new Operator.MapVoidAction("columnRemoved"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).columnRemoved(tableColumnModelEvent);
            }
        });
    }

    public void columnSelectionChanged(final ListSelectionEvent listSelectionEvent) {
        this.runMapping(new Operator.MapVoidAction("columnSelectionChanged"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).columnSelectionChanged(listSelectionEvent);
            }
        });
    }

    public int convertColumnIndexToModel(final int i) {
        return this.runMapping(new Operator.MapIntegerAction("convertColumnIndexToModel"){

            @Override
            public int map() {
                return ((JTable)JTableOperator.this.getSource()).convertColumnIndexToModel(i);
            }
        });
    }

    public int convertColumnIndexToView(final int i) {
        return this.runMapping(new Operator.MapIntegerAction("convertColumnIndexToView"){

            @Override
            public int map() {
                return ((JTable)JTableOperator.this.getSource()).convertColumnIndexToView(i);
            }
        });
    }

    public void createDefaultColumnsFromModel() {
        this.runMapping(new Operator.MapVoidAction("createDefaultColumnsFromModel"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).createDefaultColumnsFromModel();
            }
        });
    }

    public boolean editCellAt(final int i, final int i1) {
        return this.runMapping(new Operator.MapBooleanAction("editCellAt"){

            @Override
            public boolean map() {
                return ((JTable)JTableOperator.this.getSource()).editCellAt(i, i1);
            }
        });
    }

    public boolean editCellAt(final int i, final int i1, final EventObject eventObject) {
        return this.runMapping(new Operator.MapBooleanAction("editCellAt"){

            @Override
            public boolean map() {
                return ((JTable)JTableOperator.this.getSource()).editCellAt(i, i1, eventObject);
            }
        });
    }

    public void editingCanceled(final ChangeEvent changeEvent) {
        this.runMapping(new Operator.MapVoidAction("editingCanceled"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).editingCanceled(changeEvent);
            }
        });
    }

    public void editingStopped(final ChangeEvent changeEvent) {
        this.runMapping(new Operator.MapVoidAction("editingStopped"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).editingStopped(changeEvent);
            }
        });
    }

    public boolean getAutoCreateColumnsFromModel() {
        return this.runMapping(new Operator.MapBooleanAction("getAutoCreateColumnsFromModel"){

            @Override
            public boolean map() {
                return ((JTable)JTableOperator.this.getSource()).getAutoCreateColumnsFromModel();
            }
        });
    }

    public int getAutoResizeMode() {
        return this.runMapping(new Operator.MapIntegerAction("getAutoResizeMode"){

            @Override
            public int map() {
                return ((JTable)JTableOperator.this.getSource()).getAutoResizeMode();
            }
        });
    }

    public TableCellEditor getCellEditor() {
        return (TableCellEditor)this.runMapping(new Operator.MapAction("getCellEditor"){

            @Override
            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getCellEditor();
            }
        });
    }

    public TableCellEditor getCellEditor(final int i, final int i1) {
        return (TableCellEditor)this.runMapping(new Operator.MapAction("getCellEditor"){

            @Override
            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getCellEditor(i, i1);
            }
        });
    }

    public Rectangle getCellRect(final int i, final int i1, final boolean b) {
        return (Rectangle)this.runMapping(new Operator.MapAction("getCellRect"){

            @Override
            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getCellRect(i, i1, b);
            }
        });
    }

    public TableCellRenderer getCellRenderer(final int i, final int i1) {
        return (TableCellRenderer)this.runMapping(new Operator.MapAction("getCellRenderer"){

            @Override
            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getCellRenderer(i, i1);
            }
        });
    }

    public boolean getCellSelectionEnabled() {
        return this.runMapping(new Operator.MapBooleanAction("getCellSelectionEnabled"){

            @Override
            public boolean map() {
                return ((JTable)JTableOperator.this.getSource()).getCellSelectionEnabled();
            }
        });
    }

    public TableColumn getColumn(final Object object) {
        return (TableColumn)this.runMapping(new Operator.MapAction("getColumn"){

            @Override
            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getColumn(object);
            }
        });
    }

    public Class getColumnClass(final int i) {
        return (Class)this.runMapping(new Operator.MapAction("getColumnClass"){

            @Override
            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getColumnClass(i);
            }
        });
    }

    public int getColumnCount() {
        return this.runMapping(new Operator.MapIntegerAction("getColumnCount"){

            @Override
            public int map() {
                return ((JTable)JTableOperator.this.getSource()).getColumnCount();
            }
        });
    }

    public TableColumnModel getColumnModel() {
        return (TableColumnModel)this.runMapping(new Operator.MapAction("getColumnModel"){

            @Override
            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getColumnModel();
            }
        });
    }

    public String getColumnName(final int i) {
        return (String)this.runMapping(new Operator.MapAction("getColumnName"){

            @Override
            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getColumnName(i);
            }
        });
    }

    public boolean getColumnSelectionAllowed() {
        return this.runMapping(new Operator.MapBooleanAction("getColumnSelectionAllowed"){

            @Override
            public boolean map() {
                return ((JTable)JTableOperator.this.getSource()).getColumnSelectionAllowed();
            }
        });
    }

    public TableCellEditor getDefaultEditor(final Class clss) {
        return (TableCellEditor)this.runMapping(new Operator.MapAction("getDefaultEditor"){

            @Override
            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getDefaultEditor(clss);
            }
        });
    }

    public TableCellRenderer getDefaultRenderer(final Class clss) {
        return (TableCellRenderer)this.runMapping(new Operator.MapAction("getDefaultRenderer"){

            @Override
            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getDefaultRenderer(clss);
            }
        });
    }

    public int getEditingColumn() {
        return this.runMapping(new Operator.MapIntegerAction("getEditingColumn"){

            @Override
            public int map() {
                return ((JTable)JTableOperator.this.getSource()).getEditingColumn();
            }
        });
    }

    public int getEditingRow() {
        return this.runMapping(new Operator.MapIntegerAction("getEditingRow"){

            @Override
            public int map() {
                return ((JTable)JTableOperator.this.getSource()).getEditingRow();
            }
        });
    }

    public Component getEditorComponent() {
        return (Component)this.runMapping(new Operator.MapAction("getEditorComponent"){

            @Override
            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getEditorComponent();
            }
        });
    }

    public Color getGridColor() {
        return (Color)this.runMapping(new Operator.MapAction("getGridColor"){

            @Override
            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getGridColor();
            }
        });
    }

    public Dimension getIntercellSpacing() {
        return (Dimension)this.runMapping(new Operator.MapAction("getIntercellSpacing"){

            @Override
            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getIntercellSpacing();
            }
        });
    }

    public TableModel getModel() {
        return (TableModel)this.runMapping(new Operator.MapAction("getModel"){

            @Override
            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getModel();
            }
        });
    }

    public Dimension getPreferredScrollableViewportSize() {
        return (Dimension)this.runMapping(new Operator.MapAction("getPreferredScrollableViewportSize"){

            @Override
            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getPreferredScrollableViewportSize();
            }
        });
    }

    public int getRowCount() {
        return this.runMapping(new Operator.MapIntegerAction("getRowCount"){

            @Override
            public int map() {
                return ((JTable)JTableOperator.this.getSource()).getRowCount();
            }
        });
    }

    public int getRowHeight() {
        return this.runMapping(new Operator.MapIntegerAction("getRowHeight"){

            @Override
            public int map() {
                return ((JTable)JTableOperator.this.getSource()).getRowHeight();
            }
        });
    }

    public int getRowMargin() {
        return this.runMapping(new Operator.MapIntegerAction("getRowMargin"){

            @Override
            public int map() {
                return ((JTable)JTableOperator.this.getSource()).getRowMargin();
            }
        });
    }

    public boolean getRowSelectionAllowed() {
        return this.runMapping(new Operator.MapBooleanAction("getRowSelectionAllowed"){

            @Override
            public boolean map() {
                return ((JTable)JTableOperator.this.getSource()).getRowSelectionAllowed();
            }
        });
    }

    public int getScrollableBlockIncrement(final Rectangle rectangle, final int i, final int i1) {
        return this.runMapping(new Operator.MapIntegerAction("getScrollableBlockIncrement"){

            @Override
            public int map() {
                return ((JTable)JTableOperator.this.getSource()).getScrollableBlockIncrement(rectangle, i, i1);
            }
        });
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.runMapping(new Operator.MapBooleanAction("getScrollableTracksViewportHeight"){

            @Override
            public boolean map() {
                return ((JTable)JTableOperator.this.getSource()).getScrollableTracksViewportHeight();
            }
        });
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.runMapping(new Operator.MapBooleanAction("getScrollableTracksViewportWidth"){

            @Override
            public boolean map() {
                return ((JTable)JTableOperator.this.getSource()).getScrollableTracksViewportWidth();
            }
        });
    }

    public int getScrollableUnitIncrement(final Rectangle rectangle, final int i, final int i1) {
        return this.runMapping(new Operator.MapIntegerAction("getScrollableUnitIncrement"){

            @Override
            public int map() {
                return ((JTable)JTableOperator.this.getSource()).getScrollableUnitIncrement(rectangle, i, i1);
            }
        });
    }

    public int getSelectedColumn() {
        return this.runMapping(new Operator.MapIntegerAction("getSelectedColumn"){

            @Override
            public int map() {
                return ((JTable)JTableOperator.this.getSource()).getSelectedColumn();
            }
        });
    }

    public int getSelectedColumnCount() {
        return this.runMapping(new Operator.MapIntegerAction("getSelectedColumnCount"){

            @Override
            public int map() {
                return ((JTable)JTableOperator.this.getSource()).getSelectedColumnCount();
            }
        });
    }

    public int[] getSelectedColumns() {
        return (int[])this.runMapping(new Operator.MapAction("getSelectedColumns"){

            @Override
            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getSelectedColumns();
            }
        });
    }

    public int getSelectedRow() {
        return this.runMapping(new Operator.MapIntegerAction("getSelectedRow"){

            @Override
            public int map() {
                return ((JTable)JTableOperator.this.getSource()).getSelectedRow();
            }
        });
    }

    public int getSelectedRowCount() {
        return this.runMapping(new Operator.MapIntegerAction("getSelectedRowCount"){

            @Override
            public int map() {
                return ((JTable)JTableOperator.this.getSource()).getSelectedRowCount();
            }
        });
    }

    public int[] getSelectedRows() {
        return (int[])this.runMapping(new Operator.MapAction("getSelectedRows"){

            @Override
            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getSelectedRows();
            }
        });
    }

    public Color getSelectionBackground() {
        return (Color)this.runMapping(new Operator.MapAction("getSelectionBackground"){

            @Override
            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getSelectionBackground();
            }
        });
    }

    public Color getSelectionForeground() {
        return (Color)this.runMapping(new Operator.MapAction("getSelectionForeground"){

            @Override
            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getSelectionForeground();
            }
        });
    }

    public ListSelectionModel getSelectionModel() {
        return (ListSelectionModel)this.runMapping(new Operator.MapAction("getSelectionModel"){

            @Override
            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getSelectionModel();
            }
        });
    }

    public boolean getShowHorizontalLines() {
        return this.runMapping(new Operator.MapBooleanAction("getShowHorizontalLines"){

            @Override
            public boolean map() {
                return ((JTable)JTableOperator.this.getSource()).getShowHorizontalLines();
            }
        });
    }

    public boolean getShowVerticalLines() {
        return this.runMapping(new Operator.MapBooleanAction("getShowVerticalLines"){

            @Override
            public boolean map() {
                return ((JTable)JTableOperator.this.getSource()).getShowVerticalLines();
            }
        });
    }

    public JTableHeader getTableHeader() {
        return (JTableHeader)this.runMapping(new Operator.MapAction("getTableHeader"){

            @Override
            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getTableHeader();
            }
        });
    }

    public TableUI getUI() {
        return (TableUI)this.runMapping(new Operator.MapAction("getUI"){

            @Override
            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getUI();
            }
        });
    }

    public Object getValueAt(final int i, final int i1) {
        return this.runMapping(new Operator.MapAction("getValueAt"){

            @Override
            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).getValueAt(i, i1);
            }
        });
    }

    public boolean isCellEditable(final int i, final int i1) {
        return this.runMapping(new Operator.MapBooleanAction("isCellEditable"){

            @Override
            public boolean map() {
                return ((JTable)JTableOperator.this.getSource()).isCellEditable(i, i1);
            }
        });
    }

    public boolean isCellSelected(final int i, final int i1) {
        return this.runMapping(new Operator.MapBooleanAction("isCellSelected"){

            @Override
            public boolean map() {
                return ((JTable)JTableOperator.this.getSource()).isCellSelected(i, i1);
            }
        });
    }

    public boolean isColumnSelected(final int i) {
        return this.runMapping(new Operator.MapBooleanAction("isColumnSelected"){

            @Override
            public boolean map() {
                return ((JTable)JTableOperator.this.getSource()).isColumnSelected(i);
            }
        });
    }

    public boolean isEditing() {
        return this.runMapping(new Operator.MapBooleanAction("isEditing"){

            @Override
            public boolean map() {
                return ((JTable)JTableOperator.this.getSource()).isEditing();
            }
        });
    }

    public boolean isRowSelected(final int i) {
        return this.runMapping(new Operator.MapBooleanAction("isRowSelected"){

            @Override
            public boolean map() {
                return ((JTable)JTableOperator.this.getSource()).isRowSelected(i);
            }
        });
    }

    public void moveColumn(final int i, final int i1) {
        this.runMapping(new Operator.MapVoidAction("moveColumn"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).moveColumn(i, i1);
            }
        });
    }

    public Component prepareEditor(final TableCellEditor tableCellEditor, final int i, final int i1) {
        return (Component)this.runMapping(new Operator.MapAction("prepareEditor"){

            @Override
            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).prepareEditor(tableCellEditor, i, i1);
            }
        });
    }

    public Component prepareRenderer(final TableCellRenderer tableCellRenderer, final int i, final int i1) {
        return (Component)this.runMapping(new Operator.MapAction("prepareRenderer"){

            @Override
            public Object map() {
                return ((JTable)JTableOperator.this.getSource()).prepareRenderer(tableCellRenderer, i, i1);
            }
        });
    }

    public void removeColumn(final TableColumn tableColumn) {
        this.runMapping(new Operator.MapVoidAction("removeColumn"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).removeColumn(tableColumn);
            }
        });
    }

    public void removeColumnSelectionInterval(final int i, final int i1) {
        this.runMapping(new Operator.MapVoidAction("removeColumnSelectionInterval"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).removeColumnSelectionInterval(i, i1);
            }
        });
    }

    public void removeEditor() {
        this.runMapping(new Operator.MapVoidAction("removeEditor"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).removeEditor();
            }
        });
    }

    public void removeRowSelectionInterval(final int i, final int i1) {
        this.runMapping(new Operator.MapVoidAction("removeRowSelectionInterval"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).removeRowSelectionInterval(i, i1);
            }
        });
    }

    public int rowAtPoint(final Point point) {
        return this.runMapping(new Operator.MapIntegerAction("rowAtPoint"){

            @Override
            public int map() {
                return ((JTable)JTableOperator.this.getSource()).rowAtPoint(point);
            }
        });
    }

    public void selectAll() {
        this.runMapping(new Operator.MapVoidAction("selectAll"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).selectAll();
            }
        });
    }

    public void setAutoCreateColumnsFromModel(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setAutoCreateColumnsFromModel"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).setAutoCreateColumnsFromModel(b);
            }
        });
    }

    public void setAutoResizeMode(final int i) {
        this.runMapping(new Operator.MapVoidAction("setAutoResizeMode"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).setAutoResizeMode(i);
            }
        });
    }

    public void setCellEditor(final TableCellEditor tableCellEditor) {
        this.runMapping(new Operator.MapVoidAction("setCellEditor"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).setCellEditor(tableCellEditor);
            }
        });
    }

    public void setCellSelectionEnabled(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setCellSelectionEnabled"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).setCellSelectionEnabled(b);
            }
        });
    }

    public void setColumnModel(final TableColumnModel tableColumnModel) {
        this.runMapping(new Operator.MapVoidAction("setColumnModel"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).setColumnModel(tableColumnModel);
            }
        });
    }

    public void setColumnSelectionAllowed(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setColumnSelectionAllowed"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).setColumnSelectionAllowed(b);
            }
        });
    }

    public void setColumnSelectionInterval(final int i, final int i1) {
        this.runMapping(new Operator.MapVoidAction("setColumnSelectionInterval"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).setColumnSelectionInterval(i, i1);
            }
        });
    }

    public void setDefaultEditor(final Class clss, final TableCellEditor tableCellEditor) {
        this.runMapping(new Operator.MapVoidAction("setDefaultEditor"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).setDefaultEditor(clss, tableCellEditor);
            }
        });
    }

    public void setDefaultRenderer(final Class clss, final TableCellRenderer tableCellRenderer) {
        this.runMapping(new Operator.MapVoidAction("setDefaultRenderer"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).setDefaultRenderer(clss, tableCellRenderer);
            }
        });
    }

    public void setEditingColumn(final int i) {
        this.runMapping(new Operator.MapVoidAction("setEditingColumn"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).setEditingColumn(i);
            }
        });
    }

    public void setEditingRow(final int i) {
        this.runMapping(new Operator.MapVoidAction("setEditingRow"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).setEditingRow(i);
            }
        });
    }

    public void setGridColor(final Color color) {
        this.runMapping(new Operator.MapVoidAction("setGridColor"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).setGridColor(color);
            }
        });
    }

    public void setIntercellSpacing(final Dimension dimension) {
        this.runMapping(new Operator.MapVoidAction("setIntercellSpacing"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).setIntercellSpacing(dimension);
            }
        });
    }

    public void setModel(final TableModel tableModel) {
        this.runMapping(new Operator.MapVoidAction("setModel"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).setModel(tableModel);
            }
        });
    }

    public void setPreferredScrollableViewportSize(final Dimension dimension) {
        this.runMapping(new Operator.MapVoidAction("setPreferredScrollableViewportSize"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).setPreferredScrollableViewportSize(dimension);
            }
        });
    }

    public void setRowHeight(final int i) {
        this.runMapping(new Operator.MapVoidAction("setRowHeight"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).setRowHeight(i);
            }
        });
    }

    public void setRowMargin(final int i) {
        this.runMapping(new Operator.MapVoidAction("setRowMargin"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).setRowMargin(i);
            }
        });
    }

    public void setRowSelectionAllowed(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setRowSelectionAllowed"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).setRowSelectionAllowed(b);
            }
        });
    }

    public void setRowSelectionInterval(final int i, final int i1) {
        this.runMapping(new Operator.MapVoidAction("setRowSelectionInterval"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).setRowSelectionInterval(i, i1);
            }
        });
    }

    public void setSelectionBackground(final Color color) {
        this.runMapping(new Operator.MapVoidAction("setSelectionBackground"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).setSelectionBackground(color);
            }
        });
    }

    public void setSelectionForeground(final Color color) {
        this.runMapping(new Operator.MapVoidAction("setSelectionForeground"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).setSelectionForeground(color);
            }
        });
    }

    public void setSelectionMode(final int i) {
        this.runMapping(new Operator.MapVoidAction("setSelectionMode"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).setSelectionMode(i);
            }
        });
    }

    public void setSelectionModel(final ListSelectionModel listSelectionModel) {
        this.runMapping(new Operator.MapVoidAction("setSelectionModel"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).setSelectionModel(listSelectionModel);
            }
        });
    }

    public void setShowGrid(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setShowGrid"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).setShowGrid(b);
            }
        });
    }

    public void setShowHorizontalLines(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setShowHorizontalLines"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).setShowHorizontalLines(b);
            }
        });
    }

    public void setShowVerticalLines(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setShowVerticalLines"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).setShowVerticalLines(b);
            }
        });
    }

    public void setTableHeader(final JTableHeader jTableHeader) {
        this.runMapping(new Operator.MapVoidAction("setTableHeader"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).setTableHeader(jTableHeader);
            }
        });
    }

    public void setUI(final TableUI tableUI) {
        this.runMapping(new Operator.MapVoidAction("setUI"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).setUI(tableUI);
            }
        });
    }

    public void setValueAt(final Object object, final int i, final int i1) {
        this.runMapping(new Operator.MapVoidAction("setValueAt"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).setValueAt(object, i, i1);
            }
        });
    }

    public void tableChanged(final TableModelEvent tableModelEvent) {
        this.runMapping(new Operator.MapVoidAction("tableChanged"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).tableChanged(tableModelEvent);
            }
        });
    }

    public void valueChanged(final ListSelectionEvent listSelectionEvent) {
        this.runMapping(new Operator.MapVoidAction("valueChanged"){

            @Override
            public void map() {
                ((JTable)JTableOperator.this.getSource()).valueChanged(listSelectionEvent);
            }
        });
    }

    private Point findCell(String text, boolean ce, boolean ccs, int index) {
        return this.findCell(text, new Operator.DefaultStringComparator(ce, ccs), index);
    }

    static {
        Timeouts.initDefault("JTableOperator.WaitEditingTimeout", 60000L);
    }

    private static class ByRenderedComponentTableCellChooser
    implements TableCellChooser {
        ComponentChooser chooser;

        public ByRenderedComponentTableCellChooser(ComponentChooser chooser) {
            this.chooser = chooser;
        }

        @Override
        public boolean checkCell(JTableOperator oper, int row, int column) {
            return this.chooser.checkComponent(oper.getRenderedComponent(row, column));
        }

        @Override
        public String getDescription() {
            return this.chooser.getDescription();
        }
    }

    private static class BySubStringTableCellChooser
    implements TableCellChooser {
        String subString;
        Operator.StringComparator comparator;

        public BySubStringTableCellChooser(String subString, Operator.StringComparator comparator) {
            this.subString = subString;
            this.comparator = comparator;
        }

        @Override
        public boolean checkCell(JTableOperator oper, int row, int column) {
            Object value = ((JTable)oper.getSource()).getModel().getValueAt(row, column);
            return this.comparator.equals(value != null ? value.toString() : null, this.subString);
        }

        @Override
        public String getDescription() {
            return "Cell containing \"" + this.subString + "\" string";
        }
    }

    private class CellComponentWaiter
    extends Waiter {
        private ComponentChooser chooser;
        private int row;
        private int column;

        public CellComponentWaiter(ComponentChooser chooser, int row, int column) {
            this.chooser = chooser;
            this.row = row;
            this.column = column;
        }

        @Override
        public Object actionProduced(Object obj) {
            Point pnt = JTableOperator.this.getPointToClick(this.row, this.column);
            Component comp = JTableOperator.this.getComponentAt(pnt.x, pnt.y);
            if (comp != null && this.chooser.checkComponent(comp)) {
                return comp;
            }
            return null;
        }

        @Override
        public String getDescription() {
            return this.chooser.getDescription();
        }
    }

    public static class JTableByCellFinder
    implements ComponentChooser {
        String label;
        int row;
        int column;
        Operator.StringComparator comparator;

        public JTableByCellFinder(String lb, int r, int c, Operator.StringComparator comparator) {
            this.label = lb;
            this.row = r;
            this.column = c;
            this.comparator = comparator;
        }

        public JTableByCellFinder(String lb, int r, int c) {
            this(lb, r, c, Operator.getDefaultStringComparator());
        }

        @Override
        public boolean checkComponent(Component comp) {
            if (comp instanceof JTable) {
                if (this.label == null) {
                    return true;
                }
                if (((JTable)comp).getRowCount() > this.row && ((JTable)comp).getColumnCount() > this.column) {
                    Object value;
                    int c;
                    int r = this.row;
                    if (r == -1) {
                        int[] rows = ((JTable)comp).getSelectedRows();
                        if (rows.length != 0) {
                            r = rows[0];
                        } else {
                            return false;
                        }
                    }
                    if ((c = this.column) == -1) {
                        int[] columns = ((JTable)comp).getSelectedColumns();
                        if (columns.length != 0) {
                            c = columns[0];
                        } else {
                            return false;
                        }
                    }
                    if ((value = ((JTable)comp).getValueAt(r, c)) == null) {
                        return false;
                    }
                    return this.comparator.equals(value.toString(), this.label);
                }
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "JTable with text \"" + this.label + "\" in (" + new Integer(this.row).toString() + ", " + new Integer(this.column).toString() + ") cell";
        }
    }

    public static class JTableFinder
    extends Operator.Finder {
        public JTableFinder(ComponentChooser sf) {
            super(JTable.class, sf);
        }

        public JTableFinder() {
            super(JTable.class);
        }
    }

    public static interface TableCellChooser {
        public boolean checkCell(JTableOperator var1, int var2, int var3);

        public String getDescription();
    }
}

