/*
 * Decompiled with CFR 0.152.
 */
package modules.editors.gedcomproperties;

import ancestris.util.swing.DialogManager;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyFile;
import genj.util.Registry;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import modules.editors.gedcomproperties.Constants;
import modules.editors.gedcomproperties.GedcomPropertiesWizardIterator;
import modules.editors.gedcomproperties.utils.MediaManagerPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class GedcomPropertiesMediaFormatPanel
extends JPanel
implements Constants {
    private Registry registry = null;
    private final String winWidth = "gedcomProperties4Width";
    private final String winHeight = "gedcomProperties4Height";
    private Gedcom gedcom;
    private Map<PropertyFile, String> property2PathMap = null;
    private List<? extends Property> filesList = null;
    private int differentMediaFiles = 0;
    private int totalMediaFiles = 0;
    private Set<String> filesFullnames = null;
    private int nbOfPaths = 0;
    private Set<String> filesPaths = null;
    private DefaultListModel model = null;
    private String rootPath = "";
    private int totalPathsFound = 0;
    private int absPathsFound = 0;
    private int relPathsFound = 0;
    private String unfoundColor = "'black'";
    private int totalPathsUnfound = 0;
    private int absPathsUnfound = 0;
    private int relPathsUnfound = 0;
    public static final Pattern ABSOLUTE = Pattern.compile("([a-z]:).*|([A-Z]:).*|\\/.*|\\\\.*");
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JList jList1;
    private JScrollPane jScrollPane1;

    public GedcomPropertiesMediaFormatPanel(Gedcom gedcom) {
        this.gedcom = gedcom;
        this.rootPath = gedcom.getOrigin().getFile().getParentFile().getAbsolutePath();
        this.filesFullnames = new TreeSet<String>();
        this.filesPaths = new TreeSet<String>();
        this.filesList = gedcom.getPropertiesByClass(PropertyFile.class);
        this.initFilesMap();
        this.totalMediaFiles = this.filesList.size();
        for (Property property : this.filesList) {
            String value;
            if (!(property instanceof PropertyFile) || this.filesFullnames.contains(value = property.getValue())) continue;
            this.filesFullnames.add(value);
            PropertyFile pFile = (PropertyFile)property;
            File f = pFile.getFile();
            if (f == null) continue;
            String name = f.getName();
            String path = value.substring(0, value.indexOf(name));
            this.filesPaths.add(path);
            if (f.exists()) {
                ++this.totalPathsFound;
                if (ABSOLUTE.matcher(path).matches()) {
                    ++this.absPathsFound;
                    continue;
                }
                ++this.relPathsFound;
                continue;
            }
            ++this.totalPathsUnfound;
            if (ABSOLUTE.matcher(path).matches()) {
                ++this.absPathsUnfound;
                continue;
            }
            ++this.relPathsUnfound;
        }
        if (this.totalPathsUnfound > 0) {
            this.unfoundColor = "'red'";
        }
        this.differentMediaFiles = this.filesFullnames.size();
        this.model = new DefaultListModel();
        for (String string : this.filesPaths) {
            this.model.addElement(string);
        }
        this.nbOfPaths = this.filesPaths.size();
        this.initComponents();
        this.jLabel2.setVisible(false);
        this.jButton2.setVisible(false);
        if (this.totalMediaFiles == 0) {
            this.jLabel3.setEnabled(false);
            this.jLabel4.setEnabled(false);
            this.jLabel5.setEnabled(false);
            this.jLabel6.setEnabled(false);
            this.jButton1.setEnabled(false);
            this.jList1.setEnabled(false);
        }
        this.registry = Registry.get(this.getClass());
        this.setPreferredSize(new Dimension(this.registry.get("gedcomProperties4Width", this.getPreferredSize().width), this.registry.get("gedcomProperties4Height", this.getPreferredSize().height)));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jButton1 = new JButton();
        this.jLabel2 = new JLabel();
        this.jButton2 = new JButton();
        this.jLabel7 = new JLabel();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                GedcomPropertiesMediaFormatPanel.this.formComponentResized(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(GedcomPropertiesMediaFormatPanel.class, (String)"GedcomPropertiesMediaFormatPanel.jLabel1.text", (Object)this.differentMediaFiles, (Object)this.totalMediaFiles));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(GedcomPropertiesMediaFormatPanel.class, (String)"GedcomPropertiesMediaFormatPanel.jLabel3.text", (Object)this.nbOfPaths));
        this.jList1.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jList1);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(GedcomPropertiesMediaFormatPanel.class, (String)"GedcomPropertiesMediaFormatPanel.jLabel4.text", (Object)this.rootPath));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(GedcomPropertiesMediaFormatPanel.class, (String)"GedcomPropertiesMediaFormatPanel.jLabel5.text", (Object)this.totalPathsFound, (Object)this.relPathsFound, (Object)this.absPathsFound));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(GedcomPropertiesMediaFormatPanel.class, (String)"GedcomPropertiesMediaFormatPanel.jLabel6.text", (Object)this.totalPathsUnfound, (Object)this.relPathsUnfound, (Object)this.absPathsUnfound, (Object)this.unfoundColor, (Object[])new Object[0]));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(GedcomPropertiesMediaFormatPanel.class, (String)"GedcomPropertiesMediaFormatPanel.jButton1.text", (Object)this.differentMediaFiles));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GedcomPropertiesMediaFormatPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel2.setForeground(new Color(204, 0, 0));
        this.jLabel2.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(GedcomPropertiesMediaFormatPanel.class, (String)"GedcomPropertiesMediaFormatPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getMessage(GedcomPropertiesMediaFormatPanel.class, (String)"GedcomPropertiesMediaFormatPanel.jButton2.text"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GedcomPropertiesMediaFormatPanel.this.jButton2ActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(GedcomPropertiesMediaFormatPanel.class, (String)"GedcomPropertiesMediaFormatPanel.jLabel7.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, GroupLayout.Alignment.CENTER, -1, -1, Short.MAX_VALUE).addComponent(this.jButton2, GroupLayout.Alignment.CENTER).addComponent(this.jButton1, GroupLayout.Alignment.CENTER).addComponent(this.jLabel7, GroupLayout.Alignment.CENTER, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.CENTER).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE)).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 372, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel6, -1, -1, Short.MAX_VALUE)).addContainerGap()).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addGap(18, 18, 18).addComponent(this.jLabel4).addGap(18, 18, 18).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1).addGap(2, 2, 2).addComponent(this.jLabel7).addGap(1, 1, 1).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2).addContainerGap()));
    }

    private void formComponentResized(ComponentEvent evt) {
        this.registry.put("gedcomProperties4Width", evt.getComponent().getWidth());
        this.registry.put("gedcomProperties4Height", evt.getComponent().getHeight());
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.OpenMediaManager();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.initFilesMap();
        this.jLabel2.setVisible(false);
        this.jButton2.setVisible(false);
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"STEP_5_name");
    }

    private void initFilesMap() {
        this.property2PathMap = new HashMap<PropertyFile, String>();
        for (Property property : this.filesList) {
            if (!(property instanceof PropertyFile)) continue;
            PropertyFile pFile = (PropertyFile)property;
            String value = property.getValue();
            File f = pFile.getFile();
            if (f == null) continue;
            String name = f.getName();
            String path = value.substring(0, value.indexOf(name));
            this.property2PathMap.put(pFile, path);
        }
    }

    private void OpenMediaManager() {
        MediaManagerPanel panel = new MediaManagerPanel(this.rootPath, this.property2PathMap);
        Object o = DialogManager.create((String)NbBundle.getMessage(GedcomPropertiesMediaFormatPanel.class, (String)"GedcomPropertiesMediaFormatPanel.jButton1.text", (Object)this.differentMediaFiles), (JComponent)panel).setMessageType(-1).setOptionType(2).show();
        if (o == DialogManager.OK_OPTION && panel.isMapModified()) {
            this.jLabel2.setVisible(true);
            this.jButton2.setVisible(true);
        }
    }

    public boolean isModified() {
        return this.jLabel2.isVisible();
    }

    public Map<PropertyFile, String> getMediaMap() {
        return this.property2PathMap;
    }
}

