/*
 * Decompiled with CFR 0.152.
 */
package modules.editors.gedcomproperties;

import ancestris.core.pluginservice.PluginInterface;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Property;
import genj.gedcom.PropertyPlace;
import genj.util.Registry;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import modules.editors.gedcomproperties.Constants;
import modules.editors.gedcomproperties.GedcomPropertiesWizardIterator;
import modules.editors.gedcomproperties.utils.PlaceFormatConverterPanel;
import modules.editors.gedcomproperties.utils.PlaceFormatInterface;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class GedcomPropertiesPlaceFormatPanel
extends JPanel
implements Constants {
    private Registry registry = null;
    private final String winWidth = "gedcomProperties4Width";
    private final String winHeight = "gedcomProperties4Height";
    public static final int DEFAULT_MODE = 2;
    private final PlaceFormatInterface parent;
    private int mode;
    private Gedcom gedcom;
    private String originalPlaceFormat = "";
    private final DefaultListModel<String> listModel = new DefaultListModel();
    private Set<String> incorrectList = null;
    private int nbExpectedPlaces = 0;
    private String EMPTY_PLACE = "";
    private Box.Filler filler1;
    private JLabel helpLabel;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JList jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JTextArea jTextArea1;
    private JTextArea jTextArea2;
    private JTextField jTextField1;

    public GedcomPropertiesPlaceFormatPanel(PlaceFormatInterface parent) {
        this.parent = parent;
        this.mode = parent.getMode();
        this.gedcom = parent.getGedcom();
        this.originalPlaceFormat = PropertyPlace.formatSpaces((String)parent.getOriginalPlaceFormat());
        this.EMPTY_PLACE = NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"Panel4.emptyPlace");
        this.initComponents();
        this.registry = Registry.get(this.getClass());
        this.setPreferredSize(new Dimension(this.registry.get("gedcomProperties4Width", this.getPreferredSize().width), this.registry.get("gedcomProperties4Height", this.getPreferredSize().height)));
        this.updateDisplay();
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"STEP_4_name");
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.jTextArea2 = new JTextArea();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jButton8 = new JButton();
        this.jCheckBox2 = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.filler1 = new Box.Filler(new Dimension(0, 2), new Dimension(0, 2), new Dimension(Short.MAX_VALUE, 2));
        this.jPanel2 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jList1 = new JList();
        this.jButton4 = new JButton();
        this.jButton6 = new JButton();
        this.jButton7 = new JButton();
        this.jTextField1 = new JTextField();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jPanel3 = new JPanel();
        this.helpLabel = new JLabel();
        this.jLabel2 = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.jButton5 = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.setBorder(null);
        this.setPreferredSize(new Dimension(500, 375));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                GedcomPropertiesPlaceFormatPanel.this.formComponentResized(evt);
            }
        });
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setViewportBorder(null);
        this.jScrollPane1.setPreferredSize(new Dimension(500, 375));
        this.jPanel1.setBorder(null);
        this.jPanel1.setMinimumSize(new Dimension(0, 0));
        this.jPanel1.setPreferredSize(new Dimension(500, 375));
        this.jLabel4.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"GedcomPropertiesPlaceFormatPanel.jLabel4.text"));
        this.jTextArea2.setEditable(false);
        this.jTextArea2.setColumns(20);
        this.jTextArea2.setRows(5);
        this.jScrollPane4.setViewportView(this.jTextArea2);
        this.jLabel3.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"Panel4.jLabel3.update"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"Panel4.jLabel5.update"));
        this.jLabel5.setVerticalAlignment(1);
        this.jButton8.setIcon(new ImageIcon(this.getClass().getResource("/modules/editors/gedcomproperties/ressources/List.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton8, (String)NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"GedcomPropertiesPlaceFormatPanel.jButton8.text"));
        this.jButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GedcomPropertiesPlaceFormatPanel.this.jButton8ActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox2, (String)NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"GedcomPropertiesPlaceFormatPanel.jCheckBox2.text"));
        this.jCheckBox2.setToolTipText(NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"GedcomPropertiesPlaceFormatPanel.jCheckBox2.toolTipText"));
        this.jLabel1.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)(this.mode == 1 ? "Panel4.jLabel1.create" : "Panel4.jLabel1.update")));
        this.jPanel2.setPreferredSize(new Dimension(493, 210));
        this.jList1.setModel(this.listModel);
        this.jList1.setSelectionMode(0);
        this.jList1.setToolTipText(NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"GedcomPropertiesPlaceFormatPanel.jList1.toolTipText"));
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                GedcomPropertiesPlaceFormatPanel.this.jList1ValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jList1);
        this.jButton4.setIcon(new ImageIcon(this.getClass().getResource("/modules/editors/gedcomproperties/ressources/MoveDown.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton4, (String)NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"GedcomPropertiesPlaceFormatPanel.jButton4.text"));
        this.jButton4.setToolTipText(NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"GedcomPropertiesPlaceFormatPanel.jButton4.toolTipText"));
        this.jButton4.setPreferredSize(new Dimension(28, 28));
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GedcomPropertiesPlaceFormatPanel.this.jButton4ActionPerformed(evt);
            }
        });
        this.jButton6.setIcon(new ImageIcon(this.getClass().getResource("/modules/editors/gedcomproperties/ressources/Bank.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton6, (String)NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"GedcomPropertiesPlaceFormatPanel.jButton6.text"));
        this.jButton6.setToolTipText(NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"GedcomPropertiesPlaceFormatPanel.jButton6.toolTipText"));
        this.jButton6.setPreferredSize(new Dimension(28, 28));
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GedcomPropertiesPlaceFormatPanel.this.jButton6ActionPerformed(evt);
            }
        });
        this.jButton7.setIcon(new ImageIcon(this.getClass().getResource("/modules/editors/gedcomproperties/ressources/Reset.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton7, (String)NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"GedcomPropertiesPlaceFormatPanel.jButton7.text"));
        this.jButton7.setToolTipText(NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"GedcomPropertiesPlaceFormatPanel.jButton7.toolTipText"));
        this.jButton7.setPreferredSize(new Dimension(28, 28));
        this.jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GedcomPropertiesPlaceFormatPanel.this.jButton7ActionPerformed(evt);
            }
        });
        this.jTextField1.setText(NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"GedcomPropertiesPlaceFormatPanel.jTextField1.text"));
        this.jTextField1.setToolTipText(NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"GedcomPropertiesPlaceFormatPanel.jTextField1.toolTipText"));
        this.jTextField1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                GedcomPropertiesPlaceFormatPanel.this.jTextField1KeyReleased(evt);
            }
        });
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/modules/editors/gedcomproperties/ressources/Add.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"GedcomPropertiesPlaceFormatPanel.jButton1.text"));
        this.jButton1.setToolTipText(NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"GedcomPropertiesPlaceFormatPanel.jButton1.toolTipText"));
        this.jButton1.setEnabled(false);
        this.jButton1.setPreferredSize(new Dimension(28, 28));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GedcomPropertiesPlaceFormatPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/modules/editors/gedcomproperties/ressources/Delete.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"GedcomPropertiesPlaceFormatPanel.jButton2.text"));
        this.jButton2.setToolTipText(NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"GedcomPropertiesPlaceFormatPanel.jButton2.toolTipText"));
        this.jButton2.setPreferredSize(new Dimension(28, 28));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GedcomPropertiesPlaceFormatPanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/modules/editors/gedcomproperties/ressources/MoveUp.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton3, (String)NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"GedcomPropertiesPlaceFormatPanel.jButton3.text"));
        this.jButton3.setToolTipText(NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"GedcomPropertiesPlaceFormatPanel.jButton3.toolTipText"));
        this.jButton3.setPreferredSize(new Dimension(28, 28));
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GedcomPropertiesPlaceFormatPanel.this.jButton3ActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.helpLabel, (String)NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"GedcomPropertiesPlaceFormatPanel.helpLabel.text"));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.helpLabel, -1, 137, Short.MAX_VALUE).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.helpLabel).addContainerGap()));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jScrollPane2, -2, 221, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton1, -1, 44, Short.MAX_VALUE).addComponent(this.jButton2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButton4, -1, -1, Short.MAX_VALUE).addComponent(this.jButton3, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField1).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton6, -2, 44, -2).addComponent(this.jButton7, -2, 44, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addContainerGap()))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2, -1, 150, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1, -2, -1, -2).addComponent(this.jTextField1, -2, -1, -2)).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jButton2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton3, -2, -1, -2).addComponent(this.jButton6, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton4, -2, -1, -2).addComponent(this.jButton7, -2, -1, -2))).addGroup(jPanel2Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE))))).addGap(12, 12, 12)));
        this.jLabel2.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)(this.mode == 1 ? "Panel4.jLabel2.create" : "Panel4.jLabel2.update")));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox1, (String)NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"GedcomPropertiesPlaceFormatPanel.jCheckBox1.text"));
        this.jCheckBox1.setToolTipText(NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"GedcomPropertiesPlaceFormatPanel.jCheckBox1.toolTipText"));
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GedcomPropertiesPlaceFormatPanel.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jButton5.setIcon(new ImageIcon(this.getClass().getResource("/modules/editors/gedcomproperties/ressources/Mapping.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton5, (String)NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"GedcomPropertiesPlaceFormatPanel.jButton5.text"));
        this.jButton5.setToolTipText(NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"GedcomPropertiesPlaceFormatPanel.jButton5.toolTipText"));
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GedcomPropertiesPlaceFormatPanel.this.jButton5ActionPerformed(evt);
            }
        });
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(5);
        this.jScrollPane3.setViewportView(this.jTextArea1);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox2)).addComponent(this.jPanel2, -1, 482, Short.MAX_VALUE).addComponent(this.jScrollPane3).addComponent(this.jScrollPane4).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton5)).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filler1, -2, 0, -2))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4).addGap(0, 0, 0).addComponent(this.jScrollPane4, -2, 34, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jCheckBox2).addComponent(this.jButton8)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.filler1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, 162, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jCheckBox1).addComponent(this.jButton5).addComponent(this.jLabel2)).addComponent(this.jScrollPane3, -2, 34, -2).addGap(2, 2, 2)));
        this.jScrollPane1.setViewportView(this.jPanel1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
    }

    private void jTextField1KeyReleased(KeyEvent evt) {
        String juris = this.jTextField1.getText();
        this.jButton1.setEnabled(juris != null && !juris.isEmpty() && !this.listModel.contains(juris));
    }

    private void jButton7ActionPerformed(ActionEvent evt) {
        String defaultFormat = GedcomOptions.getInstance().getPlaceFormat();
        this.setPLAC(!this.originalPlaceFormat.isEmpty() ? this.originalPlaceFormat : defaultFormat);
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        this.addNewJurisdiction(NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"GedcomPropertiesPlaceFormatPanel.emptyField"));
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.moveDownSelectedIndex();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.moveUpSelectedIndex();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.removeSelectedIndex();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.addNewJurisdiction(this.jTextField1.getText());
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        this.updateDisplay(this.jList1.getSelectedIndex());
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.jButton5.setEnabled(this.jCheckBox1.isSelected());
        if (this.jCheckBox1.isSelected() && this.parent.getPlaceFormatConverter() == null) {
            this.parent.setPlaceFormatConverter(new PlaceFormatConverterPanel(this.originalPlaceFormat, this.getPLAC(), null));
            this.DisplayPlaceFormatConverter(this.parent.getPlaceFormatConverter());
        }
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        if (this.parent.getPlaceFormatConverter() == null) {
            this.parent.setPlaceFormatConverter(new PlaceFormatConverterPanel(this.originalPlaceFormat, this.getPLAC(), null));
        }
        this.DisplayPlaceFormatConverter(this.parent.getPlaceFormatConverter());
    }

    private void formComponentResized(ComponentEvent evt) {
        this.registry.put("gedcomProperties4Width", evt.getComponent().getWidth());
        this.registry.put("gedcomProperties4Height", evt.getComponent().getHeight());
    }

    private void jButton8ActionPerformed(ActionEvent evt) {
        this.DisplayIncorrectPlaces(this.incorrectList);
    }

    public void setPLAC(String str) {
        String value = PropertyPlace.formatSpaces((String)str);
        if (!value.equals(this.getPLAC())) {
            this.parent.setPlaceFormatConverter(null);
        }
        String[] placeFormatList = PropertyPlace.getFormat((String)str);
        this.listModel.clear();
        for (String p : placeFormatList) {
            if (p.isEmpty()) {
                this.listModel.addElement(NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"GedcomPropertiesPlaceFormatPanel.emptyField"));
                continue;
            }
            this.listModel.addElement(p.trim());
        }
        this.updateDisplay();
    }

    public String getPLAC() {
        boolean USE_SPACES = GedcomOptions.getInstance().isUseSpacedPlaces();
        String ret = "";
        String tmpStr = "";
        String addStr = "," + (USE_SPACES ? " " : "");
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            if (i == this.listModel.getSize() - 1) {
                addStr = "";
            }
            if ((tmpStr = this.listModel.elementAt(i).trim()).equals(NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"GedcomPropertiesPlaceFormatPanel.emptyField"))) {
                tmpStr = "";
            }
            ret = ret + tmpStr + addStr;
        }
        return ret;
    }

    public boolean getConversionToBeDone() {
        return this.jCheckBox1.isSelected();
    }

    public boolean getPlacesConversionToBeDone() {
        return this.jCheckBox2.isSelected();
    }

    private void removeSelectedIndex() {
        int index = this.jList1.getSelectedIndex();
        this.listModel.remove(index);
        int size = this.listModel.getSize();
        if (size != 0 && index == size) {
            --index;
        }
        this.updateDisplay(index);
    }

    private void addNewJurisdiction(String text) {
        int index = this.jList1.getSelectedIndex();
        index = index == -1 ? 0 : ++index;
        this.listModel.insertElementAt(text, index);
        this.updateDisplay(index);
        this.jTextField1.requestFocusInWindow();
        this.jTextField1.setText("");
        this.jButton1.setEnabled(false);
    }

    private void moveUpSelectedIndex() {
        int index = this.jList1.getSelectedIndex();
        String juris = this.listModel.remove(index);
        this.listModel.add(index - 1, juris);
        this.updateDisplay(index - 1);
    }

    private void moveDownSelectedIndex() {
        int index = this.jList1.getSelectedIndex();
        String juris = this.listModel.remove(index);
        this.listModel.add(index + 1, juris);
        this.updateDisplay(index + 1);
    }

    private void updateDisplay() {
        this.updateDisplay(this.listModel.isEmpty() ? -1 : 0);
    }

    private void updateDisplay(int index) {
        boolean listIsEmpty = this.listModel.isEmpty();
        boolean indexIsFirst = index == 0;
        boolean indexIsLast = index == this.listModel.getSize() - 1;
        this.jButton2.setEnabled(!listIsEmpty);
        this.jButton3.setEnabled(!listIsEmpty && !indexIsFirst);
        this.jButton4.setEnabled(!listIsEmpty && !indexIsLast);
        if (!listIsEmpty) {
            this.jList1.setSelectedIndex(index);
            this.jList1.ensureIndexIsVisible(index);
        }
        this.jTextArea1.setText(this.getPLAC());
        this.originalPlaceFormat = PropertyPlace.formatSpaces((String)this.parent.getOriginalPlaceFormat());
        this.jTextArea2.setText(this.originalPlaceFormat);
        boolean canBeConverted = this.mode == 2 && !this.getPLAC().equals(this.originalPlaceFormat);
        this.jCheckBox1.setVisible(canBeConverted);
        this.jButton5.setVisible(canBeConverted);
        this.jButton5.setEnabled(this.jCheckBox1.isSelected());
        this.jLabel4.setVisible(this.mode == 2);
        this.jScrollPane4.setVisible(this.mode == 2);
        this.parent.warnVersionChange(canBeConverted);
        if (canBeConverted && this.parent.getPlaceFormatConverter() != null) {
            this.parent.getPlaceFormatConverter().setValidatedMap(false, this.getPLAC());
        }
        this.jLabel3.setVisible(this.mode == 2);
        this.jLabel5.setVisible(this.mode == 2);
        Set<String> keys = this.getNbOfDifferentPlaces(this.gedcom);
        String nbOfDifferentFoundPlaces = "" + keys.size();
        this.jLabel3.setText(NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"Panel4.jLabel3.update", (Object)nbOfDifferentFoundPlaces));
        this.nbExpectedPlaces = PropertyPlace.getFormat((String)this.originalPlaceFormat).length;
        this.incorrectList = this.getIncorrectPlaces(this.nbExpectedPlaces, keys);
        if (this.incorrectList.isEmpty()) {
            this.jLabel5.setText(NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"Panel4.jLabel5.update"));
            this.jCheckBox2.setVisible(false);
            this.jButton8.setVisible(false);
        } else {
            this.jLabel5.setText(NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"Panel4.jLabel5.update.incorrect", (Object)this.incorrectList.size(), (Object)this.nbExpectedPlaces));
            this.jCheckBox2.setToolTipText(NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"GedcomPropertiesPlaceFormatPanel.jCheckBox2.toolTipText", (Object)this.nbExpectedPlaces));
            this.jCheckBox2.setVisible(this.mode == 2);
            this.jButton8.setVisible(this.mode == 2);
        }
    }

    private void DisplayPlaceFormatConverter(PlaceFormatConverterPanel placeFormatConverter) {
        this.parent.getPlaceFormatConverter().initToFields(this.getPLAC());
        Object o = DialogManager.create((String)NbBundle.getMessage(PlaceFormatConverterPanel.class, (String)"TITL_PlaceFormatConversionSettings"), (JComponent)placeFormatConverter).setMessageType(-1).show();
        if (o == DialogManager.OK_OPTION) {
            placeFormatConverter.setValidatedMap(true, null);
        } else {
            placeFormatConverter.setValidatedMap(false, null);
        }
    }

    private Set<String> getNbOfDifferentPlaces(Gedcom gedcom) {
        TreeSet<String> ret = new TreeSet<String>();
        for (Property place : gedcom.getPropertiesByClass(PropertyPlace.class)) {
            ret.add(place.getValue());
        }
        return ret;
    }

    private Set<String> getIncorrectPlaces(int nbExpected, Set<String> places) {
        TreeSet<String> ret = new TreeSet<String>();
        for (String place : places) {
            if (place.isEmpty()) {
                ret.add(this.EMPTY_PLACE);
                continue;
            }
            if (PropertyPlace.getFormat((String)place).length == nbExpected) continue;
            ret.add(place);
        }
        return ret;
    }

    private void DisplayIncorrectPlaces(Set<String> list) {
        boolean isGeoFound = false;
        PluginInterface pi = null;
        for (PluginInterface sInterface : Lookup.getDefault().lookupAll(PluginInterface.class)) {
            if (!"ancestris.modules.geo".equals(sInterface.getPluginName())) continue;
            pi = sInterface;
            isGeoFound = true;
            break;
        }
        JButton geoButton = new JButton(NbBundle.getMessage(this.getClass(), (String)"Button_Geo"));
        geoButton.setEnabled(isGeoFound);
        if (isGeoFound) {
            final PluginInterface geo = pi;
            geoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    geo.launchModule((Object)GedcomPropertiesPlaceFormatPanel.this.gedcom);
                }
            });
        }
        JScrollPane panel = new JScrollPane(new JList<Object>(list.toArray()));
        panel.setPreferredSize(new Dimension(Math.max(panel.getPreferredSize().width, 400), 300));
        Object[] options = new Object[]{DialogManager.OK_OPTION, geoButton};
        DialogManager.create((String)NbBundle.getMessage(GedcomPropertiesPlaceFormatPanel.class, (String)"TITL_IncorrectList", (Object)list.size(), (Object)this.nbExpectedPlaces), (JComponent)panel).setMessageType(-1).setOptionType(10).setOptions(options).setDialogId("incorrectPlaces").show();
    }
}

