/*
 * Decompiled with CFR 0.152.
 */
package modules.editors.gedcomproperties;

import ancestris.api.core.Version;
import ancestris.api.newgedcom.ModifyGedcom;
import ancestris.gedcom.GedcomDirectory;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyPlace;
import genj.gedcom.Submitter;
import genj.gedcom.TagPath;
import genj.gedcom.UnitOfWork;
import genj.util.Registry;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import modules.editors.gedcomproperties.Constants;
import modules.editors.gedcomproperties.GedcomPropertiesWizardIterator;
import modules.editors.gedcomproperties.ResultPanel;
import modules.editors.gedcomproperties.utils.GedcomMediaConverter;
import modules.editors.gedcomproperties.utils.GedcomPlacesAligner;
import modules.editors.gedcomproperties.utils.GedcomPlacesConverter;
import modules.editors.gedcomproperties.utils.GedcomVersionConverter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class InvokeGedcomPropertiesModifier
implements ModifyGedcom,
Constants {
    private Gedcom gedcom = null;
    private WizardDescriptor wiz = null;
    private int mode = 0;
    private String emaiTag = "";
    private String wwwTag = "";

    public boolean isReady() {
        return true;
    }

    public Context create() {
        Indi firstIndi;
        Entity prop_HEAD;
        this.gedcom = new Gedcom();
        if (this.gedcom.getGrammar().equals(Grammar.V551)) {
            this.emaiTag = "EMAIL";
            this.wwwTag = "WWW";
        } else {
            this.emaiTag = "_EMAIL";
            this.wwwTag = "_WWW";
        }
        try {
            prop_HEAD = this.gedcom.createEntity("HEAD", "");
            this.gedcom.createEntity("SUBM");
            this.gedcom.getSubmitter();
            firstIndi = (Indi)this.gedcom.createEntity("INDI");
            firstIndi.addDefaultProperties();
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        this.gedcom.initLanguages();
        this.mode = 1;
        this.wiz = new WizardDescriptor((WizardDescriptor.Iterator)new GedcomPropertiesWizardIterator(this.mode, this.gedcom));
        this.wiz.setTitleFormat(new MessageFormat("{0}"));
        this.wiz.setTitle(NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"TITLE_create"));
        this.copyGedcomToProperties();
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)this.wiz) == WizardDescriptor.FINISH_OPTION) {
            try {
                this.gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        InvokeGedcomPropertiesModifier.this.commit();
                    }
                });
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            String filename = prop_HEAD.getProperty("FILE").getDisplayValue();
            Context newContext = GedcomDirectory.getDefault().newGedcom(this.gedcom, NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"TITLE_chooseDir", (Object)filename), filename, false);
            if (newContext != null) {
                return new Context((Entity)firstIndi);
            }
        }
        DialogManager.create((String)NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"MSG_GedcomNotCreatedTitle"), (String)NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"MSG_GedcomNotCreated")).setMessageType(1).show();
        return null;
    }

    public Context update() {
        Context context = (Context)Utilities.actionsGlobalContext().lookup(Context.class);
        if (context == null) {
            List cs = GedcomDirectory.getDefault().getContexts();
            if (cs == null || cs.isEmpty()) {
                DialogManager.createError(null, (String)NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"MSG_NoGedcomFound")).show();
                return null;
            }
            context = (Context)cs.get(0);
        }
        this.update(context);
        return context;
    }

    public Context update(Context context) {
        this.gedcom = context.getGedcom();
        if (this.gedcom.getGrammar().equals(Grammar.V551)) {
            this.emaiTag = "EMAIL";
            this.wwwTag = "WWW";
        } else {
            this.emaiTag = "_EMAIL";
            this.wwwTag = "_WWW";
        }
        this.mode = 2;
        this.gedcom.initLanguages();
        this.wiz = new WizardDescriptor((WizardDescriptor.Iterator)new GedcomPropertiesWizardIterator(this.mode, this.gedcom));
        this.wiz.setTitleFormat(new MessageFormat("{0}"));
        String location = this.gedcom.getOrigin().toString();
        this.wiz.setTitle(NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"TITLE_update", (Object)location));
        this.copyGedcomToProperties();
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)this.wiz) == WizardDescriptor.FINISH_OPTION) {
            Object o;
            if (this.wiz.getProperty("ConversionVersion") == "1" && (o = DialogManager.createYesNo((String)NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"Panel3.jCheckBox1.update"), (String)NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"WNG_ConfirmVersionConversion")).setMessageType(0).show()) != DialogManager.YES_OPTION) {
                this.notifyCancellation();
                return null;
            }
            if (this.wiz.getProperty("AlignPlaceFormat") == "1" && (o = DialogManager.createYesNo((String)NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"GedcomPropertiesPlaceFormatPanel.jCheckBox2.toolTipText", (Object)PropertyPlace.getFormat((String)this.gedcom.getPlaceFormat()).length), (String)NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"WNG_ConfirmPlaceAlignment")).setMessageType(0).show()) != DialogManager.YES_OPTION) {
                this.notifyCancellation();
                return null;
            }
            if (this.wiz.getProperty("ConversionPlaceFormat") == "1" && (o = DialogManager.createYesNo((String)NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"GedcomPropertiesPlaceFormatPanel.jCheckBox1.text"), (String)NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"WNG_ConfirmPlaceConversion")).setMessageType(0).show()) != DialogManager.YES_OPTION) {
                this.notifyCancellation();
                return null;
            }
            if (this.wiz.getProperty("RelocateMedia") == "1" && (o = DialogManager.createYesNo((String)NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"GedcomPropertiesMediaFormatPanel.Conversion"), (String)NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"WNG_ConfirmMediaConversion")).setMessageType(0).show()) != DialogManager.YES_OPTION) {
                this.notifyCancellation();
                return null;
            }
            try {
                this.gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        InvokeGedcomPropertiesModifier.this.commit();
                    }
                });
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            this.notifyCancellation();
        }
        return null;
    }

    private void copyGedcomToProperties() {
        Registry submPref = Registry.get(GedcomPropertiesWizardIterator.class);
        this.copyGedPropToWizProp("HEAD:FILE", 0, NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"Panel1.jTextField1.create"));
        this.copyGedPropToWizProp("HEAD:NOTE", 0, "");
        String defaultName = "";
        String defaultCopr = "";
        if (this.mode == 1) {
            defaultName = submPref.get("submName", "");
            defaultCopr = defaultName + " " + NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"DFT_Copyright") + " " + Calendar.getInstance().get(1);
        }
        this.copyGedPropToWizProp("SUBM:NAME", 1, defaultName);
        this.copyGedPropToWizProp("SUBM:ADDR", 1, submPref.get("submAddress", ""));
        this.copyGedPropToWizProp("SUBM:ADDR:POST", 1, submPref.get("submPostcode", ""));
        this.copyGedPropToWizProp("SUBM:ADDR:CITY", 1, submPref.get("submCity", ""));
        this.copyGedPropToWizProp("SUBM:ADDR:STAE", 1, submPref.get("submState", ""));
        this.copyGedPropToWizProp("SUBM:ADDR:CTRY", 1, submPref.get("submCountry", ""));
        this.copyGedPropToWizProp("SUBM:PHON", 1, submPref.get("submPhone", ""));
        this.copyGedPropToWizProp("SUBM:" + this.emaiTag, "SUBM:EMAIL", 1, submPref.get("submEmail", ""));
        this.copyGedPropToWizProp("SUBM:" + this.wwwTag, "SUBM:WWW", 1, submPref.get("submWeb", ""));
        this.copyGedPropToWizProp("HEAD:COPR", 1, defaultCopr);
        this.copyGedPropToWizProp("HEAD:LANG", 0, Locale.getDefault().getDisplayLanguage(new Locale("en", "EN")));
        this.copyGedPropToWizProp("HEAD:CHAR", 0, "UTF-8");
        this.copyGedPropToWizProp("HEAD:GEDC:VERS", 0, "5.5.1");
        this.copyGedPropToWizProp("HEAD:DEST", 0, "ANY");
        String tagPath = "HEAD:PLAC:FORM";
        String pf = this.gedcom.getPlaceFormat();
        this.copyGedPropToWizProp(tagPath, 0, GedcomOptions.getInstance().getPlaceFormat());
        if (this.mode == 2 && !this.wiz.getProperty(tagPath).equals(pf)) {
            this.wiz.putProperty(tagPath, (Object)pf);
        }
        this.copyGedPropToWizProp("HEAD:SOUR", 1, "ANCESTRIS");
        this.copyGedPropToWizProp("HEAD:SOUR:VERS", 1, ((Version)Lookup.getDefault().lookup(Version.class)).getVersionString());
        this.copyGedPropToWizProp("HEAD:SOUR:NAME", 1, "Ancestris");
        this.copyGedPropToWizProp("HEAD:SOUR:CORP", 1, "Ancestris Team");
        this.copyGedPropertiesToWizProp("HEAD:SOUR:CORP:ADDR", 1, "http://www.ancestris.org");
        this.copyGedPropToWizProp("HEAD:DATE", 0, new SimpleDateFormat("dd MMM yyyy").format(Calendar.getInstance().getTime()));
        this.copyGedPropToWizProp("HEAD:DATE:TIME", 0, new SimpleDateFormat("HH:mm").format(Calendar.getInstance().getTime()));
    }

    public void commit() throws GedcomException {
        TagPath path;
        boolean chg = false;
        chg = chg || this.replaceOrCreateProperty("HEAD:FILE");
        chg = chg || this.replaceOrCreateProperty("HEAD:NOTE");
        chg = chg || this.replaceOrCreateProperty("HEAD:COPR");
        chg = chg || this.replaceOrCreateProperty("HEAD:LANG");
        chg = chg || this.replaceOrCreateProperty("HEAD:CHAR");
        chg = chg || this.replaceOrCreateProperty("HEAD:GEDC:VERS");
        chg = chg || this.replaceOrCreateProperty("HEAD:DEST");
        chg = chg || this.replaceOrCreateProperty("HEAD:PLAC:FORM");
        chg = chg || this.replaceOrCreateProperty("HEAD:SOUR");
        chg = chg || this.replaceOrCreateProperty("HEAD:SOUR:VERS");
        chg = chg || this.replaceOrCreateProperty("HEAD:SOUR:NAME");
        chg = chg || this.replaceOrCreateProperty("HEAD:SOUR:CORP");
        chg = chg || this.replaceOrCreateProperty("HEAD:SOUR:CORP:ADDR");
        this.gedcom.setLanguage((String)this.wiz.getProperty("HEAD:LANG"));
        this.gedcom.setEncoding((String)this.wiz.getProperty("HEAD:CHAR"));
        if (((String)this.wiz.getProperty("HEAD:GEDC:VERS")).equals("5.5.1")) {
            this.emaiTag = "EMAIL";
            this.wwwTag = "WWW";
            this.gedcom.setGrammar(Grammar.V551);
        } else {
            this.emaiTag = "_EMAIL";
            this.wwwTag = "_WWW";
            this.gedcom.setGrammar(Grammar.V55);
        }
        this.gedcom.setDestination((String)this.wiz.getProperty("HEAD:DEST"));
        this.gedcom.setPlaceFormat((String)this.wiz.getProperty("HEAD:PLAC:FORM"));
        Submitter submitter = this.gedcom.getSubmitter();
        if (submitter == null) {
            this.gedcom.createEntity("SUBM");
            submitter = this.gedcom.getSubmitter();
        }
        if (!submitter.getName().equals((String)this.wiz.getProperty("SUBM:NAME"))) {
            submitter.setName((String)this.wiz.getProperty("SUBM:NAME"));
            chg = true;
        }
        if (!submitter.getAddress().equals((String)this.wiz.getProperty("SUBM:ADDR"))) {
            submitter.setAddress((String)this.wiz.getProperty("SUBM:ADDR"));
            chg = true;
        }
        if (!submitter.getPostcode().equals((String)this.wiz.getProperty("SUBM:ADDR:POST"))) {
            submitter.setPostcode((String)this.wiz.getProperty("SUBM:ADDR:POST"));
            chg = true;
        }
        if (!submitter.getCity().equals((String)this.wiz.getProperty("SUBM:ADDR:CITY"))) {
            submitter.setCity((String)this.wiz.getProperty("SUBM:ADDR:CITY"));
            chg = true;
        }
        if (!submitter.getState().equals((String)this.wiz.getProperty("SUBM:ADDR:STAE"))) {
            submitter.setState((String)this.wiz.getProperty("SUBM:ADDR:STAE"));
            chg = true;
        }
        if (!submitter.getCountry().equals((String)this.wiz.getProperty("SUBM:ADDR:CTRY"))) {
            submitter.setCountry((String)this.wiz.getProperty("SUBM:ADDR:CTRY"));
            chg = true;
        }
        if (!submitter.getPhone().equals((String)this.wiz.getProperty("SUBM:PHON"))) {
            submitter.setPhone((String)this.wiz.getProperty("SUBM:PHON"));
            chg = true;
        }
        if (!submitter.getValue(path = new TagPath("SUBM:" + this.emaiTag), "").equals((String)this.wiz.getProperty("SUBM:EMAIL"))) {
            submitter.setValue(path, (String)this.wiz.getProperty("SUBM:EMAIL"));
            chg = true;
        }
        if (!submitter.getValue(path = new TagPath("SUBM:" + this.wwwTag), "").equals((String)this.wiz.getProperty("SUBM:WWW"))) {
            submitter.setValue(new TagPath("SUBM:" + this.wwwTag), (String)this.wiz.getProperty("SUBM:WWW"));
            chg = true;
        }
        if (this.mode == 1) {
            Indi firstIndi = (Indi)this.gedcom.getFirstEntity("INDI");
            firstIndi.setName((String)this.wiz.getProperty("INDI:FIRSTNAME"), (String)this.wiz.getProperty("INDI:LASTNAME"));
            firstIndi.setSex((Boolean)this.wiz.getProperty("INDI:SEX") != false ? 1 : 2);
            return;
        }
        String title = NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"MSG_GedcomModificationResults");
        boolean withVersionErrors = false;
        boolean withPlacesErrors = false;
        boolean withMediaErrors = false;
        GedcomVersionConverter versionConverter = null;
        GedcomPlacesAligner placesAligner = null;
        GedcomPlacesConverter placesConverter = null;
        GedcomMediaConverter mediaConverter = null;
        String message = NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"RSLT_Title");
        if (chg) {
            message = message + NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"RSLT_HeaderChanged");
        }
        if (this.wiz.getProperty("ConversionVersion") == "1" || this.wiz.getProperty("ConversionMedia") == "1") {
            if (this.wiz.getProperty("ConversionVersion") == "1") {
                message = message + NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"RSLT_VersionChanged", (Object)this.wiz.getProperty("ConversionVersionFrom"), (Object)this.wiz.getProperty("ConversionVersionTo"));
            }
            if (this.wiz.getProperty("ConversionMedia") == "1") {
                message = message + NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"RSLT_MediaChanged");
            }
            if ((versionConverter = new GedcomVersionConverter(this.gedcom, this.wiz.getProperty("ConversionVersionFrom").toString(), this.wiz.getProperty("ConversionVersionTo").toString(), this.wiz.getProperty("ConversionMedia").toString())).isConvertible() && versionConverter.convert()) {
                if (this.wiz.getProperty("ConversionVersion") == "1") {
                    message = message + NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"RSLT_VersionSuccessChanged");
                }
                if (this.wiz.getProperty("ConversionMedia") == "1") {
                    message = message + NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"RSLT_MediaSuccessChanged");
                }
                chg = true;
            } else {
                if (this.wiz.getProperty("ConversionVersion") == "1") {
                    message = message + NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"RSLT_VersionFailureChanged");
                }
                if (this.wiz.getProperty("ConversionMedia") == "1") {
                    message = message + NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"RSLT_MediaFailureChanged");
                }
                withVersionErrors = true;
            }
        }
        if (this.wiz.getProperty("AlignPlaceFormat") == "1") {
            message = message + NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"RSLT_PlaceAligned", (Object)PropertyPlace.getFormat((String)this.gedcom.getPlaceFormat()).length);
            placesAligner = new GedcomPlacesAligner(this.gedcom);
            if (placesAligner.convert()) {
                message = message + NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"RSLT_PlaceSuccessAligned", (Object)placesAligner.getNbOfPlacesAligned(), (Object)placesAligner.getNbOfPlaces());
                chg = true;
            } else {
                message = message + NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"RSLT_PlaceFailureAligned", (Object)placesAligner.getError().getMessage());
                withPlacesErrors = true;
            }
        }
        if (this.wiz.getProperty("ConversionPlaceFormat") == "1") {
            message = message + NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"RSLT_PlaceChanged", (Object)this.wiz.getProperty("ConversionPlaceFormatFrom"), (Object)this.wiz.getProperty("ConversionPlaceFormatTo"));
            placesConverter = new GedcomPlacesConverter(this.gedcom, this.wiz.getProperty("ConversionPlaceFormatFrom").toString(), this.wiz.getProperty("ConversionPlaceFormatTo").toString(), this.wiz.getProperty("ConversionPlaceFormatMap").toString());
            if (placesConverter.convert()) {
                message = message + NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"RSLT_PlaceSuccessChanged", (Object)placesConverter.getNbOfChangedPlaces(), (Object)placesConverter.getNbOfFoundPlaces(), (Object)placesConverter.getNbOfDifferentChangedPlaces(), (Object)placesConverter.getNbOfDifferentFoundPlaces(), (Object[])new Object[0]);
                chg = true;
            } else {
                message = message + NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"RSLT_PlaceFailureChanged", (Object)placesConverter.getError().getMessage(), (Object)placesConverter.getNbOfChangedPlaces(), (Object)placesConverter.getNbOfFoundPlaces(), (Object)placesConverter.getNbOfDifferentChangedPlaces(), (Object[])new Object[]{placesConverter.getNbOfDifferentFoundPlaces()});
                withPlacesErrors = true;
            }
        }
        if (this.wiz.getProperty("RelocateMedia") == "1") {
            message = message + NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"RSLT_MediaLocationsChanged");
            this.wiz.getInstantiatedObjects();
            mediaConverter = new GedcomMediaConverter(this.gedcom, (Map)this.wiz.getProperty("MediaMap"));
            if (mediaConverter.convert()) {
                message = message + NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"RSLT_MediaLocationsSuccessChanged", (Object)mediaConverter.getNbOfChangedMedia());
                chg = true;
            } else {
                message = message + NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"RSLT_MediaLocationsFailureChanged", (Object)mediaConverter.getError().getMessage());
                withMediaErrors = true;
            }
        }
        if (chg && !withVersionErrors && !withPlacesErrors && !withMediaErrors) {
            message = message + NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"RSLT_GedcomModifiedSuccessfully");
        } else if (chg && (withVersionErrors || withPlacesErrors || withMediaErrors)) {
            message = message + NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"RSLT_GedcomModifiedPartiallySuccessfully");
        } else {
            title = NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"MSG_GedcomNotModifiedTitle");
            message = message + NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"MSG_GedcomNotModifiedMessage");
        }
        message = message + NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"RSLT_EndOfMessage");
        ResultPanel jPanel = new ResultPanel(message, versionConverter, placesConverter);
        DialogManager.create((String)title, (JComponent)jPanel).setMessageType(1).setOptionType(10).show();
    }

    private void notifyCancellation() {
        DialogManager.create((String)NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"MSG_GedcomCancelModificationTitle"), (String)NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"MSG_GedcomNotModified")).setMessageType(1).show();
    }

    private void copyGedPropToWizProp(String tagPath, int modeForDefault, String defaultvalue) {
        this.copyGedPropToWizProp(tagPath, tagPath, modeForDefault, defaultvalue);
    }

    private void copyGedPropToWizProp(String tagPath1, String tagPath2, int modeForDefault, String defaultvalue) {
        Property[] props = this.getProperties(tagPath1, false);
        String str = "";
        str = modeForDefault == 0 ? defaultvalue : (this.mode == modeForDefault ? defaultvalue : "");
        this.wiz.putProperty(tagPath2, (Object)(props != null && props.length != 0 ? props[0].getDisplayValue() : str));
    }

    private void copyGedPropertiesToWizProp(String tagPath, int modeForDefault, String defaultvalue) {
        Property parent;
        String value = "";
        String str = "";
        String linebreak = "<br>";
        Property[] props = this.getProperties(tagPath, false);
        if (props != null && props.length != 0 && (parent = props[0].getParent()) != null) {
            ArrayList properties = new ArrayList();
            this.getPropertiesRecursively(parent, properties);
            for (Property prop : properties) {
                value = value + prop.getDisplayValue() + linebreak;
            }
        }
        if (value.endsWith(linebreak)) {
            value = value.substring(0, value.length() - linebreak.length());
        }
        str = modeForDefault == 0 ? defaultvalue : (this.mode == modeForDefault ? defaultvalue : "");
        this.wiz.putProperty(tagPath, (Object)(props != null ? value : str));
    }

    private boolean replaceOrCreateProperty(String tagPath) {
        String currentValue = null;
        Property prop = this.getProperty(tagPath);
        if (prop != null) {
            currentValue = prop.getDisplayValue();
        }
        String newValue = ((String)this.wiz.getProperty(tagPath)).trim();
        if (currentValue == null && !newValue.isEmpty() || currentValue != null && !currentValue.equals(newValue)) {
            Property[] props = this.getProperties(tagPath, true);
            props[0].setValue((String)this.wiz.getProperty(tagPath));
            return true;
        }
        return false;
    }

    private Property getProperty(String path) {
        TagPath tagPath = new TagPath(path);
        String tag = tagPath.get(0);
        if (tag == null) {
            return null;
        }
        Entity property = this.gedcom.getFirstEntity(tag);
        if (property == null) {
            return null;
        }
        for (int i = 1; i < tagPath.length(); ++i) {
            tag = tagPath.get(i);
            if ((property = property.getProperty(tag)) != null) continue;
            return null;
        }
        return property;
    }

    private Property[] getProperties(String tagPath, boolean createProperty) {
        return this.getProperties(null, tagPath, createProperty);
    }

    private Property[] getProperties(Property parent, String tagPath, boolean createProperty) {
        if (tagPath.contains(":")) {
            Property property;
            String firstTag = tagPath.substring(0, tagPath.indexOf(":"));
            if (firstTag.equals("HEAD") || firstTag.equals("SUBM")) {
                if (firstTag.equals("HEAD")) {
                    property = this.gedcom.getFirstEntity("HEAD");
                } else {
                    String id;
                    boolean found = false;
                    property = this.gedcom.getFirstEntity("HEAD");
                    if (property != null && (property = property.getProperty("SUBM")) != null && (property = this.gedcom.getEntity("SUBM", id = property.getValue().replaceAll("@", "").trim())) != null) {
                        found = true;
                    }
                    if (!found) {
                        property = null;
                    }
                }
            } else {
                Property property2 = property = parent != null ? parent.getProperty(firstTag) : null;
            }
            if (parent != null && property == null && createProperty) {
                property = parent.addProperty(firstTag, "");
            }
            String restOfPath = tagPath.substring(firstTag.length() + 1);
            return this.getProperties(property, restOfPath, createProperty);
        }
        if (parent != null) {
            Property property = parent.getProperty(tagPath);
            if (property == null && createProperty) {
                parent.addProperty(tagPath, "");
            }
            return parent.getProperties(tagPath);
        }
        return null;
    }

    public void getPropertiesRecursively(Property parent, List props) {
        Property[] children;
        for (Property child : children = parent.getProperties()) {
            props.add(child);
            this.getPropertiesRecursively(child, props);
        }
    }
}

