/*
 * Decompiled with CFR 0.152.
 */
package ancestris.view;

import ancestris.app.App;
import ancestris.app.ModePersisterTopComponent;
import ancestris.app.OpenGenjViewAction;
import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.gedcom.GedcomDataObject;
import ancestris.gedcom.GedcomDirectory;
import ancestris.gedcom.PropertyNode;
import ancestris.view.AncestrisViewInterface;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.util.Registry;
import genj.view.SelectionListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.openide.awt.UndoRedo;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.RetainLocation;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class AncestrisTopComponent
extends TopComponent
implements ExplorerManager.Provider,
Lookup.Provider,
AncestrisViewInterface,
SelectionListener {
    private static final String PREFERRED_ID = "AncestrisTopComponent";
    private JComponent panel;
    private boolean isRestored = false;
    private static final Logger LOG = Logger.getLogger("ancestris.app");
    private Context currentContext;
    private final ExplorerManager manager;
    private Lookup lookup;
    public boolean isOpen = false;
    private JToolBar bar = null;

    public AncestrisTopComponent() {
        this.putClientProperty("TopComponentAllowDockAnywhere", Boolean.TRUE);
        this.manager = new ExplorerManager();
        ActionMap map = this.getActionMap();
        map.put("org.openide.actions.FindAction", (Action)FileUtil.getConfigObject((String)"Actions/Edit/ancestris-app-ActionFind.instance", Action.class));
        map.put("org.openide.actions.ReplaceAction", (Action)FileUtil.getConfigObject((String)"Actions/Edit/ancestris-app-ActionReplace.instance", Action.class));
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)map));
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    protected void componentActivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)true);
    }

    protected void componentDeactivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)false);
    }

    public UndoRedo getUndoRedo() {
        try {
            return ((GedcomDataObject)GedcomDirectory.getDefault().getDataObject(this.currentContext).getLookup().lookup(GedcomDataObject.class)).getUndoRedo();
        }
        catch (GedcomDirectory.ContextNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    String getDefaultMode() {
        String modeName = Registry.get((Object)((Object)this)).get(this.preferredID() + ".dockMode", (String)null);
        if (modeName == null) {
            modeName = ((Object)((Object)this)).getClass().getAnnotation(RetainLocation.class).value();
        }
        if (modeName == null) {
            modeName = "ancestris-editor";
        }
        return modeName;
    }

    public void setDefaultMode(String mode) {
        Registry.get((Object)((Object)this)).put(this.preferredID() + ".dockMode", mode);
    }

    public void setDefaultMode(Mode mode) {
        this.setDefaultMode(mode.getName());
    }

    boolean isSingleView() {
        return false;
    }

    public void open() {
        if (this.currentContext == null) {
            return;
        }
        if (!this.isRestored) {
            String modeName = this.getGedcom().getRegistry().get(this.preferredID() + ".dockMode", this.getDefaultMode());
            Mode m = WindowManager.getDefault().findMode(modeName);
            if (m != null) {
                m.dockInto((TopComponent)this);
            }
        }
        super.open();
        this.isOpen = true;
    }

    public Gedcom getGedcom() {
        return this.currentContext == null ? null : this.currentContext.getGedcom();
    }

    public final void setContext(Context context) {
        if (this.currentContext != null && !this.currentContext.sameGedcom(context)) {
            LOG.log(Level.FINER, "context selection on unknown gedcom");
            return;
        }
        LOG.log(Level.FINER, "setContext({0},{1})", new Object[]{context});
        this.currentContext = context;
        if (context.getGedcom() != null) {
            context.getGedcom().getRegistry().put("context", context.toString());
        }
        try {
            Children children = PropertyNode.getChildren((Context)context);
            this.manager.setRootContext((Node)new AbstractNode(children));
            this.manager.setSelectedNodes(children.getNodes());
        }
        catch (PropertyVetoException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.setContextImpl(context);
    }

    protected void setContextImpl(Context context) {
    }

    public Context getContext() {
        return this.currentContext;
    }

    public void setPanel(JComponent jpanel) {
        this.removeAll();
        this.repaint();
        this.panel = jpanel;
        if (this.panel == null) {
            return;
        }
        this.setLayout(new BorderLayout());
        this.add(this.panel, "Center");
    }

    public Image getImageIcon() {
        return null;
    }

    public Image getImageIcon(String resource) {
        return ImageUtilities.loadImage((String)resource, (boolean)true);
    }

    public void setName() {
        String name;
        try {
            name = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)("CTL_" + this.preferredID()));
        }
        catch (MissingResourceException ex) {
            name = this.preferredID();
        }
        this.setName(name);
    }

    public void setToolTipText() {
        String name;
        try {
            name = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)("HINT_" + this.preferredID()));
        }
        catch (MissingResourceException ex) {
            name = this.preferredID();
        }
        this.setToolTipText(name);
    }

    public boolean createPanel() {
        return false;
    }

    public void refreshPanel(Context context) {
    }

    public int getPersistenceType() {
        return 2;
    }

    public void componentClosed() {
        this.persistMode();
        AncestrisPlugin.unregister((Object)((Object)this));
        this.isOpen = false;
    }

    public boolean canClose() {
        Context ctx = this.getContext();
        int viewCount = 0;
        for (AncestrisViewInterface gjvTc : AncestrisPlugin.lookupAll(AncestrisViewInterface.class)) {
            if (!ctx.getGedcom().equals(gjvTc.getGedcom()) || ((Object)((Object)this)).equals(gjvTc)) continue;
            ++viewCount;
        }
        if (viewCount == 0 && !GedcomDirectory.getDefault().closeGedcom(ctx)) {
            return false;
        }
        this.persistMode();
        return true;
    }

    private void persistMode() {
        Mode mode = this.getMode();
        if (mode == null) {
            return;
        }
        for (TopComponent tc : mode.getTopComponents()) {
            if (!(tc instanceof ModePersisterTopComponent)) continue;
            return;
        }
        mode.dockInto((TopComponent)new ModePersisterTopComponent());
    }

    public void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
        p.setProperty("gedcom", this.getGedcom().getOrigin().toString());
    }

    public void readProperties(Properties p) {
        this.readPropertiesImpl(p);
    }

    void readPropertiesImpl(Properties p) {
        String gedName = p.getProperty("gedcom");
        if (gedName == null) {
            this.close();
        }
        this.setRestored(true);
        this.waitStartup(gedName);
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public String getPreferencesKey(String key) {
        return "AncestrisTopComponent." + key;
    }

    public AncestrisTopComponent create(Context context) {
        Gedcom gedcom = context == null ? null : context.getGedcom();
        AncestrisTopComponent topComponent = null;
        if (gedcom != null && this.isSingleView()) {
            for (AncestrisTopComponent tc : AncestrisPlugin.lookupAll(((Object)((Object)this)).getClass())) {
                if (!gedcom.equals(tc.getGedcom())) continue;
                topComponent = tc;
                break;
            }
        }
        if (topComponent != null) {
            return topComponent;
        }
        try {
            topComponent = (AncestrisTopComponent)((Object)((Object)((Object)this)).getClass().newInstance());
        }
        catch (InstantiationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        topComponent.init(context);
        return topComponent;
    }

    public static Action openAction(TopComponent component, String displayName, String iconBase, boolean noIconInMenu) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("displayName", displayName);
        map.put("iconBase", iconBase);
        map.put("noIconInMenu", noIconInMenu);
        map.put("component", component);
        return AncestrisTopComponent.openAction(map);
    }

    public static Action openAction(Map<String, Object> map) {
        return new OpenGenjViewAction((AncestrisTopComponent)((Object)map.get("component")), map);
    }

    public void init(Context context) {
        String gedcomName;
        this.setName();
        this.setToolTipText();
        this.setContext(context);
        Image icon = this.getImageIcon();
        if (icon != null) {
            this.setIcon(icon);
        }
        if (context == null || context.getGedcom() == null) {
            return;
        }
        if (!this.createPanel()) {
            return;
        }
        AncestrisPlugin.register((Object)((Object)this));
        if (this.getGedcom() != null && (gedcomName = this.getGedcom().getName()) != null) {
            this.setName(gedcomName);
            this.setToolTipText(this.getToolTipText() + ": " + gedcomName);
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                Window w = SwingUtilities.getWindowAncestor((Component)((Object)AncestrisTopComponent.this));
                if (w != null && w instanceof JFrame && !w.equals(WindowManager.getDefault().getMainWindow())) {
                    ((JFrame)w).setTitle(AncestrisTopComponent.this.getName());
                    ((JFrame)w).setIconImage(AncestrisTopComponent.this.getIcon());
                }
            }
        });
    }

    public void waitStartup(String name) {
        final String gedName = name;
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (!App.center.isReady(0)) {
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (App.center.getOpenedContext(gedName) == null) {
                            AncestrisTopComponent.this.close();
                        } else {
                            AncestrisTopComponent.this.init(App.center.getOpenedContext(gedName));
                            AncestrisTopComponent.this.open();
                        }
                    }
                });
            }
        }).start();
    }

    public Mode getMode() {
        return WindowManager.getDefault().findMode((TopComponent)this);
    }

    public void setRestored(boolean b) {
        this.isRestored = b;
    }

    public void addToolBar() {
        this.bar = this.getToolBar();
        if (this.bar != null) {
            this.add(this.bar, Registry.get((Object)((Object)this)).get("toolbar", "North"));
        }
    }

    public JToolBar getToolBar() {
        return null;
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (this.bar != null && comp == this.bar) {
            constraints = this.getToolBarConstraints(this.bar, constraints);
            Registry.get((Object)((Object)this)).put("toolbar", constraints.toString());
            int orientation = 0;
            if ("West".equals(constraints) || "East".equals(constraints)) {
                orientation = 1;
            }
            this.bar.setOrientation(orientation);
        }
        super.addImpl(comp, constraints, index);
    }

    protected Object getToolBarConstraints(JToolBar bar, Object constraints) {
        return constraints;
    }
}

