/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.util.Iterator;
import java.util.List;
import org.apache.batik.dom.svg.SVGOMTextElement;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.TextPainter;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.renderer.StrokingTextPainter;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.Mark;
import org.apache.batik.gvt.text.TextPaintInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.render.ps.PSGraphics2D;

public class PSTextPainter
implements TextPainter {
    protected Log log = LogFactory.getLog((Class)(class$org$apache$fop$render$ps$PSTextPainter == null ? (class$org$apache$fop$render$ps$PSTextPainter = PSTextPainter.class$("org.apache.fop.render.ps.PSTextPainter")) : class$org$apache$fop$render$ps$PSTextPainter));
    private FontInfo fontInfo;
    protected static final TextPainter PROXY_PAINTER = StrokingTextPainter.getInstance();
    static /* synthetic */ Class class$org$apache$fop$render$ps$PSTextPainter;

    public PSTextPainter(FontInfo fontInfo) {
        this.fontInfo = fontInfo;
    }

    public void paint(TextNode node, Graphics2D g2d) {
        String txt = node.getText();
        Point2D loc = node.getLocation();
        if (this.hasUnsupportedAttributes(node)) {
            PROXY_PAINTER.paint(node, g2d);
        } else {
            this.paintTextRuns(node.getTextRuns(), g2d, loc);
        }
    }

    private boolean hasUnsupportedAttributes(TextNode node) {
        Iterator i = node.getTextRuns().iterator();
        while (i.hasNext()) {
            StrokingTextPainter.TextRun run = (StrokingTextPainter.TextRun)i.next();
            AttributedCharacterIterator aci = run.getACI();
            boolean hasUnsupported = this.hasUnsupportedAttributes(aci);
            if (!hasUnsupported) continue;
            return true;
        }
        return false;
    }

    private boolean hasUnsupportedAttributes(AttributedCharacterIterator aci) {
        Object rcDel;
        Object vertOr;
        Object writeMod;
        Object lengthAdjust;
        Object wordSpace;
        Object letSpace;
        Color col;
        Paint foreground;
        TextPaintInfo tpi;
        org.apache.fop.fonts.Font font;
        boolean hasunsupported = false;
        String text = this.getText(aci);
        if (this.hasUnsupportedGlyphs(text, font = this.makeFont(aci))) {
            this.log.trace((Object)"-> Unsupported glyphs found");
            hasunsupported = true;
        }
        if ((tpi = (TextPaintInfo)aci.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.PAINT_INFO)) != null && (tpi.strokeStroke != null && tpi.strokePaint != null || tpi.strikethroughStroke != null || tpi.underlineStroke != null || tpi.overlineStroke != null)) {
            this.log.trace((Object)"-> under/overlines etc. found");
            hasunsupported = true;
        }
        if ((foreground = (Paint)aci.getAttribute(TextAttribute.FOREGROUND)) instanceof Color && (col = (Color)foreground).getAlpha() != 255) {
            this.log.trace((Object)"-> transparency found");
            hasunsupported = true;
        }
        if ((letSpace = aci.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.LETTER_SPACING)) != null) {
            this.log.trace((Object)"-> letter spacing found");
            hasunsupported = true;
        }
        if ((wordSpace = aci.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.WORD_SPACING)) != null) {
            this.log.trace((Object)"-> word spacing found");
            hasunsupported = true;
        }
        if ((lengthAdjust = aci.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST)) != null) {
            this.log.trace((Object)"-> length adjustments found");
            hasunsupported = true;
        }
        if ((writeMod = aci.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE)) != null && !GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_LTR.equals(writeMod)) {
            this.log.trace((Object)"-> Unsupported writing modes found");
            hasunsupported = true;
        }
        if (GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_ANGLE.equals(vertOr = aci.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION))) {
            this.log.trace((Object)"-> vertical orientation found");
            hasunsupported = true;
        }
        if (!((rcDel = aci.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER)) instanceof SVGOMTextElement)) {
            this.log.trace((Object)"-> spans found");
            hasunsupported = true;
        }
        if (hasunsupported) {
            this.log.trace((Object)"Unsupported attributes found in ACI, using StrokingTextPainter");
        }
        return hasunsupported;
    }

    protected void paintTextRuns(List textRuns, Graphics2D g2d, Point2D loc) {
        Point2D currentloc = loc;
        Iterator i = textRuns.iterator();
        while (i.hasNext()) {
            StrokingTextPainter.TextRun run = (StrokingTextPainter.TextRun)i.next();
            currentloc = this.paintTextRun(run, g2d, currentloc);
        }
    }

    protected Point2D paintTextRun(StrokingTextPainter.TextRun run, Graphics2D g2d, Point2D loc) {
        AttributedCharacterIterator aci = run.getACI();
        return this.paintACI(aci, g2d, loc);
    }

    protected String getText(AttributedCharacterIterator aci) {
        StringBuffer sb = new StringBuffer(aci.getEndIndex() - aci.getBeginIndex());
        char c = aci.first();
        while (c != '\uffff') {
            sb.append(c);
            c = aci.next();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Point2D paintACI(AttributedCharacterIterator aci, Graphics2D g2d, Point2D loc) {
        aci.first();
        this.updateLocationFromACI(aci, loc);
        TextPaintInfo tpi = (TextPaintInfo)aci.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.PAINT_INFO);
        if (tpi == null) {
            return loc;
        }
        TextNode.Anchor anchor = (TextNode.Anchor)aci.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE);
        List gvtFonts = (List)aci.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.GVT_FONT_FAMILIES);
        Paint foreground = tpi.fillPaint;
        Paint strokePaint = tpi.strokePaint;
        Stroke stroke = tpi.strokeStroke;
        Float fontSize = (Float)aci.getAttribute(TextAttribute.SIZE);
        if (fontSize == null) {
            return loc;
        }
        Float posture = (Float)aci.getAttribute(TextAttribute.POSTURE);
        Float taWeight = (Float)aci.getAttribute(TextAttribute.WEIGHT);
        if (foreground instanceof Color) {
            Color col = (Color)foreground;
            g2d.setColor(col);
        }
        g2d.setPaint(foreground);
        g2d.setStroke(stroke);
        org.apache.fop.fonts.Font font = this.makeFont(aci);
        Font awtFont = this.makeAWTFont(aci, font);
        g2d.setFont(awtFont);
        String txt = this.getText(aci);
        float advance = this.getStringWidth(txt, font);
        float tx = 0.0f;
        if (anchor != null) {
            switch (anchor.getType()) {
                case 1: {
                    tx = -advance / 2.0f;
                    break;
                }
                case 2: {
                    tx = -advance;
                    break;
                }
            }
        }
        if (g2d instanceof PSGraphics2D) {
            ((PSGraphics2D)((Object)g2d)).setOverrideFont(font);
        }
        try {
            g2d.drawString(txt, (float)(loc.getX() + (double)tx), (float)loc.getY());
        }
        finally {
            if (g2d instanceof PSGraphics2D) {
                ((PSGraphics2D)((Object)g2d)).setOverrideFont(null);
            }
        }
        loc.setLocation(loc.getX() + (double)advance, loc.getY());
        return loc;
    }

    private void updateLocationFromACI(AttributedCharacterIterator aci, Point2D loc) {
        Float xpos = (Float)aci.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.X);
        Float ypos = (Float)aci.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.Y);
        Float dxpos = (Float)aci.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.DX);
        Float dypos = (Float)aci.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.DY);
        if (xpos != null) {
            loc.setLocation(xpos.doubleValue(), loc.getY());
        }
        if (ypos != null) {
            loc.setLocation(loc.getX(), ypos.doubleValue());
        }
        if (dxpos != null) {
            loc.setLocation(loc.getX() + dxpos.doubleValue(), loc.getY());
        }
        if (dypos != null) {
            loc.setLocation(loc.getX(), loc.getY() + dypos.doubleValue());
        }
    }

    private String getStyle(AttributedCharacterIterator aci) {
        Float posture = (Float)aci.getAttribute(TextAttribute.POSTURE);
        return posture != null && (double)posture.floatValue() > 0.0 ? "italic" : "normal";
    }

    private int getWeight(AttributedCharacterIterator aci) {
        Float taWeight = (Float)aci.getAttribute(TextAttribute.WEIGHT);
        return taWeight != null && (double)taWeight.floatValue() > 1.0 ? 700 : 400;
    }

    private org.apache.fop.fonts.Font makeFont(AttributedCharacterIterator aci) {
        Float fontSize = (Float)aci.getAttribute(TextAttribute.SIZE);
        if (fontSize == null) {
            fontSize = new Float(10.0f);
        }
        String style = this.getStyle(aci);
        int weight = this.getWeight(aci);
        boolean found = false;
        String fontFamily = null;
        List gvtFonts = (List)aci.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.GVT_FONT_FAMILIES);
        if (gvtFonts != null) {
            Iterator i = gvtFonts.iterator();
            while (i.hasNext()) {
                GVTFontFamily fam = (GVTFontFamily)i.next();
                fontFamily = fam.getFamilyName();
                if (!this.fontInfo.hasFont(fontFamily, style, weight)) continue;
                FontTriplet triplet = this.fontInfo.fontLookup(fontFamily, style, weight);
                int fsize = (int)(fontSize.floatValue() * 1000.0f);
                return this.fontInfo.getFontInstance(triplet, fsize);
            }
        }
        FontTriplet triplet = this.fontInfo.fontLookup("any", style, 400);
        int fsize = (int)(fontSize.floatValue() * 1000.0f);
        return this.fontInfo.getFontInstance(triplet, fsize);
    }

    private Font makeAWTFont(AttributedCharacterIterator aci, org.apache.fop.fonts.Font font) {
        String style = this.getStyle(aci);
        int weight = this.getWeight(aci);
        int fStyle = 0;
        if (weight == 700) {
            fStyle |= 1;
        }
        if ("italic".equals(style)) {
            fStyle |= 2;
        }
        return new Font(font.getFontName(), fStyle, font.getFontSize() / 1000);
    }

    private float getStringWidth(String str, org.apache.fop.fonts.Font font) {
        float wordWidth = 0.0f;
        float whitespaceWidth = font.getWidth(font.mapChar(' '));
        for (int i = 0; i < str.length(); ++i) {
            float charWidth;
            char c = str.charAt(i);
            if (c != ' ' && c != '\n' && c != '\r' && c != '\t') {
                charWidth = font.getWidth(font.mapChar(c));
                if (charWidth <= 0.0f) {
                    charWidth = whitespaceWidth;
                }
            } else {
                charWidth = whitespaceWidth;
            }
            wordWidth += charWidth;
        }
        return wordWidth / 1000.0f;
    }

    private boolean hasUnsupportedGlyphs(String str, org.apache.fop.fonts.Font font) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == ' ' || c == '\n' || c == '\r' || c == '\t' || font.hasChar(c)) continue;
            return true;
        }
        return false;
    }

    public Shape getOutline(TextNode node) {
        return PROXY_PAINTER.getOutline(node);
    }

    public Rectangle2D getBounds2D(TextNode node) {
        return PROXY_PAINTER.getBounds2D(node);
    }

    public Rectangle2D getGeometryBounds(TextNode node) {
        return PROXY_PAINTER.getGeometryBounds(node);
    }

    public Mark getMark(TextNode node, int pos, boolean all) {
        return null;
    }

    public Mark selectAt(double x, double y, TextNode node) {
        return null;
    }

    public Mark selectTo(double x, double y, Mark beginMark) {
        return null;
    }

    public Mark selectFirst(TextNode node) {
        return null;
    }

    public Mark selectLast(TextNode node) {
        return null;
    }

    public int[] getSelected(Mark start, Mark finish) {
        return null;
    }

    public Shape getHighlightShape(Mark beginMark, Mark endMark) {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

