/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.history;

import ancestris.core.pluginservice.PluginInterface;
import ancestris.gedcom.GedcomDirectory;
import ancestris.modules.gedcom.history.GedcomHistory;
import ancestris.modules.gedcom.history.GedcomHistoryPlugin;
import ancestris.modules.gedcom.history.GedcomHistoryTableModel;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import java.awt.Container;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.RetainLocation;
import org.openide.windows.TopComponent;

@RetainLocation(value="ancestris-table")
@TopComponent.Description(preferredID="GedcomHistoryTopComponent", persistenceType=2)
public final class GedcomHistoryTopComponent
extends TopComponent
implements ChangeListener {
    private static final Logger log = Logger.getLogger(GedcomHistoryTopComponent.class.getName());
    GedcomHistory gedcomHistory = null;
    GedcomHistoryTableModel historyTableModel = null;
    private Gedcom gedcom = null;
    private JScrollPane gedcomHistoryScrollPane;
    private JTable gedcomHistoryTable;

    public GedcomHistoryTopComponent() {
        Context context = (Context)Utilities.actionsGlobalContext().lookup(Context.class);
        if (context == null) {
            List gedcontexts = GedcomDirectory.getDefault().getContexts();
            if (gedcontexts.isEmpty()) {
                return;
            }
            context = (Context)gedcontexts.get(0);
        }
        if (context != null) {
            String gedcomName = context.getGedcom().getName().substring(0, context.getGedcom().getName().lastIndexOf(".") == -1 ? context.getGedcom().getName().length() : context.getGedcom().getName().lastIndexOf("."));
            for (PluginInterface pluginInterface : Lookup.getDefault().lookupAll(PluginInterface.class)) {
                if (!(pluginInterface instanceof GedcomHistoryPlugin)) continue;
                this.gedcomHistory = ((GedcomHistoryPlugin)pluginInterface).getGedcomHistory(context.getGedcom());
                if (this.gedcomHistory != null) {
                    this.gedcom = context.getGedcom();
                    this.historyTableModel = new GedcomHistoryTableModel(this.gedcomHistory, this.getGedcom());
                    this.initComponents();
                    this.setName(NbBundle.getMessage(this.getClass(), (String)"CTL_GedcomHistoryTopComponent", (Object)this.gedcomHistory.getGedcomName()));
                    this.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"HINT_GedcomHistoryTopComponent"));
                    this.gedcomHistoryTable.getSelectionModel().addListSelectionListener(new RowListener());
                } else {
                    log.log(Level.FINE, "No history recorder found for {0}", gedcomName);
                }
                return;
            }
            log.log(Level.FINE, "No Instance of GedcomHistoryPlugin found");
        } else {
            log.log(Level.FINE, "No context found");
        }
    }

    private void initComponents() {
        this.gedcomHistoryScrollPane = new JScrollPane();
        this.gedcomHistoryTable = new JTable();
        this.gedcomHistoryTable.setAutoCreateRowSorter(true);
        this.gedcomHistoryTable.setModel(this.historyTableModel);
        this.gedcomHistoryScrollPane.setViewportView(this.gedcomHistoryTable);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gedcomHistoryScrollPane, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gedcomHistoryScrollPane, -1, 300, Short.MAX_VALUE));
    }

    public void componentOpened() {
        if (this.gedcomHistory != null) {
            this.gedcomHistory.addChangeListener(this);
        }
    }

    public void componentClosed() {
        if (this.gedcomHistory != null) {
            this.gedcomHistory.removeChangeListener(this);
        }
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        this.historyTableModel.fireTableRowsInserted(this.gedcomHistory.getHistoryList().size() - 1, this.gedcomHistory.getHistoryList().size() - 1);
    }

    public Gedcom getGedcom() {
        return this.gedcom;
    }

    private class RowListener
    implements ListSelectionListener {
        private RowListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            Entity entity;
            if (event.getValueIsAdjusting()) {
                return;
            }
            String currentId = (String)GedcomHistoryTopComponent.this.historyTableModel.getValueAt(GedcomHistoryTopComponent.this.gedcomHistoryTable.convertRowIndexToModel(GedcomHistoryTopComponent.this.gedcomHistoryTable.getSelectedRow()), 2);
            if (currentId != null && GedcomHistoryTopComponent.this.getGedcom() != null && (entity = GedcomHistoryTopComponent.this.getGedcom().getEntity(currentId)) != null) {
                SelectionDispatcher.fireSelection((Context)new Context(entity));
            }
        }
    }
}

